/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TargetAssignmentBuilder;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.UnionSet;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.image.TopicsImage;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TargetAssignmentBuilderTest {
    @Test
    public void testEmpty() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20)), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)result.targetAssignment());
    }

    @Test
    public void testAssignmentHasNotChanged() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20)), (Object)result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testAssignmentSwapped() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testNewMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.updateMemberSubscription("member-3", Arrays.asList("foo", "bar", "zar"));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testUpdateMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.updateMemberSubscription("member-3", Arrays.asList("foo", "bar", "zar"), Optional.of("instance-id-3"), Optional.of("rack-0"));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testPartialAssignmentUpdate() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5))));
        expectedAssignment.put("member-3", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testDeleteMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.removeMemberSubscription("member-3");
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testReplaceStaticMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", "instance-member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", "instance-member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", "instance-member-3", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.removeMemberSubscription("member-3");
        context.updateMemberSubscription("member-3-a", Arrays.asList("foo", "bar", "zar"), Optional.of("instance-member-3"), Optional.empty());
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3-a", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-3-a", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20)), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3-a", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testRegularExpressions() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6);
        Uuid barTopicId = context.addTopicMetadata("bar", 6);
        context.addGroupMember("member-1", Arrays.asList("bar", "zar"), "foo*", AssignmentTestUtil.mkAssignment(new Map.Entry[0]));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(new Map.Entry[0]));
        context.addGroupMember("member-3", Collections.emptyList(), "foo*", AssignmentTestUtil.mkAssignment(new Map.Entry[0]));
        context.addResolvedRegularExpression("foo*", new ResolvedRegularExpression(Collections.singleton("foo"), 10L, 12345L));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"my-group", (int)20))), result.records());
        HashMap<String, MemberAssignmentImpl> expectedAssignment = new HashMap<String, MemberAssignmentImpl>();
        expectedAssignment.put("member-1", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-2", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        expectedAssignment.put("member-3", new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    public static class TargetAssignmentBuilderTestContext {
        private final String groupId;
        private final int groupEpoch;
        private final PartitionAssignor assignor = (PartitionAssignor)Mockito.mock(PartitionAssignor.class);
        private final Map<String, ConsumerGroupMember> members = new HashMap<String, ConsumerGroupMember>();
        private final Map<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>();
        private final Map<String, ConsumerGroupMember> updatedMembers = new HashMap<String, ConsumerGroupMember>();
        private final Map<String, Assignment> targetAssignment = new HashMap<String, Assignment>();
        private final Map<String, MemberAssignment> memberAssignments = new HashMap<String, MemberAssignment>();
        private final Map<String, String> staticMembers = new HashMap<String, String>();
        private final Map<String, ResolvedRegularExpression> resolvedRegularExpressions = new HashMap<String, ResolvedRegularExpression>();
        private MetadataImageBuilder topicsImageBuilder = new MetadataImageBuilder();

        public TargetAssignmentBuilderTestContext(String groupId, int groupEpoch) {
            this.groupId = groupId;
            this.groupEpoch = groupEpoch;
        }

        public void addGroupMember(String memberId, List<String> subscriptions, Map<Uuid, Set<Integer>> targetPartitions) {
            this.addGroupMember(memberId, null, subscriptions, "", targetPartitions);
        }

        public void addGroupMember(String memberId, List<String> subscriptions, String subscribedRegex, Map<Uuid, Set<Integer>> targetPartitions) {
            this.addGroupMember(memberId, null, subscriptions, subscribedRegex, targetPartitions);
        }

        public void addGroupMember(String memberId, String instanceId, List<String> subscriptions, Map<Uuid, Set<Integer>> targetPartitions) {
            this.addGroupMember(memberId, instanceId, subscriptions, "", targetPartitions);
        }

        public void addGroupMember(String memberId, String instanceId, List<String> subscriptions, String subscribedRegex, Map<Uuid, Set<Integer>> targetPartitions) {
            ConsumerGroupMember.Builder memberBuilder = new ConsumerGroupMember.Builder(memberId).setSubscribedTopicNames(subscriptions).setSubscribedTopicRegex(subscribedRegex);
            if (instanceId != null) {
                memberBuilder.setInstanceId(instanceId);
                this.staticMembers.put(instanceId, memberId);
            }
            this.members.put(memberId, memberBuilder.build());
            this.targetAssignment.put(memberId, new Assignment(targetPartitions));
        }

        public Uuid addTopicMetadata(String topicName, int numPartitions) {
            Uuid topicId = Uuid.randomUuid();
            this.subscriptionMetadata.put(topicName, new TopicMetadata(topicId, topicName, numPartitions));
            this.topicsImageBuilder = this.topicsImageBuilder.addTopic(topicId, topicName, numPartitions);
            return topicId;
        }

        public void updateMemberSubscription(String memberId, List<String> subscriptions) {
            this.updateMemberSubscription(memberId, subscriptions, Optional.empty(), Optional.empty());
        }

        public void updateMemberSubscription(String memberId, List<String> subscriptions, Optional<String> instanceId, Optional<String> rackId) {
            ConsumerGroupMember existingMember = this.members.get(memberId);
            ConsumerGroupMember.Builder builder = existingMember != null ? new ConsumerGroupMember.Builder(existingMember) : new ConsumerGroupMember.Builder(memberId);
            this.updatedMembers.put(memberId, builder.setSubscribedTopicNames(subscriptions).maybeUpdateInstanceId(instanceId).maybeUpdateRackId(rackId).build());
        }

        public void removeMemberSubscription(String memberId) {
            this.updatedMembers.put(memberId, null);
        }

        public void prepareMemberAssignment(String memberId, Map<Uuid, Set<Integer>> assignment) {
            this.memberAssignments.put(memberId, (MemberAssignment)new MemberAssignmentImpl(assignment));
        }

        public void addResolvedRegularExpression(String regex, ResolvedRegularExpression resolvedRegularExpression) {
            this.resolvedRegularExpressions.put(regex, resolvedRegularExpression);
        }

        private MemberSubscriptionAndAssignmentImpl newMemberSubscriptionAndAssignment(ConsumerGroupMember member, Assignment memberAssignment, TopicIds.TopicResolver topicResolver) {
            ResolvedRegularExpression resolvedRegularExpression;
            Set subscriptions = member.subscribedTopicNames();
            String subscribedTopicRegex = member.subscribedTopicRegex();
            if (subscribedTopicRegex != null && !subscribedTopicRegex.isEmpty() && (resolvedRegularExpression = this.resolvedRegularExpressions.get(subscribedTopicRegex)) != null) {
                if (subscriptions.isEmpty()) {
                    subscriptions = resolvedRegularExpression.topics;
                } else if (!resolvedRegularExpression.topics.isEmpty()) {
                    subscriptions = new UnionSet(subscriptions, resolvedRegularExpression.topics);
                }
            }
            return new MemberSubscriptionAndAssignmentImpl(Optional.ofNullable(member.rackId()), Optional.ofNullable(member.instanceId()), (Set)new TopicIds(subscriptions, topicResolver), memberAssignment);
        }

        public TargetAssignmentBuilder.TargetAssignmentResult build() {
            TopicsImage topicsImage = this.topicsImageBuilder.build().topics();
            TopicIds.CachedTopicResolver topicResolver = new TopicIds.CachedTopicResolver(topicsImage);
            HashMap<String, MemberSubscriptionAndAssignmentImpl> memberSubscriptions = new HashMap<String, MemberSubscriptionAndAssignmentImpl>();
            this.members.forEach((arg_0, arg_1) -> this.lambda$build$0(memberSubscriptions, (TopicIds.TopicResolver)topicResolver, arg_0, arg_1));
            this.updatedMembers.forEach((arg_0, arg_1) -> this.lambda$build$1(memberSubscriptions, (TopicIds.TopicResolver)topicResolver, arg_0, arg_1));
            HashMap topicMetadataMap = new HashMap();
            this.subscriptionMetadata.forEach((topicName, topicMetadata) -> topicMetadataMap.put(topicMetadata.id(), topicMetadata));
            SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadataMap);
            SubscriptionType subscriptionType = SubscriptionType.HOMOGENEOUS;
            Map<Uuid, Map<Integer, String>> invertedTargetAssignment = AssignmentTestUtil.invertedTargetAssignment(memberSubscriptions);
            GroupSpecImpl groupSpec = new GroupSpecImpl(memberSubscriptions, subscriptionType, invertedTargetAssignment);
            Mockito.when((Object)this.assignor.assign((GroupSpec)ArgumentMatchers.any(), (SubscribedTopicDescriber)ArgumentMatchers.any())).thenReturn((Object)new GroupAssignment(this.memberAssignments));
            TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder builder = ((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)((TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder)new TargetAssignmentBuilder.ConsumerTargetAssignmentBuilder(this.groupId, this.groupEpoch, this.assignor).withMembers(this.members)).withStaticMembers(this.staticMembers)).withSubscriptionMetadata(this.subscriptionMetadata)).withSubscriptionType(subscriptionType)).withTargetAssignment(this.targetAssignment)).withInvertedTargetAssignment(invertedTargetAssignment)).withTopicsImage(topicsImage)).withResolvedRegularExpressions(this.resolvedRegularExpressions);
            this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
                if (updatedMemberOrNull != null) {
                    builder.addOrUpdateMember(memberId, (ModernGroupMember)updatedMemberOrNull);
                } else {
                    builder.removeMember(memberId);
                }
            });
            TargetAssignmentBuilder.TargetAssignmentResult result = builder.build();
            ((PartitionAssignor)Mockito.verify((Object)this.assignor, (VerificationMode)Mockito.times((int)1))).assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
            return result;
        }

        private /* synthetic */ void lambda$build$1(Map memberSubscriptions, TopicIds.TopicResolver topicResolver, String memberId, ConsumerGroupMember updatedMemberOrNull) {
            if (updatedMemberOrNull == null) {
                memberSubscriptions.remove(memberId);
            } else {
                String previousMemberId;
                Assignment assignment = this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY);
                if (updatedMemberOrNull.instanceId() != null && (previousMemberId = this.staticMembers.get(updatedMemberOrNull.instanceId())) != null && !previousMemberId.equals(memberId)) {
                    assignment = this.targetAssignment.getOrDefault(previousMemberId, Assignment.EMPTY);
                }
                memberSubscriptions.put(memberId, this.newMemberSubscriptionAndAssignment(updatedMemberOrNull, assignment, topicResolver));
            }
        }

        private /* synthetic */ void lambda$build$0(Map memberSubscriptions, TopicIds.TopicResolver topicResolver, String memberId, ConsumerGroupMember member) {
            memberSubscriptions.put(memberId, this.newMemberSubscriptionAndAssignment(member, this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), topicResolver));
        }
    }
}

