/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.metrics.MetricsTestUtils;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        HashSet<MetricName> expectedMetrics = new HashSet<MetricName>(Arrays.asList(metrics.metricName("offset-commit-rate", "group-coordinator-metrics"), metrics.metricName("offset-commit-count", "group-coordinator-metrics"), metrics.metricName("offset-expiration-rate", "group-coordinator-metrics"), metrics.metricName("offset-expiration-count", "group-coordinator-metrics"), metrics.metricName("offset-deletion-rate", "group-coordinator-metrics"), metrics.metricName("offset-deletion-count", "group-coordinator-metrics"), metrics.metricName("group-completed-rebalance-rate", "group-coordinator-metrics"), metrics.metricName("group-completed-rebalance-count", "group-coordinator-metrics"), metrics.metricName("consumer-group-rebalance-rate", "group-coordinator-metrics"), metrics.metricName("consumer-group-rebalance-count", "group-coordinator-metrics"), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "mixed")), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.EMPTY.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.ASSIGNING.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.RECONCILING.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.STABLE.toString())), metrics.metricName("mixed-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.ASSIGNING.toString())), metrics.metricName("mixed-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.RECONCILING.toString())), metrics.metricName("mixed-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.STABLE.toString())), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("rebalance-rate", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("rebalance-count", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("share-group-count", "group-coordinator-metrics", "The number of share groups in empty state.", new String[]{"state", GroupState.EMPTY.toString()}), metrics.metricName("share-group-count", "group-coordinator-metrics", "The number of share groups in stable state.", new String[]{"state", GroupState.STABLE.toString()}), metrics.metricName("share-group-count", "group-coordinator-metrics", "The number of share groups in dead state.", new String[]{"state", GroupState.DEAD.toString()}), metrics.metricName("group-member-count", "group-coordinator-metrics", "The total number of groups using the classic rebalance protocol.", Collections.singletonMap("protocol", "classic")), metrics.metricName("group-member-count", "group-coordinator-metrics", "The total number of groups using the consumer rebalance protocol.", Collections.singletonMap("protocol", "consumer")), metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", "The longest pending rebalance time among the classic groups", Collections.singletonMap("protocol", "classic")), metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", "The longest pending rebalance time among the consumer groups", Collections.singletonMap("protocol", "consumer")), metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", "The longest pending rebalance time among the mixed groups", Collections.singletonMap("protocol", "mixed"))));
        try {
            try (GroupCoordinatorMetrics ignored = new GroupCoordinatorMetrics(Time.SYSTEM, registry, metrics);){
                HashSet<String> expectedRegistry = new HashSet<String>(Arrays.asList("kafka.coordinator.group:type=GroupMetadataManager,name=NumOffsets", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroups", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsPreparingRebalance", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsCompletingRebalance", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsStable", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsDead", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsEmpty", "kafka.coordinator.group:type=GroupMetadataManager,name=NumTotalGroupMembers", "kafka.coordinator.group:type=GroupMetadataManager,name=MaxPendingRebalanceTime"));
                MetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", expectedRegistry);
                expectedMetrics.forEach(metricName -> Assertions.assertTrue((boolean)metrics.metrics().containsKey(metricName)));
            }
            MetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", Collections.emptySet());
            expectedMetrics.forEach(metricName -> Assertions.assertFalse((boolean)metrics.metrics().containsKey(metricName)));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void aggregateShards() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(Time.SYSTEM, registry, metrics);
        SnapshotRegistry snapshotRegistry0 = new SnapshotRegistry(new LogContext());
        SnapshotRegistry snapshotRegistry1 = new SnapshotRegistry(new LogContext());
        TopicPartition tp0 = new TopicPartition("__consumer_offsets", 0);
        TopicPartition tp1 = new TopicPartition("__consumer_offsets", 1);
        GroupCoordinatorMetricsShard shard0 = coordinatorMetrics.newMetricsShard(snapshotRegistry0, tp0);
        GroupCoordinatorMetricsShard shard1 = coordinatorMetrics.newMetricsShard(snapshotRegistry1, tp1);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard0);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard1);
        shard0.setClassicGroupGauges(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.PREPARING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.COMPLETING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.STABLE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.EMPTY, (Object)1L)}));
        shard1.setClassicGroupGauges(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.PREPARING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.COMPLETING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.STABLE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.EMPTY, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.DEAD, (Object)1L)}));
        shard0.setNumClassicGroupMembers(Long.valueOf(10L));
        shard1.setNumClassicGroupMembers(Long.valueOf(20L));
        shard0.setConsumerGroupGauges(Collections.singletonMap(ConsumerGroup.ConsumerGroupState.ASSIGNING, 5L));
        shard1.setConsumerGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.RECONCILING, 1L, ConsumerGroup.ConsumerGroupState.DEAD, 1L));
        shard0.setNumConsumerGroupMembers(Long.valueOf(15L));
        shard1.setNumConsumerGroupMembers(Long.valueOf(25L));
        shard0.setMixedGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.STABLE, 2L, ConsumerGroup.ConsumerGroupState.ASSIGNING, 2L));
        shard1.setMixedGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.RECONCILING, 1L, ConsumerGroup.ConsumerGroupState.DEAD, 1L));
        shard0.setShareGroupGauges(Map.of(ShareGroup.ShareGroupState.STABLE, 2L));
        shard1.setShareGroupGauges(Map.of(ShareGroup.ShareGroupState.EMPTY, 2L, ShareGroup.ShareGroupState.STABLE, 3L, ShareGroup.ShareGroupState.DEAD, 1L));
        IntStream.range(0, 6).forEach(__ -> shard0.incrementNumOffsets());
        IntStream.range(0, 2).forEach(__ -> shard1.incrementNumOffsets());
        IntStream.range(0, 1).forEach(__ -> shard1.decrementNumOffsets());
        Assertions.assertEquals((long)4L, (long)shard0.numClassicGroups());
        Assertions.assertEquals((long)5L, (long)shard1.numClassicGroups());
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroups"), 9L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 9L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumTotalGroupMembers"), 30L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-member-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 30L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-member-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 40L);
        snapshotRegistry0.idempotentCreateSnapshot(1000L);
        snapshotRegistry1.idempotentCreateSnapshot(1500L);
        shard0.commitUpTo(1000L);
        shard1.commitUpTo(1500L);
        Assertions.assertEquals((long)5L, (long)shard0.numConsumerGroups());
        Assertions.assertEquals((long)2L, (long)shard1.numConsumerGroups());
        Assertions.assertEquals((long)4L, (long)shard0.numMixedGroups());
        Assertions.assertEquals((long)2L, (long)shard1.numMixedGroups());
        Assertions.assertEquals((long)6L, (long)shard0.numOffsets());
        Assertions.assertEquals((long)1L, (long)shard1.numOffsets());
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 7L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "mixed")), 6L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumOffsets"), 7L);
        Assertions.assertEquals((long)2L, (long)shard0.numShareGroups());
        Assertions.assertEquals((long)6L, (long)shard1.numShareGroups());
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "share")), 8L);
    }

    @Test
    public void testGlobalSensors() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics((Time)time, registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), new TopicPartition("__consumer_offsets", 0));
        shard.record("CompletedRebalances", 10.0);
        this.assertMetricValue(metrics, metrics.metricName("group-completed-rebalance-rate", "group-coordinator-metrics"), 0.3333333333333333);
        this.assertMetricValue(metrics, metrics.metricName("group-completed-rebalance-count", "group-coordinator-metrics"), 10.0);
        shard.record("OffsetCommits", 20.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-commit-rate", "group-coordinator-metrics"), 0.6666666666666666);
        this.assertMetricValue(metrics, metrics.metricName("offset-commit-count", "group-coordinator-metrics"), 20.0);
        shard.record("OffsetExpired", 30.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-expiration-rate", "group-coordinator-metrics"), 1.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-expiration-count", "group-coordinator-metrics"), 30.0);
        shard.record("ConsumerGroupRebalances", 50.0);
        this.assertMetricValue(metrics, metrics.metricName("consumer-group-rebalance-rate", "group-coordinator-metrics"), 1.6666666666666667);
        this.assertMetricValue(metrics, metrics.metricName("consumer-group-rebalance-count", "group-coordinator-metrics"), 50.0);
        shard.record("ShareGroupRebalances", 50.0);
        this.assertMetricValue(metrics, metrics.metricName("rebalance-rate", "group-coordinator-metrics", "The rate of share group rebalances", new String[]{"protocol", "share"}), 1.6666666666666667);
        this.assertMetricValue(metrics, metrics.metricName("rebalance-count", "group-coordinator-metrics", "The total number of share group rebalances", new String[]{"protocol", "share"}), 50.0);
    }

    @Test
    public void testMaxPendingRebalanceTimeMetric() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics((Time)time, registry, metrics);
        GroupCoordinatorMetricsShard shard0 = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), new TopicPartition("__consumer_offsets", 0));
        GroupCoordinatorMetricsShard shard1 = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), new TopicPartition("__consumer_offsets", 1));
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard0);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard1);
        long now = time.milliseconds();
        shard0.setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(now - 1000L));
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "MaxPendingRebalanceTime"), 1000L);
        shard0.setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "MaxPendingRebalanceTime"), 0L);
        shard0.setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(now - 1000L));
        shard1.setConsumerGroupMinRebalanceStartTimestamps(Long.valueOf(now - 3000L));
        shard1.setMixedGroupMinRebalanceStartTimestamps(Long.valueOf(now - 2000L));
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "MaxPendingRebalanceTime"), 3000L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 1000L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 3000L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "mixed")), 2000L);
        shard1.setConsumerGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "MaxPendingRebalanceTime"), 2000L);
        shard0.setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        shard1.setMixedGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "MaxPendingRebalanceTime"), 0L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 0L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 0L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-max-pending-rebalance-time", "group-coordinator-metrics", Collections.singletonMap("protocol", "mixed")), 0L);
    }

    @Test
    public void testAssignmentBuildTimeMetrics() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics((Time)time, new MetricsRegistry(), metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), new TopicPartition("__consumer_offsets", 0));
        IntStream.range(1, 1001).forEach(i -> shard.record("AssignmentBuild", (double)i));
        String metricNamePrefix = "assignment-build-time-ms";
        KafkaMetric metric = (KafkaMetric)metrics.metrics().get(metrics.metricName(metricNamePrefix + "-max", "group-coordinator-metrics", "The max assignment build time in milliseconds"));
        Assertions.assertEquals((Object)1000.0, (Object)metric.metricValue());
        metric = (KafkaMetric)metrics.metrics().get(metrics.metricName(metricNamePrefix + "-p50", "group-coordinator-metrics", "The max assignment build time in milliseconds"));
        Assertions.assertEquals((Object)500.0, (Object)metric.metricValue());
        metric = (KafkaMetric)metrics.metrics().get(metrics.metricName(metricNamePrefix + "-p95", "group-coordinator-metrics", "The max assignment build time in milliseconds"));
        Assertions.assertEquals((Object)950.0, (Object)metric.metricValue());
        metric = (KafkaMetric)metrics.metrics().get(metrics.metricName(metricNamePrefix + "-p99", "group-coordinator-metrics", "The max assignment build time in milliseconds"));
        Assertions.assertEquals((Object)990.0, (Object)metric.metricValue());
        metric = (KafkaMetric)metrics.metrics().get(metrics.metricName(metricNamePrefix + "-p999", "group-coordinator-metrics", "The max assignment build time in milliseconds"));
        Assertions.assertEquals((Object)999.0, (Object)metric.metricValue());
    }

    private void assertMetricValue(Metrics metrics, MetricName metricName, double val) {
        Assertions.assertEquals((Object)val, (Object)metrics.metric(metricName).metricValue());
    }
}

