/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.classic;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClassicGroupMemberTest {
    @Test
    public void testMatchesSupportedProtocols() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0}));
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", protocols, new byte[0]);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection collection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        collection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0}));
        Assertions.assertTrue((boolean)member.matches(collection));
        collection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        collection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{1}));
        Assertions.assertFalse((boolean)member.matches(collection));
        collection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        collection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        Assertions.assertFalse((boolean)member.matches(collection));
        collection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        collection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        collection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        Assertions.assertFalse((boolean)member.matches(collection));
        Assertions.assertTrue((boolean)member.matches(protocols));
    }

    @Test
    public void testVoteForPreferredProtocol() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[0]));
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[0]));
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", protocols, ClassicGroupMember.EMPTY_ASSIGNMENT);
        HashSet<String> expectedProtocolNames = new HashSet<String>();
        expectedProtocolNames.add("range");
        expectedProtocolNames.add("roundrobin");
        Assertions.assertEquals((Object)"range", (Object)member.vote(expectedProtocolNames));
        expectedProtocolNames.clear();
        expectedProtocolNames.add("unknown");
        expectedProtocolNames.add("roundrobin");
        Assertions.assertEquals((Object)"roundrobin", (Object)member.vote(expectedProtocolNames));
    }

    @Test
    public void testMetadata() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0}));
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[]{1}));
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", protocols, ClassicGroupMember.EMPTY_ASSIGNMENT);
        Assertions.assertArrayEquals((byte[])new byte[]{0}, (byte[])member.metadata("range"));
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])member.metadata("roundrobin"));
    }

    @Test
    public void testMetadataRaisesOnUnsupportedProtocol() {
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(), ClassicGroupMember.EMPTY_ASSIGNMENT);
        Assertions.assertThrows(IllegalArgumentException.class, () -> member.metadata("unknown"));
    }

    @Test
    public void testVoteRaisesOnNoSupportedProtocols() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0}));
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[]{1}));
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", protocols, ClassicGroupMember.EMPTY_ASSIGNMENT);
        Assertions.assertThrows(IllegalArgumentException.class, () -> member.vote(Set.of("unknown")));
    }

    @Test
    public void testHasValidGroupInstanceId() {
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(), ClassicGroupMember.EMPTY_ASSIGNMENT);
        Assertions.assertTrue((boolean)member.isStaticMember());
        Assertions.assertEquals(Optional.of("group-instance-id"), (Object)member.groupInstanceId());
    }

    @Test
    public void testPlainProtocolSet() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocolCollection = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
        protocolCollection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0}));
        protocolCollection.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(new byte[]{1}));
        HashSet<String> expectedProtocolNames = new HashSet<String>();
        expectedProtocolNames.add("range");
        expectedProtocolNames.add("roundrobin");
        Assertions.assertEquals(expectedProtocolNames, (Object)ClassicGroupMember.plainProtocolSet((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocolCollection));
    }

    @Test
    public void testHasHeartbeatSatisfied() {
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(), ClassicGroupMember.EMPTY_ASSIGNMENT);
        Assertions.assertFalse((boolean)member.hasSatisfiedHeartbeat());
        member.setIsNew(true);
        Assertions.assertFalse((boolean)member.hasSatisfiedHeartbeat());
        member.setIsNew(false);
        member.setAwaitingJoinFuture(new CompletableFuture());
        Assertions.assertTrue((boolean)member.hasSatisfiedHeartbeat());
        member.setAwaitingJoinFuture(null);
        member.setAwaitingSyncFuture(new CompletableFuture());
        Assertions.assertTrue((boolean)member.hasSatisfiedHeartbeat());
    }

    @Test
    public void testDescribeNoMetadata() {
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(), new byte[0]);
        DescribeGroupsResponseData.DescribedGroupMember expectedDescribedGroupMember = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setGroupInstanceId("group-instance-id").setClientId("client-id").setClientHost("client-host").setMemberAssignment(new byte[0]);
        DescribeGroupsResponseData.DescribedGroupMember describedGroupMember = member.describeNoMetadata();
        Assertions.assertEquals((Object)expectedDescribedGroupMember, (Object)describedGroupMember);
    }

    @Test
    public void testDescribe() {
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(List.of(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(new byte[]{0})).iterator());
        ClassicGroupMember member = new ClassicGroupMember("member", Optional.of("group-instance-id"), "client-id", "client-host", 10, 4500, "generic", protocols, new byte[0]);
        DescribeGroupsResponseData.DescribedGroupMember expectedDescribedGroupMember = new DescribeGroupsResponseData.DescribedGroupMember().setMemberId("member").setGroupInstanceId("group-instance-id").setClientId("client-id").setClientHost("client-host").setMemberAssignment(new byte[0]).setMemberMetadata(member.metadata("range"));
        DescribeGroupsResponseData.DescribedGroupMember describedGroupMember = member.describe("range");
        Assertions.assertEquals((Object)expectedDescribedGroupMember, (Object)describedGroupMember);
    }
}

