/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UniformHeterogeneousAssignmentBuilderTest {
    private final UniformAssignor assignor = new UniformAssignor();
    private final Uuid topic1Uuid = Uuid.fromString((String)"T1-A4s3VTwiI5CTbEp6POw");
    private final Uuid topic2Uuid = Uuid.fromString((String)"T2-B4s3VTwiI5YHbPp6YUe");
    private final Uuid topic3Uuid = Uuid.fromString((String)"T3-CU8fVTLCz5YMkLoDQsa");
    private final Uuid topic4Uuid = Uuid.fromString((String)"T4-Tw9fVTLCz5HbPp6YQsa");
    private final String topic1Name = "topic1";
    private final String topic2Name = "topic2";
    private final String topic3Name = "topic3";
    private final String topic4Name = "topic4";
    private final String memberA = "A";
    private final String memberB = "B";
    private final String memberC = "C";

    @Test
    public void testTwoMembersNoTopicSubscription() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        GroupAssignment groupAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testTwoMembersSubscribedToNonexistentTopics() {
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3)));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic2Uuid), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.lambda$testTwoMembersSubscribedToNonexistentTopics$0((GroupSpec)groupSpec, subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 6));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3, 5)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumMembersGreaterThanTotalNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 1));
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic3Uuid), Assignment.EMPTY));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic1Uuid), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", Collections.emptyMap());
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentForTwoMembersThreeTopicsGivenUnbalancedPrevAssignment() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 4));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 4));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic1Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 4, 5), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3)))));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 5)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 4), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenPartitionsAreAddedForTwoMembers() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 3));
        topicMetadata.put(this.topic4Uuid, new TopicMetadata(this.topic4Uuid, "topic4", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid, this.topic4Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2)))));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAndPartitionsAddedTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 7));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic1Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)))));
        members.put("C", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 3, 4, 5)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2, 6)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 3, 4, 5)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberRemovedAfterInitialAssignmentWithThreeMembersThreeTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 8));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic3Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 3, 4, 5, 6)))));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4, 5, 6, 7)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.singleton(this.topic1Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 3)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2, 4)))));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenTopicPartitionsRunOutAndMembersHaveNoPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)))));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, AssignmentTestUtil.invertedTargetAssignment(members));
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentWithTwoMembersIncludingOneWithoutSubscriptions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3));
        TreeMap<String, MemberSubscriptionAndAssignmentImpl> members = new TreeMap<String, MemberSubscriptionAndAssignmentImpl>();
        members.put("A", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topic1Uuid), Assignment.EMPTY));
        members.put("B", new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Collections.emptySet(), Assignment.EMPTY));
        TestGroupSpecImpl groupSpec = new TestGroupSpecImpl(members, SubscriptionType.HETEROGENEOUS, Collections.emptyMap());
        SubscribedTopicDescriberImpl subscribedTopicMetadata = new SubscribedTopicDescriberImpl(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign((GroupSpec)groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        expectedAssignment.put("B", Collections.emptyMap());
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    private /* synthetic */ void lambda$testTwoMembersSubscribedToNonexistentTopics$0(GroupSpec groupSpec, SubscribedTopicDescriberImpl subscribedTopicMetadata) throws Throwable {
        this.assignor.assign(groupSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
    }

    private static class TestGroupSpecImpl
    extends GroupSpecImpl {
        private final List<String> orderedMembers;

        public TestGroupSpecImpl(Map<String, MemberSubscriptionAndAssignmentImpl> members, SubscriptionType subscriptionType, Map<Uuid, Map<Integer, String>> invertedMemberAssignment) {
            super(members, subscriptionType, invertedMemberAssignment);
            this.orderedMembers = new ArrayList<String>(members.keySet());
            this.orderedMembers.sort(null);
        }

        public Collection<String> memberIds() {
            return this.orderedMembers;
        }
    }
}

