/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.GroupSpecImpl;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GroupSpecImplTest {
    private static final String TEST_MEMBER = "test-member";
    private Map<String, MemberSubscriptionAndAssignmentImpl> members;
    private SubscriptionType subscriptionType;
    private Map<Uuid, Map<Integer, String>> invertedTargetAssignment;
    private GroupSpecImpl groupSpec;
    private Uuid topicId;

    @BeforeEach
    void setUp() {
        this.members = new HashMap<String, MemberSubscriptionAndAssignmentImpl>();
        this.subscriptionType = SubscriptionType.HOMOGENEOUS;
        this.invertedTargetAssignment = new HashMap<Uuid, Map<Integer, String>>();
        this.topicId = Uuid.randomUuid();
        this.members.put(TEST_MEMBER, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topicId), Assignment.EMPTY));
        this.groupSpec = new GroupSpecImpl(this.members, this.subscriptionType, this.invertedTargetAssignment);
    }

    @Test
    void testMemberIds() {
        Assertions.assertEquals(this.members.keySet(), (Object)this.groupSpec.memberIds());
    }

    @Test
    void testSubscriptionType() {
        Assertions.assertEquals((Object)this.subscriptionType, (Object)this.groupSpec.subscriptionType());
    }

    @Test
    void testIsPartitionAssigned() {
        HashMap<Integer, String> partitionMap = new HashMap<Integer, String>();
        partitionMap.put(1, TEST_MEMBER);
        this.invertedTargetAssignment.put(this.topicId, partitionMap);
        Assertions.assertTrue((boolean)this.groupSpec.isPartitionAssigned(this.topicId, 1));
        Assertions.assertFalse((boolean)this.groupSpec.isPartitionAssigned(this.topicId, 2));
        Assertions.assertFalse((boolean)this.groupSpec.isPartitionAssigned(Uuid.randomUuid(), 2));
    }

    @Test
    void testMemberSubscription() {
        Assertions.assertEquals((Object)this.members.get(TEST_MEMBER), (Object)this.groupSpec.memberSubscription(TEST_MEMBER));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.groupSpec.memberSubscription("unknown-member"));
    }

    @Test
    void testMemberAssignment() {
        HashMap<Uuid, Set<Integer>> topicPartitions = new HashMap<Uuid, Set<Integer>>();
        topicPartitions.put(this.topicId, Set.of(Integer.valueOf(0), Integer.valueOf(1)));
        this.members.put(TEST_MEMBER, new MemberSubscriptionAndAssignmentImpl(Optional.empty(), Optional.empty(), Set.of(this.topicId), new Assignment(topicPartitions)));
        Assertions.assertEquals(topicPartitions, (Object)this.groupSpec.memberAssignment(TEST_MEMBER).partitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)this.groupSpec.memberAssignment("unknown-member").partitions());
    }
}

