/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;

public class MockPartitionAssignor
implements ConsumerGroupPartitionAssignor,
ShareGroupPartitionAssignor {
    private final String name;
    private final MockTime mockTime;
    private final long assignorTimeMs;
    private GroupAssignment prepareGroupAssignment = null;

    MockPartitionAssignor(String name, MockTime mockTime, long assignorTimeMs) {
        this.name = name;
        this.mockTime = mockTime;
        this.assignorTimeMs = assignorTimeMs;
    }

    MockPartitionAssignor(String name) {
        this(name, null, 0L);
    }

    public void prepareGroupAssignment(GroupAssignment prepareGroupAssignment) {
        this.prepareGroupAssignment = prepareGroupAssignment;
    }

    public String name() {
        return this.name;
    }

    public GroupAssignment assign(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) throws PartitionAssignorException {
        if (this.mockTime != null) {
            this.mockTime.sleep(this.assignorTimeMs);
        }
        return this.prepareGroupAssignment;
    }

    public Map<Uuid, Set<Integer>> targetPartitions(String memberId) {
        Objects.requireNonNull(this.prepareGroupAssignment);
        return ((MemberAssignment)this.prepareGroupAssignment.members().get(memberId)).partitions();
    }
}

