/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InconsistentGroupProtocolException;
import org.apache.kafka.common.errors.InvalidRegularExpression;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnreleasedInstanceIdException;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.MockCoordinatorExecutor;
import org.apache.kafka.coordinator.common.runtime.MockCoordinatorTimer;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.GroupMetadataManagerTestContext;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.MockPartitionAssignor;
import org.apache.kafka.coordinator.group.NoOpPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupBuilder;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupBuilder;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupMember;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GroupMetadataManagerTest {
    @Test
    public void testConsumerHeartbeatRequestValidation() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MemberId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("   ")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("foo").setMemberEpoch(0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RebalanceTimeoutMs must be provided in first request.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("foo").setMemberEpoch(0).setRebalanceTimeoutMs(5000)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TopicPartitions must be empty when (re-)joining.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("foo").setMemberEpoch(0).setRebalanceTimeoutMs(5000).setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Either SubscribedTopicNames or SubscribedTopicRegex must be non-null when (re-)joining.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(1).setInstanceId("")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"InstanceId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(1).setRackId("")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RackId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedAssignorException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(1).setServerAssignor("bar")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ServerAssignor bar is not supported. Supported assignors: range.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"InstanceId can't be null.", (Object)ex.getMessage());
    }

    @Test
    public void testConsumerHeartbeatRegexValidation() {
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRegularExpression.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(Uuid.randomUuid().toString()).setGroupId("foo").setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("[").setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SubscribedTopicRegex `[` is not a valid regular expression: missing closing ].", (Object)ex.getMessage());
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex(".*").setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertThrows(InvalidRegularExpression.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(1).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("[").setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SubscribedTopicRegex `[` is not a valid regular expression: missing closing ].", (Object)ex.getMessage());
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(memberId).setMemberEpoch(1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
    }

    @Test
    public void testMemberIdGeneration() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(MetadataImage.EMPTY).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("group-foo").setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()), (short)0);
        String memberId = ((ConsumerGroupHeartbeatResponseData)result.response()).memberId();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)memberId);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"", (Object)memberId);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (Object)result.response());
    }

    @Test
    public void testUnknownGroupId() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(100).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testUnknownMemberIdJoinsConsumerGroup() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).build();
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("no-op").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupMemberEpochValidation() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(100).setPreviousMemberEpoch(99).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)member));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)100));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)100));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(200).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(50).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(1), Integer.valueOf(2))))));
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
    }

    @Test
    public void testMemberJoinsEmptyConsumerGroup() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup(groupId));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testUpdatingSubscriptionTriggersNewTargetAssignment() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockTime time = new MockTime(0L, 0L, 0L);
        MockPartitionAssignor assignor = new MockPartitionAssignor("range", time, 2000L);
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withTime(time).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        time.sleep(1000L);
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10).setSubscribedTopicNames(List.of("foo", "bar")));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).record("AssignmentBuild", 2000.0);
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testNewJoiningMemberTriggersNewTargetAssignment() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), memberId3, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setState(MemberState.UNRELEASED_PARTITIONS).setMemberEpoch(11).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3))), result.records());
    }

    @Test
    public void testLeavingMemberBumpsGroupEpoch() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-1), (ApiMessage)result.response());
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testGroupEpochBumpWhenNewStaticMemberJoins() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), memberId3, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setInstanceId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setState(MemberState.UNRELEASED_PARTITIONS).setInstanceId(memberId3).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3))), result.records());
    }

    @Test
    public void testStaticMemberGetsBackAssignmentUponRejoin() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String member2RejoinId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3)))).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(-2).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-2), (ApiMessage)result.response());
        ConsumerGroupMember member2UpdatedEpoch = new ConsumerGroupMember.Builder(member2).setMemberEpoch(-2).build();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertRecordEquals((CoordinatorRecord)result.records().get(0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member2UpdatedEpoch));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> rejoinResult = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(member2RejoinId).setGroupId(groupId).setInstanceId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(member2RejoinId).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(2)))))), (ApiMessage)rejoinResult.response());
        ConsumerGroupMember expectedCopiedMember = new ConsumerGroupMember.Builder(member2RejoinId).setState(MemberState.STABLE).setMemberEpoch(0).setPreviousMemberEpoch(0).setInstanceId(memberId2).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        ConsumerGroupMember expectedRejoinedMember = new ConsumerGroupMember.Builder(member2RejoinId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(0).setInstanceId(memberId2).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        List<CoordinatorRecord> expectedRecordsAfterRejoin = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)member2RejoinId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedRejoinedMember));
        Assertions.assertRecordsEquals(expectedRecordsAfterRejoin, rejoinResult.records());
        context.assertNoSessionTimeout(groupId, memberId2);
        context.assertNoRebalanceTimeout(groupId, memberId2);
    }

    @Test
    public void testStaticMemberRejoinsWithNewSubscribedTopics() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String member2RejoinId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId("instance-id-1").setMemberEpoch(10).setPreviousMemberEpoch(9).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setInstanceId("instance-id-2").setMemberEpoch(10).setPreviousMemberEpoch(9).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).withAssignmentEpoch(10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6)))).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))), member2RejoinId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId("instance-id-2").setMemberEpoch(-2));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-2), (ApiMessage)result.response());
        ConsumerGroupMember member2UpdatedEpoch = new ConsumerGroupMember.Builder(member2).setMemberEpoch(-2).build();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertRecordEquals((CoordinatorRecord)result.records().get(0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member2UpdatedEpoch));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> rejoinResult = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(member2RejoinId).setGroupId(groupId).setInstanceId("instance-id-2").setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(member2RejoinId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)rejoinResult.response());
        ConsumerGroupMember expectedCopiedMember = new ConsumerGroupMember.Builder(member2RejoinId).setState(MemberState.STABLE).setMemberEpoch(0).setPreviousMemberEpoch(0).setInstanceId("instance-id-2").setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build();
        ConsumerGroupMember expectedRejoinedMember = new ConsumerGroupMember.Builder(member2RejoinId).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(0).setInstanceId("instance-id-2").setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<CoordinatorRecord> expectedRecordsAfterRejoin = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)member2RejoinId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedRejoinedMember), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)member2RejoinId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedRejoinedMember));
        Assertions.assertRecordsEquals(expectedRecordsAfterRejoin, rejoinResult.records());
        context.assertNoSessionTimeout(groupId, memberId2);
        context.assertNoRebalanceTimeout(groupId, memberId2);
    }

    @Test
    public void testNoGroupEpochBumpWhenStaticMemberTemporarilyLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-2), (ApiMessage)result.response());
        ConsumerGroupMember member2UpdatedEpoch = new ConsumerGroupMember.Builder(member2).setMemberEpoch(-2).build();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertRecordEquals((CoordinatorRecord)result.records().get(0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member2UpdatedEpoch));
    }

    @Test
    public void testLeavingStaticMemberBumpsGroupEpoch() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setInstanceId(memberId2).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-1), (ApiMessage)result.response());
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testShouldThrownUnreleasedInstanceIdExceptionWhenNewMemberJoinsWithInUseInstanceId() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnreleasedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrownUnknownMemberIdExceptionWhenUnknownStaticMemberJoins() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrowFencedInstanceIdExceptionWhenStaticMemberWithDifferentMemberIdJoins() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-" + memberId1).setInstanceId(memberId1).setMemberEpoch(11).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupMemberEpochValidationForStaticMember() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setInstanceId(memberId).setMemberEpoch(100).setPreviousMemberEpoch(99).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)member));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)100));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)100));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(200).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(50).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar"))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(1), Integer.valueOf(2))))));
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
    }

    @Test
    public void testShouldThrowUnknownMemberIdExceptionWhenUnknownStaticMemberLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setInstanceId("unknown-" + memberId1).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrowFencedInstanceIdExceptionWhenStaticMemberWithDifferentMemberIdLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-" + memberId1).setInstanceId(memberId1).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupHeartbeatFullResponse() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))))), (ApiMessage)result.response());
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))))), (ApiMessage)result.response());
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo.*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))))), (ApiMessage)result.response());
    }

    @Test
    public void testReconciliationProcess() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))), memberId3, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        Assertions.assertRecordEquals(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setState(MemberState.UNRELEASED_PARTITIONS).setMemberEpoch(11).setPreviousMemberEpoch(0).build()), (CoordinatorRecord)result.records().get(result.records().size() - 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNRELEASED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0)))))), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNREVOKED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(2)))))), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNREVOKED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setState(MemberState.UNRELEASED_PARTITIONS).setMemberEpoch(11).setPreviousMemberEpoch(11).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNRELEASED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1))), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0))))));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(11).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNREVOKED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(1)))))), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setState(MemberState.UNRELEASED_PARTITIONS).setMemberEpoch(11).setPreviousMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNRELEASED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.UNRELEASED_PARTITIONS, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3))), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(2))))));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(2), Integer.valueOf(3))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(2)))))), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(1))))));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(1)))))), (ApiMessage)result.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
    }

    @Test
    public void testNewMemberIsRejectedWithMaximumMembersIsReached() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build()).withConfig("group.consumer.max.size", 2).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupMaxSizeReachedException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupStates() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10)).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)context.consumerGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setSubscribedTopicNames(List.of(fooTopicName)).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)context.consumerGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
    }

    @Test
    public void testPartitionAssignorExceptionOnRegularHeartbeat() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        ConsumerGroupPartitionAssignor assignor = (ConsumerGroupPartitionAssignor)Mockito.mock(ConsumerGroupPartitionAssignor.class);
        Mockito.when((Object)assignor.name()).thenReturn((Object)"range");
        Mockito.when((Object)assignor.assign((GroupSpec)ArgumentMatchers.any(), (SubscribedTopicDescriber)ArgumentMatchers.any())).thenThrow(new Throwable[]{new PartitionAssignorException("Assignment failed.")});
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownServerException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testSubscriptionMetadataRefreshedAfterGroupIsLoaded() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 3)))).build();
        ConsumerGroup consumerGroup = context.groupMetadataManager.consumerGroup(groupId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))))), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + Integer.MAX_VALUE), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
    }

    @Test
    public void testSubscriptionMetadataRefreshedAgainAfterWriteFailure() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 3)))).build();
        ConsumerGroup consumerGroup = context.groupMetadataManager.consumerGroup(groupId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + Integer.MAX_VALUE), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
        context.rollback();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))))), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + Integer.MAX_VALUE), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
    }

    @Test
    public void testGroupIdsByTopics() {
        String groupId1 = "group1";
        String groupId2 = "group2";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m1").setSubscribedTopicNames(List.of("foo", "bar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(List.of("foo", "bar", "zar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m2").setSubscribedTopicNames(List.of("bar", "zar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(List.of("foo", "bar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId1, (String)"group1-m1"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId1, (String)"group1-m1"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1, groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(List.of("foo")).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId2), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(groupId1), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m2").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
    }

    @Test
    public void testOnNewMetadataImageWithEmptyDelta() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(new MockPartitionAssignor("range"))).build();
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        context.groupMetadataManager.onNewMetadataImage(image, delta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)image, (Object)context.groupMetadataManager.image());
    }

    @Test
    public void testOnNewMetadataImage() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group1", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m1").setSubscribedTopicNames(List.of("a", "b")).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group2", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(List.of("b", "c")).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group3", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group3-m1").setSubscribedTopicNames(List.of("d")).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group4", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group4-m1").setSubscribedTopicNames(List.of("e")).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group5", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group5-m1").setSubscribedTopicNames(List.of("f")).build()));
        List.of("group1", "group2", "group3", "group4", "group5").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
            group.setMetadataRefreshDeadline(context.time.milliseconds() + 5000L, 0);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        Uuid topicA = Uuid.randomUuid();
        Uuid topicB = Uuid.randomUuid();
        Uuid topicC = Uuid.randomUuid();
        Uuid topicD = Uuid.randomUuid();
        Uuid topicE = Uuid.randomUuid();
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        delta.replay(new TopicRecord().setTopicId(topicA).setName("a"));
        delta.replay(new PartitionRecord().setTopicId(topicA).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicB).setName("b"));
        delta.replay(new PartitionRecord().setTopicId(topicB).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicC).setName("c"));
        delta.replay(new PartitionRecord().setTopicId(topicC).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicD).setName("d"));
        delta.replay(new PartitionRecord().setTopicId(topicD).setPartitionId(0));
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        delta = new MetadataDelta(image, __ -> null, new MetadataEncryptorFactory());
        delta.replay(new PartitionRecord().setTopicId(topicB).setPartitionId(2));
        delta.replay(new RemoveTopicRecord().setTopicId(topicD));
        delta.replay(new TopicRecord().setTopicId(topicE).setName("e"));
        delta.replay(new PartitionRecord().setTopicId(topicE).setPartitionId(1));
        image = delta.apply(MetadataProvenance.EMPTY);
        context.groupMetadataManager.onNewMetadataImage(image, delta);
        List.of("group1", "group2", "group3", "group4").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        List.of("group5").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)image, (Object)context.groupMetadataManager.image());
    }

    @Test
    public void testSessionTimeoutLifecycle() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(-1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRebalanceTimeout(groupId, memberId);
    }

    @Test
    public void testSessionTimeoutExpiration() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(45001L);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.groupSessionTimeoutKey((String)groupId, (String)memberId), new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)2))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRebalanceTimeout(groupId, memberId);
    }

    @Test
    public void testSessionTimeoutExpirationStaticMember() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(-2).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-2, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(45001L);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.groupSessionTimeoutKey((String)groupId, (String)memberId), new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)2))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRebalanceTimeout(groupId, memberId);
    }

    @Test
    public void testRebalanceTimeoutLifecycle() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(180000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))))));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(2).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setRebalanceTimeoutMs(12000).setSubscribedTopicNames(List.of("foo")));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))))), (ApiMessage)result.response());
        MockCoordinatorTimer.ScheduledTimeout<Void, CoordinatorRecord> scheduledTimeout = context.assertRebalanceTimeout(groupId, memberId1, 12000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1))))));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(2).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        context.assertNoRebalanceTimeout(groupId, memberId1);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)scheduledTimeout.operation.generateRecords().records());
    }

    @Test
    public void testRebalanceTimeoutExpiration() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(10000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))))));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(10000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(2).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1)))))), (ApiMessage)result.response());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(10001L);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.consumerGroupRebalanceTimeoutKey((String)groupId, (String)memberId1), new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)3))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId1);
        context.assertNoRebalanceTimeout(groupId, memberId1);
    }

    @Test
    public void testOnLoaded() {
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build()).withConsumerGroup(new ConsumerGroupBuilder("foo", 10).withMember(new ConsumerGroupMember.Builder("foo-1").setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(9).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build()).withMember(new ConsumerGroupMember.Builder("foo-2").setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").build()).withAssignment("foo-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.onLoaded();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)context.timer.timeout(GroupMetadataManager.groupSessionTimeoutKey((String)"foo", (String)"foo-1")));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)context.timer.timeout(GroupMetadataManager.groupSessionTimeoutKey((String)"foo", (String)"foo-2")));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)context.timer.timeout(GroupMetadataManager.consumerGroupRebalanceTimeoutKey((String)"foo", (String)"foo-1")));
    }

    @Test
    public void testUpdateGroupMetrics() {
        ArrayList groupIds = new ArrayList();
        IntStream.range(0, 8).forEach(i -> groupIds.add("group-" + i));
        List<String> classicMemberIds = List.of("classic-member-id-0", "classic-member-id-1", "classic-member-id-2");
        List<String> consumerMemberIds = List.of("consumer-member-id-0", "consumer-member-id-1", "consumer-member-id-2");
        ArrayList classicMembers = new ArrayList();
        classicMemberIds.forEach(memberId -> classicMembers.add(new ClassicGroupMember(memberId, Optional.empty(), "client", "host", 1000, 1000, "consumer", new JoinGroupRequestData.JoinGroupRequestProtocolCollection(Collections.singletonList(new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range")).iterator()))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder((String)groupIds.get(0), 10)).withConsumerGroup(new ConsumerGroupBuilder((String)groupIds.get(1), 10).withAssignmentEpoch(10).withMember(new ConsumerGroupMember.Builder(consumerMemberIds.get(0)).setMemberEpoch(10).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata()).build())).withConsumerGroup(new ConsumerGroupBuilder((String)groupIds.get(2), 10).withAssignmentEpoch(9).withMember(new ConsumerGroupMember.Builder(consumerMemberIds.get(1)).setMemberEpoch(9).build())).withConsumerGroup(new ConsumerGroupBuilder((String)groupIds.get(3), 10).withAssignmentEpoch(10).withMember(new ConsumerGroupMember.Builder(consumerMemberIds.get(2)).setMemberEpoch(9).build())).build();
        ConsumerGroup group1 = context.groupMetadataManager.getOrMaybeCreateConsumerGroup((String)groupIds.get(1), false, Collections.emptyList());
        ConsumerGroup group2 = context.groupMetadataManager.getOrMaybeCreateConsumerGroup((String)groupIds.get(2), false, Collections.emptyList());
        ConsumerGroup group3 = context.groupMetadataManager.getOrMaybeCreateConsumerGroup((String)groupIds.get(3), false, Collections.emptyList());
        ClassicGroup group4 = context.groupMetadataManager.getOrMaybeCreateClassicGroup((String)groupIds.get(4), true);
        group4.add((ClassicGroupMember)classicMembers.get(0));
        group4.add((ClassicGroupMember)classicMembers.get(1));
        group4.add((ClassicGroupMember)classicMembers.get(2));
        ClassicGroup group5 = context.groupMetadataManager.getOrMaybeCreateClassicGroup((String)groupIds.get(5), true);
        group5.add((ClassicGroupMember)classicMembers.get(0));
        ClassicGroup group6 = context.groupMetadataManager.getOrMaybeCreateClassicGroup((String)groupIds.get(6), true);
        group6.add((ClassicGroupMember)classicMembers.get(0));
        ClassicGroup group7 = context.groupMetadataManager.getOrMaybeCreateClassicGroup((String)groupIds.get(7), true);
        context.groupMetadataManager.updateGroupMetrics();
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setClassicGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.EMPTY, (Object)4L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setConsumerGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)1L), Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)1L), Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)1L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setMixedGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)1L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setNumClassicGroupMembers(Long.valueOf(5L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setNumConsumerGroupMembers(Long.valueOf(3L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setConsumerGroupMinRebalanceStartTimestamps(Long.valueOf(0L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setMixedGroupMinRebalanceStartTimestamps(Long.valueOf(Long.MAX_VALUE));
        context.time.setCurrentTimeMs(1000L);
        group4.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        context.time.setCurrentTimeMs(2000L);
        group5.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group5.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group6.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group6.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group6.transitionTo(ClassicGroupState.STABLE);
        group7.transitionTo(ClassicGroupState.DEAD);
        classicMemberIds.forEach(memberId -> group4.remove(memberId));
        group5.remove(classicMemberIds.get(0));
        context.time.setCurrentTimeMs(3000L);
        group1.setGroupEpoch(11);
        context.time.setCurrentTimeMs(4000L);
        group2.setTargetAssignmentEpoch(10);
        group2.removeMember(consumerMemberIds.get(1));
        context.time.setCurrentTimeMs(5000L);
        group3.updateMember(new ConsumerGroupMember.Builder(consumerMemberIds.get(2)).setMemberEpoch(10).build());
        group3.setGroupEpoch(11);
        context.groupMetadataManager.updateGroupMetrics();
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setClassicGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.PREPARING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.COMPLETING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.STABLE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.DEAD, (Object)1L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setConsumerGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)2L), Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)1L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setMixedGroupGauges((Map)ArgumentMatchers.eq((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)1L)})));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setNumClassicGroupMembers(Long.valueOf(1L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setNumConsumerGroupMembers(Long.valueOf(2L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setClassicGroupMinRebalanceStartTimestamps(Long.valueOf(1000L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setConsumerGroupMinRebalanceStartTimestamps(Long.valueOf(5000L));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).setMixedGroupMinRebalanceStartTimestamps(Long.valueOf(3000L));
    }

    @Test
    public void testGenerateRecordsOnNewClassicGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newEmptyGroupMetadataRecord((ClassicGroup)group)), joinResult.records);
    }

    @Test
    public void testGenerateRecordsOnNewClassicGroupFailureTransformsError() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.completeExceptionally((Throwable)new NotLeaderOrFollowerException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NOT_COORDINATOR.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplayGroupMetadataRecords(boolean useDefaultRebalanceTimeout) {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"))).array();
        ArrayList members = new ArrayList();
        ArrayList expectedMembers = new ArrayList();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection expectedProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0);
        expectedProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(subscription));
        IntStream.range(0, 2).forEach(i -> {
            members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(useDefaultRebalanceTimeout ? -1 : 9000));
            expectedMembers.add(new ClassicGroupMember("member-" + i, Optional.of("group-instance-id-" + i), "client-" + i, "host-" + i, useDefaultRebalanceTimeout ? 4000 : 9000, 4000, "consumer", expectedProtocols, new byte[]{2}));
        });
        CoordinatorRecord groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()));
        context.replay(groupMetadataRecord);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        ClassicGroup expectedGroup = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.STABLE, (Time)context.time, new GroupCoordinatorMetricsShard(context.snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0)), 1, Optional.of("consumer"), Optional.of("range"), Optional.of("member-0"), Optional.of(context.time.milliseconds()));
        expectedMembers.forEach(arg_0 -> ((ClassicGroup)expectedGroup).add(arg_0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.groupId(), (Object)group.groupId());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedGroup.generationId(), (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.protocolType(), (Object)group.protocolType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.protocolName(), (Object)group.protocolName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.leaderOrNull(), (Object)group.leaderOrNull());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.currentState(), (Object)group.currentState());
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedGroup.currentStateTimestampOrDefault(), (long)group.currentStateTimestampOrDefault());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.currentClassicGroupMembers(), (Object)group.currentClassicGroupMembers());
    }

    @Test
    public void testOnLoadedExceedGroupMaxSizeTriggersRebalance() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", 1).build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"))).array();
        ArrayList members = new ArrayList();
        IntStream.range(0, 2).forEach(i -> members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(9000)));
        CoordinatorRecord groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()));
        context.replay(groupMetadataRecord);
        context.groupMetadataManager.onLoaded();
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
    }

    @Test
    public void testOnLoadedSchedulesClassicGroupMemberHeartbeats() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"))).array();
        ArrayList members = new ArrayList();
        IntStream.range(0, 2).forEach(i -> members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(9000)));
        CoordinatorRecord groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()));
        context.replay(groupMetadataRecord);
        context.groupMetadataManager.onLoaded();
        IntStream.range(0, 2).forEach(i -> {
            MockCoordinatorTimer.ScheduledTimeout timeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)"member-1"));
            org.junit.jupiter.api.Assertions.assertNotNull((Object)timeout);
            org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + 4000L), (long)timeout.deadlineMs);
        });
    }

    @Test
    public void testJoinGroupShouldReceiveErrorIfGroupOverMaxSize() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", 10).build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withReason("exceed max group size").build();
        IntStream.range(0, 10).forEach(i -> {
            GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        });
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.GROUP_MAX_SIZE_REACHED.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testDynamicMembersJoinGroupWithMaxSizeAndRequiredKnownMember() {
        boolean requiredKnownMemberId = true;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", groupMaxSize).withConfig("group.initial.rebalance.delay.ms", 50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, 0, Errors.MEMBER_ID_REQUIRED);
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)memberIds.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)group.numPendingJoinMembers());
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        List<GroupMetadataManagerTestContext.JoinResult> thirdRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(thirdRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
    }

    @Test
    public void testDynamicMembersJoinGroupWithMaxSizeAndNotRequiredKnownMember() {
        boolean requiredKnownMemberId = false;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", groupMaxSize).withConfig("group.initial.rebalance.delay.ms", 50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, 10, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testStaticMembersJoinGroupWithMaxSize() {
        int groupMaxSize = 10;
        List groupInstanceIds = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> "instance-id-" + i).collect(Collectors.toList());
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", groupMaxSize).withConfig("group.initial.rebalance.delay.ms", 50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = groupInstanceIds.stream().map(instanceId -> context.sendClassicGroupJoin(request.setGroupInstanceId(instanceId))).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request.setMemberId((String)memberIds.get(i)).setGroupInstanceId((String)groupInstanceIds.get(i)))).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testDynamicMembersCanRejoinGroupWithMaxSizeWhileRebalancing() {
        boolean requiredKnownMemberId = true;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", groupMaxSize).withConfig("group.initial.rebalance.delay.ms", 50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(__ -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, 0, Errors.MEMBER_ID_REQUIRED);
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)memberIds.size());
        memberIds.forEach(memberId -> {
            GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        List<GroupMetadataManagerTestContext.JoinResult> thirdRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(thirdRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testLastJoiningMembersAreKickedOutWhenRejoiningGroupWithMaxSize() {
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", groupMaxSize).withConfig("group.initial.rebalance.delay.ms", 50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        List<String> memberIds = IntStream.range(0, groupMaxSize + 2).mapToObj(i -> group.generateMemberId("client-id", Optional.empty())).collect(Collectors.toList());
        memberIds.forEach(memberId -> group.add(new ClassicGroupMember(memberId, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", GroupMetadataManagerTestContext.toProtocols("range"))));
        context.groupMetadataManager.prepareRebalance(group, "test");
        List<GroupMetadataManagerTestContext.JoinResult> joinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId((String)memberId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build())).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(joinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        memberIds.subList(groupMaxSize, groupMaxSize + 2).forEach(memberId -> org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMember(memberId)));
        memberIds.subList(0, groupMaxSize).forEach(memberId -> org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(memberId)));
    }

    @Test
    public void testJoinGroupUnknownMemberNewGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withGroupInstanceId("group-instance-id").build();
        joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testClassicGroupJoinInconsistentProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("connect").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupWithEmptyProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
        joinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("group-instance-id"), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupWithEmptyGroupProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0)).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testNewMemberJoinExpiration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000 + context.classicGroupNewMemberJoinTimeoutMs).withRebalanceTimeoutMs(2 * context.classicGroupNewMemberJoinTimeoutMs).build();
        JoinGroupResponseData firstResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        String firstMemberId = firstResponse.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstResponse.leader(), (Object)firstMemberId);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)group);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        GroupMetadataManagerTestContext.JoinResult secondJoinResult = context.sendClassicGroupJoin(request.setSessionTimeoutMs(5000).setRebalanceTimeoutMs(5000));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        ClassicGroupMember newMember = group.allMembers().stream().filter(ClassicGroupMember::isNew).findFirst().get();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstMemberId, (Object)newMember.memberId());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupNewMemberJoinTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondJoinResult.joinFuture.isDone());
        JoinGroupResponseData secondResponse = secondJoinResult.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)secondResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstMemberId, (Object)((ClassicGroupMember)group.allMembers().iterator().next()).memberId());
    }

    @Test
    public void testJoinGroupInconsistentGroupProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)otherJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupSecondJoinInconsistentProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        String memberId = joinResult.joinFuture.get().memberId();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection emptyProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0);
        request = request.setMemberId(memberId).setProtocols(emptyProtocols);
        joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
        joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("range")), true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberJoinAsFirstMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        context.joinClassicGroupAndCompleteJoin(request, false, true);
    }

    @Test
    public void testStaticMemberRejoinWithExplicitUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(5000).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, false, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId("unknown-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(5000).build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId("other-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerNewDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupProtocolTypeIsNotProvidedWhenAnErrorOccurs() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertNull((Object)joinResult.joinFuture.get().protocolType());
    }

    @Test
    public void testJoinGroupReturnsTheProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"consumer", (Object)leaderJoinResult.joinFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"consumer", (Object)memberJoinResult.joinFuture.get().protocolType());
    }

    @Test
    public void testDelayInitialRebalanceByGroupInitialRebalanceDelayOnEmptyGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2 + 1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testResetRebalanceDelayWhenNewMemberJoinsGroupDuringInitialRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(context.classicGroupInitialRebalanceDelayMs * 3).build();
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs - 1));
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2 + 1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testDelayRebalanceUptoRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(context.classicGroupInitialRebalanceDelayMs * 2).build();
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs + 1));
        GroupMetadataManagerTestContext.JoinResult thirdMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thirdMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)thirdMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs - 1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)thirdMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thirdMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)thirdMemberJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupReplaceStaticMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult oldMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)newMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
    }

    @Test
    public void testHeartbeatExpirationShouldRemovePendingMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numPendingJoinMembers());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1000L));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testHeartbeatExpirationShouldRemoveMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.initial.rebalance.delay.ms", 600000).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        String memberId = group.leaderOrNull();
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(context.classicGroupNewMemberJoinTimeoutMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        timeouts.forEach(timeout -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)memberId), (Object)timeout.key);
            org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), (Object)timeout.result.records());
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numMembers());
    }

    @Test
    public void testExistingMemberJoinDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(memberId));
        group.transitionTo(ClassicGroupState.DEAD);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupExistingPendingMemberWithGroupInstanceIdThrowsException() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String memberId = joinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> context.sendClassicGroupJoin(request.setMemberId(memberId).setGroupInstanceId("group-instance-id")));
    }

    @Test
    public void testJoinGroupExistingMemberUpdatedMetadataTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(protocols).build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        ClassicGroupMember member = group.member(memberId);
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)member.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId).setProtocols(protocols));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)member.supportedProtocols());
    }

    @Test
    public void testJoinGroupAsExistingLeaderTriggersRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(memberId));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testJoinGroupAsExistingMemberWithUpdatedMetadataTriggersRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        String leaderId = leaderResponse.leader();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        group.transitionTo(ClassicGroupState.STABLE);
        String memberId = memberJoinResult.joinFuture.get().memberId();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        memberJoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId).setProtocols(protocols));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
    }

    @Test
    public void testJoinGroupExistingMemberDoesNotTriggerRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        String leaderId = leaderResponse.leader();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        String memberId = memberJoinResult.joinFuture.get().memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        memberJoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)memberJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testJoinGroupExistingMemberInEmptyState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)joinResult.joinFuture.get().generationId());
    }

    @Test
    public void testCompleteJoinRemoveNotYetRejoinedDynamicMembers() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).withRebalanceTimeoutMs(1000).build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(memberJoinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testCompleteJoinPhaseInEmptyStateSkipsRebalance() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).withRebalanceTimeoutMs(1000).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        group.transitionTo(ClassicGroupState.DEAD);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.generationId());
    }

    @Test
    public void testCompleteJoinPhaseNoMembersRejoinedExtendsJoinPhase() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("first-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(30000).withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData firstMemberResponse = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberResponse.errorCode());
        String firstMemberId = firstMemberResponse.memberId();
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("second-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(firstMemberId).setGroupInstanceId("first-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        String secondMemberId = secondMemberJoinResult.joinFuture.get().memberId();
        context.groupMetadataManager.prepareRebalance(group, "trigger rebalance");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)(context.timer.timeout((String)"join-group-id").deadlineMs - context.time.milliseconds()));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)(context.timer.timeout((String)"join-group-id").deadlineMs - context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        firstMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(firstMemberId).setGroupInstanceId("first-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        secondMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(secondMemberId).setGroupInstanceId("second-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplaceStaticMemberInStableStateNoError(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String oldMemberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.STABLE);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(protocols).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(4500), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String newMemberId = group.staticMemberId("group-instance-id");
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setLeader(oldMemberId).setMemberId(newMemberId).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(supportSkippingAssignment).setErrorCode(Errors.NONE.code());
        if (supportSkippingAssignment) {
            expectedResponse.setMembers(List.of(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(newMemberId).setGroupInstanceId("group-instance-id").setMetadata(protocols.find("range").metadata()))).setLeader(newMemberId);
        }
        ClassicGroupMember updatedMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)newMemberId, (Object)updatedMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)updatedMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)7000, (int)updatedMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)4500, (int)updatedMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)updatedMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testReplaceStaticMemberInStableStateWithUpdatedProtocolTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range", "roundrobin")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testReplaceStaticMemberInStableStateErrors() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(protocols).withRebalanceTimeoutMs(4000).withSessionTimeoutMs(3000).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String oldMemberId = response.memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("bar"))).array()));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(protocols).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(6000), false, false);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setLeader(oldMemberId).setMemberId("").setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(false).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        ClassicGroupMember revertedMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)oldMemberId, (Object)revertedMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)revertedMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)4000, (int)revertedMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)3000, (int)revertedMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)revertedMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplaceStaticMemberInStableStateSucceeds(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String oldMemberId = response.memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("range", "roundrobin")).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(6000), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(supportSkippingAssignment ? GroupMetadataManagerTest.toJoinResponseMembers(group) : Collections.emptyList()).setLeader(supportSkippingAssignment ? joinResult.joinFuture.get().memberId() : oldMemberId).setMemberId(joinResult.joinFuture.get().memberId()).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(supportSkippingAssignment).setErrorCode(Errors.NONE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        ClassicGroupMember newMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)oldMemberId, (Object)newMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)newMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)7000, (int)newMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)6000, (int)newMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManagerTestContext.toProtocols("range", "roundrobin"), (Object)newMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testReplaceStaticMemberInCompletingRebalanceStateTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testJoinGroupAppendErrorConversion() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.NOT_ENOUGH_REPLICAS));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.REQUEST_TIMED_OUT));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.NOT_LEADER_OR_FOLLOWER));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.KAFKA_STORAGE_ERROR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.MESSAGE_TOO_LARGE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.RECORD_LIST_TOO_LARGE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.INVALID_FETCH_SIZE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)Errors.LEADER_NOT_AVAILABLE);
    }

    @Test
    public void testNewMemberTimeoutCompletion() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(context.classicGroupNewMemberJoinTimeoutMs + 5000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(joinResult.joinFuture.get().memberId()).withGenerationId(joinResult.joinFuture.get().generationId()).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupNewMemberJoinTimeoutMs));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(5000L);
        List<CoordinatorRecord> expectedRecords = List.of(GroupMetadataManagerTestContext.newGroupMetadataRecord(group.groupId(), new GroupMetadataValue().setMembers(Collections.emptyList()).setGeneration(2).setLeader(null).setProtocolType("consumer").setProtocol(null).setCurrentStateTimestamp(context.time.milliseconds())));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        String memberId = joinResult.joinFuture.get().memberId();
        timeouts.forEach(timeout -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)memberId), (Object)timeout.key);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecords, (Object)timeout.result.records());
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
    }

    @Test
    public void testNewMemberFailureAfterJoinGroupCompletion() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResponse.errorCode());
        String memberId = joinResponse.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((Object)memberId, (Object)joinResponse.leader());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)joinResponse.generationId());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(1).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherJoinResult.joinFuture.get().errorCode());
        context.verifySessionExpiration(group, 5000);
    }

    @Test
    public void testStaticMemberFenceDuplicateRejoinedFollower() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerJoinResult.joinFuture.isDone());
        context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.FENCED_INSTANCE_ID.code()).setProtocolName(null).setProtocolType(null).setLeader("").setMemberId(rebalanceResult.followerId).setGenerationId(-1);
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.PREPARING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberFenceDuplicateSyncingFollowerAfterMemberIdChanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().withRebalanceTimeoutMs(10000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)leaderJoinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(oldFollowerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer");
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerId, (Object)oldFollowerJoinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)oldFollowerJoinResult.joinFuture.get().leader());
        GroupMetadataManagerTestContext.SyncResult oldFollowerSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(oldFollowerJoinResult.joinFuture.get().generationId()).withMemberId(oldFollowerJoinResult.joinFuture.get().memberId()).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerSyncResult.syncFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult duplicateFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldFollowerSyncResult.syncFuture.get().errorCode());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(10000L);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)timeouts.size());
        timeouts.forEach(timeout -> org.junit.jupiter.api.Assertions.assertEquals((Object)timeout.result, (Object)GroupMetadataManager.EMPTY_RESULT));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(duplicateFollowerJoinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)duplicateFollowerJoinResult.joinFuture.get().memberId(), (Object)duplicateFollowerJoinResult.joinFuture.get().leader());
    }

    @Test
    public void testStaticMemberFenceDuplicateRejoiningFollowerAfterMemberIdChanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult duplicateFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedDuplicateFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(duplicateFollowerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedDuplicateFollowerResponse, duplicateFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedOldFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.FENCED_INSTANCE_ID.code()).setGenerationId(-1).setMemberId(rebalanceResult.followerId).setLeader("").setProtocolName(null).setProtocolType(null).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedOldFollowerResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberRejoinWithKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(request, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResponse.errorCode());
        String memberId = joinResponse.memberId();
        GroupMetadataManagerTestContext.JoinResult rejoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)rejoinResult.joinFuture.get().errorCode());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(joinResponse.generationId()).withGroupInstanceId("group-instance-id").build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStaticMemberRejoinWithLeaderIdAndUnknownMemberId(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), joinResult.records);
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String leader = supportSkippingAssignment ? joinResult.joinFuture.get().memberId() : rebalanceResult.leaderId;
        List<Object> members = supportSkippingAssignment ? GroupMetadataManagerTest.toJoinResponseMembers(group) : Collections.emptyList();
        JoinGroupResponseData expectedJoinResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(joinResult.joinFuture.get().memberId()).setLeader(leader).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(supportSkippingAssignment).setMembers(members);
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedJoinResponse, joinResult.joinFuture.get(), group, ClassicGroupState.STABLE, supportSkippingAssignment ? Set.of("leader-instance-id", "follower-instance-id") : Collections.emptySet());
        GroupMetadataManagerTestContext.JoinResult oldLeaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(rebalanceResult.leaderId), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldLeaderJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData oldLeaderSyncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(rebalanceResult.leaderId).build();
        GroupMetadataManagerTestContext.SyncResult oldLeaderSyncResult = context.sendClassicGroupSync(oldLeaderSyncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldLeaderSyncResult.syncFuture.get().errorCode());
        SyncGroupRequestData newLeaderSyncRequest = oldLeaderSyncRequest.setGroupInstanceId(null);
        GroupMetadataManagerTestContext.SyncResult newLeaderSyncResult = context.sendClassicGroupSync(newLeaderSyncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLeaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLeaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)newLeaderSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(request, true, true, 10000);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMember(rebalanceResult.followerId));
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndUnexpectedDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.DEAD);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndUnexpectedEmptyGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithFollowerIdAndChangeOfProtocol() throws Exception {
        int rebalanceTimeoutMs = 10000;
        int sessionTimeoutMs = 15000;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("roundrobin");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.followerId).withProtocols(protocols).withRebalanceTimeoutMs(rebalanceTimeoutMs).withSessionTimeoutMs(sessionTimeoutMs).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(rebalanceResult.followerId));
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.followerId).setLeader(rebalanceResult.followerId).setProtocolName("roundrobin").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWithSelectedProtocolChanged() throws Exception {
        int rebalanceTimeoutMs = 10000;
        int sessionTimeoutMs = 15000;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"roundrobin", (Object)group.selectProtocol());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("roundrobin");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).withRebalanceTimeoutMs(rebalanceTimeoutMs).withSessionTimeoutMs(sessionTimeoutMs).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"roundrobin", (Object)group.selectProtocol());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(joinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)joinResult.joinFuture.get().memberId());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(joinResult.joinFuture.get().memberId()).setLeader(joinResult.joinFuture.get().memberId()).setProtocolName("roundrobin").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWhileSelectProtocolUnchangedPersistenceFailure() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols(group.selectProtocol());
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), followerJoinResult.records);
        followerJoinResult.appendFuture.completeExceptionally((Throwable)Errors.MESSAGE_TOO_LARGE.exception());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)followerJoinResult.joinFuture.get().memberId());
        followerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("leader-instance-id").setMemberId(rebalanceResult.leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withGenerationId(rebalanceResult.generationId + 1).build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(syncRequest);
        leaderSyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), leaderSyncResult.records);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
        GroupMetadataManagerTestContext.SyncResult oldMemberSyncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)oldMemberSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWhileSelectProtocolUnchanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols(group.selectProtocol());
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), followerJoinResult.records);
        followerJoinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        String newFollowerId = followerJoinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)newFollowerId);
        followerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(rebalanceResult.followerId).withAssignment(Collections.emptyList()).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)syncResult.syncFuture.get().errorCode());
        syncResult = context.sendClassicGroupSync(syncRequest.setMemberId(newFollowerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerAssignment, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testStaticMemberRejoinWithKnownLeaderIdToTriggerRebalanceAndFollowerWithChangeofProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(leaderJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id"));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        followerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId).setProtocols(protocols), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(5000L);
        org.junit.jupiter.api.Assertions.assertTrue((timeouts.size() <= 2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        String newFollowerId = followerJoinResult.joinFuture.get().memberId();
        expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 2).setMemberId(newFollowerId).setLeader(newFollowerId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("follower-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), followerJoinResult.records);
        followerJoinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)followerJoinResult.joinFuture.get().memberId());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(followerJoinResult.joinFuture.get().memberId()).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerAssignment, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithKnownMemberIdAndNoProtocolChange() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.followerId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(rebalanceResult.followerId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithMismatchedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.followerId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)followerJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinAsLeaderWithMismatchedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberSyncAsLeaderWithInvalidMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        SyncGroupRequestData request = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("invalid-member-id").build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testGetDifferentStaticMemberIdAfterEachRejoin() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String lastMemberId = rebalanceResult.leaderId;
        for (int i = 0; i < 5; ++i) {
            JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
            GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
            org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), leaderJoinResult.records);
            leaderJoinResult.appendFuture.complete(null);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertEquals((Object)group.staticMemberId("leader-instance-id"), (Object)leaderJoinResult.joinFuture.get().memberId());
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)lastMemberId, (Object)leaderJoinResult.joinFuture.get().memberId());
            lastMemberId = leaderJoinResult.joinFuture.get().memberId();
        }
    }

    @Test
    public void testStaticMemberJoinWithUnknownInstanceIdAndKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("unknown-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberReJoinWithIllegalStateAsUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocolSuperset().build();
        IllegalStateException exception = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> context.sendClassicGroupJoin(request, true, true));
        String message = exception.getMessage();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.contains(group.groupId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.contains("follower-instance-id"));
    }

    @Test
    public void testStaticMemberFollowerFailToRejoinBeforeRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", 10000, 15000);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String newMemberInstanceId = "new-member-instance-id";
        String leaderId = rebalanceResult.leaderId;
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId(newMemberInstanceId).withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("leader-instance-id").setMemberId(leaderId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(leaderId).setLeader(leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id", newMemberInstanceId));
        JoinGroupResponseData expectedNewMemberResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newMemberJoinResult.joinFuture.get().memberId()).setLeader(leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedNewMemberResponse, newMemberJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberLeaderFailToRejoinBeforeRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", 10000, 15000);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String newMemberInstanceId = "new-member-instance-id";
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId(newMemberInstanceId).withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        JoinGroupResponseData oldFollowerJoinResponse = oldFollowerJoinResult.joinFuture.get();
        JoinGroupResponseData newMemberJoinResponse = newMemberJoinResult.joinFuture.get();
        JoinGroupResponseData newLeaderResponse = oldFollowerJoinResponse.leader().equals(oldFollowerJoinResponse.memberId()) ? oldFollowerJoinResponse : newMemberJoinResponse;
        JoinGroupResponseData newFollowerResponse = oldFollowerJoinResponse.leader().equals(oldFollowerJoinResponse.memberId()) ? newMemberJoinResponse : oldFollowerJoinResponse;
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newLeaderResponse.memberId()).setLeader(newLeaderResponse.memberId()).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, newLeaderResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Set.of("leader-instance-id", "follower-instance-id", newMemberInstanceId));
        JoinGroupResponseData expectedNewMemberResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newFollowerResponse.memberId()).setLeader(newLeaderResponse.memberId()).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedNewMemberResponse, newFollowerResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testSyncGroupReturnsAnErrorWhenProtocolTypeIsInconsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.of("protocolType"), Optional.empty(), Errors.INCONSISTENT_GROUP_PROTOCOL, Optional.empty(), Optional.empty());
    }

    @Test
    public void testSyncGroupReturnsAnErrorWhenProtocolNameIsInconsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.empty(), Optional.of("protocolName"), Errors.INCONSISTENT_GROUP_PROTOCOL, Optional.empty(), Optional.empty());
    }

    @Test
    public void testSyncGroupSucceedWhenProtocolTypeAndNameAreNotProvided() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.empty(), Optional.empty(), Errors.NONE, Optional.of("consumer"), Optional.of("range"));
    }

    @Test
    public void testSyncGroupSucceedWhenProtocolTypeAndNameAreConsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.of("consumer"), Optional.of("range"), Errors.NONE, Optional.of("consumer"), Optional.of("range"));
    }

    private void testSyncGroupProtocolTypeAndNameWith(Optional<String> protocolType, Optional<String> protocolName, Errors expectedError, Optional<String> expectedProtocolType, Optional<String> expectedProtocolName) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest.setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        String leaderId = leaderJoinResult.joinFuture.get().memberId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        int generationId = leaderJoinResult.joinFuture.get().generationId();
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderId));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderId).withProtocolType(protocolType.orElse(null)).withProtocolName(protocolName.orElse(null)).withGenerationId(generationId).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(syncRequest);
        leaderSyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolType.orElse(null), (Object)leaderSyncResult.syncFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolName.orElse(null), (Object)leaderSyncResult.syncFuture.get().protocolName());
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolType.orElse(null), (Object)followerSyncResult.syncFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolName.orElse(null), (Object)followerSyncResult.syncFuture.get().protocolName());
    }

    @Test
    public void testSyncGroupFromUnknownGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withGenerationId(1).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testSyncGroupFromUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        String memberId = joinResponse.memberId();
        int generationId = joinResponse.generationId();
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(memberId));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(generationId).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((SyncGroupRequestData.SyncGroupRequestAssignment)assignment.get(0)).assignment(), (Object)syncResult.syncFuture.get().assignment());
        syncResult = context.sendClassicGroupSync(syncRequest.setMemberId("unknown-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ClassicGroupMember.EMPTY_ASSIGNMENT, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testSyncGroupFromIllegalGeneration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String memberId = joinResponse.memberId();
        int generationId = joinResponse.generationId();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(generationId + 1).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.ILLEGAL_GENERATION.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testSyncGroupAsLeaderAppendFailureTransformsError() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(joinResponse.memberId()).withGenerationId(1).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)syncResult.syncFuture.isDone());
        syncResult.appendFuture.completeExceptionally((Throwable)new NotLeaderOrFollowerException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NOT_COORDINATOR.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupFromUnchangedFollowerDoesNotRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        followerJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)nextGenerationId, (int)followerJoinResult.joinFuture.get().generationId());
    }

    @Test
    public void testLeaderFailureInSyncGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(followerId).withGenerationId(nextGenerationId).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerSyncResult.syncFuture.isDone());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(10000L);
        org.junit.jupiter.api.Assertions.assertTrue((timeouts.size() <= 2 ? 1 : 0) != 0);
        timeouts.forEach(timeout -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testSyncGroupFollowerAfterLeader() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        byte[] leaderAssignment = new byte[]{0};
        byte[] followerAssignment = new byte[]{1};
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderJoinResponse.memberId()).setAssignment(leaderAssignment));
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerId).setAssignment(followerAssignment));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withGenerationId(leaderJoinResponse.generationId()).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest.setGenerationId(nextGenerationId));
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderAssignment, (Object)syncResult.syncFuture.get().assignment());
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId).setGenerationId(nextGenerationId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)followerAssignment, (Object)followerSyncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testSyncGroupLeaderAfterFollower() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        byte[] leaderAssignment = new byte[]{0};
        byte[] followerAssignment = new byte[]{1};
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withGenerationId(leaderJoinResponse.generationId()).build();
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId).setGenerationId(nextGenerationId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerSyncResult.syncFuture.isDone());
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderJoinResponse.memberId()).setAssignment(leaderAssignment));
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerId).setAssignment(followerAssignment));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest.setMemberId(leaderJoinResponse.memberId()).setGenerationId(nextGenerationId).setAssignments(assignment));
        syncResult.appendFuture.complete(null);
        Map<String, byte[]> updatedAssignment = assignment.stream().collect(Collectors.toMap(SyncGroupRequestData.SyncGroupRequestAssignment::memberId, SyncGroupRequestData.SyncGroupRequestAssignment::assignment));
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, updatedAssignment)), syncResult.records);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderAssignment, (Object)syncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)followerAssignment, (Object)followerSyncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testJoinGroupFromUnchangedLeaderShouldRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.JoinResult leaderRejoinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderRejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderRejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderRejoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)(leaderJoinResponse.generationId() + 1), (int)leaderRejoinResult.joinFuture.get().generationId());
    }

    @Test
    public void testJoinGroupCompletionWhenPendingMemberJoins() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingMemberResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(pendingMemberResponse.memberId()).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testJoinGroupCompletionWhenPendingMemberTimesOut() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        context.setupGroupWithPendingMember(group);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(3000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testGenerationIdIncrementsOnRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)joinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberHeartbeatLeaderWithInvalidMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withGenerationId(rebalanceResult.generationId).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(rebalanceResult.leaderId).setGenerationId(rebalanceResult.generationId);
        HeartbeatResponseData validHeartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)validHeartbeatResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest.setGroupInstanceId("leader-instance-id").setMemberId("invalid-member-id")));
    }

    @Test
    public void testHeartbeatUnknownGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(-1);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
    }

    @Test
    public void testHeartbeatDeadGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(-1);
        org.junit.jupiter.api.Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
    }

    @Test
    public void testHeartbeatEmptyGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.add(new ClassicGroupMember("member-id", Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", GroupMetadataManagerTestContext.toProtocols("range")));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(0);
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testHeartbeatUnknownMemberExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId("unknown-member-id").setGenerationId(leaderJoinResponse.generationId())));
    }

    @Test
    public void testHeartbeatDuringPreparingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        String memberId = joinResult.joinFuture.get().memberId();
        context.sendClassicGroupJoin(joinRequest.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(memberId).setGenerationId(0)).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testHeartbeatDuringCompletingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)leaderJoinResponse.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId())).response();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HeartbeatResponseData(), (Object)heartbeatResponse);
    }

    @Test
    public void testHeartbeatIllegalGeneration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId() + 1)));
    }

    @Test
    public void testValidHeartbeat() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId())).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testClassicGroupMemberSessionTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        context.verifySessionExpiration(group, 5000);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId())));
    }

    @Test
    public void testClassicGroupMemberHeartbeatMaintainsSession() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testClassicGroupMemberSessionTimeoutDuringRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(5000L));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testRebalanceCompletesBeforeMemberJoins() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String firstMemberId = leaderJoinResponse.memberId();
        int firstGenerationId = leaderJoinResponse.generationId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstGenerationId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(firstMemberId).withGenerationId(firstGenerationId).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId("").setGroupInstanceId(null).setSessionTimeoutMs(2500));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        HeartbeatRequestData firstMemberHeartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(firstMemberId).setGenerationId(firstGenerationId);
        for (int i = 0; i < 2; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
            HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest).response();
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
        }
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(8000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String otherMemberId = secondMemberJoinResult.joinFuture.get().memberId();
        syncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId(null).setMemberId(otherMemberId).setGenerationId(2));
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest));
        List<Errors> expectedErrors = List.of(Errors.NONE, Errors.NONE, Errors.REBALANCE_IN_PROGRESS);
        for (Errors expectedError : expectedErrors) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2000L));
            HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest.setMemberId(otherMemberId).setGenerationId(2)).response();
            org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)heartbeatResponse.errorCode());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult otherMemberRejoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(otherMemberId).setGroupInstanceId(null).setSessionTimeoutMs(2500));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberRejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberRejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherMemberRejoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)otherMemberRejoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.SyncResult otherMemberResyncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId(null).setMemberId(otherMemberId).setGenerationId(3));
        otherMemberResyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberResyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherMemberResyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        for (int i = 0; i < 20; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2000L));
            HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest.setMemberId(otherMemberId).setGenerationId(3)).response();
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        }
    }

    @Test
    public void testSyncGroupEmptyAssignment() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId())).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testSecondMemberPartiallyJoinAndTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String firstMemberId = leaderJoinResponse.memberId();
        int firstGenerationId = leaderJoinResponse.generationId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstGenerationId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(firstMemberId).withGenerationId(firstGenerationId).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId("").setGroupInstanceId(null).setSessionTimeoutMs(5000), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(firstMemberId).setGenerationId(firstGenerationId);
        for (int i = 0; i < 2; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
            HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMember(firstMemberId));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceived() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), (Object)timeout.result.records());
        timeout.result.appendFuture().complete(null);
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceivedFromFollowers() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(joinResponses.get(0).memberId()).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        context.verifyHeartbeat(group.groupId(), joinResponses.get(0), Errors.NONE);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty());
        joinResponses.subList(0, 1).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.REBALANCE_IN_PROGRESS));
        joinResponses.subList(1, 3).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceivedFromLeaders() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List<CompletableFuture> followerSyncFutures = joinResponses.subList(1, 3).stream().map(response -> {
            GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(response.memberId()).build());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)syncResult.syncFuture.isDone());
            return syncResult.syncFuture;
        }).collect(Collectors.toList());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty());
        followerSyncFutures.forEach(future -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)future.isDone());
            try {
                org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((SyncGroupResponseData)future.get()).errorCode());
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
            }
        });
        joinResponses.subList(0, 1).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        joinResponses.subList(1, 3).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.REBALANCE_IN_PROGRESS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testRebalanceDoesNotTimeOutWhenAllSyncAreReceived() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String leaderId = joinResponses.get(0).memberId();
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List syncFutures = joinResponses.stream().map(response -> {
            GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(response.memberId()).build());
            if (response.memberId().equals(leaderId)) {
                org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), syncResult.records);
                syncResult.appendFuture.complete(null);
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
            return syncResult.syncFuture;
        }).collect(Collectors.toList());
        for (CompletableFuture syncFuture : syncFutures) {
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)((SyncGroupResponseData)syncFuture.get()).errorCode());
        }
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testHeartbeatDuringRebalanceCausesRebalanceInProgress() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)leaderJoinResponse.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(heartbeatRequest).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testListGroups() {
        String consumerGroupId = "consumer-group-id";
        String classicGroupId = "classic-group-id";
        String shareGroupId = "share-group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withShareGroupAssignor(assignor).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupId, 10)).build();
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord(classicGroupId, new GroupMetadataValue().setMembers(Collections.emptyList()).setGeneration(2).setLeader(null).setProtocolType("classic").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds())));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)shareGroupId, (int)6));
        context.commit();
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(classicGroupId, false);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setSubscribedTopicNames(List.of(fooTopicName)).build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)consumerGroupId, (int)11));
        Map actualAllGroupMap = context.sendListGroups(Collections.emptyList(), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        Map<String, Object> expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(shareGroupId).setProtocolType("share").setGroupState(ShareGroup.ShareGroupState.EMPTY.toString()).setGroupType(Group.GroupType.SHARE.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(List.of("empty"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        context.commit();
        actualAllGroupMap = context.sendListGroups(List.of("assigning"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(List.of("Empty"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(shareGroupId).setProtocolType("share").setGroupState(ShareGroup.ShareGroupState.EMPTY.toString()).setGroupType(Group.GroupType.SHARE.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), List.of(Group.GroupType.CLASSIC.toString())).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), List.of("Consumer")).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), List.of("Share")).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(shareGroupId).setProtocolType("share").setGroupState(ShareGroup.ShareGroupState.EMPTY.toString()).setGroupType(Group.GroupType.SHARE.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(List.of("empty", "Assigning"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType(Group.GroupType.CLASSIC.toString()).setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(shareGroupId).setProtocolType("share").setGroupState(ShareGroup.ShareGroupState.EMPTY.toString()).setGroupType(Group.GroupType.SHARE.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), List.of("Invalid")).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Collections.emptyMap();
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(List.of("Invalid"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Collections.emptyMap();
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
    }

    @Test
    public void testConsumerGroupDescribeNoErrors() {
        List<String> consumerGroupIds = List.of("group-id-1", "group-id-2");
        int epoch = 10;
        String memberId = "member-id";
        String topicName = "topicName";
        ConsumerGroupMember.Builder memberBuilder = new ConsumerGroupMember.Builder(memberId).setSubscribedTopicNames(List.of(topicName)).setServerAssignorName("assignorName");
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupIds.get(0), epoch)).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupIds.get(1), epoch).withMember(memberBuilder.build())).build();
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = List.of(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupEpoch(epoch).setGroupId(consumerGroupIds.get(0)).setGroupState(ConsumerGroup.ConsumerGroupState.EMPTY.toString()).setAssignorName("range"), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupEpoch(epoch).setGroupId(consumerGroupIds.get(1)).setMembers(List.of(memberBuilder.build().asConsumerGroupDescribeMember(new Assignment(Collections.emptyMap()), new MetadataImageBuilder().build().topics()))).setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setAssignorName("assignorName"));
        List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = context.sendConsumerGroupDescribe(consumerGroupIds);
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testConsumerGroupDescribeWithErrors() {
        String groupId = "groupId";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).build();
        List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = context.sendConsumerGroupDescribe(List.of(groupId));
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group " + groupId + " not found.");
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = List.of(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testConsumerGroupDescribeBeforeAndAfterCommittingOffset() {
        String consumerGroupId = "consumerGroupId";
        int epoch = 10;
        String memberId1 = "memberId1";
        String memberId2 = "memberId2";
        String topicName = "topicName";
        Uuid topicId = Uuid.randomUuid();
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(topicId, topicName, 3).build();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        ConsumerGroupMember.Builder memberBuilder1 = new ConsumerGroupMember.Builder(memberId1).setSubscribedTopicNames(List.of(topicName));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder1.build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)consumerGroupId, (int)(epoch + 1)));
        Map assignmentMap = Map.of(topicId, Collections.emptySet());
        ConsumerGroupMember.Builder memberBuilder2 = new ConsumerGroupMember.Builder(memberId2);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder2.build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)consumerGroupId, (String)memberId2, assignmentMap));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder2.build()));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)consumerGroupId, (int)(epoch + 2)));
        List actual = context.groupMetadataManager.consumerGroupDescribe(List.of(consumerGroupId), context.lastCommittedOffset);
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(consumerGroupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group " + consumerGroupId + " not found.");
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = List.of(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
        context.commit();
        actual = context.groupMetadataManager.consumerGroupDescribe(List.of(consumerGroupId), context.lastCommittedOffset);
        describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(consumerGroupId).setMembers(List.of(memberBuilder1.build().asConsumerGroupDescribeMember(new Assignment(Collections.emptyMap()), metadataImage.topics()), memberBuilder2.build().asConsumerGroupDescribeMember(new Assignment(assignmentMap), metadataImage.topics()))).setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setAssignorName("range").setGroupEpoch(epoch + 2);
        expected = List.of(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testDescribeGroupStable() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataValue.MemberMetadata memberMetadata = new GroupMetadataValue.MemberMetadata().setMemberId("member-id").setGroupInstanceId("group-instance-id").setClientHost("client-host").setClientId("client-id").setAssignment(new byte[]{0}).setSubscription(new byte[]{0, 1, 2});
        GroupMetadataValue groupMetadataValue = new GroupMetadataValue().setMembers(List.of(memberMetadata)).setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds());
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", groupMetadataValue));
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
        context.commit();
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = List.of(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setGroupState(ClassicGroupState.STABLE.toString()).setProtocolType(groupMetadataValue.protocolType()).setProtocolData(groupMetadataValue.protocol()).setMembers(List.of(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberMetadata.memberId()).setGroupInstanceId(memberMetadata.groupInstanceId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setMemberMetadata(memberMetadata.subscription()).setMemberAssignment(memberMetadata.assignment()))));
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = context.describeGroups(List.of("group-id"));
        org.junit.jupiter.api.Assertions.assertEquals(expectedDescribedGroups, describedGroups);
    }

    @Test
    public void testDescribeGroupRebalancing() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataValue.MemberMetadata memberMetadata = new GroupMetadataValue.MemberMetadata().setMemberId("member-id").setGroupInstanceId("group-instance-id").setClientHost("client-host").setClientId("client-id").setAssignment(new byte[]{0}).setSubscription(new byte[]{0, 1, 2});
        GroupMetadataValue groupMetadataValue = new GroupMetadataValue().setMembers(List.of(memberMetadata)).setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds());
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", groupMetadataValue));
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        context.groupMetadataManager.prepareRebalance(group, "trigger rebalance");
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
        context.commit();
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = List.of(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setGroupState(ClassicGroupState.PREPARING_REBALANCE.toString()).setProtocolType(groupMetadataValue.protocolType()).setProtocolData("").setMembers(List.of(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberMetadata.memberId()).setGroupInstanceId(memberMetadata.groupInstanceId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setMemberAssignment(memberMetadata.assignment()))));
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = context.describeGroups(List.of("group-id"));
        org.junit.jupiter.api.Assertions.assertEquals(expectedDescribedGroups, describedGroups);
    }

    @Test
    public void testDescribeGroupsGroupIdNotFoundException() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
    }

    @Test
    public void testDescribeGroupsBeforeV6GroupIdNotFoundException() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.verifyDescribeGroupsBeforeV6ReturnsDeadGroup("group-id");
    }

    @Test
    public void testGroupStuckInRebalanceTimeoutDueToNonjoinedStaticMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int longSessionTimeoutMs = 10000;
        int rebalanceTimeoutMs = 5000;
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, longSessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolSuperset().withSessionTimeoutMs(longSessionTimeoutMs).build());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)joinResult.joinFuture.get().leader(), (Object)joinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)joinResult.joinFuture.get().members().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)joinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(rebalanceResult.leaderId, rebalanceResult.followerId, joinResult.joinFuture.get().memberId()), (Object)group.allMemberIds());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(rebalanceResult.leaderId, rebalanceResult.followerId), (Object)group.allStaticMemberIds());
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(joinResult.joinFuture.get().memberId()), (Object)group.allDynamicMemberIds());
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        context.sleep(rebalanceTimeoutMs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.allDynamicMemberIds().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton(rebalanceResult.leaderId), (Object)group.allMemberIds());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.allDynamicMemberIds().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testPendingMembersLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingJoinResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingJoinResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingJoinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allDynamicMemberIds().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testLeaveGroupInvalidGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("invalid-group-id")));
    }

    @Test
    public void testLeaveGroupUnknownGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("unknown-group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId("member-id")))));
    }

    @Test
    public void testLeaveGroupUnknownMemberIdExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testLeaveDeadGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId("member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testValidLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData joinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(joinResponse.memberId()))));
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment())), (Object)leaveResult.records());
        leaveResult.appendFuture().complete(null);
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(joinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testLeaveGroupWithFencedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("group-instance-id").setMemberId("other-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("group-instance-id").setMemberId("other-member-id").setErrorCode(Errors.FENCED_INSTANCE_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testLeaveGroupStaticMemberWithUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("group-instance-id").setMemberId(""))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("group-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersValidBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("leader-instance-id"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersLeaveUnknownGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("invalid-group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id")))));
    }

    @Test
    public void testStaticMembersFencedInstanceBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id").setMemberId("invalid-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("leader-instance-id"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id").setMemberId("invalid-member-id").setErrorCode(Errors.FENCED_INSTANCE_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersUnknownInstanceBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("unknown-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("unknown-instance-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testPendingMemberBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingJoinResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("unknown-instance-id"), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingJoinResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("unknown-instance-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingJoinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testJoinedMemberPendingMemberBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.PendingMemberGroupResult pendingMemberGroupResult = context.setupGroupWithPendingMember(group);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testJoinedMemberPendingMemberBatchLeaveGroupWithUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.PendingMemberGroupResult pendingMemberGroupResult = context.setupGroupWithPendingMember(group);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()), new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testClassicGroupDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.createGroupTombstoneRecords("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
    }

    @Test
    public void testClassicGroupMaybeDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
        records = new ArrayList();
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
        records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup("invalid-group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
    }

    @Test
    public void testConsumerGroupDelete() {
        String groupId = "group-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10)).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.createGroupTombstoneRecords("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
    }

    @Test
    public void testConsumerGroupMaybeDelete() {
        String groupId = "group-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10)).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup(groupId, records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
        records = new ArrayList();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).build()));
        context.groupMetadataManager.maybeDeleteGroup(groupId, records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
    }

    @Test
    public void testClassicGroupCompletedRebalanceSensor() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics)).record("CompletedRebalances");
    }

    @Test
    public void testConsumerGroupRebalanceSensor() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics)).record("ConsumerGroupRebalances");
    }

    @Test
    public void testConsumerGroupHeartbeatWithNonEmptyClassicGroup() {
        String classicGroupId = "classic-group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).build();
        ClassicGroup classicGroup = new ClassicGroup(new LogContext(), classicGroupId, ClassicGroupState.EMPTY, (Time)context.time, context.metrics);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)classicGroup, (Map)classicGroup.groupAssignment()));
        context.groupMetadataManager.getOrMaybeCreateClassicGroup(classicGroupId, false).transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(classicGroupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("no-op").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupHeartbeatWithEmptyClassicGroup() {
        String classicGroupId = "classic-group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).build();
        ClassicGroup classicGroup = new ClassicGroup(new LogContext(), classicGroupId, ClassicGroupState.EMPTY, (Time)context.time, context.metrics);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)classicGroup, (Map)classicGroup.groupAssignment()));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(classicGroupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("no-op").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("no-op").setAssignedPartitions(Collections.emptyMap()).build();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)((ConsumerGroupHeartbeatResponseData)result.response()).errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)classicGroupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)classicGroupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)classicGroupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)classicGroupId, (String)memberId, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)classicGroupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)classicGroupId, (ConsumerGroupMember)expectedMember)), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.CONSUMER, (Object)context.groupMetadataManager.consumerGroup(classicGroupId).type());
    }

    @Test
    public void testClassicGroupJoinWithEmptyConsumerGroup() throws Exception {
        String consumerGroupId = "consumer-group-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(consumerGroupId, 10)).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(consumerGroupId).withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)consumerGroupId), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)consumerGroupId), GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)consumerGroupId));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, joinResult.records.subList(0, expectedRecords.size()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.CLASSIC, (Object)context.groupMetadataManager.getOrMaybeCreateClassicGroup(consumerGroupId, false).type());
    }

    @Test
    public void testConsumerGroupHeartbeatWithStableClassicGroup() {
        String groupId = "group-id";
        String memberId1 = "member-id-1";
        String memberId2 = "member-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))));
        Map<String, byte[]> assignments = Map.of(memberId1, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0))))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("range"));
        group.add(new ClassicGroupMember(memberId1, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols, assignments.get(memberId1)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(0).setPreviousMemberEpoch(0).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(1).setPreviousMemberEpoch(0).setState(MemberState.UNRELEASED_PARTITIONS).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setServerAssignorName("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(5000).setAssignedPartitions(Collections.emptyMap()).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 1), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)expectedMember1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, assignor.targetPartitions(memberId2)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, assignor.targetPartitions(memberId1)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        context.assertSessionTimeout(groupId, memberId1, ((Integer)expectedMember1.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId2, 45000L);
        context.rollback();
        org.junit.jupiter.api.Assertions.assertEquals((Object)group, (Object)context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false));
    }

    @Test
    public void testConsumerGroupHeartbeatWithPreparingRebalanceClassicGroup() throws Exception {
        String groupId = "group-id";
        String memberId1 = "member-id-1";
        String memberId2 = "member-id-2";
        String memberId3 = "member-id-3";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), memberId3, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))))));
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols1 = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols1.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1)))))));
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols2 = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols2.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(barTopicName, 0)))))));
        Map<String, byte[]> assignments = Map.of(memberId1, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1))))), memberId2, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(barTopicName, 0))))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("range"));
        group.add(new ClassicGroupMember(memberId1, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols1, assignments.get(memberId1)));
        group.add(new ClassicGroupMember(memberId2, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols2, assignments.get(memberId2)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId1).withProtocols(protocols1).withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupHeartbeatResult = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(0).setPreviousMemberEpoch(0).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols1))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build();
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(0).setPreviousMemberEpoch(0).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols2))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(1).setPreviousMemberEpoch(0).setState(MemberState.UNRELEASED_PARTITIONS).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setServerAssignorName("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(5000).setAssignedPartitions(Collections.emptyMap()).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)expectedMember1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, (Map)expectedMember2.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)0), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, assignor.targetPartitions(memberId1)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId3, assignor.targetPartitions(memberId3)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3));
        Assertions.assertRecordsEquals(expectedRecords, consumerGroupHeartbeatResult.records());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)joinResult.joinFuture.get().errorCode());
        context.assertSessionTimeout(groupId, memberId1, ((Integer)expectedMember1.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId2, ((Integer)expectedMember2.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId3, 45000L);
        context.rollback();
        org.junit.jupiter.api.Assertions.assertEquals((Object)group, (Object)context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false));
    }

    private static Stream<Arguments> testConsumerGroupHeartbeatWithCustomAssignorClassicGroupSource() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, true}), Arguments.of((Object[])new Object[]{ByteBuffer.allocate(0), true}), Arguments.of((Object[])new Object[]{ByteBuffer.allocate(1), false}));
    }

    @ParameterizedTest
    @MethodSource(value={"testConsumerGroupHeartbeatWithCustomAssignorClassicGroupSource"})
    public void testConsumerGroupHeartbeatWithCustomAssignorClassicGroup(ByteBuffer userData, boolean expectUpgrade) {
        String groupId = "group-id";
        String memberId1 = "member-id-1";
        String memberId2 = "member-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))));
        Map<String, byte[]> assignments = Map.of(memberId1, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)), userData))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("range"));
        group.add(new ClassicGroupMember(memberId1, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols, assignments.get(memberId1)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        ConsumerGroupHeartbeatRequestData consumerGroupHeartbeatRequestData = new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList());
        if (expectUpgrade) {
            context.consumerGroupHeartbeat(consumerGroupHeartbeatRequestData);
        } else {
            Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.consumerGroupHeartbeat(consumerGroupHeartbeatRequestData));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Cannot upgrade classic group group-id to consumer group because an unsupported custom assignor is in use. Please refer to the documentation or switch to a default assignor before re-attempting the upgrade.", (Object)ex.getMessage());
        }
    }

    @Test
    public void testConsumerGroupHeartbeatToClassicGroupFromExistingStaticMember() {
        String groupId = "group-id";
        String memberId = "member-id";
        String instanceId = "instance-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("no-op").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName), null, List.of(new TopicPartition(fooTopicName, 0)))))));
        Map<String, byte[]> assignments = Map.of(memberId, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0))))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("no-op"));
        group.add(new ClassicGroupMember(memberId, Optional.of(instanceId), "client", GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString(), 10000, 5000, "consumer", protocols, assignments.get(memberId)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.initNextGeneration();
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        String newMemberId = Uuid.randomUuid().toString();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(newMemberId).setInstanceId(instanceId).setRebalanceTimeoutMs(5000).setServerAssignor("no-op").setSubscribedTopicNames(List.of(fooTopicName)).setTopicPartitions(Collections.emptyList()), ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        ConsumerGroupMember expectedClassicMember = new ConsumerGroupMember.Builder(memberId).setInstanceId(instanceId).setMemberEpoch(group.generationId()).setPreviousMemberEpoch(group.generationId()).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)newMemberId, (Object)((ConsumerGroupHeartbeatResponseData)result.response()).memberId(), (String)"Server should not generate a new memberId since the consumer has already generated its own.");
        ConsumerGroupMember expectedReplacingConsumerMember = new ConsumerGroupMember.Builder(newMemberId).setInstanceId(instanceId).setMemberEpoch(0).setPreviousMemberEpoch(0).setState(MemberState.STABLE).setClientId(expectedClassicMember.clientId()).setClientHost(expectedClassicMember.clientHost()).setSubscribedTopicNames(new ArrayList(expectedClassicMember.subscribedTopicNames())).setRebalanceTimeoutMs(expectedClassicMember.rebalanceTimeoutMs()).setAssignedPartitions(expectedClassicMember.assignedPartitions()).setClassicMemberMetadata((ConsumerGroupMemberMetadataValue.ClassicMemberMetadata)expectedClassicMember.classicMemberMetadata().get()).build();
        ConsumerGroupMember expectedFinalConsumerMember = new ConsumerGroupMember.Builder(expectedReplacingConsumerMember).setMemberEpoch(group.generationId()).setServerAssignorName("no-op").setRebalanceTimeoutMs(5000).setClassicMemberMetadata(null).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedClassicMember), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)group.generationId()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, (Map)expectedClassicMember.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)group.generationId()), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedClassicMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedReplacingConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)newMemberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedReplacingConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedFinalConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedFinalConsumerMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        context.assertSessionTimeout(groupId, newMemberId, 45000L);
    }

    @Test
    public void testConsumerGroupHeartbeatToClassicGroupWithEmptyAssignmentMember() throws ExecutionException, InterruptedException {
        String groupId = "group-id";
        String memberId2 = "member-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 1).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName))))));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withProtocols(protocols).withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build());
        context.sleep(3001L);
        String memberId1 = joinResult.joinFuture.get().memberId();
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setRebalanceTimeoutMs(5000).setServerAssignor("no-op").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(1).setPreviousMemberEpoch(1).setState(MemberState.STABLE).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).setAssignedPartitions(Collections.emptyMap()).build();
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(2).setPreviousMemberEpoch(0).setState(MemberState.STABLE).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setServerAssignorName("no-op").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(5000).setAssignedPartitions(Collections.emptyMap()).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 1), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)expectedMember1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        context.assertSessionTimeout(groupId, memberId1, ((Integer)expectedMember1.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId2, 45000L);
    }

    @Test
    public void testConsumerGroupHeartbeatFromExistingClassicStaticMember() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String instanceId1 = "instance-id-1";
        String instanceId2 = "instance-id-2";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setInstanceId(instanceId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("no-op").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(instanceId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("no-op").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))));
        context.commit();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setInstanceId(instanceId1).setRebalanceTimeoutMs(5000).setServerAssignor("no-op").setSubscribedTopicNames(new ArrayList(member1.subscribedTopicNames())).setTopicPartitions(Collections.emptyList()), ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)memberId1, (Object)((ConsumerGroupHeartbeatResponseData)result.response()).memberId(), (String)"Server should not generate a new memberId since the consumer has already generated its own.");
        ConsumerGroupMember expectedReplacingConsumerMember = new ConsumerGroupMember.Builder(memberId1).setInstanceId(instanceId1).setMemberEpoch(0).setPreviousMemberEpoch(0).setState(MemberState.STABLE).setClientId(member1.clientId()).setClientHost(member1.clientHost()).setServerAssignorName("no-op").setSubscribedTopicNames(new ArrayList(member1.subscribedTopicNames())).setRebalanceTimeoutMs(member1.rebalanceTimeoutMs()).setAssignedPartitions(member1.assignedPartitions()).setClassicMemberMetadata((ConsumerGroupMemberMetadataValue.ClassicMemberMetadata)member1.classicMemberMetadata().get()).build();
        ConsumerGroupMember expectedFinalConsumerMember = new ConsumerGroupMember.Builder(expectedReplacingConsumerMember).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setClassicMemberMetadata(null).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedReplacingConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)member1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedReplacingConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedFinalConsumerMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedFinalConsumerMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        context.assertSessionTimeout(groupId, memberId1, 45000L);
    }

    @Test
    public void testConsumerGroupHeartbeatWithCompletingRebalanceClassicGroup() throws Exception {
        String groupId = "group-id";
        String memberId1 = "member-id-1";
        String memberId2 = "member-id-2";
        String memberId3 = "member-id-3";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), memberId3, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))))));
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.UPGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(metadataImage).build();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols1 = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols1.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1)))))));
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols2 = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(1);
        protocols2.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(barTopicName, 0)))))));
        Map<String, byte[]> assignments = Map.of(memberId1, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1))))), memberId2, Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(barTopicName, 0))))));
        ClassicGroup group = context.createClassicGroup(groupId);
        group.setProtocolName(Optional.of("range"));
        group.add(new ClassicGroupMember(memberId1, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols1, assignments.get(memberId1)));
        group.add(new ClassicGroupMember(memberId2, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", protocols2, assignments.get(memberId2)));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group.transitionTo(ClassicGroupState.STABLE);
        context.replay(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignments));
        context.commit();
        group = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId1).withProtocols(protocols1).withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build());
        context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId2).withProtocols(protocols2).withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId2).withGenerationId(1).build());
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupHeartbeatResult = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setTopicPartitions(Collections.emptyList()));
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(1).setPreviousMemberEpoch(1).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols1))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build();
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(1).setPreviousMemberEpoch(1).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols2))).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(2).setPreviousMemberEpoch(0).setState(MemberState.UNRELEASED_PARTITIONS).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setServerAssignorName("range").setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(5000).setAssignedPartitions(Collections.emptyMap()).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, (Map)expectedMember1.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, (Map)expectedMember2.assignedPartitions()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, assignor.targetPartitions(memberId1)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId3, assignor.targetPartitions(memberId3)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3));
        Assertions.assertRecordsEquals(expectedRecords, consumerGroupHeartbeatResult.records());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)syncResult.syncFuture.get().errorCode());
        context.assertSessionTimeout(groupId, memberId1, ((Integer)expectedMember1.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId2, ((Integer)expectedMember2.classicProtocolSessionTimeout().get()).intValue());
        context.assertSessionTimeout(groupId, memberId3, 45000L);
        context.rollback();
        org.junit.jupiter.api.Assertions.assertEquals((Object)group, (Object)context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false));
    }

    @Test
    public void testClassicGroupOnUnloadedEmptyAndPreparingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup emptyGroup = context.createClassicGroup("empty-group");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)emptyGroup.isInState(ClassicGroupState.EMPTY));
        ClassicGroup preparingGroup = context.createClassicGroup("preparing-group");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("preparing-group").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult1 = context.sendClassicGroupJoin(request);
        GroupMetadataManagerTestContext.JoinResult joinResult2 = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult1.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult2.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)preparingGroup.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)preparingGroup.numMembers());
        context.onUnloaded();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)emptyGroup.isInState(ClassicGroupState.DEAD));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)preparingGroup.isInState(ClassicGroupState.DEAD));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult1.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult2.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(joinResult1.joinFuture.get().memberId()).setMembers(Collections.emptyList()).setErrorCode(Errors.NOT_COORDINATOR.code()), (Object)joinResult1.joinFuture.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(joinResult2.joinFuture.get().memberId()).setMembers(Collections.emptyList()).setErrorCode(Errors.NOT_COORDINATOR.code()), (Object)joinResult2.joinFuture.get());
    }

    @Test
    public void testClassicGroupOnUnloadedCompletingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.PendingMemberGroupResult pendingGroupResult = context.setupGroupWithPendingMember(group);
        String pendingMemberId = pendingGroupResult.pendingMemberResponse.memberId();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(pendingMemberId).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(pendingGroupResult.followerId).withGenerationId(joinResult.joinFuture.get().generationId()).build());
        GroupMetadataManagerTestContext.SyncResult pendingMemberSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(pendingMemberId).withGenerationId(joinResult.joinFuture.get().generationId()).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pendingMemberSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        context.onUnloaded();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.DEAD));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pendingMemberSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new SyncGroupResponseData().setAssignment(ClassicGroupMember.EMPTY_ASSIGNMENT).setErrorCode(Errors.NOT_COORDINATOR.code()), (Object)followerSyncResult.syncFuture.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new SyncGroupResponseData().setAssignment(ClassicGroupMember.EMPTY_ASSIGNMENT).setErrorCode(Errors.NOT_COORDINATOR.code()), (Object)pendingMemberSyncResult.syncFuture.get());
    }

    @Test
    public void testLastConsumerProtocolMemberLeavingConsumerGroup() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))));
        context.commit();
        ConsumerGroup consumerGroup = context.groupMetadataManager.consumerGroup(groupId);
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        byte[] assignment = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))));
        Map<String, byte[]> assignments = Map.of(memberId1, assignment);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), result.records());
        MockCoordinatorTimer.ScheduledTimeout heartbeatTimeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)groupId, (String)memberId1));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)heartbeatTimeout);
        MockCoordinatorTimer.ScheduledTimeout groupJoinTimeout = context.timer.timeout(GroupMetadataManager.classicGroupJoinKey((String)groupId));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)groupJoinTimeout);
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)classicGroup.isInState(ClassicGroupState.PREPARING_REBALANCE));
        context.rollback();
        org.junit.jupiter.api.Assertions.assertEquals((Object)consumerGroup, (Object)context.groupMetadataManager.consumerGroup(groupId));
    }

    @Test
    public void testLastConsumerProtocolMemberSessionTimeoutInConsumerGroup() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))));
        context.commit();
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        context.assertSessionTimeout(groupId, memberId2, 45000L);
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = context.sleep(45001L).get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.groupSessionTimeoutKey((String)groupId, (String)memberId2), (Object)timeout.key);
        byte[] assignment = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))));
        Map<String, byte[]> assignments = Map.of(memberId1, assignment);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), timeout.result.records());
        MockCoordinatorTimer.ScheduledTimeout heartbeatTimeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)groupId, (String)memberId1));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)heartbeatTimeout);
        MockCoordinatorTimer.ScheduledTimeout groupJoinTimeout = context.timer.timeout(GroupMetadataManager.classicGroupJoinKey((String)groupId));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)groupJoinTimeout);
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)classicGroup.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testLastConsumerProtocolMemberRebalanceTimeoutInConsumerGroup() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(30000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar", "zar")).setServerAssignorName("range").setRebalanceTimeoutMs(30000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3), zarTopicName, new TopicMetadata(zarTopicId, zarTopicName, 1))));
        context.commit();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))))));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(List.of(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(2))))));
        context.assertRebalanceTimeout(groupId, memberId2, 30000L);
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = context.sleep(30001L).get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.consumerGroupRebalanceTimeoutKey((String)groupId, (String)memberId2), (Object)timeout.key);
        byte[] assignment = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))));
        Map<String, byte[]> assignments = Map.of(memberId1, assignment);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 11, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), timeout.result.records());
        MockCoordinatorTimer.ScheduledTimeout heartbeatTimeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)groupId, (String)memberId1));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)heartbeatTimeout);
        MockCoordinatorTimer.ScheduledTimeout groupJoinTimeout = context.timer.timeout(GroupMetadataManager.classicGroupJoinKey((String)groupId));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)groupJoinTimeout);
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)classicGroup.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testLastStaticConsumerProtocolMemberReplacedByClassicProtocolMember() throws ExecutionException, InterruptedException {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String oldMemberId2 = Uuid.randomUuid().toString();
        String instanceId = "instance-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols1 = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols1)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember oldMember2 = new ConsumerGroupMember.Builder(oldMemberId2).setInstanceId(instanceId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 2).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(oldMember2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(oldMemberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.consumerGroup(groupId).setMetadataRefreshDeadline(Long.MAX_VALUE, 10);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 2))));
        context.commit();
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withGroupInstanceId(instanceId).withProtocolType("consumer").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult result = context.sendClassicGroupJoin(joinRequest);
        result.appendFuture.complete(null);
        String newMemberId2 = result.joinFuture.get().memberId();
        ConsumerGroupMember expectedNewConsumerMember2 = new ConsumerGroupMember.Builder(oldMember2, newMemberId2).setMemberEpoch(0).setPreviousMemberEpoch(0).build();
        ConsumerGroupMember expectedNewClassicMember2 = new ConsumerGroupMember.Builder(oldMember2, newMemberId2).setPreviousMemberEpoch(0).setRebalanceTimeoutMs(joinRequest.rebalanceTimeoutMs()).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(joinRequest.sessionTimeoutMs()).setSupportedProtocols(List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName)))))))).build();
        byte[] assignment1 = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1)))));
        byte[] assignment2 = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 3), new TopicPartition(fooTopicName, 4), new TopicPartition(fooTopicName, 5)))));
        Map<String, byte[]> assignments = Map.of(memberId1, assignment1, newMemberId2, assignment2);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment1));
        expectedClassicGroup.add(new ClassicGroupMember(newMemberId2, Optional.ofNullable(oldMember2.instanceId()), "client", GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString(), joinRequest.rebalanceTimeoutMs(), joinRequest.sessionTimeoutMs(), joinRequest.protocolType(), joinRequest.protocols(), assignment2));
        String leader = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false).leaderOrNull();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Set.of(memberId1, newMemberId2).contains(leader));
        expectedClassicGroup.setLeaderId(Optional.of(leader));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)oldMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)oldMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)oldMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedNewConsumerMember2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)newMemberId2, (Map)expectedNewConsumerMember2.assignedPartitions())), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedNewConsumerMember2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedNewClassicMember2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedNewClassicMember2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)newMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)newMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)newMemberId2)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), result.records);
        MockCoordinatorTimer.ScheduledTimeout heartbeatTimeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)groupId, (String)memberId1));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)heartbeatTimeout);
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)classicGroup.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testJoiningConsumerGroupThrowsExceptionIfGroupOverMaxSize() {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).build())).withConfig("group.consumer.max.size", 1).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(GroupMaxSizeReachedException.class, () -> context.sendClassicGroupJoin(request));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"The consumer group has reached its maximum capacity of 1 members.", (Object)ex.getMessage());
    }

    @Test
    public void testJoiningConsumerGroupThrowsExceptionIfProtocolIsNotSupported() {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toProtocols("roundrobin")))).build())).build();
        JoinGroupRequestData requestWithEmptyProtocols = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withProtocolType("consumer").withDefaultProtocolTypeAndProtocols().build();
        org.junit.jupiter.api.Assertions.assertThrows(InconsistentGroupProtocolException.class, () -> context.sendClassicGroupJoin(requestWithEmptyProtocols));
        JoinGroupRequestData requestWithInvalidProtocolType = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withProtocolType("connect").withDefaultProtocolTypeAndProtocols().build();
        org.junit.jupiter.api.Assertions.assertThrows(InconsistentGroupProtocolException.class, () -> context.sendClassicGroupJoin(requestWithInvalidProtocolType));
    }

    @Test
    public void testJoiningConsumerGroupWithNewDynamicMember() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            String memberId = Uuid.randomUuid().toString();
            MockPartitionAssignor assignor = new MockPartitionAssignor("range");
            GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2))).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).withAssignmentEpoch(10)).build();
            JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), Collections.emptyList(), version)).build();
            GroupMetadataManagerTestContext.JoinResult firstJoinResult = context.sendClassicGroupJoin(request, true);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)firstJoinResult.records.isEmpty());
            firstJoinResult.appendFuture.complete(null);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)firstJoinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)firstJoinResult.joinFuture.get().errorCode());
            String newMemberId = firstJoinResult.joinFuture.get().memberId();
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)"", (Object)newMemberId);
            assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), newMemberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
            JoinGroupRequestData secondRequest = new JoinGroupRequestData().setGroupId(request.groupId()).setMemberId(newMemberId).setProtocolType(request.protocolType()).setProtocols(request.protocols()).setSessionTimeoutMs(request.sessionTimeoutMs()).setRebalanceTimeoutMs(request.rebalanceTimeoutMs()).setReason(request.reason());
            GroupMetadataManagerTestContext.JoinResult secondJoinResult = context.sendClassicGroupJoin(secondRequest, true);
            ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(newMemberId).setMemberEpoch(11).setPreviousMemberEpoch(0).setState(MemberState.STABLE).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(500).setAssignedPartitions(assignor.targetPartitions(newMemberId)).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)request.protocols()))).build();
            Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId, assignor.targetPartitions(memberId)), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)newMemberId, assignor.targetPartitions(newMemberId))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember))), secondJoinResult.records);
            secondJoinResult.appendFuture.complete(null);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)secondJoinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(newMemberId).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)secondJoinResult.joinFuture.get());
            context.assertSessionTimeout(groupId, newMemberId, request.sessionTimeoutMs());
            context.assertSyncTimeout(groupId, newMemberId, request.rebalanceTimeoutMs());
        }
    }

    @Test
    public void testJoiningConsumerGroupFailingToPersistRecords() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        String memberId = Uuid.randomUuid().toString();
        String newMemberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), newMemberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2))).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).withAssignmentEpoch(10)).build();
        context.commit();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(newMemberId).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName), Collections.emptyList())).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        joinResult.appendFuture.completeExceptionally((Throwable)new NotLeaderOrFollowerException());
        context.rollback();
        context.assertNoSessionTimeout(groupId, newMemberId);
        context.assertNoSyncTimeout(groupId, newMemberId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)context.groupMetadataManager.consumerGroup(groupId).hasMember(newMemberId));
    }

    @Test
    public void testJoiningConsumerGroupWithNewStaticMember() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        String memberId = Uuid.randomUuid().toString();
        String instanceId = "instance-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2))).withMember(new ConsumerGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).withAssignmentEpoch(10)).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withGroupInstanceId(instanceId).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), Collections.emptyList())).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        joinResult.appendFuture.complete(null);
        String newMemberId = joinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"", (Object)newMemberId);
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(newMemberId).setMemberEpoch(11).setPreviousMemberEpoch(0).setInstanceId(instanceId).setState(MemberState.STABLE).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setRebalanceTimeoutMs(500).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)request.protocols()))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)newMemberId, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, joinResult.records);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(newMemberId).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResult.joinFuture.get());
        context.assertSessionTimeout(groupId, newMemberId, request.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, newMemberId, request.rebalanceTimeoutMs());
    }

    @Test
    public void testJoiningConsumerGroupReplacingExistingStaticMember() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        String memberId = Uuid.randomUuid().toString();
        String instanceId = "instance-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DISABLED.toString()).withConfig("group.consumer.assignors", List.of(new NoOpPartitionAssignor())).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2))).withMember(new ConsumerGroupMember.Builder(memberId).setInstanceId(instanceId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setSubscribedTopicNames(List.of(fooTopicName)).setRebalanceTimeoutMs(500).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.consumerGroup(groupId).setMetadataRefreshDeadline(Long.MAX_VALUE, 10);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withGroupInstanceId(instanceId).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName), Collections.emptyList())).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        joinResult.appendFuture.complete(null);
        String newMemberId = joinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"", (Object)newMemberId);
        ConsumerGroupMember expectedCopiedMember = new ConsumerGroupMember.Builder(newMemberId).setMemberEpoch(0).setPreviousMemberEpoch(0).setInstanceId(instanceId).setState(MemberState.STABLE).setSubscribedTopicNames(List.of(fooTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).setRebalanceTimeoutMs(500).build();
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(newMemberId).setMemberEpoch(10).setPreviousMemberEpoch(0).setInstanceId(instanceId).setState(MemberState.STABLE).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).setRebalanceTimeoutMs(500).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)request.protocols()))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)newMemberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedCopiedMember), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, joinResult.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(newMemberId).setGenerationId(10).setProtocolType("consumer").setProtocolName("range"), (Object)joinResult.joinFuture.get());
        context.assertSessionTimeout(groupId, newMemberId, request.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, newMemberId, request.rebalanceTimeoutMs());
    }

    @Test
    public void testJoiningConsumerGroupWithExistingStaticMemberAndNewSubscription() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String instanceId = "instance-id";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1), zarTopicName, new TopicMetadata(zarTopicId, zarTopicName, 1))).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(instanceId).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1)))))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).withAssignmentEpoch(10)).build();
        ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
        group.setMetadataRefreshDeadline(Long.MAX_VALUE, 11);
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0), AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))))));
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), Collections.emptyList())).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId1).setInstanceId(instanceId).setMemberEpoch(11).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setState(MemberState.STABLE).setSubscribedTopicNames(List.of(fooTopicName, barTopicName, zarTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), Collections.emptyList())))).build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0), AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember))), joinResult.records);
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResult.joinFuture.get());
        context.assertSessionTimeout(groupId, memberId1, request.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request.rebalanceTimeoutMs());
    }

    @Test
    public void testStaticMemberJoiningConsumerGroupWithUnknownInstanceId() throws Exception {
        String groupId = "group-id";
        String instanceId = "instance-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String fooTopicName = "foo";
        String barTopicName = "bar";
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1)));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).build())).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withGroupInstanceId(instanceId).withProtocols(protocols).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupJoin(request));
    }

    @Test
    public void testStaticMemberJoiningConsumerGroupWithUnmatchedMemberId() throws Exception {
        String groupId = "group-id";
        String instanceId = "instance-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String fooTopicName = "foo";
        String barTopicName = "bar";
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1)));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(instanceId).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)protocols))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).build())).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(Uuid.randomUuid().toString()).withGroupInstanceId(instanceId).withProtocols(protocols).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.sendClassicGroupJoin(request));
    }

    @Test
    public void testReconciliationInJoiningConsumerGroupWithEagerProtocol() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).withAssignmentEpoch(10)).build();
        ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
        group.setMetadataRefreshDeadline(Long.MAX_VALUE, 11);
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withSessionTimeoutMs(5000).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), Collections.emptyList())).build();
        GroupMetadataManagerTestContext.JoinResult joinResult1 = context.sendClassicGroupJoin(request);
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(11).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setState(MemberState.UNRELEASED_PARTITIONS).setSubscribedTopicNames(List.of(fooTopicName, barTopicName, zarTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), Collections.emptyList())))).build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1), zarTopicName, new TopicMetadata(zarTopicId, zarTopicName, 1)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1))), joinResult1.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMember1.state(), (Object)group.getOrMaybeCreateMember(memberId1, false).state());
        joinResult1.appendFuture.complete(null);
        JoinGroupResponseData joinResponse1 = joinResult1.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResponse1);
        context.assertSessionTimeout(groupId, memberId1, request.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request.rebalanceTimeoutMs());
        context.verifyClassicGroupSyncToConsumerGroup(groupId, joinResponse1.memberId(), joinResponse1.generationId(), joinResponse1.protocolName(), joinResponse1.protocolType(), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(zarTopicName, 0)));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setGenerationId(joinResponse1.generationId())).response()).errorCode());
        context.assertJoinTimeout(groupId, memberId1, 500L);
        GroupMetadataManagerTestContext.JoinResult joinResult2 = context.sendClassicGroupJoin(request);
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(expectedMember1).setState(MemberState.STABLE).setPreviousMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))).build();
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2)), joinResult2.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMember2.state(), (Object)group.getOrMaybeCreateMember(memberId1, false).state());
        joinResult2.appendFuture.complete(null);
        context.assertNoJoinTimeout(groupId, memberId1);
        JoinGroupResponseData joinResponse2 = joinResult2.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResponse2);
        context.assertSessionTimeout(groupId, memberId1, request.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request.rebalanceTimeoutMs());
        context.verifyClassicGroupSyncToConsumerGroup(groupId, joinResponse2.memberId(), joinResponse2.generationId(), joinResponse2.protocolName(), joinResponse2.protocolType(), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(zarTopicName, 0)));
    }

    @Test
    public void testReconciliationInJoiningConsumerGroupWithCooperativeProtocol() throws Exception {
        String groupId = "group-id";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of(fooTopicName, barTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).withAssignmentEpoch(10)).build();
        ConsumerGroup group = context.groupMetadataManager.consumerGroup(groupId);
        group.setMetadataRefreshDeadline(Long.MAX_VALUE, 11);
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))))));
        JoinGroupRequestData request1 = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withSessionTimeoutMs(5000).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))).build();
        GroupMetadataManagerTestContext.JoinResult joinResult1 = context.sendClassicGroupJoin(request1);
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(10).setRebalanceTimeoutMs(500).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setState(MemberState.UNREVOKED_PARTITIONS).setSubscribedTopicNames(List.of(fooTopicName, barTopicName, zarTopicName)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request1.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(barTopicName, 0)))))).build();
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1), zarTopicName, new TopicMetadata(zarTopicId, zarTopicName, 1)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1))), joinResult1.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMember1.state(), (Object)group.getOrMaybeCreateMember(memberId1, false).state());
        joinResult1.appendFuture.complete(null);
        JoinGroupResponseData joinResponse1 = joinResult1.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(10).setProtocolType("consumer").setProtocolName("range"), (Object)joinResponse1);
        context.assertSessionTimeout(groupId, memberId1, request1.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request1.rebalanceTimeoutMs());
        context.verifyClassicGroupSyncToConsumerGroup(groupId, joinResponse1.memberId(), joinResponse1.generationId(), joinResponse1.protocolName(), joinResponse1.protocolType(), List.of(new TopicPartition(fooTopicName, 0)));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setGenerationId(joinResponse1.generationId())).response()).errorCode());
        context.assertJoinTimeout(groupId, memberId1, 500L);
        JoinGroupRequestData request2 = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withSessionTimeoutMs(5000).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0)))).build();
        GroupMetadataManagerTestContext.JoinResult joinResult2 = context.sendClassicGroupJoin(request2);
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(expectedMember1).setMemberEpoch(11).setState(MemberState.UNRELEASED_PARTITIONS).setPartitionsPendingRevocation(Collections.emptyMap()).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request2.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0)))))).build();
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2)), joinResult2.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMember2.state(), (Object)group.getOrMaybeCreateMember(memberId1, false).state());
        joinResult2.appendFuture.complete(null);
        context.assertNoJoinTimeout(groupId, memberId1);
        JoinGroupResponseData joinResponse2 = joinResult2.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResponse2);
        context.assertSessionTimeout(groupId, memberId1, request2.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request2.rebalanceTimeoutMs());
        context.verifyClassicGroupSyncToConsumerGroup(groupId, joinResponse2.memberId(), joinResponse2.generationId(), joinResponse2.protocolName(), joinResponse2.protocolType(), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(zarTopicName, 0)));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((HeartbeatResponseData)context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setGenerationId(joinResponse2.generationId())).response()).errorCode());
        context.assertJoinTimeout(groupId, memberId1, 500L);
        JoinGroupRequestData request3 = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId1).withSessionTimeoutMs(5000).withProtocols(GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(zarTopicName, 0)))).build();
        GroupMetadataManagerTestContext.JoinResult joinResult3 = context.sendClassicGroupJoin(request3);
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(expectedMember2).setState(MemberState.STABLE).setPreviousMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(zarTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(request3.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName, zarTopicName), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(zarTopicName, 0)))))).build();
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3)), joinResult3.records);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedMember3.state(), (Object)group.getOrMaybeCreateMember(memberId1, false).state());
        joinResult3.appendFuture.complete(null);
        context.assertNoJoinTimeout(groupId, memberId1);
        JoinGroupResponseData joinResponse3 = joinResult3.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((Object)new JoinGroupResponseData().setMemberId(memberId1).setGenerationId(11).setProtocolType("consumer").setProtocolName("range"), (Object)joinResponse3);
        context.assertSessionTimeout(groupId, memberId1, request3.sessionTimeoutMs());
        context.assertSyncTimeout(groupId, memberId1, request3.rebalanceTimeoutMs());
        context.verifyClassicGroupSyncToConsumerGroup(groupId, joinResponse3.memberId(), joinResponse3.generationId(), joinResponse3.protocolName(), joinResponse3.protocolType(), List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(zarTopicName, 0)));
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupWithAllConsumerProtocolVersions() throws Exception {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        for (short version = 0; version <= 3; version = (short)(version + 1)) {
            List<TopicPartition> topicPartitions = List.of(new TopicPartition(fooTopicName, 0), new TopicPartition(fooTopicName, 1), new TopicPartition(fooTopicName, 2), new TopicPartition(barTopicName, 0), new TopicPartition(barTopicName, 1));
            List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, topicPartitions), (short)version))));
            ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setSubscribedTopicNames(List.of("foo", "bar")).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
            ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setSubscribedTopicNames(List.of("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
            GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
            context.verifyClassicGroupSyncToConsumerGroup(groupId, memberId1, 10, "range", "consumer", topicPartitions, version);
        }
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupWithUnknownMemberId() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(Uuid.randomUuid().toString()).withGenerationId(10).withProtocolName("range").withProtocolType("consumer").build()));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGroupInstanceId("unknown-instance-id").withGenerationId(10).withProtocolName("range").withProtocolType("consumer").build()));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGenerationId(10).withProtocolName("range").withProtocolType("consumer").build()));
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupWithFencedInstanceId() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        String instanceId = "instance-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setInstanceId(instanceId).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(Uuid.randomUuid().toString()).withGroupInstanceId(instanceId).withGenerationId(10).withProtocolName("range").withProtocolType("consumer").build()));
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupWithInconsistentGroupProtocol() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setMemberEpoch(10).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(InconsistentGroupProtocolException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGenerationId(10).withProtocolName("roundrobin").withProtocolType("consumer").build()));
        org.junit.jupiter.api.Assertions.assertThrows(InconsistentGroupProtocolException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGenerationId(10).withProtocolName("range").withProtocolType("connect").build()));
        context.verifyClassicGroupSyncToConsumerGroup(groupId, memberId, 10, null, null, Collections.emptyList());
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupWithIllegalGeneration() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setMemberEpoch(10).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGenerationId(9).withProtocolType("consumer").withProtocolName("range").build()));
    }

    @Test
    public void testClassicGroupSyncToConsumerGroupRebalanceInProgress() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 11).withMember(new ConsumerGroupMember.Builder(memberId).setRebalanceTimeoutMs(10000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setMemberEpoch(10).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(RebalanceInProgressException.class, () -> context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withMemberId(memberId).withGenerationId(10).withProtocolType("consumer").withProtocolName("range").build()));
        context.assertJoinTimeout(groupId, memberId, 10000L);
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerGroupMaintainsSession() throws Exception {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        int sessionTimeout = 5000;
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeout).setSupportedProtocols(protocols)).setMemberEpoch(10).build())).build();
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(10);
        context.sendClassicGroupHeartbeat(request);
        context.assertSessionTimeout(groupId, memberId, sessionTimeout);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(sessionTimeout / 2));
        HeartbeatResponseData heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(request).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        context.assertSessionTimeout(groupId, memberId, sessionTimeout);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(sessionTimeout / 2));
        heartbeatResponse = (HeartbeatResponseData)context.sendClassicGroupHeartbeat(request).response();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        context.assertSessionTimeout(groupId, memberId, sessionTimeout);
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerGroupRebalanceInProgress() throws Exception {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        int sessionTimeout = 5000;
        int rebalanceTimeout = 10000;
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setRebalanceTimeoutMs(rebalanceTimeout).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeout).setSupportedProtocols(protocols)).setMemberEpoch(9).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.UNREVOKED_PARTITIONS).setRebalanceTimeoutMs(rebalanceTimeout).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeout).setSupportedProtocols(protocols)).setMemberEpoch(10).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder(memberId3).setState(MemberState.UNRELEASED_PARTITIONS).setRebalanceTimeoutMs(rebalanceTimeout).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeout).setSupportedProtocols(protocols)).setMemberEpoch(10).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withMember(member3).withAssignment(memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2)))).build();
        List.of(memberId1, memberId2, memberId3).forEach(memberId -> {
            CoordinatorResult<HeartbeatResponseData, CoordinatorRecord> heartbeatResult = context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(memberId.equals(memberId1) ? 9 : 10));
            org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)heartbeatResult.records());
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((HeartbeatResponseData)heartbeatResult.response()).errorCode());
            context.assertSessionTimeout(groupId, (String)memberId, sessionTimeout);
            context.assertJoinTimeout(groupId, (String)memberId, rebalanceTimeout);
        });
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerWithUnknownMember() {
        String groupId = "group-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-member-id").setGenerationId(10)));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-member-id").setGroupInstanceId("unknown-instance-id").setGenerationId(10)));
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerWithFencedInstanceId() {
        String groupId = "group-id";
        String memberId = "member-id";
        String instanceId = "instance-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setInstanceId(instanceId).setMemberEpoch(10).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(Collections.emptyList())).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-member-id").setGroupInstanceId(instanceId).setGenerationId(10)));
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerWithIllegalGenerationId() {
        String groupId = "group-id";
        String memberId = "member-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(10).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(Collections.emptyList())).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(9)));
    }

    @Test
    public void testClassicGroupHeartbeatToConsumerWithMemberNotUsingClassicProtocol() {
        String groupId = "group-id";
        String memberId = "member-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(10).build())).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(10)));
    }

    @Test
    public void testConsumerGroupMemberUsingClassicProtocolFencedWhenSessionTimeout() {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        int sessionTimeout = 5000;
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(sessionTimeout).setSupportedProtocols(protocols)).setMemberEpoch(10).build())).build();
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(10);
        context.sendClassicGroupHeartbeat(request);
        context.assertSessionTimeout(groupId, memberId, sessionTimeout);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(sessionTimeout + 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.groupSessionTimeoutKey((String)groupId, (String)memberId), (Object)timeout.key);
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), timeout.result.records());
    }

    @Test
    public void testConsumerGroupMemberUsingClassicProtocolFencedWhenJoinTimeout() {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        int rebalanceTimeout = 500;
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of("foo"), null, Collections.emptyList())))));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setRebalanceTimeoutMs(rebalanceTimeout).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocols)).setMemberEpoch(9).build())).build();
        HeartbeatRequestData request = new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(9);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((HeartbeatResponseData)context.sendClassicGroupHeartbeat(request).response()).errorCode());
        context.assertSessionTimeout(groupId, memberId, 5000L);
        context.assertJoinTimeout(groupId, memberId, rebalanceTimeout);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(rebalanceTimeout + 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.consumerGroupJoinKey((String)groupId, (String)memberId), (Object)timeout.key);
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), timeout.result.records());
    }

    @Test
    public void testConsumerGroupMemberUsingClassicProtocolBatchLeaveGroup() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        String instanceId2 = "instance-id-2";
        String instanceId3 = "instance-id-3";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocol1 = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0)))))));
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocol2 = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocol1)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(instanceId2).setState(MemberState.STABLE).setMemberEpoch(9).setPreviousMemberEpoch(8).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocol2)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder(memberId3).setInstanceId(instanceId3).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withMember(member3).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).withAssignment(memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.consumerGroup(groupId).setMetadataRefreshDeadline(Long.MAX_VALUE, 10);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))));
        context.sendClassicGroupJoin((JoinGroupRequestData)new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId((String)groupId).withMemberId((String)memberId1).withRebalanceTimeoutMs((int)member1.rebalanceTimeoutMs()).withSessionTimeoutMs((int)((ConsumerGroupMemberMetadataValue.ClassicMemberMetadata)member1.classicMemberMetadata().get()).sessionTimeoutMs()).withProtocols((JoinGroupRequestData.JoinGroupRequestProtocolCollection)GroupMetadataManagerTestContext.toConsumerProtocol(List.of(fooTopicName, barTopicName), List.of(new TopicPartition((String)fooTopicName, (int)0)))).build()).appendFuture.complete(null);
        context.assertSyncTimeout(groupId, memberId1, member1.rebalanceTimeoutMs());
        context.assertSessionTimeout(groupId, memberId1, ((ConsumerGroupMemberMetadataValue.ClassicMemberMetadata)member1.classicMemberMetadata().get()).sessionTimeoutMs());
        context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setGenerationId(9));
        context.assertJoinTimeout(groupId, memberId2, member2.rebalanceTimeoutMs());
        context.assertSessionTimeout(groupId, memberId2, ((ConsumerGroupMemberMetadataValue.ClassicMemberMetadata)member2.classicMemberMetadata().get()).sessionTimeoutMs());
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId1).setGroupInstanceId(null), new LeaveGroupRequestData.MemberIdentity().setMemberId("").setGroupInstanceId(instanceId2), new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId3).setGroupInstanceId(instanceId3), new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id").setGroupInstanceId(null), new LeaveGroupRequestData.MemberIdentity().setMemberId("").setGroupInstanceId("unknown-instance-id"), new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id").setGroupInstanceId(instanceId3))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(memberId1), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(instanceId2).setMemberId(""), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(instanceId3).setMemberId(memberId3), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("unknown-instance-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setMemberId("unknown-member-id").setGroupInstanceId(instanceId3).setErrorCode(Errors.FENCED_INSTANCE_ID.code()))), (Object)leaveResult.response());
        List<List<CoordinatorRecord>> expectedRecords = List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId3)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap())), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)));
        Assertions.assertUnorderedRecordsEquals(expectedRecords, leaveResult.records());
        context.assertNoSessionTimeout(groupId, memberId1);
        context.assertNoSyncTimeout(groupId, memberId1);
        context.assertNoSessionTimeout(groupId, memberId2);
        context.assertNoJoinTimeout(groupId, memberId2);
    }

    @Test
    public void testConsumerGroupMemberUsingClassicProtocolBatchLeaveGroupUpdatingSubscriptionMetadata() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocol = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocol)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.consumerGroup(groupId).setMetadataRefreshDeadline(Long.MAX_VALUE, 10);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 1))));
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId1))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(memberId1))), (Object)leaveResult.response());
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, (Object)leaveResult.records());
    }

    @Test
    public void testClassicGroupLeaveToConsumerGroupWithoutValidLeaveGroupMember() {
        String groupId = "group-id";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).build())).build();
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id"))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()))), (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)leaveResult.records());
    }

    @Test
    public void testLastConsumerProtocolMemberLeavingConsumerGroupByAdminApi() {
        String groupId = "group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        String memberId4 = Uuid.randomUuid().toString();
        String instanceId2 = "instance-id-2";
        String instanceId4 = "instance-id-4";
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocol1 = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 0)))))));
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocol2 = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(List.of(fooTopicName, barTopicName), null, List.of(new TopicPartition(fooTopicName, 1)))))));
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocol1)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(instanceId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(5000).setSupportedProtocols(protocol2)).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder(memberId3).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build();
        ConsumerGroupMember member4 = new ConsumerGroupMember.Builder(memberId4).setInstanceId(instanceId4).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setRebalanceTimeoutMs(45000).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).addTopic(barTopicId, barTopicName, 2).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withMember(member3).withMember(member4).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).withAssignment(memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).withAssignment(memberId4, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).withAssignmentEpoch(10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 2), barTopicName, new TopicMetadata(barTopicId, barTopicName, 2))));
        context.commit();
        ConsumerGroup consumerGroup = context.groupMetadataManager.consumerGroup(groupId);
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId2).setGroupInstanceId(null), new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId3).setGroupInstanceId(null), new LeaveGroupRequestData.MemberIdentity().setMemberId("").setGroupInstanceId(instanceId4))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(memberId2), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(memberId3), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(instanceId4).setMemberId(""))), (Object)leaveResult.response());
        byte[] assignment = Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(List.of(new TopicPartition(fooTopicName, 0)))));
        Map<String, byte[]> assignments = Map.of(memberId1, assignment);
        ClassicGroup expectedClassicGroup = new ClassicGroup(new LogContext(), groupId, ClassicGroupState.STABLE, (Time)context.time, context.metrics, 10, Optional.of("consumer"), Optional.of("range"), Optional.of(memberId1), Optional.of(context.time.milliseconds()));
        expectedClassicGroup.add(new ClassicGroupMember(memberId1, Optional.ofNullable(member1.instanceId()), member1.clientId(), member1.clientHost(), member1.rebalanceTimeoutMs(), ((Integer)member1.classicProtocolSessionTimeout().get()).intValue(), "consumer", member1.supportedJoinGroupRequestProtocols(), assignment));
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId4)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId4)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId4)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)groupId)), List.of(GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)expectedClassicGroup, assignments))), leaveResult.records());
        MockCoordinatorTimer.ScheduledTimeout heartbeatTimeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)groupId, (String)memberId1));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)heartbeatTimeout);
        MockCoordinatorTimer.ScheduledTimeout groupJoinTimeout = context.timer.timeout(GroupMetadataManager.classicGroupJoinKey((String)groupId));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)groupJoinTimeout);
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)classicGroup.isInState(ClassicGroupState.PREPARING_REBALANCE));
        context.rollback();
        org.junit.jupiter.api.Assertions.assertEquals((Object)consumerGroup, (Object)context.groupMetadataManager.consumerGroup(groupId));
    }

    @Test
    public void testNoConversionWhenSizeExceedsClassicMaxGroupSize() throws Exception {
        String groupId = "group-id";
        String nonClassicMemberId = "1";
        List<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = List.of(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(nonClassicMemberId).build();
        ConsumerGroupMember classicMember1 = new ConsumerGroupMember.Builder("2").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
        ConsumerGroupMember classicMember2 = new ConsumerGroupMember.Builder("3").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.max.size", 1).withConfig("group.consumer.migration.policy", ConsumerGroupMigrationPolicy.DOWNGRADE.toString()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member).withMember(classicMember1).withMember(classicMember2)).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.CONSUMER, (Object)context.groupMetadataManager.group(groupId).type());
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(nonClassicMemberId).setMemberEpoch(-1).setRebalanceTimeoutMs(5000));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Group.GroupType.CONSUMER, (Object)context.groupMetadataManager.group(groupId).type());
    }

    @Test
    public void testShareGroupHeartbeatRequestValidation() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).build();
        Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MemberId can't be empty.", (Object)ex.getMessage());
        String memberId = Uuid.randomUuid().toString();
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setMemberId(memberId)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("   ")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("foo").setMemberEpoch(0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SubscribedTopicNames must be set in first request.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId("foo").setMemberEpoch(1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MemberId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setMemberId(memberId).setGroupId("foo").setMemberEpoch(1).setRackId("")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RackId can't be empty.", (Object)ex.getMessage());
    }

    @Test
    public void testShareGroupDescribeRequest() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        List<ShareGroupDescribeResponseData.DescribedGroup> groups = context.sendShareGroupDescribe(Collections.emptyList());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)groups.size());
        groups = context.sendShareGroupDescribe(List.of("unknown-group"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)groups.size());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.GROUP_ID_NOT_FOUND.code(), (short)groups.get(0).errorCode());
    }

    @Test
    public void testShareGroupDescribeNoErrors() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("share-range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        List<String> groupIds = List.of("group-id-1", "group-id-2");
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupIds.get(0), (int)100));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupIds.get(1), (int)15));
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupIds.get(1)).setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo")));
        String memberId = ((ShareGroupHeartbeatResponseData)result.response()).memberId();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)memberId);
        context.commit();
        List<ShareGroupDescribeResponseData.DescribedGroup> expected = List.of(new ShareGroupDescribeResponseData.DescribedGroup().setGroupEpoch(100).setGroupId(groupIds.get(0)).setGroupState(ShareGroup.ShareGroupState.EMPTY.toString()).setAssignorName("share-range"), new ShareGroupDescribeResponseData.DescribedGroup().setGroupEpoch(16).setAssignmentEpoch(16).setGroupId(groupIds.get(1)).setMembers(List.of(new ShareGroupMember.Builder(memberId).setMemberEpoch(16).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(List.of("foo")).build().asShareGroupDescribeMember(new MetadataImageBuilder().build().topics()))).setGroupState(ShareGroup.ShareGroupState.STABLE.toString()).setAssignorName("share-range"));
        List<ShareGroupDescribeResponseData.DescribedGroup> actual = context.sendShareGroupDescribe(groupIds);
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testShareGroupMemberIdGeneration() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        String memberId = Uuid.randomUuid().toString();
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId("group-foo").setMemberId(memberId).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)memberId, (Object)((ShareGroupHeartbeatResponseData)result.response()).memberId(), (String)"MemberId should remain unchanged, as the server does not generate a new one since the consumer generates its own.");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ShareGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ShareGroupHeartbeatResponseData.Assignment()), (Object)result.response());
    }

    @Test
    public void testShareGroupUnknownGroupId() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(100).setSubscribedTopicNames(List.of("foo", "bar"))));
    }

    @Test
    public void testShareGroupUnknownMemberIdJoins() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(new NoOpPartitionAssignor()).build();
        context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar")));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setSubscribedTopicNames(List.of("foo", "bar"))));
    }

    @Test
    public void testShareGroupMemberJoinsEmptyGroupWithAssignments() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.shareGroup(groupId));
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar")));
        Assertions.assertResponseEquals((ApiMessage)new ShareGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ShareGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))), new ShareGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)))))), (ApiMessage)result.response());
        ShareGroupMember expectedMember = new ShareGroupMember.Builder(memberId).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setMemberEpoch(1).setPreviousMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newShareGroupMemberSubscriptionRecord((String)groupId, (ShareGroupMember)expectedMember), GroupCoordinatorRecordHelpers.newShareGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentRecord((String)groupId, (ShareGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testShareGroupLeavingMemberBumpsGroupEpoch() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withShareGroup(new ShareGroupBuilder(groupId, 10).withMember(new ShareGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(List.of("foo", "bar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ShareGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(List.of("foo", "bar", "zar")).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(-1).setSubscribedTopicNames(List.of("foo", "bar")));
        Assertions.assertResponseEquals((ApiMessage)new ShareGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-1), (ApiMessage)result.response());
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newShareGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newShareGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testShareGroupNewMemberIsRejectedWithMaximumMembersIsReached() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withConfig("group.share.max.size", 1).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupId, (int)100));
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar")));
        org.junit.jupiter.api.Assertions.assertEquals((int)101, (int)((ShareGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertThrows(GroupMaxSizeReachedException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo", "bar"))));
    }

    @Test
    public void testShareGroupDelete() {
        String groupId = "share-group-id";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroup(new ShareGroupBuilder(groupId, 10)).build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newShareGroupSubscriptionMetadataTombstoneRecord((String)groupId), GroupCoordinatorRecordHelpers.newShareGroupEpochTombstoneRecord((String)groupId));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.createGroupTombstoneRecords("share-group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
    }

    @Test
    public void testShareGroupStates() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("share-range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withShareGroup(new ShareGroupBuilder(groupId, 10)).build();
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupId, (int)10));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ShareGroup.ShareGroupState.EMPTY, (Object)context.shareGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupMemberSubscriptionRecord((String)groupId, (ShareGroupMember)new ShareGroupMember.Builder(memberId1).setState(MemberState.STABLE).setSubscribedTopicNames(List.of(fooTopicName)).build()));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)context.shareGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupTargetAssignmentEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)context.shareGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentRecord((String)groupId, (ShareGroupMember)new ShareGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)context.shareGroupState(groupId));
        context.replay(GroupCoordinatorRecordHelpers.newShareGroupCurrentAssignmentRecord((String)groupId, (ShareGroupMember)new ShareGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ShareGroup.ShareGroupState.STABLE, (Object)context.shareGroupState(groupId));
    }

    public void testConsumerGroupDynamicConfigs() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(List.of("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertEquals((int)5000, (int)((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        Properties newGroupConfig = new Properties();
        newGroupConfig.put("consumer.session.timeout.ms", (Object)50000);
        newGroupConfig.put("consumer.heartbeat.interval.ms", (Object)10000);
        context.updateGroupConfig(groupId, newGroupConfig);
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertEquals((int)10000, (int)((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs());
        context.assertSessionTimeout(groupId, memberId, 50000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(-1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRebalanceTimeout(groupId, memberId);
    }

    @Test
    public void testShareGroupDynamicConfigs() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("simple");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ShareGroupHeartbeatResponseData, CoordinatorRecord> result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setSubscribedTopicNames(List.of("foo")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ShareGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertEquals((int)5000, (int)((ShareGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ShareGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        Properties newGroupConfig = new Properties();
        newGroupConfig.put("share.session.timeout.ms", (Object)50000);
        newGroupConfig.put("share.heartbeat.interval.ms", (Object)10000);
        context.updateGroupConfig(groupId, newGroupConfig);
        result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ShareGroupHeartbeatResponseData)result.response()).memberEpoch()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ShareGroupHeartbeatResponseData)result.response()).memberEpoch());
        org.junit.jupiter.api.Assertions.assertEquals((int)10000, (int)((ShareGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs());
        context.assertSessionTimeout(groupId, memberId, 50000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ShareGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(-1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)((ShareGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRebalanceTimeout(groupId, memberId);
    }

    @Test
    public void testReplayConsumerGroupMemberMetadata() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setClientId("clientid").setClientHost("clienthost").setServerAssignorName("range").setRackId("rackid").setSubscribedTopicNames(List.of("foo")).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"foo", (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertEquals((Object)member, (Object)context.groupMetadataManager.consumerGroup("foo").getOrMaybeCreateMember("member", false));
    }

    @Test
    public void testReplayConsumerGroupMemberMetadataTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)"foo", (int)10));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"foo", (String)"m1"));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.groupMetadataManager.consumerGroup("foo").getOrMaybeCreateMember("m1", false));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"bar", (String)"m1"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("bar"));
    }

    @Test
    public void testReplayConsumerGroupMetadata() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)"foo", (int)10));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)context.groupMetadataManager.consumerGroup("foo").groupEpoch());
    }

    @Test
    public void testReplayConsumerGroupMetadataTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)"foo"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("foo"));
    }

    @Test
    public void testReplayConsumerGroupPartitionMetadata() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        Map<String, TopicMetadata> metadata = Map.of("bar", new TopicMetadata(Uuid.randomUuid(), "bar", 10));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)"foo", metadata));
        org.junit.jupiter.api.Assertions.assertEquals(metadata, (Object)context.groupMetadataManager.consumerGroup("foo").subscriptionMetadata());
    }

    @Test
    public void testReplayConsumerGroupPartitionMetadataTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)"foo"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("foo"));
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMember() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        Map<Uuid, Set<Integer>> assignment = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"foo", (String)"m1", assignment));
        org.junit.jupiter.api.Assertions.assertEquals(assignment, (Object)context.groupMetadataManager.consumerGroup("foo").targetAssignment("m1").partitions());
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMemberTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"foo", (String)"m1"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("foo"));
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMetadata() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"foo", (int)10));
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)context.groupMetadataManager.consumerGroup("foo").assignmentEpoch());
    }

    @Test
    public void testReplayConsumerGroupTargetAssignmentMetadataTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)"foo"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("foo"));
    }

    @Test
    public void testReplayConsumerGroupCurrentMemberAssignment() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(9).setState(MemberState.UNRELEASED_PARTITIONS).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 0, 1, 2))).build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)"bar", (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertEquals((Object)member, (Object)context.groupMetadataManager.consumerGroup("bar").getOrMaybeCreateMember("member", false));
    }

    @Test
    public void testReplayConsumerGroupCurrentMemberAssignmentTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)"foo", (int)10));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"foo", (String)"m1"));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.groupMetadataManager.consumerGroup("foo").getOrMaybeCreateMember("m1", false));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"bar", (String)"m1"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("bar"));
    }

    @Test
    public void testConsumerGroupHeartbeatOnShareGroup() {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).withShareGroup(new ShareGroupBuilder(groupId, 1).withMember(new ShareGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(new Map.Entry[0])).withAssignmentEpoch(1)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(memberId).setGroupId(groupId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testClassicGroupJoinOnShareGroup() throws Exception {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).withShareGroup(new ShareGroupBuilder(groupId, 1).withMember(new ShareGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(new Map.Entry[0])).withAssignmentEpoch(1)).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId(groupId).withMemberId("").withProtocolType("consumer").withProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0)).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testClassicGroupSyncOnShareGroup() throws Exception {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).withShareGroup(new ShareGroupBuilder(groupId, 1).withMember(new ShareGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(new Map.Entry[0])).withAssignmentEpoch(1)).build();
        SyncGroupRequestData request = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId(groupId).withGenerationId(1).withMemberId(memberId).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testClassicGroupLeaveOnShareGroup() throws Exception {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).withShareGroup(new ShareGroupBuilder(groupId, 1).withMember(new ShareGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(new Map.Entry[0])).withAssignmentEpoch(1)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId(groupId).setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId)))));
    }

    @Test
    public void testConsumerGroupDescribeOnShareGroup() {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("share");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withShareGroupAssignor(assignor).withMetadataImage(MetadataImage.EMPTY).withShareGroup(new ShareGroupBuilder(groupId, 1).withMember(new ShareGroupMember.Builder(memberId).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo")).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(new Map.Entry[0])).withAssignmentEpoch(1)).build();
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = List.of(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group " + groupId + " is not a consumer group."));
        List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = context.sendConsumerGroupDescribe(List.of(groupId));
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testShareGroupHeartbeatOnConsumerGroup() {
        String groupId = "group-foo";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicNames(List.of("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.shareGroupHeartbeat(new ShareGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setSubscribedTopicNames(List.of("foo", "bar"))));
    }

    @Test
    public void testShareGroupDescribeOnConsumerGroup() {
        String groupId = "group-foo";
        String memberId = Uuid.randomUuid().toString();
        int epoch = 10;
        String topicName = "topicName";
        ConsumerGroupMember.Builder memberBuilder = new ConsumerGroupMember.Builder(memberId).setSubscribedTopicNames(List.of(topicName)).setServerAssignorName("assignorName");
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withConsumerGroup(new ConsumerGroupBuilder(groupId, epoch).withMember(memberBuilder.build())).build();
        List<ShareGroupDescribeResponseData.DescribedGroup> expected = List.of(new ShareGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group " + groupId + " is not a share group."));
        List<ShareGroupDescribeResponseData.DescribedGroup> actual = context.sendShareGroupDescribe(List.of(groupId));
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testReplayConsumerGroupRegularExpression() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ResolvedRegularExpression resolvedRegularExpression = new ResolvedRegularExpression(Set.of("abc", "abcd"), 10L, 12345L);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)"foo", (String)"abc*", (ResolvedRegularExpression)resolvedRegularExpression));
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of(resolvedRegularExpression), (Object)context.groupMetadataManager.consumerGroup("foo").resolvedRegularExpression("abc*"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of("foo"), (Object)context.groupMetadataManager.groupsSubscribedToTopic("abc"));
    }

    @Test
    public void testReplayConsumerGroupRegularExpressionTombstone() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)"foo", (String)"abc*"));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.consumerGroup("foo"));
        ResolvedRegularExpression resolvedRegularExpression = new ResolvedRegularExpression(Set.of("abc", "abcd"), 10L, 12345L);
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)"foo", (String)"abc*", (ResolvedRegularExpression)resolvedRegularExpression));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of("foo"), (Object)context.groupMetadataManager.groupsSubscribedToTopic("abc"));
        context.replay(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)"foo", (String)"abc*"));
        org.junit.jupiter.api.Assertions.assertEquals(Optional.empty(), (Object)context.groupMetadataManager.consumerGroup("foo").resolvedRegularExpression("abc*"));
        org.junit.jupiter.api.Assertions.assertEquals(Set.of(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("abc"));
    }

    @Test
    public void testConsumerGroupMemberPicksUpExistingResolvedRegularExpression() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        ConsumerGroupPartitionAssignor assignor = (ConsumerGroupPartitionAssignor)Mockito.mock(ConsumerGroupPartitionAssignor.class);
        Mockito.when((Object)assignor.name()).thenReturn((Object)"range");
        Mockito.when((Object)assignor.assign((GroupSpec)ArgumentMatchers.any(), (SubscribedTopicDescriber)ArgumentMatchers.any())).thenAnswer(answer -> {
            GroupSpec spec = (GroupSpec)answer.getArgument(0);
            List.of(memberId1, memberId2).forEach(memberId -> org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton(fooTopicId), (Object)spec.memberSubscription(memberId).subscribedTopicIds(), (String)String.format("Member %s has unexpected subscribed topic ids", memberId)));
            return new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)))));
        });
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 2).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).build()).withResolvedRegularExpression("foo*", new ResolvedRegularExpression(Collections.singleton(fooTopicName), 100L, 12345L)).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(10000).setSubscribedTopicRegex("foo*").setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (Object)result.response());
    }

    @Test
    public void testConsumerGroupMemberJoinsWithNewRegex() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build(12345L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorExecutor.ExecutorResult(groupId + "-regex", new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("foo"), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))))), tasks);
    }

    @Test
    public void testConsumerGroupMemberJoinsWithUpdatedRegex() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(12345L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*|bar*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))))), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*|bar*").setServerAssignorName("range").build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*"));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tasks.size());
        MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord> task = tasks.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(groupId + "-regex"), (Object)task.key);
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo*|bar*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("foo", "bar"), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of("foo", new TopicMetadata(fooTopicId, fooTopicName, 6), "bar", new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11)), task.result.records());
    }

    @Test
    public void testConsumerGroupMemberJoinsWithRegexAndUpdatesItBeforeResolutionCompleted() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(12345L)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ApiMessage)result.response());
        ConsumerGroupMember expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").build();
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)groupId, (String)memberId1, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember1));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.executor.isScheduled(groupId + "-regex"));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setSubscribedTopicRegex("foo*|bar*"));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        expectedMember1 = new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(1).setPreviousMemberEpoch(0).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*|bar*").setServerAssignorName("range").build();
        expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember1), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*"));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.executor.isScheduled(groupId + "-regex"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)context.executor.size());
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tasks.size());
        MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord> task = tasks.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(groupId + "-regex"), (Object)task.key);
        Assertions.assertRecordsEquals(Collections.emptyList(), task.result.records());
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setSubscribedTopicRegex("foo*|bar*"));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000), (ApiMessage)result.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.executor.isScheduled(groupId + "-regex"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)context.executor.size());
        tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tasks.size());
        task = tasks.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(groupId + "-regex"), (Object)task.key);
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo*|bar*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("foo", "bar"), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of("foo", new TopicMetadata(fooTopicId, fooTopicName, 6), "bar", new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)2)), task.result.records());
    }

    @Test
    public void testConsumerGroupMemberJoinRefreshesExpiredRegexes() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        Uuid foooTopicId = Uuid.randomUuid();
        String foooTopicName = "fooo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(1L);
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(image).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("bar*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build()).withResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of(fooTopicName), 0L, 0L)).withResolvedRegularExpression("bar*", new ResolvedRegularExpression(Set.of(barTopicName), 0L, 0L)).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        MetadataImage newImage = new MetadataImageBuilder(image).addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(foooTopicId, foooTopicName, 1).build(2L);
        context.groupMetadataManager.onNewMetadataImage(newImage, new MetadataDelta(newImage, __ -> null, new MetadataEncryptorFactory()));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)context.executor.isScheduled(groupId + "-regex"));
        context.sleep(11000L);
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)context.executor.isScheduled(groupId + "-regex"));
        List<MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord>> tasks = context.processTasks();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tasks.size());
        MockCoordinatorExecutor.ExecutorResult<CoordinatorRecord> task = tasks.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)(groupId + "-regex"), (Object)task.key);
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of(fooTopicName, foooTopicName), 2L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"bar*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of(barTopicName), 2L, context.time.milliseconds()))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3), foooTopicName, new TopicMetadata(foooTopicId, foooTopicName, 1)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))), task.result.records());
    }

    @Test
    public void testConsumerGroupMemberJoinsWithRegexWithTopicAuthorizationFailure() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", List.of(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(12345L)).withAuthorizer(authorizer).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(List.of("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build()).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6))).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).withResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of(fooTopicName), 0L, 0L)).withAssignmentEpoch(10)).build();
        context.time.sleep(10001L);
        HashMap<String, AuthorizationResult> acls = new HashMap<String, AuthorizationResult>();
        acls.put(fooTopicName, AuthorizationResult.ALLOWED);
        acls.put(barTopicName, AuthorizationResult.DENIED);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenAnswer(invocation -> {
            List actions = (List)invocation.getArgument(1, List.class);
            return actions.stream().map(action -> acls.getOrDefault(action.resourcePattern().name(), AuthorizationResult.DENIED)).collect(Collectors.toList());
        });
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result1 = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*|bar*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()), ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))))), (ApiMessage)result1.response());
        ConsumerGroupMember expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*|bar*").setServerAssignorName("range").build();
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*")), result1.records());
        org.junit.jupiter.api.Assertions.assertEquals(List.of(new MockCoordinatorExecutor.ExecutorResult(groupId + "-regex", new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo*|bar*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("foo"), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))))), context.processTasks());
        context.time.sleep(10001L);
        acls.put(barTopicName, AuthorizationResult.ALLOWED);
        assignor.prepareGroupAssignment(new GroupAssignment(Map.of(memberId1, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))), memberId2, new MemberAssignmentImpl(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result2 = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo|bar*").setServerAssignor("range").setTopicPartitions(Collections.emptyList()), ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion());
        expectedMember2 = new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(11).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo|bar*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build();
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(List.of(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)))))), (ApiMessage)result2.response());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember2), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*|bar*"), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)groupId, (int)11), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember2)), result2.records());
        Assertions.assertRecordsEquals(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)groupId, (String)"foo|bar*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("foo", "bar"), 12345L, context.time.milliseconds())), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)12)), context.processTasks().get((int)0).result.records());
    }

    @Test
    public void testResolvedRegularExpressionsRemovedWhenMembersLeaveOrFenced() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(1L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("bar*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build()).withResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of(fooTopicName), 0L, 0L)).withResolvedRegularExpression("bar*", new ResolvedRegularExpression(Set.of(barTopicName), 0L, 0L)).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        context.onLoaded();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(-1));
        Assertions.assertResponseEquals((ApiMessage)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(-1), (ApiMessage)result.response());
        List<CoordinatorRecord> expectedRecords = List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*"), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        context.assertSessionTimeout(groupId, memberId2, 45000L);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, CoordinatorRecord>> timeouts = context.sleep(45001L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.groupSessionTimeoutKey((String)groupId, (String)memberId2), new CoordinatorResult(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"bar*"), GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap()), GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)12))))), timeouts);
    }

    @Test
    public void testResolvedRegularExpressionsRemovedWhenConsumerMembersRemovedByAdminApi() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        String memberId4 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withConfig("group.consumer.assignors", Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build(1L)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setInstanceId(memberId1).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setInstanceId(memberId2).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("foo*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build()).withMember(new ConsumerGroupMember.Builder(memberId3).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setInstanceId(memberId3).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("bar*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId4).setState(MemberState.STABLE).setMemberEpoch(10).setPreviousMemberEpoch(10).setInstanceId(memberId4).setClientId("client").setClientHost(GroupMetadataManagerTestContext.DEFAULT_CLIENT_ADDRESS.toString()).setRebalanceTimeoutMs(5000).setSubscribedTopicRegex("bar*").setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withResolvedRegularExpression("foo*", new ResolvedRegularExpression(Set.of(fooTopicName), 0L, 0L)).withResolvedRegularExpression("bar*", new ResolvedRegularExpression(Set.of(barTopicName), 0L, 0L)).withSubscriptionMetadata(Map.of(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6), barTopicName, new TopicMetadata(barTopicId, barTopicName, 3))).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> result = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId(groupId).setMembers(List.of(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId1).setGroupInstanceId(null), new LeaveGroupRequestData.MemberIdentity().setMemberId(memberId2).setGroupInstanceId(memberId2), new LeaveGroupRequestData.MemberIdentity().setMemberId("").setGroupInstanceId(memberId3))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new LeaveGroupResponseData().setMembers(List.of(new LeaveGroupResponseData.MemberResponse().setMemberId(memberId1).setGroupInstanceId(null), new LeaveGroupResponseData.MemberResponse().setMemberId(memberId2).setGroupInstanceId(memberId2), new LeaveGroupResponseData.MemberResponse().setMemberId("").setGroupInstanceId(memberId3))), (Object)result.response());
        Assertions.assertUnorderedRecordsEquals(List.of(List.of(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)groupId, (String)memberId3), GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId3)), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)groupId, (String)"foo*")), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)groupId, Map.of(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3)))), List.of(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)groupId, (int)11))), result.records());
    }

    private static void checkJoinGroupResponse(JoinGroupResponseData expectedResponse, JoinGroupResponseData actualResponse, ClassicGroup group, ClassicGroupState expectedState, Set<String> expectedGroupInstanceIds) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)actualResponse);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(expectedState));
        Set groupInstanceIds = actualResponse.members().stream().map(JoinGroupResponseData.JoinGroupResponseMember::groupInstanceId).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertEquals(expectedGroupInstanceIds, groupInstanceIds);
    }

    private static List<JoinGroupResponseData.JoinGroupResponseMember> toJoinResponseMembers(ClassicGroup group) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> members = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        String protocolName = (String)group.protocolName().get();
        group.allMembers().forEach(member -> members.add(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId().orElse("")).setMetadata(member.metadata(protocolName))));
        return members;
    }

    private static List<String> verifyClassicGroupJoinResponses(List<GroupMetadataManagerTestContext.JoinResult> joinResults, int expectedSuccessCount, Errors expectedFailure) {
        int successCount = 0;
        ArrayList<String> memberIds = new ArrayList<String>();
        for (GroupMetadataManagerTestContext.JoinResult joinResult : joinResults) {
            if (!joinResult.joinFuture.isDone()) {
                org.junit.jupiter.api.Assertions.fail((String)"All responseFutures should be completed.");
            }
            try {
                JoinGroupResponseData joinResponse = joinResult.joinFuture.get();
                if (joinResponse.errorCode() == Errors.NONE.code()) {
                    ++successCount;
                } else {
                    org.junit.jupiter.api.Assertions.assertEquals((short)expectedFailure.code(), (short)joinResponse.errorCode());
                }
                memberIds.add(joinResponse.memberId());
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedSuccessCount, (int)successCount);
        return memberIds;
    }
}

