/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordType;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorRecordSerdeTest {
    @Test
    public void testSerializeKey() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = CoordinatorRecord.record((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.key().apiKey(), (Message)record.key()), (byte[])serializer.serializeKey(record));
    }

    @Test
    public void testSerializeValue() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = CoordinatorRecord.record((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.value().version(), (Message)record.value().message()), (byte[])serializer.serializeValue(record));
    }

    @Test
    public void testSerializeNullValue() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = CoordinatorRecord.tombstone((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"));
        Assertions.assertNull((Object)serializer.serializeValue(record));
    }

    @Test
    public void testDeserialize() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ConsumerGroupMetadataKey key = new ConsumerGroupMetadataKey().setGroupId("foo");
        ByteBuffer keyBuffer = MessageUtil.toCoordinatorTypePrefixedByteBuffer((ApiMessage)key);
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0);
        ByteBuffer valueBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)value.version(), (Message)value.message());
        CoordinatorRecord record = serde.deserialize(keyBuffer, valueBuffer);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
    }

    @Test
    public void testDeserializeWithTombstoneForValue() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ConsumerGroupMetadataKey key = new ConsumerGroupMetadataKey().setGroupId("foo");
        ByteBuffer keyBuffer = MessageUtil.toCoordinatorTypePrefixedByteBuffer((ApiMessage)key);
        CoordinatorRecord record = serde.deserialize(keyBuffer, null);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertNull((Object)record.value());
    }

    @Test
    public void testDeserializeWithInvalidRecordType() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(64);
        keyBuffer.putShort((short)255);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        Deserializer.UnknownRecordTypeException ex = (Deserializer.UnknownRecordTypeException)Assertions.assertThrows(Deserializer.UnknownRecordTypeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((short)255, (short)ex.unknownType());
    }

    @Test
    public void testDeserializeWithKeyEmptyBuffer() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(0);
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from key's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithValueEmptyBuffer() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(0);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from value's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidKeyBytes() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(2);
        keyBuffer.putShort((short)3);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 3 from key's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidValueBytes() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 0 from value's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidValueVersion() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ConsumerGroupMetadataKey key = new ConsumerGroupMetadataKey().setGroupId("foo");
        ByteBuffer keyBuffer = MessageUtil.toCoordinatorTypePrefixedByteBuffer((ApiMessage)key);
        ByteBuffer valueBuffer1 = ByteBuffer.allocate(2);
        valueBuffer1.putShort((short)1);
        valueBuffer1.rewind();
        Deserializer.UnknownRecordVersionException ex = (Deserializer.UnknownRecordVersionException)Assertions.assertThrows(Deserializer.UnknownRecordVersionException.class, () -> serde.deserialize(keyBuffer, valueBuffer1));
        Assertions.assertEquals((short)key.apiKey(), (short)ex.type());
        Assertions.assertEquals((int)1, (int)ex.unknownVersion());
        keyBuffer.rewind();
        ByteBuffer valueBuffer2 = ByteBuffer.allocate(2);
        valueBuffer2.putShort((short)-1);
        valueBuffer2.rewind();
        ex = (Deserializer.UnknownRecordVersionException)Assertions.assertThrows(Deserializer.UnknownRecordVersionException.class, () -> serde.deserialize(keyBuffer, valueBuffer2));
        Assertions.assertEquals((short)key.apiKey(), (short)ex.type());
        Assertions.assertEquals((int)-1, (int)ex.unknownVersion());
    }

    @Test
    public void testDeserializeAllRecordTypes() {
        for (CoordinatorRecordType record : CoordinatorRecordType.values()) {
            this.roundTrip(record.newRecordKey(), record.newRecordValue());
        }
    }

    private void roundTrip(ApiMessage key, ApiMessage val) {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        for (short version = val.lowestSupportedVersion(); version < val.highestSupportedVersion(); version = (short)(version + 1)) {
            ApiMessageAndVersion valMessageAndVersion = new ApiMessageAndVersion(val, version);
            CoordinatorRecord record = serde.deserialize(MessageUtil.toCoordinatorTypePrefixedByteBuffer((ApiMessage)key), MessageUtil.toVersionPrefixedByteBuffer((short)version, (Message)val));
            Assertions.assertEquals((Object)key, (Object)record.key());
            Assertions.assertEquals((Object)valMessageAndVersion, (Object)record.value());
        }
    }
}

