/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GroupConfigManagerTest {
    private GroupConfigManager configManager;

    @BeforeEach
    public void setUp() {
        this.configManager = GroupConfigManagerTest.createConfigManager();
    }

    @AfterEach
    public void tearDown() {
        if (this.configManager != null) {
            this.configManager.close();
        }
    }

    @Test
    public void testUpdateConfigWithInvalidGroupId() {
        Assertions.assertThrows(InvalidRequestException.class, () -> this.configManager.updateGroupConfig("", new Properties()));
    }

    @Test
    public void testGetNonExistentGroupConfig() {
        Optional groupConfig = this.configManager.groupConfig("foo");
        Assertions.assertFalse((boolean)groupConfig.isPresent());
    }

    @Test
    public void testUpdateGroupConfig() {
        String groupId = "foo";
        Properties props = new Properties();
        props.put("consumer.session.timeout.ms", (Object)50000);
        props.put("consumer.heartbeat.interval.ms", (Object)6000);
        this.configManager.updateGroupConfig(groupId, props);
        Optional configOptional = this.configManager.groupConfig(groupId);
        Assertions.assertTrue((boolean)configOptional.isPresent());
        GroupConfig config = (GroupConfig)configOptional.get();
        Assertions.assertEquals((int)50000, (Integer)config.getInt("consumer.session.timeout.ms"));
        Assertions.assertEquals((int)6000, (Integer)config.getInt("consumer.heartbeat.interval.ms"));
    }

    public static GroupConfigManager createConfigManager() {
        HashMap<String, String> defaultConfig = new HashMap<String, String>();
        defaultConfig.put("consumer.session.timeout.ms", String.valueOf(45000));
        defaultConfig.put("consumer.heartbeat.interval.ms", String.valueOf(5000));
        defaultConfig.put("share.record.lock.duration.ms", String.valueOf(30000));
        return new GroupConfigManager(defaultConfig);
    }
}

