/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.modern.MemberSubscriptionAndAssignmentImpl;
import org.junit.jupiter.api.Assertions;

public class AssignmentTestUtil {
    public static Map.Entry<Uuid, Set<Integer>> mkTopicAssignment(Uuid topicId, Integer ... partitions) {
        return new AbstractMap.SimpleEntry<Uuid, Set<Integer>>(topicId, new HashSet<Integer>(Arrays.asList(partitions)));
    }

    public static Map.Entry<Uuid, Set<Integer>> mkOrderedTopicAssignment(Uuid topicId, Integer ... partitions) {
        return new AbstractMap.SimpleEntry<Uuid, Set<Integer>>(topicId, new LinkedHashSet<Integer>(Arrays.asList(partitions)));
    }

    @SafeVarargs
    public static Map<Uuid, Set<Integer>> mkAssignment(Map.Entry<Uuid, Set<Integer>> ... entries) {
        HashMap<Uuid, Set<Integer>> assignment = new HashMap<Uuid, Set<Integer>>();
        for (Map.Entry<Uuid, Set<Integer>> entry : entries) {
            assignment.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(assignment);
    }

    @SafeVarargs
    public static Map<Uuid, Set<Integer>> mkOrderedAssignment(Map.Entry<Uuid, Set<Integer>> ... entries) {
        LinkedHashMap<Uuid, Set<Integer>> assignment = new LinkedHashMap<Uuid, Set<Integer>>();
        for (Map.Entry<Uuid, Set<Integer>> entry : entries) {
            assignment.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(assignment);
    }

    public static void assertAssignment(Map<String, Map<Uuid, Set<Integer>>> expectedAssignment, GroupAssignment computedGroupAssignment) {
        Assertions.assertEquals((int)expectedAssignment.size(), (int)computedGroupAssignment.members().size());
        computedGroupAssignment.members().forEach((memberId, memberAssignment) -> {
            Map computedAssignmentForMember = memberAssignment.partitions();
            Assertions.assertEquals(expectedAssignment.get(memberId), (Object)computedAssignmentForMember);
        });
    }

    public static Map<Uuid, Map<Integer, String>> invertedTargetAssignment(Map<String, MemberSubscriptionAndAssignmentImpl> members) {
        HashMap<Uuid, Map<Integer, String>> invertedTargetAssignment = new HashMap<Uuid, Map<Integer, String>>();
        for (Map.Entry<String, MemberSubscriptionAndAssignmentImpl> memberEntry : members.entrySet()) {
            String memberId = memberEntry.getKey();
            Map memberAssignment = memberEntry.getValue().partitions();
            for (Map.Entry topicEntry : memberAssignment.entrySet()) {
                Uuid topicId = (Uuid)topicEntry.getKey();
                Set partitions = (Set)topicEntry.getValue();
                Map partitionMap = invertedTargetAssignment.computeIfAbsent(topicId, k -> new HashMap());
                for (Integer partitionId : partitions) {
                    partitionMap.put(partitionId, memberId);
                }
            }
        }
        return invertedTargetAssignment;
    }
}

