/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.modern.TopicIds;
import org.apache.kafka.image.TopicsImage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicIdsTest {
    @Test
    public void testTopicNamesCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new TopicIds(null, TopicsImage.EMPTY));
    }

    @Test
    public void testTopicsImageCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new TopicIds(Collections.emptySet(), (TopicsImage)null));
    }

    @Test
    public void testTopicResolverCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new TopicIds(Collections.emptySet(), (TopicIds.TopicResolver)null));
    }

    @Test
    public void testSize() {
        Set<String> topicNames = Set.of("foo", "bar", "baz");
        TopicIds topicIds = new TopicIds(topicNames, TopicsImage.EMPTY);
        Assertions.assertEquals((int)topicNames.size(), (int)topicIds.size());
    }

    @Test
    public void testIsEmpty() {
        Set topicNames = Collections.emptySet();
        TopicIds topicIds = new TopicIds(topicNames, TopicsImage.EMPTY);
        Assertions.assertEquals((int)topicNames.size(), (int)topicIds.size());
    }

    @Test
    public void testContains() {
        Uuid fooUuid = Uuid.randomUuid();
        Uuid barUuid = Uuid.randomUuid();
        Uuid bazUuid = Uuid.randomUuid();
        Uuid quxUuid = Uuid.randomUuid();
        TopicsImage topicsImage = new MetadataImageBuilder().addTopic(fooUuid, "foo", 3).addTopic(barUuid, "bar", 3).addTopic(bazUuid, "qux", 3).build().topics();
        TopicIds topicIds = new TopicIds(Set.of("foo", "bar", "baz"), topicsImage);
        Assertions.assertTrue((boolean)topicIds.contains(fooUuid));
        Assertions.assertTrue((boolean)topicIds.contains(barUuid));
        Assertions.assertFalse((boolean)topicIds.contains(bazUuid));
        Assertions.assertFalse((boolean)topicIds.contains(quxUuid));
    }

    @Test
    public void testContainsAll() {
        Uuid fooUuid = Uuid.randomUuid();
        Uuid barUuid = Uuid.randomUuid();
        Uuid bazUuid = Uuid.randomUuid();
        Uuid quxUuid = Uuid.randomUuid();
        TopicsImage topicsImage = new MetadataImageBuilder().addTopic(fooUuid, "foo", 3).addTopic(barUuid, "bar", 3).addTopic(bazUuid, "baz", 3).addTopic(quxUuid, "qux", 3).build().topics();
        TopicIds topicIds = new TopicIds(Set.of("foo", "bar", "baz", "qux"), topicsImage);
        Assertions.assertTrue((boolean)topicIds.contains(fooUuid));
        Assertions.assertTrue((boolean)topicIds.contains(barUuid));
        Assertions.assertTrue((boolean)topicIds.contains(bazUuid));
        Assertions.assertTrue((boolean)topicIds.contains(quxUuid));
        Assertions.assertTrue((boolean)topicIds.containsAll(Set.of(fooUuid, barUuid, bazUuid, quxUuid)));
    }

    @Test
    public void testContainsAllOneTopicConversionFails() {
        Uuid fooUuid = Uuid.randomUuid();
        Uuid barUuid = Uuid.randomUuid();
        Uuid bazUuid = Uuid.randomUuid();
        Uuid quxUuid = Uuid.randomUuid();
        TopicsImage topicsImage = new MetadataImageBuilder().addTopic(fooUuid, "foo", 3).addTopic(barUuid, "bar", 3).addTopic(bazUuid, "baz", 3).build().topics();
        TopicIds topicIds = new TopicIds(Set.of("foo", "bar", "baz", "qux"), topicsImage);
        Assertions.assertTrue((boolean)topicIds.contains(fooUuid));
        Assertions.assertTrue((boolean)topicIds.contains(barUuid));
        Assertions.assertTrue((boolean)topicIds.contains(bazUuid));
        Assertions.assertTrue((boolean)topicIds.containsAll(Set.of(fooUuid, barUuid, bazUuid)));
        Assertions.assertFalse((boolean)topicIds.containsAll(Set.of(fooUuid, barUuid, bazUuid, quxUuid)));
    }

    @Test
    public void testIterator() {
        Uuid fooUuid = Uuid.randomUuid();
        Uuid barUuid = Uuid.randomUuid();
        Uuid bazUuid = Uuid.randomUuid();
        Uuid quxUuid = Uuid.randomUuid();
        TopicsImage topicsImage = new MetadataImageBuilder().addTopic(fooUuid, "foo", 3).addTopic(barUuid, "bar", 3).addTopic(bazUuid, "baz", 3).addTopic(quxUuid, "qux", 3).build().topics();
        TopicIds topicIds = new TopicIds(Set.of("foo", "bar", "baz", "qux"), topicsImage);
        Set<Uuid> expectedIds = Set.of(fooUuid, barUuid, bazUuid, quxUuid);
        HashSet actualIds = new HashSet(topicIds);
        Assertions.assertEquals(expectedIds, actualIds);
    }

    @Test
    public void testIteratorOneTopicConversionFails() {
        Uuid fooUuid = Uuid.randomUuid();
        Uuid barUuid = Uuid.randomUuid();
        Uuid bazUuid = Uuid.randomUuid();
        Uuid qux = Uuid.randomUuid();
        TopicsImage topicsImage = new MetadataImageBuilder().addTopic(fooUuid, "foo", 3).addTopic(barUuid, "bar", 3).addTopic(bazUuid, "baz", 3).addTopic(qux, "qux", 3).build().topics();
        TopicIds topicIds = new TopicIds(Set.of("foo", "bar", "baz", "quux"), topicsImage);
        Set<Uuid> expectedIds = Set.of(fooUuid, barUuid, bazUuid);
        HashSet actualIds = new HashSet(topicIds);
        Assertions.assertEquals(expectedIds, actualIds);
    }

    @Test
    public void testEquals() {
        Uuid topicId = Uuid.randomUuid();
        TopicIds topicIds1 = new TopicIds(Collections.singleton("topic"), new MetadataImageBuilder().addTopic(topicId, "topicId", 3).build().topics());
        TopicIds topicIds2 = new TopicIds(Collections.singleton("topic"), new MetadataImageBuilder().addTopic(topicId, "topicId", 3).build().topics());
        Assertions.assertEquals((Object)topicIds1, (Object)topicIds2);
    }
}

