/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.modern.SubscribedTopicDescriberImpl;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubscribedTopicMetadataTest {
    private Map<Uuid, TopicMetadata> topicMetadataMap;
    private SubscribedTopicDescriberImpl subscribedTopicMetadata;

    @BeforeEach
    public void setUp() {
        this.topicMetadataMap = new HashMap<Uuid, TopicMetadata>();
        for (int i = 0; i < 5; ++i) {
            Uuid topicId = Uuid.randomUuid();
            String topicName = "topic" + i;
            this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, topicName, 5));
        }
        this.subscribedTopicMetadata = new SubscribedTopicDescriberImpl(this.topicMetadataMap);
    }

    @Test
    public void testAttribute() {
        Assertions.assertEquals(this.topicMetadataMap, (Object)this.subscribedTopicMetadata.topicMetadata());
    }

    @Test
    public void testTopicMetadataCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new SubscribedTopicDescriberImpl(null));
    }

    @Test
    public void testNumberOfPartitions() {
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertEquals((int)-1, (int)this.subscribedTopicMetadata.numPartitions(topicId));
        this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, "topic6", 3));
        Assertions.assertEquals((int)3, (int)this.subscribedTopicMetadata.numPartitions(topicId));
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)new SubscribedTopicDescriberImpl(this.topicMetadataMap), (Object)this.subscribedTopicMetadata);
        HashMap<Uuid, TopicMetadata> topicMetadataMap2 = new HashMap<Uuid, TopicMetadata>();
        Uuid topicId = Uuid.randomUuid();
        topicMetadataMap2.put(topicId, new TopicMetadata(topicId, "newTopic", 5));
        Assertions.assertNotEquals((Object)new SubscribedTopicDescriberImpl(topicMetadataMap2), (Object)this.subscribedTopicMetadata);
    }
}

