/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.metrics.MetricsTestUtils;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        HashSet<MetricName> expectedMetrics = new HashSet<MetricName>(Arrays.asList(metrics.metricName("offset-commit-rate", "group-coordinator-metrics"), metrics.metricName("offset-commit-count", "group-coordinator-metrics"), metrics.metricName("offset-expiration-rate", "group-coordinator-metrics"), metrics.metricName("offset-expiration-count", "group-coordinator-metrics"), metrics.metricName("offset-deletion-rate", "group-coordinator-metrics"), metrics.metricName("offset-deletion-count", "group-coordinator-metrics"), metrics.metricName("group-completed-rebalance-rate", "group-coordinator-metrics"), metrics.metricName("group-completed-rebalance-count", "group-coordinator-metrics"), metrics.metricName("consumer-group-rebalance-rate", "group-coordinator-metrics"), metrics.metricName("consumer-group-rebalance-count", "group-coordinator-metrics"), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.EMPTY.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.ASSIGNING.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.RECONCILING.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.STABLE.toString())), metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.DEAD.toString())), metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("rebalance-rate", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("rebalance-count", "group-coordinator-metrics", Collections.singletonMap("protocol", Group.GroupType.SHARE.toString())), metrics.metricName("group-count", "group-coordinator-metrics", "The number of share groups in empty state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", GroupState.EMPTY.toString()}), metrics.metricName("group-count", "group-coordinator-metrics", "The number of share groups in stable state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", GroupState.STABLE.toString()}), metrics.metricName("group-count", "group-coordinator-metrics", "The number of share groups in dead state.", new String[]{"protocol", Group.GroupType.SHARE.toString(), "state", GroupState.DEAD.toString()})));
        try {
            try (GroupCoordinatorMetrics ignored = new GroupCoordinatorMetrics(registry, metrics);){
                HashSet<String> expectedRegistry = new HashSet<String>(Arrays.asList("kafka.coordinator.group:type=GroupMetadataManager,name=NumOffsets", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroups", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsPreparingRebalance", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsCompletingRebalance", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsStable", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsDead", "kafka.coordinator.group:type=GroupMetadataManager,name=NumGroupsEmpty"));
                MetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", expectedRegistry);
                expectedMetrics.forEach(metricName -> Assertions.assertTrue((boolean)metrics.metrics().containsKey(metricName)));
            }
            MetricsTestUtils.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", Collections.emptySet());
            expectedMetrics.forEach(metricName -> Assertions.assertFalse((boolean)metrics.metrics().containsKey(metricName)));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void aggregateShards() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        SnapshotRegistry snapshotRegistry0 = new SnapshotRegistry(new LogContext());
        SnapshotRegistry snapshotRegistry1 = new SnapshotRegistry(new LogContext());
        TopicPartition tp0 = new TopicPartition("__consumer_offsets", 0);
        TopicPartition tp1 = new TopicPartition("__consumer_offsets", 1);
        GroupCoordinatorMetricsShard shard0 = coordinatorMetrics.newMetricsShard(snapshotRegistry0, tp0);
        GroupCoordinatorMetricsShard shard1 = coordinatorMetrics.newMetricsShard(snapshotRegistry1, tp1);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard0);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard1);
        shard0.setClassicGroupGauges(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.PREPARING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.COMPLETING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.STABLE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.EMPTY, (Object)1L)}));
        shard1.setClassicGroupGauges(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ClassicGroupState.PREPARING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.COMPLETING_REBALANCE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.STABLE, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.EMPTY, (Object)1L), Utils.mkEntry((Object)ClassicGroupState.DEAD, (Object)1L)}));
        shard0.setConsumerGroupGauges(Collections.singletonMap(ConsumerGroup.ConsumerGroupState.ASSIGNING, 5L));
        shard1.setConsumerGroupGauges(Map.of(ConsumerGroup.ConsumerGroupState.RECONCILING, 1L, ConsumerGroup.ConsumerGroupState.DEAD, 1L));
        IntStream.range(0, 6).forEach(__ -> shard0.incrementNumOffsets());
        IntStream.range(0, 2).forEach(__ -> shard1.incrementNumOffsets());
        IntStream.range(0, 1).forEach(__ -> shard1.decrementNumOffsets());
        IntStream.range(0, 5).forEach(__ -> shard0.incrementNumShareGroups(ShareGroup.ShareGroupState.STABLE));
        IntStream.range(0, 5).forEach(__ -> shard1.incrementNumShareGroups(ShareGroup.ShareGroupState.EMPTY));
        IntStream.range(0, 3).forEach(__ -> shard1.decrementNumShareGroups(ShareGroup.ShareGroupState.DEAD));
        Assertions.assertEquals((long)4L, (long)shard0.numClassicGroups());
        Assertions.assertEquals((long)5L, (long)shard1.numClassicGroups());
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroups"), 9L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 9L);
        snapshotRegistry0.idempotentCreateSnapshot(1000L);
        snapshotRegistry1.idempotentCreateSnapshot(1500L);
        shard0.commitUpTo(1000L);
        shard1.commitUpTo(1500L);
        Assertions.assertEquals((long)5L, (long)shard0.numConsumerGroups());
        Assertions.assertEquals((long)2L, (long)shard1.numConsumerGroups());
        Assertions.assertEquals((long)6L, (long)shard0.numOffsets());
        Assertions.assertEquals((long)1L, (long)shard1.numOffsets());
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 7L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumOffsets"), 7L);
        Assertions.assertEquals((long)5L, (long)shard0.numShareGroups());
        Assertions.assertEquals((long)2L, (long)shard1.numShareGroups());
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "share")), 7L);
    }

    @Test
    public void testGlobalSensors() {
        MetricsRegistry registry = new MetricsRegistry();
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), new TopicPartition("__consumer_offsets", 0));
        shard.record("CompletedRebalances", 10.0);
        this.assertMetricValue(metrics, metrics.metricName("group-completed-rebalance-rate", "group-coordinator-metrics"), 0.3333333333333333);
        this.assertMetricValue(metrics, metrics.metricName("group-completed-rebalance-count", "group-coordinator-metrics"), 10.0);
        shard.record("OffsetCommits", 20.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-commit-rate", "group-coordinator-metrics"), 0.6666666666666666);
        this.assertMetricValue(metrics, metrics.metricName("offset-commit-count", "group-coordinator-metrics"), 20.0);
        shard.record("OffsetExpired", 30.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-expiration-rate", "group-coordinator-metrics"), 1.0);
        this.assertMetricValue(metrics, metrics.metricName("offset-expiration-count", "group-coordinator-metrics"), 30.0);
        shard.record("ConsumerGroupRebalances", 50.0);
        this.assertMetricValue(metrics, metrics.metricName("consumer-group-rebalance-rate", "group-coordinator-metrics"), 1.6666666666666667);
        this.assertMetricValue(metrics, metrics.metricName("consumer-group-rebalance-count", "group-coordinator-metrics"), 50.0);
        shard.record("ShareGroupRebalances", 50.0);
        this.assertMetricValue(metrics, metrics.metricName("rebalance-rate", "group-coordinator-metrics", "The rate of share group rebalances", new String[]{"protocol", "share"}), 1.6666666666666667);
        this.assertMetricValue(metrics, metrics.metricName("rebalance-count", "group-coordinator-metrics", "The total number of share group rebalances", new String[]{"protocol", "share"}), 50.0);
    }

    private void assertMetricValue(Metrics metrics, MetricName metricName, double val) {
        Assertions.assertEquals((Object)val, (Object)metrics.metric(metricName).metricValue());
    }
}

