/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorMetricsShardTest {
    @Test
    public void testTimelineGaugeCounters() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(snapshotRegistry, tp);
        shard.incrementNumOffsets();
        snapshotRegistry.idempotentCreateSnapshot(1000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
        shard.commitUpTo(1000L);
        Assertions.assertEquals((long)1L, (long)shard.numOffsets());
        shard.decrementNumOffsets();
        snapshotRegistry.idempotentCreateSnapshot(2000L);
        shard.commitUpTo(2000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
    }
}

