/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Arrays;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;

public class MetadataImageBuilder {
    private final MetadataDelta delta;

    public MetadataImageBuilder() {
        this(MetadataImage.EMPTY);
    }

    public MetadataImageBuilder(MetadataImage image) {
        this.delta = new MetadataDelta(image);
    }

    public MetadataImageBuilder addTopic(Uuid topicId, String topicName, int numPartitions) {
        this.delta.replay(new TopicRecord().setTopicId(topicId).setName(topicName));
        for (int i = 0; i < numPartitions; ++i) {
            this.delta.replay(new PartitionRecord().setTopicId(topicId).setPartitionId(i).setReplicas(Arrays.asList(i % 4, (i + 1) % 4)));
        }
        return this;
    }

    public MetadataImageBuilder addRacks() {
        for (int i = 0; i < 4; ++i) {
            this.delta.replay(new RegisterBrokerRecord().setBrokerId(i).setRack("rack" + i));
        }
        return this;
    }

    public MetadataImage build() {
        return this.build(0L);
    }

    public MetadataImage build(long version) {
        return this.delta.apply(new MetadataProvenance(version, 0, 0L, true));
    }
}

