/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorRecordSerdeTest {
    @Test
    public void testSerializeKey() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.key().version(), (Message)record.key().message()), (byte[])serializer.serializeKey(record));
    }

    @Test
    public void testSerializeValue() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.value().version(), (Message)record.value().message()), (byte[])serializer.serializeValue(record));
    }

    @Test
    public void testSerializeNullValue() {
        GroupCoordinatorRecordSerde serializer = new GroupCoordinatorRecordSerde();
        CoordinatorRecord record = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 1), null);
        Assertions.assertNull((Object)serializer.serializeValue(record));
    }

    @Test
    public void testDeserialize() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0);
        ByteBuffer valueBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)value.version(), (Message)value.message());
        CoordinatorRecord record = serde.deserialize(keyBuffer, valueBuffer);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
    }

    @Test
    public void testDeserializeWithTombstoneForValue() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        CoordinatorRecord record = serde.deserialize(keyBuffer, null);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertNull((Object)record.value());
    }

    @Test
    public void testDeserializeWithInvalidRecordType() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(64);
        keyBuffer.putShort((short)255);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        Deserializer.UnknownRecordTypeException ex = (Deserializer.UnknownRecordTypeException)Assertions.assertThrows(Deserializer.UnknownRecordTypeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((short)255, (short)ex.unknownType());
    }

    @Test
    public void testDeserializeWithKeyEmptyBuffer() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(0);
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from key's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithValueEmptyBuffer() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(0);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from value's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidKeyBytes() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(2);
        keyBuffer.putShort((short)3);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 3 from key's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidValueBytes() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 0 from value's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidValueVersion() {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer1 = ByteBuffer.allocate(2);
        valueBuffer1.putShort((short)1);
        valueBuffer1.rewind();
        Deserializer.UnknownRecordVersionException ex = (Deserializer.UnknownRecordVersionException)Assertions.assertThrows(Deserializer.UnknownRecordVersionException.class, () -> serde.deserialize(keyBuffer, valueBuffer1));
        Assertions.assertEquals((short)key.version(), (short)ex.type());
        Assertions.assertEquals((int)1, (int)ex.unknownVersion());
        keyBuffer.rewind();
        ByteBuffer valueBuffer2 = ByteBuffer.allocate(2);
        valueBuffer2.putShort((short)-1);
        valueBuffer2.rewind();
        ex = (Deserializer.UnknownRecordVersionException)Assertions.assertThrows(Deserializer.UnknownRecordVersionException.class, () -> serde.deserialize(keyBuffer, valueBuffer2));
        Assertions.assertEquals((short)key.version(), (short)ex.type());
        Assertions.assertEquals((int)-1, (int)ex.unknownVersion());
    }

    @Test
    public void testDeserializeAllRecordTypes() {
        this.roundTrip((short)0, (ApiMessage)new OffsetCommitKey(), (ApiMessage)new OffsetCommitValue());
        this.roundTrip((short)1, (ApiMessage)new OffsetCommitKey(), (ApiMessage)new OffsetCommitValue());
        this.roundTrip((short)2, (ApiMessage)new GroupMetadataKey(), (ApiMessage)new GroupMetadataValue());
        this.roundTrip((short)3, (ApiMessage)new ConsumerGroupMetadataKey(), (ApiMessage)new ConsumerGroupMetadataValue());
        this.roundTrip((short)4, (ApiMessage)new ConsumerGroupPartitionMetadataKey(), (ApiMessage)new ConsumerGroupPartitionMetadataValue());
        this.roundTrip((short)5, (ApiMessage)new ConsumerGroupMemberMetadataKey(), (ApiMessage)new ConsumerGroupMemberMetadataValue());
        this.roundTrip((short)6, (ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey(), (ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue());
        this.roundTrip((short)7, (ApiMessage)new ConsumerGroupTargetAssignmentMemberKey(), (ApiMessage)new ConsumerGroupTargetAssignmentMemberValue());
        this.roundTrip((short)8, (ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey(), (ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue());
        this.roundTrip((short)9, (ApiMessage)new ShareGroupPartitionMetadataKey(), (ApiMessage)new ShareGroupPartitionMetadataValue());
        this.roundTrip((short)10, (ApiMessage)new ShareGroupMemberMetadataKey(), (ApiMessage)new ShareGroupMemberMetadataValue());
        this.roundTrip((short)11, (ApiMessage)new ShareGroupMetadataKey(), (ApiMessage)new ShareGroupMetadataValue());
        this.roundTrip((short)12, (ApiMessage)new ShareGroupTargetAssignmentMetadataKey(), (ApiMessage)new ShareGroupTargetAssignmentMetadataValue());
        this.roundTrip((short)13, (ApiMessage)new ShareGroupTargetAssignmentMemberKey(), (ApiMessage)new ShareGroupTargetAssignmentMemberValue());
        this.roundTrip((short)14, (ApiMessage)new ShareGroupCurrentMemberAssignmentKey(), (ApiMessage)new ShareGroupCurrentMemberAssignmentValue());
        this.roundTrip((short)15, (ApiMessage)new ShareGroupStatePartitionMetadataKey(), (ApiMessage)new ShareGroupStatePartitionMetadataValue());
        this.roundTrip((short)16, (ApiMessage)new ConsumerGroupRegularExpressionKey(), (ApiMessage)new ConsumerGroupRegularExpressionValue());
    }

    private void roundTrip(short recordType, ApiMessage key, ApiMessage val) {
        GroupCoordinatorRecordSerde serde = new GroupCoordinatorRecordSerde();
        for (short version = val.lowestSupportedVersion(); version < val.highestSupportedVersion(); version = (short)(version + 1)) {
            ApiMessageAndVersion keyMessageAndVersion = new ApiMessageAndVersion(key, recordType);
            ApiMessageAndVersion valMessageAndVersion = new ApiMessageAndVersion(val, version);
            CoordinatorRecord record = serde.deserialize(MessageUtil.toVersionPrefixedByteBuffer((short)recordType, (Message)key), MessageUtil.toVersionPrefixedByteBuffer((short)version, (Message)val));
            Assertions.assertEquals((Object)keyMessageAndVersion, (Object)record.key());
            Assertions.assertEquals((Object)valMessageAndVersion, (Object)record.value());
        }
    }
}

