/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorRecordHelpersTest {
    @Test
    public void testNewConsumerGroupMemberSubscriptionRecord() {
        ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol> protocols = new ArrayList<ConsumerGroupMemberMetadataValue.ClassicProtocol>();
        protocols.add(new ConsumerGroupMemberMetadataValue.ClassicProtocol().setName("range").setMetadata(new byte[0]));
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(Arrays.asList("foo", "zar", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)).build();
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId("group-id").setMemberId("member-id"), 5), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue().setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(Arrays.asList("bar", "foo", "zar")).setSubscribedTopicRegex("regex").setServerAssignor("range").setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSupportedProtocols(protocols)), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord((String)"group-id", (ConsumerGroupMember)member));
    }

    @Test
    public void testNewConsumerGroupMemberSubscriptionTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId("group-id").setMemberId("member-id"), 5), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    @Test
    public void testNewConsumerGroupSubscriptionMetadataRecord() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        LinkedHashMap<String, TopicMetadata> subscriptionMetadata = new LinkedHashMap<String, TopicMetadata>();
        subscriptionMetadata.put("foo", new TopicMetadata(fooTopicId, "foo", 10));
        subscriptionMetadata.put("bar", new TopicMetadata(barTopicId, "bar", 20));
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataValue().setTopics(Arrays.asList(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(fooTopicId).setTopicName("foo").setNumPartitions(10), new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(barTopicId).setTopicName("bar").setNumPartitions(20))), 0));
        Assertions.assertRecordEquals(expectedRecord, GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)"group-id", subscriptionMetadata));
    }

    @Test
    public void testNewConsumerGroupSubscriptionMetadataTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testEmptyPartitionMetadataWhenRacksUnavailableGroupSubscriptionMetadataRecord() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        LinkedHashMap<String, TopicMetadata> subscriptionMetadata = new LinkedHashMap<String, TopicMetadata>();
        subscriptionMetadata.put("foo", new TopicMetadata(fooTopicId, "foo", 10));
        subscriptionMetadata.put("bar", new TopicMetadata(barTopicId, "bar", 20));
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataValue().setTopics(Arrays.asList(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(fooTopicId).setTopicName("foo").setNumPartitions(10), new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(barTopicId).setTopicName("bar").setNumPartitions(20))), 0));
        Assertions.assertRecordEquals(expectedRecord, GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataRecord((String)"group-id", subscriptionMetadata));
    }

    @Test
    public void testNewConsumerGroupEpochRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group-id"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord((String)"group-id", (int)10));
    }

    @Test
    public void testNewConsumerGroupEpochTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group-id"), 3), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testNewShareGroupEpochTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ShareGroupMetadataKey().setGroupId("group-id"), 11), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newShareGroupEpochTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testNewConsumerGroupTargetAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 11, 12, 13), AssignmentTestUtil.mkTopicAssignment(topicId2, 21, 22, 23));
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId("group-id").setMemberId("member-id"), 7), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(Arrays.asList(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId1).setPartitions(Arrays.asList(11, 12, 13)), new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId2).setPartitions(Arrays.asList(21, 22, 23)))), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord((String)"group-id", (String)"member-id", partitions));
    }

    @Test
    public void testNewConsumerGroupTargetAssignmentTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId("group-id").setMemberId("member-id"), 7), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    @Test
    public void testNewConsumerGroupTargetAssignmentEpochRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId("group-id"), 6), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue().setAssignmentEpoch(10), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord((String)"group-id", (int)10));
    }

    @Test
    public void testNewConsumerGroupTargetAssignmentEpochTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId("group-id"), 6), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testNewConsumerGroupCurrentAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        Map<Uuid, Set<Integer>> assigned = AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkOrderedTopicAssignment(topicId1, 11, 12, 13), AssignmentTestUtil.mkOrderedTopicAssignment(topicId2, 21, 22, 23));
        Map<Uuid, Set<Integer>> revoking = AssignmentTestUtil.mkOrderedAssignment(AssignmentTestUtil.mkOrderedTopicAssignment(topicId1, 14, 15, 16), AssignmentTestUtil.mkOrderedTopicAssignment(topicId2, 24, 25, 26));
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId("group-id").setMemberId("member-id"), 8), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setState(MemberState.UNREVOKED_PARTITIONS.value()).setMemberEpoch(22).setPreviousMemberEpoch(21).setAssignedPartitions(Arrays.asList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(11, 12, 13)), new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(21, 22, 23)))).setPartitionsPendingRevocation(Arrays.asList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(14, 15, 16)), new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(24, 25, 26)))), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord((String)"group-id", (ConsumerGroupMember)new ConsumerGroupMember.Builder("member-id").setState(MemberState.UNREVOKED_PARTITIONS).setMemberEpoch(22).setPreviousMemberEpoch(21).setAssignedPartitions(assigned).setPartitionsPendingRevocation(revoking).build()));
    }

    @Test
    public void testNewConsumerGroupCurrentAssignmentTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId("group-id").setMemberId("member-id"), 8), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    @Test
    public void testNewGroupMetadataRecord() {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(new byte[]{1, 2}));
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-2").setClientId("client-2").setClientHost("host-2").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-2").setSubscription(new byte[]{1, 2}).setAssignment(new byte[]{2, 3}));
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol("range").setProtocolType("consumer").setLeader("member-1").setGeneration(1).setCurrentStateTimestamp(time.milliseconds()).setMembers(expectedMembers), 3));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time);
        HashMap assignment = new HashMap();
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(member.subscription()));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, ClassicGroupMember.EMPTY_ASSIGNMENT));
            assignment.put(member.memberId(), member.assignment());
        });
        group.initNextGeneration();
        CoordinatorRecord groupMetadataRecord = GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignment);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @Test
    public void testNewGroupMetadataTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), null);
        CoordinatorRecord groupMetadataRecord = GroupCoordinatorRecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @Test
    public void testNewGroupMetadataRecordThrowsWhenNullSubscription() {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(new byte[]{1, 2}));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time);
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(null));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, member.assignment()));
        });
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap()));
    }

    @Test
    public void testNewGroupMetadataRecordThrowsWhenEmptyAssignment() {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(null));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time);
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(member.subscription()));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, member.assignment()));
        });
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> GroupCoordinatorRecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap()));
    }

    @Test
    public void testEmptyGroupMetadataRecord() {
        MockTime time = new MockTime();
        List expectedMembers = Collections.emptyList();
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(null).setProtocolType("").setLeader(null).setGeneration(0).setCurrentStateTimestamp(time.milliseconds()).setMembers(expectedMembers), 3));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time);
        group.initNextGeneration();
        CoordinatorRecord groupMetadataRecord = GroupCoordinatorRecordHelpers.newEmptyGroupMetadataRecord((ClassicGroup)group);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @Test
    public void testOffsetCommitValueVersion() {
        org.junit.jupiter.api.Assertions.assertEquals((short)1, (short)GroupCoordinatorRecordHelpers.offsetCommitValueVersion((boolean)true));
        org.junit.jupiter.api.Assertions.assertEquals((short)3, (short)GroupCoordinatorRecordHelpers.offsetCommitValueVersion((boolean)false));
    }

    @Test
    public void testNewOffsetCommitRecord() {
        OffsetCommitKey key = new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1);
        OffsetCommitValue value = new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(-1L);
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)key, 1), new ApiMessageAndVersion((ApiMessage)value, GroupCoordinatorRecordHelpers.offsetCommitValueVersion((boolean)false)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.of(10), "metadata", 1234L, OptionalLong.empty())));
        value.setLeaderEpoch(-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.empty(), "metadata", 1234L, OptionalLong.empty())));
    }

    @Test
    public void testNewOffsetCommitRecordWithExpireTimestamp() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1), 1), new ApiMessageAndVersion((ApiMessage)new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(5678L), 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)GroupCoordinatorRecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.of(10), "metadata", 1234L, OptionalLong.of(5678L))));
    }

    @Test
    public void testNewOffsetCommitTombstoneRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1), 1), null);
        CoordinatorRecord record = GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord((String)"group-id", (String)"foo", (int)1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)record);
    }

    @Test
    public void testNewConsumerGroupRegularExpressionRecord() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupRegularExpressionKey().setGroupId("group-id").setRegularExpression("ab*"), 16), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupRegularExpressionValue().setTopics(Arrays.asList("abc", "abcd")).setVersion(10L).setTimestamp(12345L), 0));
        CoordinatorRecord record = GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionRecord((String)"group-id", (String)"ab*", (ResolvedRegularExpression)new ResolvedRegularExpression(Set.of("abc", "abcd"), 10L, 12345L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)record);
    }

    @Test
    public void testNewConsumerGroupRegularExpressionTombstone() {
        CoordinatorRecord expectedRecord = new CoordinatorRecord(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupRegularExpressionKey().setGroupId("group-id").setRegularExpression("ab*"), 16), null);
        CoordinatorRecord record = GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone((String)"group-id", (String)"ab*");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)record);
    }

    public static Map<Integer, Set<String>> mkMapOfPartitionRacks(int numPartitions) {
        HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitionRacks.put(i, new HashSet<String>(Arrays.asList("rack" + i % 4, "rack" + (i + 1) % 4)));
        }
        return partitionRacks;
    }
}

