/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupPartitionMetadataValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.opentest4j.AssertionFailedError;

public class Assertions {
    private static final BiConsumer<ApiMessage, ApiMessage> API_MESSAGE_DEFAULT_COMPARATOR = org.junit.jupiter.api.Assertions::assertEquals;
    private static final Map<Class<?>, BiConsumer<ApiMessage, ApiMessage>> API_MESSAGE_COMPARATORS = Map.of(ConsumerGroupHeartbeatResponseData.class, Assertions::assertConsumerGroupHeartbeatResponse, ShareGroupHeartbeatResponseData.class, Assertions::assertShareGroupHeartbeatResponse, SyncGroupResponseData.class, Assertions::assertSyncGroupResponse, ConsumerGroupCurrentMemberAssignmentValue.class, Assertions::assertConsumerGroupCurrentMemberAssignmentValue, ConsumerGroupPartitionMetadataValue.class, Assertions::assertConsumerGroupPartitionMetadataValue, GroupMetadataValue.class, Assertions::assertGroupMetadataValue, ConsumerGroupTargetAssignmentMemberValue.class, Assertions::assertConsumerGroupTargetAssignmentMemberValue, ShareGroupPartitionMetadataValue.class, Assertions::assertShareGroupPartitionMetadataValue);

    public static void assertResponseEquals(ApiMessage expected, ApiMessage actual) {
        BiConsumer<ApiMessage, ApiMessage> asserter = API_MESSAGE_COMPARATORS.getOrDefault(expected.getClass(), API_MESSAGE_DEFAULT_COMPARATOR);
        asserter.accept(expected, actual);
    }

    public static void assertRecordsEquals(List<CoordinatorRecord> expectedRecords, List<CoordinatorRecord> actualRecords) {
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecords.size());
            for (int i = 0; i < expectedRecords.size(); ++i) {
                CoordinatorRecord expectedRecord = expectedRecords.get(i);
                CoordinatorRecord actualRecord = actualRecords.get(i);
                Assertions.assertRecordEquals(expectedRecord, actualRecord);
            }
        }
        catch (AssertionFailedError e) {
            AssertionFailureBuilder.assertionFailure().expected(expectedRecords).actual(actualRecords).buildAndThrow();
        }
    }

    public static void assertUnorderedRecordsEquals(List<List<CoordinatorRecord>> expectedRecords, List<CoordinatorRecord> actualRecords) {
        try {
            int j = 0;
            for (int i = 0; i < expectedRecords.size(); ++i) {
                List<CoordinatorRecord> slice = expectedRecords.get(i);
                Assertions.assertRecordsEquals(slice.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()), actualRecords.subList(j, j + slice.size()).stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
                j += slice.size();
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)j, (int)actualRecords.size());
        }
        catch (AssertionFailedError e) {
            AssertionFailureBuilder.assertionFailure().expected(expectedRecords).actual(actualRecords).buildAndThrow();
        }
    }

    public static void assertRecordEquals(CoordinatorRecord expected, CoordinatorRecord actual) {
        try {
            Assertions.assertApiMessageAndVersionEquals(expected.key(), actual.key());
            Assertions.assertApiMessageAndVersionEquals(expected.value(), actual.value());
        }
        catch (AssertionFailedError e) {
            AssertionFailureBuilder.assertionFailure().expected((Object)expected).actual((Object)actual).buildAndThrow();
        }
    }

    private static void assertConsumerGroupHeartbeatResponse(ApiMessage exp, ApiMessage act) {
        ConsumerGroupHeartbeatResponseData expected = (ConsumerGroupHeartbeatResponseData)exp.duplicate();
        ConsumerGroupHeartbeatResponseData actual = (ConsumerGroupHeartbeatResponseData)act.duplicate();
        Consumer<ConsumerGroupHeartbeatResponseData> normalize = message -> {
            if (message.assignment() != null) {
                message.assignment().topicPartitions().sort(Comparator.comparing(ConsumerGroupHeartbeatResponseData.TopicPartitions::topicId));
                message.assignment().topicPartitions().forEach(topic -> topic.partitions().sort(Integer::compareTo));
            }
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertShareGroupHeartbeatResponse(ApiMessage exp, ApiMessage act) {
        ShareGroupHeartbeatResponseData expected = (ShareGroupHeartbeatResponseData)exp.duplicate();
        ShareGroupHeartbeatResponseData actual = (ShareGroupHeartbeatResponseData)act.duplicate();
        Consumer<ShareGroupHeartbeatResponseData> normalize = message -> {
            if (message.assignment() != null) {
                message.assignment().topicPartitions().sort(Comparator.comparing(ShareGroupHeartbeatResponseData.TopicPartitions::topicId));
                message.assignment().topicPartitions().forEach(topic -> topic.partitions().sort(Integer::compareTo));
            }
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertApiMessageAndVersionEquals(ApiMessageAndVersion expected, ApiMessageAndVersion actual) {
        if (expected == actual) {
            return;
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)expected);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)actual);
        org.junit.jupiter.api.Assertions.assertEquals((short)expected.version(), (short)actual.version());
        BiConsumer<ApiMessage, ApiMessage> asserter = API_MESSAGE_COMPARATORS.getOrDefault(expected.message().getClass(), API_MESSAGE_DEFAULT_COMPARATOR);
        asserter.accept(expected.message(), actual.message());
    }

    private static void assertConsumerGroupCurrentMemberAssignmentValue(ApiMessage exp, ApiMessage act) {
        ConsumerGroupCurrentMemberAssignmentValue expected = (ConsumerGroupCurrentMemberAssignmentValue)exp.duplicate();
        ConsumerGroupCurrentMemberAssignmentValue actual = (ConsumerGroupCurrentMemberAssignmentValue)act.duplicate();
        Consumer<List> sortTopicsAndPartitions = topicPartitions -> {
            topicPartitions.sort(Comparator.comparing(ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions::topicId));
            topicPartitions.forEach(topic -> topic.partitions().sort(Integer::compareTo));
        };
        Consumer<ConsumerGroupCurrentMemberAssignmentValue> normalize = message -> {
            sortTopicsAndPartitions.accept(message.assignedPartitions());
            sortTopicsAndPartitions.accept(message.partitionsPendingRevocation());
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertConsumerGroupPartitionMetadataValue(ApiMessage exp, ApiMessage act) {
        ConsumerGroupPartitionMetadataValue expected = (ConsumerGroupPartitionMetadataValue)exp.duplicate();
        ConsumerGroupPartitionMetadataValue actual = (ConsumerGroupPartitionMetadataValue)act.duplicate();
        Consumer<ConsumerGroupPartitionMetadataValue> normalize = message -> {
            message.topics().sort(Comparator.comparing(ConsumerGroupPartitionMetadataValue.TopicMetadata::topicId));
            message.topics().forEach(topic -> {
                topic.partitionMetadata().sort(Comparator.comparing(ConsumerGroupPartitionMetadataValue.PartitionMetadata::partition));
                topic.partitionMetadata().forEach(partition -> partition.racks().sort(String::compareTo));
            });
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertShareGroupPartitionMetadataValue(ApiMessage exp, ApiMessage act) {
        ShareGroupPartitionMetadataValue expected = (ShareGroupPartitionMetadataValue)exp.duplicate();
        ShareGroupPartitionMetadataValue actual = (ShareGroupPartitionMetadataValue)act.duplicate();
        Consumer<ShareGroupPartitionMetadataValue> normalize = message -> {
            message.topics().sort(Comparator.comparing(ShareGroupPartitionMetadataValue.TopicMetadata::topicId));
            message.topics().forEach(topic -> {
                topic.partitionMetadata().sort(Comparator.comparing(ShareGroupPartitionMetadataValue.PartitionMetadata::partition));
                topic.partitionMetadata().forEach(partition -> partition.racks().sort(String::compareTo));
            });
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertGroupMetadataValue(ApiMessage exp, ApiMessage act) {
        GroupMetadataValue expected = (GroupMetadataValue)exp.duplicate();
        GroupMetadataValue actual = (GroupMetadataValue)act.duplicate();
        Consumer<GroupMetadataValue> normalize = message -> {
            message.members().sort(Comparator.comparing(GroupMetadataValue.MemberMetadata::memberId));
            try {
                message.members().forEach(memberMetadata -> {
                    ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)ByteBuffer.wrap(memberMetadata.subscription()));
                    subscription.topics().sort(String::compareTo);
                    subscription.ownedPartitions().sort(Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
                    memberMetadata.setSubscription(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)subscription, (short)ConsumerProtocol.deserializeVersion((ByteBuffer)ByteBuffer.wrap(memberMetadata.subscription())))));
                    ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(memberMetadata.assignment()));
                    assignment.partitions().sort(Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
                    memberMetadata.setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)assignment, (short)ConsumerProtocol.deserializeVersion((ByteBuffer)ByteBuffer.wrap(memberMetadata.assignment())))));
                });
            }
            catch (SchemaException ex) {
                org.junit.jupiter.api.Assertions.fail((String)("Failed deserialization: " + ex.getMessage()));
            }
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertConsumerGroupTargetAssignmentMemberValue(ApiMessage exp, ApiMessage act) {
        ConsumerGroupTargetAssignmentMemberValue expected = (ConsumerGroupTargetAssignmentMemberValue)exp.duplicate();
        ConsumerGroupTargetAssignmentMemberValue actual = (ConsumerGroupTargetAssignmentMemberValue)act.duplicate();
        Consumer<ConsumerGroupTargetAssignmentMemberValue> normalize = message -> {
            message.topicPartitions().sort(Comparator.comparing(ConsumerGroupTargetAssignmentMemberValue.TopicPartition::topicId));
            message.topicPartitions().forEach(topic -> topic.partitions().sort(Integer::compareTo));
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static void assertSyncGroupResponse(ApiMessage exp, ApiMessage act) {
        SyncGroupResponseData expected = (SyncGroupResponseData)exp.duplicate();
        SyncGroupResponseData actual = (SyncGroupResponseData)act.duplicate();
        Consumer<SyncGroupResponseData> normalize = message -> {
            try {
                ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(message.assignment()));
                assignment.partitions().sort(Comparator.comparing(TopicPartition::topic).thenComparing(TopicPartition::partition));
                message.setAssignment(Utils.toArray((ByteBuffer)ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)assignment, (short)ConsumerProtocol.deserializeVersion((ByteBuffer)ByteBuffer.wrap(message.assignment())))));
            }
            catch (SchemaException ex) {
                org.junit.jupiter.api.Assertions.fail((String)("Failed deserialization: " + ex.getMessage()));
            }
        };
        normalize.accept(expected);
        normalize.accept(actual);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

