/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.CoordinatorRecord;
import org.apache.kafka.coordinator.group.CoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.MemberState;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public class ConsumerGroup
implements Group {
    private final Time time;
    private final SnapshotRegistry snapshotRegistry;
    private final String groupId;
    private final TimelineObject<ConsumerGroupState> state;
    private final TimelineInteger groupEpoch;
    private final TimelineHashMap<String, ConsumerGroupMember> members;
    private final TimelineHashMap<String, String> staticMembers;
    private final TimelineHashMap<String, Integer> serverAssignors;
    private final TimelineHashMap<String, Integer> subscribedTopicNames;
    private final TimelineHashMap<String, TopicMetadata> subscribedTopicMetadata;
    private final TimelineObject<SubscriptionType> subscriptionType;
    private final TimelineInteger targetAssignmentEpoch;
    private final TimelineHashMap<String, Assignment> targetAssignment;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, String>> invertedTargetAssignment;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, Integer>> currentPartitionEpoch;
    private final GroupCoordinatorMetricsShard metrics;
    private DeadlineAndEpoch metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;
    private final TimelineInteger numClassicProtocolMembers;
    private final TimelineHashMap<String, Integer> classicProtocolMembersSupportedProtocols;
    private final TimelineObject<Optional<Long>> rebalanceStartTimestampMs;

    public ConsumerGroup(Time time, SnapshotRegistry snapshotRegistry, String groupId, GroupCoordinatorMetricsShard metrics) {
        this.time = time;
        this.snapshotRegistry = Objects.requireNonNull(snapshotRegistry);
        this.groupId = Objects.requireNonNull(groupId);
        this.state = new TimelineObject(snapshotRegistry, (Object)ConsumerGroupState.EMPTY);
        this.groupEpoch = new TimelineInteger(snapshotRegistry);
        this.members = new TimelineHashMap(snapshotRegistry, 0);
        this.staticMembers = new TimelineHashMap(snapshotRegistry, 0);
        this.serverAssignors = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicNames = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicMetadata = new TimelineHashMap(snapshotRegistry, 0);
        this.subscriptionType = new TimelineObject(snapshotRegistry, (Object)SubscriptionType.HOMOGENEOUS);
        this.targetAssignmentEpoch = new TimelineInteger(snapshotRegistry);
        this.targetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.invertedTargetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.currentPartitionEpoch = new TimelineHashMap(snapshotRegistry, 0);
        this.metrics = Objects.requireNonNull(metrics);
        this.numClassicProtocolMembers = new TimelineInteger(snapshotRegistry);
        this.classicProtocolMembersSupportedProtocols = new TimelineHashMap(snapshotRegistry, 0);
        this.rebalanceStartTimestampMs = new TimelineObject(snapshotRegistry, Optional.empty());
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.CONSUMER;
    }

    @Override
    public String stateAsString() {
        return ((ConsumerGroupState)((Object)this.state.get())).toString();
    }

    @Override
    public String stateAsString(long committedOffset) {
        return ((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString();
    }

    @Override
    public ListGroupsResponseData.ListedGroup asListedGroup(long committedOffset) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(this.groupId).setProtocolType("consumer").setGroupState(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString()).setGroupType(this.type().toString());
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public ConsumerGroupState state() {
        return (ConsumerGroupState)((Object)this.state.get());
    }

    public ConsumerGroupState state(long committedOffset) {
        return (ConsumerGroupState)((Object)this.state.get(committedOffset));
    }

    public int groupEpoch() {
        return this.groupEpoch.get();
    }

    public void setGroupEpoch(int groupEpoch) {
        this.groupEpoch.set(groupEpoch);
        this.maybeUpdateGroupState();
    }

    public int assignmentEpoch() {
        return this.targetAssignmentEpoch.get();
    }

    public void setTargetAssignmentEpoch(int targetAssignmentEpoch) {
        this.targetAssignmentEpoch.set(targetAssignmentEpoch);
        this.maybeUpdateGroupState();
    }

    public void setNumClassicProtocolMembers(int numClassicProtocolMembers) {
        this.numClassicProtocolMembers.set(numClassicProtocolMembers);
    }

    public String staticMemberId(String groupInstanceId) {
        return (String)this.staticMembers.get((Object)groupInstanceId);
    }

    public ConsumerGroupMember getOrMaybeCreateMember(String memberId, boolean createIfNotExists) {
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId);
        if (member != null) {
            return member;
        }
        if (!createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        return new ConsumerGroupMember.Builder(memberId).build();
    }

    public ConsumerGroupMember staticMember(String instanceId) {
        String existingMemberId = this.staticMemberId(instanceId);
        return existingMemberId == null ? null : this.getOrMaybeCreateMember(existingMemberId, false);
    }

    public void updateMember(ConsumerGroupMember newMember) {
        if (newMember == null) {
            throw new IllegalArgumentException("newMember cannot be null.");
        }
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.put((Object)newMember.memberId(), (Object)newMember);
        this.maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(oldMember, newMember);
        this.maybeUpdateServerAssignors(oldMember, newMember);
        this.maybeUpdatePartitionEpoch(oldMember, newMember);
        this.updateStaticMember(newMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, newMember);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, newMember);
    }

    private void updateStaticMember(ConsumerGroupMember newMember) {
        if (newMember.instanceId() != null) {
            this.staticMembers.put((Object)newMember.instanceId(), (Object)newMember.memberId());
        }
    }

    public void removeMember(String memberId) {
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.remove((Object)memberId);
        this.maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(oldMember, null);
        this.maybeUpdateServerAssignors(oldMember, null);
        this.maybeRemovePartitionEpoch(oldMember);
        this.removeStaticMember(oldMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, null);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, null);
    }

    private void removeStaticMember(ConsumerGroupMember oldMember) {
        if (oldMember.instanceId() != null) {
            this.staticMembers.remove((Object)oldMember.instanceId());
        }
    }

    public boolean hasMember(String memberId) {
        return this.members.containsKey((Object)memberId);
    }

    public int numMembers() {
        return this.members.size();
    }

    public int numClassicProtocolMembers() {
        return this.numClassicProtocolMembers.get();
    }

    public Map<String, Integer> classicMembersSupportedProtocols() {
        return Collections.unmodifiableMap(this.classicProtocolMembersSupportedProtocols);
    }

    public Map<String, ConsumerGroupMember> members() {
        return Collections.unmodifiableMap(this.members);
    }

    public Map<String, String> staticMembers() {
        return Collections.unmodifiableMap(this.staticMembers);
    }

    public Map<String, Integer> subscribedTopicNames() {
        return Collections.unmodifiableMap(this.subscribedTopicNames);
    }

    @Override
    public boolean isSubscribedToTopic(String topic) {
        return this.subscribedTopicNames.containsKey((Object)topic);
    }

    public SubscriptionType subscriptionType() {
        return (SubscriptionType)this.subscriptionType.get();
    }

    public Assignment targetAssignment(String memberId) {
        return (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY);
    }

    public Map<Uuid, Map<Integer, String>> invertedTargetAssignment() {
        return Collections.unmodifiableMap(this.invertedTargetAssignment);
    }

    public void updateTargetAssignment(String memberId, Assignment newTargetAssignment) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)new Assignment(Collections.emptyMap())), newTargetAssignment);
        this.targetAssignment.put((Object)memberId, (Object)newTargetAssignment);
    }

    private void updateInvertedTargetAssignment(String memberId, Assignment oldTargetAssignment, Assignment newTargetAssignment) {
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>();
        allTopicIds.addAll(oldTargetAssignment.partitions().keySet());
        allTopicIds.addAll(newTargetAssignment.partitions().keySet());
        for (Uuid topicId : allTopicIds) {
            Set oldPartitions = oldTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            Set newPartitions = newTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            TimelineHashMap topicPartitionAssignment = (TimelineHashMap)this.invertedTargetAssignment.computeIfAbsent((Object)topicId, k -> new TimelineHashMap(this.snapshotRegistry, Math.max(oldPartitions.size(), newPartitions.size())));
            for (Integer partition : oldPartitions) {
                if (newPartitions.contains(partition) || !memberId.equals(topicPartitionAssignment.get((Object)partition))) continue;
                topicPartitionAssignment.remove((Object)partition);
            }
            for (Integer partition : newPartitions) {
                if (oldPartitions.contains(partition)) continue;
                topicPartitionAssignment.put((Object)partition, (Object)memberId);
            }
            if (topicPartitionAssignment.isEmpty()) {
                this.invertedTargetAssignment.remove((Object)topicId);
                continue;
            }
            this.invertedTargetAssignment.put((Object)topicId, (Object)topicPartitionAssignment);
        }
    }

    public void removeTargetAssignment(String memberId) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY), Assignment.EMPTY);
        this.targetAssignment.remove((Object)memberId);
    }

    public Map<String, Assignment> targetAssignment() {
        return Collections.unmodifiableMap(this.targetAssignment);
    }

    public int currentPartitionEpoch(Uuid topicId, int partitionId) {
        Map partitions = (Map)this.currentPartitionEpoch.get((Object)topicId);
        if (partitions == null) {
            return -1;
        }
        return partitions.getOrDefault(partitionId, -1);
    }

    public Optional<String> computePreferredServerAssignor(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>((Map<String, Integer>)this.serverAssignors);
        ConsumerGroup.maybeUpdateServerAssignors(counts, oldMember, newMember);
        return counts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Optional<String> preferredServerAssignor() {
        return this.preferredServerAssignor(Long.MAX_VALUE);
    }

    public Optional<String> preferredServerAssignor(long committedOffset) {
        return this.serverAssignors.entrySet(committedOffset).stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Map<String, TopicMetadata> subscriptionMetadata() {
        return Collections.unmodifiableMap(this.subscribedTopicMetadata);
    }

    public void setSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscribedTopicMetadata.clear();
        this.subscribedTopicMetadata.putAll(subscriptionMetadata);
    }

    public Map<String, TopicMetadata> computeSubscriptionMetadata(Map<String, Integer> subscribedTopicNames, TopicsImage topicsImage, ClusterImage clusterImage) {
        HashMap newSubscriptionMetadata = new HashMap(subscribedTopicNames.size());
        subscribedTopicNames.forEach((topicName, count) -> {
            TopicImage topicImage = topicsImage.getTopic(topicName);
            if (topicImage != null) {
                HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>();
                topicImage.partitions().forEach((partition, partitionRegistration) -> {
                    HashSet racks = new HashSet();
                    for (int replica : partitionRegistration.replicas) {
                        Optional rackOptional = clusterImage.broker(replica).rack();
                        rackOptional.ifPresent(racks::add);
                    }
                    if (!racks.isEmpty()) {
                        partitionRacks.put((Integer)partition, racks);
                    }
                });
                newSubscriptionMetadata.put(topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size(), partitionRacks));
            }
        });
        return Collections.unmodifiableMap(newSubscriptionMetadata);
    }

    public void setMetadataRefreshDeadline(long deadlineMs, int groupEpoch) {
        this.metadataRefreshDeadline = new DeadlineAndEpoch(deadlineMs, groupEpoch);
    }

    public void requestMetadataRefresh() {
        this.metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;
    }

    public boolean hasMetadataExpired(long currentTimeMs) {
        return currentTimeMs >= this.metadataRefreshDeadline.deadlineMs || this.groupEpoch() < this.metadataRefreshDeadline.epoch;
    }

    public DeadlineAndEpoch metadataRefreshDeadline() {
        return this.metadataRefreshDeadline;
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int memberEpoch, boolean isTransactional, short apiVersion) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberEpoch < 0 && this.members().isEmpty()) {
            return;
        }
        ConsumerGroupMember member = this.getOrMaybeCreateMember(memberId, false);
        if (!isTransactional && !member.useClassicProtocol() && apiVersion < 9) {
            throw new UnsupportedVersionException("OffsetCommit version 9 or above must be used by members using the consumer group protocol");
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetFetch(String memberId, int memberEpoch, long lastCommittedOffset) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberId == null && memberEpoch < 0) {
            return;
        }
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId, lastCommittedOffset);
        if (member == null) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetDelete() {
    }

    @Override
    public void validateDeleteGroup() throws ApiException {
        if (this.state() != ConsumerGroupState.EMPTY) {
            throw Errors.NON_EMPTY_GROUP.exception();
        }
    }

    @Override
    public void createGroupTombstoneRecords(List<CoordinatorRecord> records) {
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newCurrentAssignmentTombstoneRecord(this.groupId(), memberId)));
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newTargetAssignmentTombstoneRecord(this.groupId(), memberId)));
        records.add(CoordinatorRecordHelpers.newTargetAssignmentEpochTombstoneRecord(this.groupId()));
        this.members().forEach((memberId, member) -> records.add(CoordinatorRecordHelpers.newMemberSubscriptionTombstoneRecord(this.groupId(), memberId)));
        records.add(CoordinatorRecordHelpers.newGroupSubscriptionMetadataTombstoneRecord(this.groupId()));
        records.add(CoordinatorRecordHelpers.newGroupEpochTombstoneRecord(this.groupId()));
    }

    @Override
    public boolean isEmpty() {
        return this.state() == ConsumerGroupState.EMPTY;
    }

    @Override
    public Optional<OffsetExpirationCondition> offsetExpirationCondition() {
        return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> offsetAndMetadata.commitTimestampMs));
    }

    @Override
    public boolean isInStates(Set<String> statesFilter, long committedOffset) {
        return statesFilter.contains(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toLowerCaseString());
    }

    private void validateMemberEpoch(int receivedMemberEpoch, int expectedMemberEpoch, boolean useClassicProtocol) throws StaleMemberEpochException, IllegalGenerationException {
        if (receivedMemberEpoch != expectedMemberEpoch) {
            if (useClassicProtocol) {
                throw new IllegalGenerationException(String.format("The received generation id %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
            }
            throw new StaleMemberEpochException(String.format("The received member epoch %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
        }
    }

    private void maybeUpdateGroupState() {
        ConsumerGroupState prevState = (ConsumerGroupState)((Object)this.state.get());
        ConsumerGroupState newState = ConsumerGroupState.STABLE;
        if (this.members.isEmpty()) {
            newState = ConsumerGroupState.EMPTY;
        } else if (this.groupEpoch.get() > this.targetAssignmentEpoch.get()) {
            newState = ConsumerGroupState.ASSIGNING;
        } else {
            for (ConsumerGroupMember member : this.members.values()) {
                if (member.isReconciledTo(this.targetAssignmentEpoch.get())) continue;
                newState = ConsumerGroupState.RECONCILING;
                break;
            }
        }
        this.state.set((Object)newState);
        this.rebalanceStartTimestampMs.set(this.getRebalanceStartTimestampMs(prevState, newState));
        this.metrics.recordRebalanceStartTimestampMs(this.type(), this.groupId, ((Optional)this.rebalanceStartTimestampMs.get()).orElse(null));
        this.metrics.onConsumerGroupStateTransition(prevState, newState);
    }

    private void maybeUpdateServerAssignors(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateServerAssignors(this.serverAssignors, oldMember, newMember);
    }

    private static void maybeUpdateServerAssignors(Map<String, Integer> serverAssignorCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, ConsumerGroup::decValue));
        }
        if (newMember != null) {
            newMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, ConsumerGroup::incValue));
        }
    }

    private void maybeUpdateNumClassicProtocolMembers(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        int delta = 0;
        if (oldMember != null && oldMember.useClassicProtocol()) {
            --delta;
        }
        if (newMember != null && newMember.useClassicProtocol()) {
            ++delta;
        }
        this.setNumClassicProtocolMembers(this.numClassicProtocolMembers() + delta);
    }

    private void maybeUpdateClassicProtocolMembersSupportedProtocols(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> {
                Integer cfr_ignored_0 = (Integer)this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), ConsumerGroup::decValue);
            }));
        }
        if (newMember != null) {
            newMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> {
                Integer cfr_ignored_0 = (Integer)this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), ConsumerGroup::incValue);
            }));
        }
    }

    private void maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateSubscribedTopicNames(this.subscribedTopicNames, oldMember, newMember);
        this.subscriptionType.set((Object)ConsumerGroup.subscriptionType(this.subscribedTopicNames, this.members.size()));
    }

    private static void maybeUpdateSubscribedTopicNames(Map<String, Integer> subscribedTopicCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, ConsumerGroup::decValue));
        }
        if (newMember != null) {
            newMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, ConsumerGroup::incValue));
        }
    }

    public Map<String, Integer> computeSubscribedTopicNames(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        HashMap<String, Integer> subscribedTopicNames = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedTopicNames);
        ConsumerGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, oldMember, newMember);
        return subscribedTopicNames;
    }

    public Map<String, Integer> computeSubscribedTopicNames(Set<ConsumerGroupMember> removedMembers) {
        HashMap<String, Integer> subscribedTopicNames = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedTopicNames);
        if (removedMembers != null) {
            removedMembers.forEach(removedMember -> ConsumerGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, removedMember, null));
        }
        return subscribedTopicNames;
    }

    public static SubscriptionType subscriptionType(Map<String, Integer> subscribedTopicNames, int numberOfMembers) {
        if (subscribedTopicNames.isEmpty()) {
            return SubscriptionType.HOMOGENEOUS;
        }
        for (int subscriberCount : subscribedTopicNames.values()) {
            if (subscriberCount == numberOfMembers) continue;
            return SubscriptionType.HETEROGENEOUS;
        }
        return SubscriptionType.HOMOGENEOUS;
    }

    private void maybeUpdatePartitionEpoch(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        this.maybeRemovePartitionEpoch(oldMember);
        this.addPartitionEpochs(newMember.assignedPartitions(), newMember.memberEpoch());
        this.addPartitionEpochs(newMember.partitionsPendingRevocation(), newMember.memberEpoch());
    }

    private void maybeRemovePartitionEpoch(ConsumerGroupMember oldMember) {
        if (oldMember != null) {
            this.removePartitionEpochs(oldMember.assignedPartitions(), oldMember.memberEpoch());
            this.removePartitionEpochs(oldMember.partitionsPendingRevocation(), oldMember.memberEpoch());
        }
    }

    void removePartitionEpochs(Map<Uuid, Set<Integer>> assignment, int expectedEpoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull != null) {
                assignedPartitions.forEach(partitionId -> {
                    Integer prevValue = (Integer)partitionsOrNull.remove(partitionId);
                    if (prevValue != expectedEpoch) {
                        throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s-%s because the partition is still owned at a different epoch %d", expectedEpoch, topicId, partitionId, prevValue));
                    }
                });
                if (partitionsOrNull.isEmpty()) {
                    return null;
                }
                return partitionsOrNull;
            }
            throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s because it does not have any epoch", expectedEpoch, topicId));
        }));
    }

    void addPartitionEpochs(Map<Uuid, Set<Integer>> assignment, int epoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull == null) {
                partitionsOrNull = new TimelineHashMap(this.snapshotRegistry, assignedPartitions.size());
            }
            for (Integer partitionId : assignedPartitions) {
                Integer prevValue = (Integer)partitionsOrNull.put((Object)partitionId, (Object)epoch);
                if (prevValue == null) continue;
                throw new IllegalStateException(String.format("Cannot set the epoch of %s-%s to %d because the partition is still owned at epoch %d", topicId, partitionId, epoch, prevValue));
            }
            return partitionsOrNull;
        }));
    }

    private Optional<Long> getRebalanceStartTimestampMs(ConsumerGroupState prevState, ConsumerGroupState nextState) {
        switch (nextState) {
            case ASSIGNING: 
            case RECONCILING: {
                if (prevState == ConsumerGroupState.ASSIGNING || prevState == ConsumerGroupState.RECONCILING) {
                    return (Optional)this.rebalanceStartTimestampMs.get();
                }
                return Optional.of(this.time.milliseconds());
            }
        }
        return Optional.empty();
    }

    private static Integer decValue(String key, Integer value) {
        if (value == null) {
            return null;
        }
        return value == 1 ? null : Integer.valueOf(value - 1);
    }

    private static Integer incValue(String key, Integer value) {
        return value == null ? 1 : value + 1;
    }

    public ConsumerGroupDescribeResponseData.DescribedGroup asDescribedGroup(long committedOffset, String defaultAssignor, TopicsImage topicsImage) {
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(this.groupId).setAssignorName(this.preferredServerAssignor(committedOffset).orElse(defaultAssignor)).setGroupEpoch(this.groupEpoch.get(committedOffset)).setGroupState(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString()).setAssignmentEpoch(this.targetAssignmentEpoch.get(committedOffset));
        this.members.entrySet(committedOffset).forEach(entry -> describedGroup.members().add(((ConsumerGroupMember)entry.getValue()).asConsumerGroupDescribeMember((Assignment)this.targetAssignment.get((Object)((ConsumerGroupMember)entry.getValue()).memberId(), committedOffset), topicsImage)));
        return describedGroup;
    }

    public static ConsumerGroup fromClassicGroup(SnapshotRegistry snapshotRegistry, GroupCoordinatorMetricsShard metrics, ClassicGroup classicGroup, TopicsImage topicsImage, Time time) {
        String groupId = classicGroup.groupId();
        ConsumerGroup consumerGroup = new ConsumerGroup(time, snapshotRegistry, groupId, metrics);
        consumerGroup.setGroupEpoch(classicGroup.generationId());
        consumerGroup.setTargetAssignmentEpoch(classicGroup.generationId());
        classicGroup.allMembers().forEach(classicGroupMember -> {
            ConsumerPartitionAssignor.Assignment assignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(classicGroupMember.assignment()));
            Map<Uuid, Set<Integer>> partitions = ConsumerGroup.topicPartitionMapFromList(assignment.partitions(), topicsImage);
            ConsumerPartitionAssignor.Subscription subscription = ConsumerProtocol.deserializeSubscription((ByteBuffer)ByteBuffer.wrap(classicGroupMember.metadata(classicGroup.protocolName().get())));
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(classicGroupMember.memberId()).setMemberEpoch(classicGroup.generationId()).setState(MemberState.STABLE).setPreviousMemberEpoch(classicGroup.generationId()).setInstanceId(classicGroupMember.groupInstanceId().orElse(null)).setRackId(subscription.rackId().orElse(null)).setRebalanceTimeoutMs(classicGroupMember.rebalanceTimeoutMs()).setClientId(classicGroupMember.clientId()).setClientHost(classicGroupMember.clientHost()).setSubscribedTopicNames(subscription.topics()).setAssignedPartitions(partitions).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(classicGroupMember.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection(classicGroupMember.supportedProtocols()))).build();
            consumerGroup.updateTargetAssignment(newMember.memberId(), new Assignment(partitions));
            consumerGroup.updateMember(newMember);
        });
        return consumerGroup;
    }

    public void createConsumerGroupRecords(List<CoordinatorRecord> records) {
        this.members().forEach((__, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newMemberSubscriptionRecord(this.groupId(), consumerGroupMember)));
        records.add(CoordinatorRecordHelpers.newGroupEpochRecord(this.groupId(), this.groupEpoch()));
        this.members().forEach((consumerGroupMemberId, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newTargetAssignmentRecord(this.groupId(), consumerGroupMemberId, this.targetAssignment((String)consumerGroupMemberId).partitions())));
        records.add(CoordinatorRecordHelpers.newTargetAssignmentEpochRecord(this.groupId(), this.groupEpoch()));
        this.members().forEach((__, consumerGroupMember) -> records.add(CoordinatorRecordHelpers.newCurrentAssignmentRecord(this.groupId(), consumerGroupMember)));
    }

    private static Map<Uuid, Set<Integer>> topicPartitionMapFromList(List<TopicPartition> partitions, TopicsImage topicsImage) {
        HashMap<Uuid, Set<Integer>> topicPartitionMap = new HashMap<Uuid, Set<Integer>>();
        partitions.forEach(topicPartition -> {
            TopicImage topicImage = topicsImage.getTopic(topicPartition.topic());
            if (topicImage != null) {
                topicPartitionMap.computeIfAbsent(topicImage.id(), __ -> new HashSet()).add(topicPartition.partition());
            }
        });
        return topicPartitionMap;
    }

    public boolean supportsClassicProtocols(String memberProtocolType, Set<String> memberProtocols) {
        if ("consumer".equals(memberProtocolType)) {
            if (this.isEmpty()) {
                return !memberProtocols.isEmpty();
            }
            return memberProtocols.stream().anyMatch(name -> ((Integer)this.classicProtocolMembersSupportedProtocols.getOrDefault(name, (Object)0)).intValue() == this.numClassicProtocolMembers());
        }
        return false;
    }

    public boolean allMembersUseClassicProtocolExcept(String memberId) {
        return this.numClassicProtocolMembers() == this.members().size() - 1 && !this.getOrMaybeCreateMember(memberId, false).useClassicProtocol();
    }

    public boolean waitingOnUnreleasedPartition(ConsumerGroupMember member) {
        if (member.state() == MemberState.UNRELEASED_PARTITIONS) {
            for (Map.Entry<Uuid, Set<Integer>> entry : this.targetAssignment().get(member.memberId()).partitions().entrySet()) {
                Uuid topicId = entry.getKey();
                Set assignedPartitions = member.assignedPartitions().getOrDefault(topicId, Collections.emptySet());
                for (int partition : entry.getValue()) {
                    if (assignedPartitions.contains(partition) || this.currentPartitionEpoch(topicId, partition) == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class DeadlineAndEpoch {
        static final DeadlineAndEpoch EMPTY = new DeadlineAndEpoch(0L, 0);
        public final long deadlineMs;
        public final int epoch;

        DeadlineAndEpoch(long deadlineMs, int epoch) {
            this.deadlineMs = deadlineMs;
            this.epoch = epoch;
        }
    }

    public static enum ConsumerGroupState {
        EMPTY("Empty"),
        ASSIGNING("Assigning"),
        RECONCILING("Reconciling"),
        STABLE("Stable"),
        DEAD("Dead");

        private final String name;
        private final String lowerCaseName;

        private ConsumerGroupState(String name) {
            this.name = name;
            this.lowerCaseName = name.toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name;
        }

        public String toLowerCaseString() {
            return this.lowerCaseName;
        }
    }
}

