/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.coordinator.group.runtime.PartitionWriter;
import org.apache.kafka.storage.internals.log.VerificationGuard;

public class InMemoryPartitionWriter<T>
implements PartitionWriter<T> {
    private final boolean autoCommit;
    private final Map<TopicPartition, PartitionState> partitions;

    public InMemoryPartitionWriter(boolean autoCommit) {
        this.autoCommit = autoCommit;
        this.partitions = new ConcurrentHashMap<TopicPartition, PartitionState>();
    }

    private PartitionState partitionState(TopicPartition tp) {
        return this.partitions.computeIfAbsent(tp, __ -> new PartitionState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(TopicPartition tp, PartitionWriter.Listener listener) {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.listeners.add(listener);
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterListener(TopicPartition tp, PartitionWriter.Listener listener) {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.listeners.remove(listener);
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(TopicPartition tp, long producerId, short producerEpoch, VerificationGuard verificationGuard, List<T> records) throws KafkaException {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.entries.addAll(records.stream().map(record -> new LogValue(producerId, producerEpoch, record)).collect(Collectors.toList()));
            PartitionState partitionState = state;
            partitionState.endOffset = partitionState.endOffset + (long)records.size();
            if (this.autoCommit) {
                this.commit(tp, state.endOffset);
            }
            long l = state.endOffset;
            return l;
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long appendEndTransactionMarker(TopicPartition tp, long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result) throws KafkaException {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.entries.add(new LogControl(producerId, producerEpoch, coordinatorEpoch, result));
            PartitionState partitionState = state;
            partitionState.endOffset = partitionState.endOffset + 1L;
            if (this.autoCommit) {
                this.commit(tp, state.endOffset);
            }
            long l = state.endOffset;
            return l;
        }
        finally {
            state.lock.unlock();
        }
    }

    public CompletableFuture<VerificationGuard> maybeStartTransactionVerification(TopicPartition tp, String transactionalId, long producerId, short producerEpoch) throws KafkaException {
        return CompletableFuture.completedFuture(new VerificationGuard());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(TopicPartition tp, long offset) {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.committedOffset = offset;
            state.listeners.forEach(listener -> listener.onHighWatermarkUpdated(tp, state.committedOffset));
        }
        finally {
            state.lock.unlock();
        }
    }

    public void commit(TopicPartition tp) {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            state.committedOffset = state.endOffset;
            state.listeners.forEach(listener -> listener.onHighWatermarkUpdated(tp, state.committedOffset));
        }
        finally {
            state.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEntry> entries(TopicPartition tp) {
        PartitionState state = this.partitionState(tp);
        state.lock.lock();
        try {
            List<LogEntry> list = Collections.unmodifiableList(state.entries);
            return list;
        }
        finally {
            state.lock.unlock();
        }
    }

    private class PartitionState {
        private ReentrantLock lock = new ReentrantLock();
        private List<PartitionWriter.Listener> listeners = new ArrayList<PartitionWriter.Listener>();
        private List<LogEntry> entries = new ArrayList<LogEntry>();
        private long endOffset = 0L;
        private long committedOffset = 0L;

        private PartitionState() {
        }
    }

    public static class LogControl
    extends LogEntry {
        public final long producerId;
        public final short producerEpoch;
        public final int coordinatorEpoch;
        public final TransactionResult result;

        private LogControl(long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result) {
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.coordinatorEpoch = coordinatorEpoch;
            this.result = result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogControl that = (LogControl)o;
            if (this.producerId != that.producerId) {
                return false;
            }
            if (this.producerEpoch != that.producerEpoch) {
                return false;
            }
            if (this.coordinatorEpoch != that.coordinatorEpoch) {
                return false;
            }
            return this.result == that.result;
        }

        public int hashCode() {
            int result1 = (int)(this.producerId ^ this.producerId >>> 32);
            result1 = 31 * result1 + this.producerEpoch;
            result1 = 31 * result1 + this.coordinatorEpoch;
            result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
            return result1;
        }

        public String toString() {
            return "ControlRecord(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", coordinatorEpoch=" + this.coordinatorEpoch + ", result=" + this.result + ')';
        }
    }

    public static class LogValue<T>
    extends LogEntry {
        public final long producerId;
        public final short producerEpoch;
        public final T value;

        private LogValue(long producerId, short producerEpoch, T value) {
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.value = value;
        }

        private LogValue(T value) {
            this(-1L, -1, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogValue that = (LogValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "BasicRecord(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", value=" + this.value + ')';
        }
    }

    public static class LogEntry {
        public static <T> LogEntry value(T value) {
            return new LogValue(value);
        }

        public static <T> LogEntry value(long producerId, short producerEpoch, T value) {
            return new LogValue(producerId, producerEpoch, value);
        }

        public static LogEntry control(long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result) {
            return new LogControl(producerId, producerEpoch, coordinatorEpoch, result);
        }
    }
}

