/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.coordinator.group.runtime.EventAccumulator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventAccumulatorTest {
    @Test
    public void testBasicOperations() {
        EventAccumulator accumulator = new EventAccumulator();
        Assertions.assertEquals((int)0, (int)accumulator.size());
        Assertions.assertNull((Object)accumulator.poll());
        List<MockEvent> events = Arrays.asList(new MockEvent(1, 0), new MockEvent(1, 1), new MockEvent(1, 2), new MockEvent(2, 0), new MockEvent(2, 1), new MockEvent(2, 3), new MockEvent(3, 0), new MockEvent(3, 1), new MockEvent(3, 2));
        events.forEach(arg_0 -> ((EventAccumulator)accumulator).add(arg_0));
        Assertions.assertEquals((int)9, (int)accumulator.size());
        HashSet<MockEvent> polledEvents = new HashSet<MockEvent>();
        for (int i = 0; i < events.size(); ++i) {
            MockEvent event = (MockEvent)accumulator.poll();
            Assertions.assertNotNull((Object)event);
            polledEvents.add(event);
            Assertions.assertEquals((int)(events.size() - 1 - i), (int)accumulator.size());
            accumulator.done((EventAccumulator.Event)event);
        }
        Assertions.assertNull((Object)accumulator.poll());
        Assertions.assertEquals(new HashSet<MockEvent>(events), polledEvents);
        Assertions.assertEquals((int)0, (int)accumulator.size());
        accumulator.close();
    }

    @Test
    public void testKeyConcurrentAndOrderingGuarantees() {
        EventAccumulator accumulator = new EventAccumulator();
        MockEvent event0 = new MockEvent(1, 0);
        MockEvent event1 = new MockEvent(1, 1);
        MockEvent event2 = new MockEvent(1, 2);
        accumulator.add((EventAccumulator.Event)event0);
        accumulator.add((EventAccumulator.Event)event1);
        accumulator.add((EventAccumulator.Event)event2);
        Assertions.assertEquals((int)3, (int)accumulator.size());
        MockEvent event = null;
        event = (MockEvent)accumulator.poll();
        Assertions.assertEquals((Object)event0, (Object)event);
        Assertions.assertNull((Object)accumulator.poll());
        accumulator.done((EventAccumulator.Event)event);
        event = (MockEvent)accumulator.poll();
        Assertions.assertEquals((Object)event1, (Object)event);
        Assertions.assertNull((Object)accumulator.poll());
        accumulator.done((EventAccumulator.Event)event);
        event = (MockEvent)accumulator.poll();
        Assertions.assertEquals((Object)event2, (Object)event);
        Assertions.assertNull((Object)accumulator.poll());
        accumulator.done((EventAccumulator.Event)event);
        accumulator.close();
    }

    @Test
    public void testDoneUnblockWaitingThreads() throws ExecutionException, InterruptedException, TimeoutException {
        EventAccumulator accumulator = new EventAccumulator();
        MockEvent event0 = new MockEvent(1, 0);
        MockEvent event1 = new MockEvent(1, 1);
        MockEvent event2 = new MockEvent(1, 2);
        CompletableFuture<MockEvent> future0 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        CompletableFuture<MockEvent> future1 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        CompletableFuture<MockEvent> future2 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        List futures = Arrays.asList(future0, future1, future2);
        Assertions.assertFalse((boolean)future0.isDone());
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        accumulator.add((EventAccumulator.Event)event0);
        accumulator.add((EventAccumulator.Event)event1);
        accumulator.add((EventAccumulator.Event)event2);
        Assertions.assertEquals((Object)event0, (Object)CompletableFuture.anyOf(futures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.SECONDS));
        futures = futures.stream().filter(future -> !future.isDone()).collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)futures.size());
        accumulator.done((EventAccumulator.Event)event0);
        Assertions.assertEquals((Object)event1, (Object)CompletableFuture.anyOf(futures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.SECONDS));
        futures = futures.stream().filter(future -> !future.isDone()).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)futures.size());
        accumulator.done((EventAccumulator.Event)event1);
        Assertions.assertEquals((Object)event2, (Object)CompletableFuture.anyOf(futures.toArray(new CompletableFuture[0])).get(5L, TimeUnit.SECONDS));
        futures = futures.stream().filter(future -> !future.isDone()).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)futures.size());
        accumulator.done((EventAccumulator.Event)event2);
        Assertions.assertEquals((int)0, (int)accumulator.size());
        accumulator.close();
    }

    @Test
    public void testCloseUnblockWaitingThreads() throws ExecutionException, InterruptedException, TimeoutException {
        EventAccumulator accumulator = new EventAccumulator();
        CompletableFuture<MockEvent> future0 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        CompletableFuture<MockEvent> future1 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        CompletableFuture<MockEvent> future2 = CompletableFuture.supplyAsync(() -> ((EventAccumulator)accumulator).take());
        Assertions.assertFalse((boolean)future0.isDone());
        Assertions.assertFalse((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        accumulator.close();
        Assertions.assertNull((Object)future0.get(5L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)future1.get(5L, TimeUnit.SECONDS));
        Assertions.assertNull((Object)future2.get(5L, TimeUnit.SECONDS));
    }

    private class MockEvent
    implements EventAccumulator.Event<Integer> {
        int key;
        int value;

        MockEvent(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public Integer key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockEvent mockEvent = (MockEvent)o;
            if (this.key != mockEvent.key) {
                return false;
            }
            return this.value == mockEvent.value;
        }

        public int hashCode() {
            int result = this.key;
            result = 31 * result + this.value;
            return result;
        }

        public String toString() {
            return "MockEvent(key=" + this.key + ", value=" + this.value + ')';
        }
    }
}

