/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;

public class MetricsTestUtils {
    static void assertMetricsForTypeEqual(MetricsRegistry registry, String expectedPrefix, Set<String> expected) {
        TreeSet actual = new TreeSet();
        registry.allMetrics().forEach((name, __) -> {
            StringBuilder bld = new StringBuilder();
            bld.append(name.getGroup());
            bld.append(":type=").append(name.getType());
            bld.append(",name=").append(name.getName());
            if (bld.toString().startsWith(expectedPrefix)) {
                actual.add(bld.toString());
            }
        });
        Assertions.assertEquals(new TreeSet<String>(expected), actual);
    }

    static void assertGaugeValue(MetricsRegistry registry, com.yammer.metrics.core.MetricName metricName, long count) {
        Gauge gauge = (Gauge)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)((Long)gauge.value()));
    }

    static void assertGaugeValue(Metrics metrics, MetricName metricName, long count) {
        Long metricVal = (Long)((KafkaMetric)metrics.metrics().get(metricName)).metricValue();
        Assertions.assertEquals((long)count, (Long)metricVal);
    }

    static com.yammer.metrics.core.MetricName metricName(String type, String name) {
        String mBeanName = String.format("kafka.coordinator.group:type=%s,name=%s", type, name);
        return new com.yammer.metrics.core.MetricName("kafka.coordinator.group", type, name, null, mBeanName);
    }
}

