/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.group.runtime.CoordinatorRuntime;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorRuntimeMetricsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricNames() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        HashSet<MetricName> expectedMetrics = new HashSet<MetricName>(Arrays.asList(GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "loading"), GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "active"), GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "failed"), metrics.metricName("event-queue-size", "group-coordinator-metrics"), metrics.metricName("partition-load-time-max", "group-coordinator-metrics"), metrics.metricName("partition-load-time-avg", "group-coordinator-metrics"), metrics.metricName("thread-idle-ratio-min", "group-coordinator-metrics"), metrics.metricName("thread-idle-ratio-avg", "group-coordinator-metrics")));
        try {
            try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
                HashSet<String> expectedRegistry = new HashSet<String>(Arrays.asList("kafka.coordinator.group:type=group-coordinator-metrics,name=EventQueueTimeMs", "kafka.coordinator.group:type=group-coordinator-metrics,name=EventQueueProcessingTimeMs"));
                runtimeMetrics.registerEventQueueSizeGauge(() -> 0);
                GroupCoordinatorRuntimeMetricsTest.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", expectedRegistry);
                expectedMetrics.forEach(metricName -> Assertions.assertTrue((boolean)metrics.metrics().containsKey(metricName)));
            }
            GroupCoordinatorRuntimeMetricsTest.assertMetricsForTypeEqual(registry, "kafka.coordinator.group", Collections.emptySet());
            expectedMetrics.forEach(metricName -> Assertions.assertFalse((boolean)metrics.metrics().containsKey(metricName)));
        }
        finally {
            registry.shutdown();
        }
    }

    @Test
    public void testUpdateNumPartitionsMetrics() {
        Metrics metrics = new Metrics();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(KafkaYammerMetrics.defaultRegistry(), metrics);){
            IntStream.range(0, 10).forEach(__ -> runtimeMetrics.recordPartitionStateChange(CoordinatorRuntime.CoordinatorState.INITIAL, CoordinatorRuntime.CoordinatorState.LOADING));
            IntStream.range(0, 8).forEach(__ -> runtimeMetrics.recordPartitionStateChange(CoordinatorRuntime.CoordinatorState.LOADING, CoordinatorRuntime.CoordinatorState.ACTIVE));
            IntStream.range(0, 8).forEach(__ -> runtimeMetrics.recordPartitionStateChange(CoordinatorRuntime.CoordinatorState.ACTIVE, CoordinatorRuntime.CoordinatorState.FAILED));
            IntStream.range(0, 2).forEach(__ -> runtimeMetrics.recordPartitionStateChange(CoordinatorRuntime.CoordinatorState.FAILED, CoordinatorRuntime.CoordinatorState.CLOSED));
            GroupCoordinatorRuntimeMetricsTest.assertMetricGauge(metrics, GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "loading"), 2L);
            GroupCoordinatorRuntimeMetricsTest.assertMetricGauge(metrics, GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "active"), 0L);
            GroupCoordinatorRuntimeMetricsTest.assertMetricGauge(metrics, GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "num-partitions", "state", "failed"), 6L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionLoadSensorMetrics() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        MetricsRegistry registry = new MetricsRegistry();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
            long startTimeMs = time.milliseconds();
            runtimeMetrics.recordPartitionLoadSensor(startTimeMs, startTimeMs + 1000L);
            runtimeMetrics.recordPartitionLoadSensor(startTimeMs, startTimeMs + 2000L);
            MetricName metricName = metrics.metricName("partition-load-time-avg", "group-coordinator-metrics");
            KafkaMetric metric = (KafkaMetric)metrics.metrics().get(metricName);
            Assertions.assertEquals((Object)1500.0, (Object)metric.metricValue());
            metricName = metrics.metricName("partition-load-time-max", "group-coordinator-metrics");
            metric = (KafkaMetric)metrics.metrics().get(metricName);
            Assertions.assertEquals((Object)2000.0, (Object)metric.metricValue());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadIdleRatioSensor() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        MetricsRegistry registry = new MetricsRegistry();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
            IntStream.range(0, 3).forEach(i -> runtimeMetrics.recordThreadIdleRatio(1.0 / (double)(i + 1)));
            MetricName metricName = metrics.metricName("thread-idle-ratio-avg", "group-coordinator-metrics");
            KafkaMetric metric = (KafkaMetric)metrics.metrics().get(metricName);
            Assertions.assertEquals((Object)0.611111111111111, (Object)metric.metricValue());
            metricName = metrics.metricName("thread-idle-ratio-min", "group-coordinator-metrics");
            metric = (KafkaMetric)metrics.metrics().get(metricName);
            Assertions.assertEquals((Object)0.3333333333333333, (Object)metric.metricValue());
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventQueueTime() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        MetricsRegistry registry = new MetricsRegistry();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
            IntStream.range(0, 3).forEach(i -> runtimeMetrics.recordEventQueueTime((long)(i + 1) * 1000L));
            GroupCoordinatorRuntimeMetricsTest.assertMetricHistogram(registry, GroupCoordinatorRuntimeMetricsTest.yammerMetricName("group-coordinator-metrics", "EventQueueTimeMs"), 3L, 6000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventQueueProcessingTime() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        MetricsRegistry registry = new MetricsRegistry();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
            IntStream.range(0, 4).forEach(i -> runtimeMetrics.recordEventQueueProcessingTime((long)(i + 1) * 1000L));
            GroupCoordinatorRuntimeMetricsTest.assertMetricHistogram(registry, GroupCoordinatorRuntimeMetricsTest.yammerMetricName("group-coordinator-metrics", "EventQueueProcessingTimeMs"), 4L, 10000.0);
        }
        finally {
            registry.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventQueueSize() {
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        MetricsRegistry registry = new MetricsRegistry();
        try (GroupCoordinatorRuntimeMetrics runtimeMetrics = new GroupCoordinatorRuntimeMetrics(registry, metrics);){
            runtimeMetrics.registerEventQueueSizeGauge(() -> 5);
            GroupCoordinatorRuntimeMetricsTest.assertMetricGauge(metrics, GroupCoordinatorRuntimeMetricsTest.kafkaMetricName(metrics, "event-queue-size", new String[0]), 5L);
        }
        finally {
            registry.shutdown();
        }
    }

    private static void assertMetricGauge(Metrics metrics, MetricName metricName, long count) {
        Assertions.assertEquals((long)count, (long)((Long)metrics.metric(metricName).metricValue()));
    }

    private static void assertMetricHistogram(MetricsRegistry registry, com.yammer.metrics.core.MetricName metricName, long count, double sum) {
        Histogram histogram = (Histogram)registry.allMetrics().get(metricName);
        Assertions.assertEquals((long)count, (long)histogram.count());
        Assertions.assertEquals((double)sum, (double)histogram.sum(), (double)0.1);
    }

    private static com.yammer.metrics.core.MetricName yammerMetricName(String type, String name) {
        String mBeanName = String.format("kafka.coordinator.group:type=%s,name=%s", type, name);
        return new com.yammer.metrics.core.MetricName("kafka.coordinator.group", type, name, null, mBeanName);
    }

    private static MetricName kafkaMetricName(Metrics metrics, String name, String ... keyValue) {
        return metrics.metricName(name, "group-coordinator-metrics", "", keyValue);
    }

    private static void assertMetricsForTypeEqual(MetricsRegistry registry, String expectedPrefix, Set<String> expected) {
        TreeSet actual = new TreeSet();
        registry.allMetrics().forEach((name, __) -> {
            StringBuilder bld = new StringBuilder();
            bld.append(name.getGroup());
            bld.append(":type=").append(name.getType());
            bld.append(",name=").append(name.getName());
            if (bld.toString().startsWith(expectedPrefix)) {
                actual.add(bld.toString());
            }
        });
        Assertions.assertEquals(new TreeSet<String>(expected), actual);
    }
}

