/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Collections;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.metrics.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.metrics.MetricsTestUtils;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorMetricsShardTest {
    @Test
    public void testTimelineGaugeCounters() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(snapshotRegistry, tp);
        shard.incrementNumOffsets();
        shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY);
        shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING);
        shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING);
        shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE);
        shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD);
        snapshotRegistry.getOrCreateSnapshot(1000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD));
        shard.commitUpTo(1000L);
        Assertions.assertEquals((long)1L, (long)shard.numOffsets());
        Assertions.assertEquals((long)5L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD));
        shard.decrementNumOffsets();
        shard.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY);
        shard.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING);
        shard.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING);
        shard.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE);
        shard.decrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD);
        snapshotRegistry.getOrCreateSnapshot(2000L);
        shard.commitUpTo(2000L);
        Assertions.assertEquals((long)0L, (long)shard.numOffsets());
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.DEAD));
    }

    @Test
    public void testGenericGroupStateTransitionMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(new SnapshotRegistry(new LogContext()), tp);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard);
        LogContext logContext = new LogContext();
        ClassicGroup group0 = new ClassicGroup(logContext, "groupId0", ClassicGroupState.EMPTY, Time.SYSTEM, shard);
        ClassicGroup group1 = new ClassicGroup(logContext, "groupId1", ClassicGroupState.EMPTY, Time.SYSTEM, shard);
        ClassicGroup group2 = new ClassicGroup(logContext, "groupId2", ClassicGroupState.EMPTY, Time.SYSTEM, shard);
        ClassicGroup group3 = new ClassicGroup(logContext, "groupId3", ClassicGroupState.EMPTY, Time.SYSTEM, shard);
        IntStream.range(0, 4).forEach(__ -> shard.incrementNumClassicGroups(ClassicGroupState.EMPTY));
        Assertions.assertEquals((long)4L, (long)shard.numClassicGroups());
        group0.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group0.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group1.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group2.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.EMPTY));
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.PREPARING_REBALANCE));
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.DEAD));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.STABLE));
        group0.transitionTo(ClassicGroupState.STABLE);
        group1.transitionTo(ClassicGroupState.COMPLETING_REBALANCE);
        group3.transitionTo(ClassicGroupState.DEAD);
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.EMPTY));
        Assertions.assertEquals((long)0L, (long)shard.numClassicGroups(ClassicGroupState.PREPARING_REBALANCE));
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.COMPLETING_REBALANCE));
        Assertions.assertEquals((long)2L, (long)shard.numClassicGroups(ClassicGroupState.DEAD));
        Assertions.assertEquals((long)1L, (long)shard.numClassicGroups(ClassicGroupState.STABLE));
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "classic")), 4L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroups"), 4L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroupsEmpty"), 0L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroupsPreparingRebalance"), 0L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroupsCompletingRebalance"), 1L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroupsDead"), 2L);
        MetricsTestUtils.assertGaugeValue(registry, MetricsTestUtils.metricName("GroupMetadataManager", "NumGroupsStable"), 1L);
    }

    @Test
    public void testConsumerGroupStateTransitionMetrics() {
        MetricsRegistry registry = new MetricsRegistry();
        Metrics metrics = new Metrics();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TopicPartition tp = new TopicPartition("__consumer_offsets", 0);
        GroupCoordinatorMetrics coordinatorMetrics = new GroupCoordinatorMetrics(registry, metrics);
        GroupCoordinatorMetricsShard shard = coordinatorMetrics.newMetricsShard(snapshotRegistry, tp);
        coordinatorMetrics.activateMetricsShard((CoordinatorMetricsShard)shard);
        ConsumerGroup group0 = new ConsumerGroup(snapshotRegistry, "group-0", shard);
        ConsumerGroup group1 = new ConsumerGroup(snapshotRegistry, "group-1", shard);
        ConsumerGroup group2 = new ConsumerGroup(snapshotRegistry, "group-2", shard);
        ConsumerGroup group3 = new ConsumerGroup(snapshotRegistry, "group-3", shard);
        IntStream.range(0, 4).forEach(__ -> shard.incrementNumConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        snapshotRegistry.getOrCreateSnapshot(1000L);
        shard.commitUpTo(1000L);
        Assertions.assertEquals((long)4L, (long)shard.numConsumerGroups());
        Assertions.assertEquals((long)4L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        ConsumerGroupMember member0 = group0.getOrMaybeCreateMember("member-id", true);
        ConsumerGroupMember member1 = group1.getOrMaybeCreateMember("member-id", true);
        ConsumerGroupMember member2 = group2.getOrMaybeCreateMember("member-id", true);
        ConsumerGroupMember member3 = group3.getOrMaybeCreateMember("member-id", true);
        group0.updateMember(member0);
        group1.updateMember(member1);
        group2.updateMember(member2);
        group3.updateMember(member3);
        snapshotRegistry.getOrCreateSnapshot(2000L);
        shard.commitUpTo(2000L);
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)4L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        group2.setGroupEpoch(1);
        group3.setGroupEpoch(1);
        snapshotRegistry.getOrCreateSnapshot(3000L);
        shard.commitUpTo(3000L);
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)2L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)2L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        group2.setTargetAssignmentEpoch(1);
        new ConsumerGroupMember.Builder(member2).setPartitionsPendingAssignment(Collections.singletonMap(Uuid.ZERO_UUID, Collections.singleton(0))).build();
        snapshotRegistry.getOrCreateSnapshot(4000L);
        shard.commitUpTo(4000L);
        Assertions.assertEquals((long)0L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.EMPTY));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.ASSIGNING));
        Assertions.assertEquals((long)1L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.RECONCILING));
        Assertions.assertEquals((long)2L, (long)shard.numConsumerGroups(ConsumerGroup.ConsumerGroupState.STABLE));
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("group-count", "group-coordinator-metrics", Collections.singletonMap("protocol", "consumer")), 4L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.EMPTY.toString())), 0L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.ASSIGNING.toString())), 1L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.RECONCILING.toString())), 1L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.STABLE.toString())), 2L);
        MetricsTestUtils.assertGaugeValue(metrics, metrics.metricName("consumer-group-count", "group-coordinator-metrics", Collections.singletonMap("state", ConsumerGroup.ConsumerGroupState.DEAD.toString())), 0L);
    }
}

