/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VersionedMetadataTest {
    @Test
    public void testAttributes() {
        VersionedMetadata metadata = new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((short)1, (short)metadata.version());
        Assertions.assertEquals((Object)ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), (Object)metadata.metadata());
    }

    @Test
    public void testMetadataCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new VersionedMetadata(1, null));
    }

    @Test
    public void testEquals() {
        VersionedMetadata metadata = new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertEquals((Object)new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))), (Object)metadata);
        Assertions.assertNotEquals((Object)VersionedMetadata.EMPTY, (Object)metadata);
    }
}

