/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicMetadataTest {
    @Test
    public void testAttributes() {
        Uuid topicId = Uuid.randomUuid();
        Map<Integer, Set<String>> partitionRacks = RecordHelpersTest.mkMapOfPartitionRacks(15);
        TopicMetadata topicMetadata = new TopicMetadata(topicId, "foo", 15, partitionRacks);
        Assertions.assertEquals((Object)topicId, (Object)topicMetadata.id());
        Assertions.assertEquals((Object)"foo", (Object)topicMetadata.name());
        Assertions.assertEquals((int)15, (int)topicMetadata.numPartitions());
        Assertions.assertEquals(partitionRacks, (Object)topicMetadata.partitionRacks());
    }

    @Test
    public void testTopicIdAndNameCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new TopicMetadata(Uuid.randomUuid(), null, 15, Collections.emptyMap()));
        Assertions.assertThrows(NullPointerException.class, () -> new TopicMetadata(null, "foo", 15, Collections.emptyMap()));
    }

    @Test
    public void testEquals() {
        Uuid topicId = Uuid.randomUuid();
        Map<Integer, Set<String>> partitionRacks = RecordHelpersTest.mkMapOfPartitionRacks(15);
        TopicMetadata topicMetadata = new TopicMetadata(topicId, "foo", 15, partitionRacks);
        Assertions.assertEquals((Object)new TopicMetadata(topicId, "foo", 15, partitionRacks), (Object)topicMetadata);
        Assertions.assertNotEquals((Object)new TopicMetadata(topicId, "foo", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)), (Object)topicMetadata);
    }

    @Test
    public void testFromRecord() {
        Uuid topicId = Uuid.randomUuid();
        String topicName = "foo";
        ConsumerGroupPartitionMetadataValue.TopicMetadata record = new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(topicId).setTopicName(topicName).setNumPartitions(15).setPartitionMetadata(RecordHelpersTest.mkListOfPartitionRacks(15));
        Assertions.assertEquals((Object)new TopicMetadata(topicId, topicName, 15, RecordHelpersTest.mkMapOfPartitionRacks(15)), (Object)TopicMetadata.fromRecord((ConsumerGroupPartitionMetadataValue.TopicMetadata)record));
    }
}

