/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TargetAssignmentBuilder;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TargetAssignmentBuilderTest {
    @Test
    public void testCreateAssignmentMemberSpec() {
        final Uuid fooTopicId = Uuid.randomUuid();
        final Uuid barTopicId = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setRackId("rackId").setInstanceId("instanceId").build();
        HashMap<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>(){
            {
                this.put("foo", new TopicMetadata(fooTopicId, "foo", 5, Collections.emptyMap()));
                this.put("bar", new TopicMetadata(barTopicId, "bar", 5, Collections.emptyMap()));
            }
        };
        Assignment assignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        AssignmentMemberSpec assignmentMemberSpec = TargetAssignmentBuilder.createAssignmentMemberSpec((ConsumerGroupMember)member, (Assignment)assignment, (Map)subscriptionMetadata);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new AssignmentMemberSpec(Optional.of("instanceId"), Optional.of("rackId"), new HashSet<Uuid>(Arrays.asList(fooTopicId, barTopicId)), assignment.partitions()), (Object)assignmentMemberSpec);
    }

    @Test
    public void testEmpty() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20)), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyMap(), (Object)result.targetAssignment());
    }

    @Test
    public void testAssignmentHasNotChanged() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20)), (Object)result.records());
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testAssignmentSwapped() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Arrays.asList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)))), result.records().subList(0, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(2));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testNewMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        context.updateMemberSubscription("member-3", Arrays.asList("foo", "bar", "zar"));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Arrays.asList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)))), result.records().subList(0, 3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(3));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testUpdateMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.updateMemberSubscription("member-3", Arrays.asList("foo", "bar", "zar"), Optional.of("instance-id-3"), Optional.of("rack-0"));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Arrays.asList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)))), result.records().subList(0, 3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(3));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testPartialAssignmentUpdate() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, RecordHelpersTest.mkMapOfPartitionRacks(6));
        Uuid barTopicId = context.addTopicMetadata("bar", 6, RecordHelpersTest.mkMapOfPartitionRacks(6));
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5)));
        context.prepareMemberAssignment("member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Arrays.asList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-3", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6)))), result.records().subList(0, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(2));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4, 5))));
        expectedAssignment.put("member-3", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testDeleteMember() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.removeMemberSubscription("member-3");
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Arrays.asList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))), RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6)))), result.records().subList(0, 2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(2));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    @Test
    public void testStaticMemberReplace() {
        TargetAssignmentBuilderTestContext context = new TargetAssignmentBuilderTestContext("my-group", 20);
        Uuid fooTopicId = context.addTopicMetadata("foo", 6, Collections.emptyMap());
        Uuid barTopicId = context.addTopicMetadata("bar", 6, Collections.emptyMap());
        context.addGroupMember("member-1", "member-1", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.addGroupMember("member-2", "member-2", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.addGroupMember("member-3", "member-3", Arrays.asList("foo", "bar", "zar"), AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        context.removeMemberSubscription("member-3", "member-3");
        context.updateMemberSubscription("member-3-a", Arrays.asList("foo", "bar", "zar"), Optional.of("member-3"), Optional.empty());
        context.prepareMemberAssignment("member-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2)));
        context.prepareMemberAssignment("member-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4)));
        context.prepareMemberAssignment("member-3-a", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)));
        TargetAssignmentBuilder.TargetAssignmentResult result = context.build();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)result.records().size());
        Assertions.assertUnorderedListEquals(Collections.singletonList(RecordHelpers.newTargetAssignmentRecord((String)"my-group", (String)"member-3-a", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6)))), result.records().subList(0, 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"my-group", (int)20), result.records().get(1));
        HashMap<String, Assignment> expectedAssignment = new HashMap<String, Assignment>();
        expectedAssignment.put("member-1", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2))));
        expectedAssignment.put("member-2", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4), AssignmentTestUtil.mkTopicAssignment(barTopicId, 3, 4))));
        expectedAssignment.put("member-3-a", new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 5, 6), AssignmentTestUtil.mkTopicAssignment(barTopicId, 5, 6))));
        org.junit.jupiter.api.Assertions.assertEquals(expectedAssignment, (Object)result.targetAssignment());
    }

    public static class TargetAssignmentBuilderTestContext {
        private final String groupId;
        private final int groupEpoch;
        private final PartitionAssignor assignor = (PartitionAssignor)Mockito.mock(PartitionAssignor.class);
        private final Map<String, ConsumerGroupMember> members = new HashMap<String, ConsumerGroupMember>();
        private final Map<String, TopicMetadata> subscriptionMetadata = new HashMap<String, TopicMetadata>();
        private final Map<String, ConsumerGroupMember> updatedMembers = new HashMap<String, ConsumerGroupMember>();
        private final Map<String, Assignment> targetAssignment = new HashMap<String, Assignment>();
        private final Map<String, MemberAssignment> memberAssignments = new HashMap<String, MemberAssignment>();
        private final Map<String, String> staticMembers = new HashMap<String, String>();

        public TargetAssignmentBuilderTestContext(String groupId, int groupEpoch) {
            this.groupId = groupId;
            this.groupEpoch = groupEpoch;
        }

        public void addGroupMember(String memberId, List<String> subscriptions, Map<Uuid, Set<Integer>> targetPartitions) {
            this.addGroupMember(memberId, null, subscriptions, targetPartitions);
        }

        private void addGroupMember(String memberId, String instanceId, List<String> subscriptions, Map<Uuid, Set<Integer>> targetPartitions) {
            ConsumerGroupMember.Builder memberBuilder = new ConsumerGroupMember.Builder(memberId).setSubscribedTopicNames(subscriptions);
            if (instanceId != null) {
                memberBuilder.setInstanceId(instanceId);
                this.staticMembers.put(instanceId, memberId);
            }
            this.members.put(memberId, memberBuilder.build());
            this.targetAssignment.put(memberId, new Assignment(0, targetPartitions, VersionedMetadata.EMPTY));
        }

        public Uuid addTopicMetadata(String topicName, int numPartitions, Map<Integer, Set<String>> partitionRacks) {
            Uuid topicId = Uuid.randomUuid();
            this.subscriptionMetadata.put(topicName, new TopicMetadata(topicId, topicName, numPartitions, partitionRacks));
            return topicId;
        }

        public void updateMemberSubscription(String memberId, List<String> subscriptions) {
            this.updateMemberSubscription(memberId, subscriptions, Optional.empty(), Optional.empty());
        }

        public void updateMemberSubscription(String memberId, List<String> subscriptions, Optional<String> instanceId, Optional<String> rackId) {
            ConsumerGroupMember existingMember = this.members.get(memberId);
            ConsumerGroupMember.Builder builder = existingMember != null ? new ConsumerGroupMember.Builder(existingMember) : new ConsumerGroupMember.Builder(memberId);
            this.updatedMembers.put(memberId, builder.setSubscribedTopicNames(subscriptions).maybeUpdateInstanceId(instanceId).maybeUpdateRackId(rackId).build());
        }

        public void removeMemberSubscription(String memberId) {
            this.removeMemberSubscription(memberId, null);
        }

        public void removeMemberSubscription(String memberId, String instanceId) {
            this.updatedMembers.put(memberId, null);
            if (instanceId != null) {
                this.staticMembers.remove(instanceId);
            }
        }

        public void prepareMemberAssignment(String memberId, Map<Uuid, Set<Integer>> assignment) {
            this.memberAssignments.put(memberId, new MemberAssignment(assignment));
        }

        public TargetAssignmentBuilder.TargetAssignmentResult build() {
            HashMap memberSpecs = new HashMap();
            this.members.forEach((memberId, member) -> memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec((ConsumerGroupMember)member, (Assignment)this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY), this.subscriptionMetadata)));
            this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
                if (updatedMemberOrNull == null) {
                    memberSpecs.remove(memberId);
                } else {
                    ConsumerGroupMember member = this.members.get(memberId);
                    Assignment assignment = member == null && this.staticMembers.containsKey(updatedMemberOrNull.instanceId()) ? this.targetAssignment.getOrDefault(this.staticMembers.get(updatedMemberOrNull.instanceId()), Assignment.EMPTY) : this.targetAssignment.getOrDefault(memberId, Assignment.EMPTY);
                    memberSpecs.put(memberId, TargetAssignmentBuilder.createAssignmentMemberSpec((ConsumerGroupMember)updatedMemberOrNull, (Assignment)assignment, this.subscriptionMetadata));
                }
            });
            HashMap topicMetadataMap = new HashMap();
            this.subscriptionMetadata.forEach((topicName, topicMetadata) -> topicMetadataMap.put(topicMetadata.id(), topicMetadata));
            SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadataMap);
            AssignmentSpec assignmentSpec = new AssignmentSpec(memberSpecs);
            Mockito.when((Object)this.assignor.assign((AssignmentSpec)ArgumentMatchers.any(), (SubscribedTopicDescriber)ArgumentMatchers.any())).thenReturn((Object)new GroupAssignment(this.memberAssignments));
            TargetAssignmentBuilder builder = new TargetAssignmentBuilder(this.groupId, this.groupEpoch, this.assignor).withMembers(this.members).withStaticMembers(this.staticMembers).withSubscriptionMetadata(this.subscriptionMetadata).withTargetAssignment(this.targetAssignment);
            this.updatedMembers.forEach((memberId, updatedMemberOrNull) -> {
                if (updatedMemberOrNull != null) {
                    builder.addOrUpdateMember(memberId, updatedMemberOrNull);
                } else {
                    builder.removeMember(memberId);
                }
            });
            TargetAssignmentBuilder.TargetAssignmentResult result = builder.build();
            ((PartitionAssignor)Mockito.verify((Object)this.assignor, (VerificationMode)Mockito.times((int)1))).assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
            return result;
        }
    }
}

