/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SubscribedTopicMetadataTest {
    private Map<Uuid, TopicMetadata> topicMetadataMap;
    private SubscribedTopicMetadata subscribedTopicMetadata;

    @BeforeEach
    public void setUp() {
        this.topicMetadataMap = new HashMap<Uuid, TopicMetadata>();
        for (int i = 0; i < 5; ++i) {
            Uuid topicId = Uuid.randomUuid();
            String topicName = "topic" + i;
            Map<Integer, Set<String>> partitionRacks = RecordHelpersTest.mkMapOfPartitionRacks(5);
            this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, topicName, 5, partitionRacks));
        }
        this.subscribedTopicMetadata = new SubscribedTopicMetadata(this.topicMetadataMap);
    }

    @Test
    public void testAttribute() {
        Assertions.assertEquals(this.topicMetadataMap, (Object)this.subscribedTopicMetadata.topicMetadata());
    }

    @Test
    public void testTopicMetadataCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new SubscribedTopicMetadata(null));
    }

    @Test
    public void testNumberOfPartitions() {
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertEquals((int)-1, (int)this.subscribedTopicMetadata.numPartitions(topicId));
        this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, "topic6", 3, Collections.emptyMap()));
        Assertions.assertEquals((int)3, (int)this.subscribedTopicMetadata.numPartitions(topicId));
    }

    @Test
    public void testRacksForPartition() {
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertEquals(Collections.emptySet(), (Object)this.subscribedTopicMetadata.racksForPartition(topicId, 0));
        Map<Integer, Set<String>> partitionRacks = RecordHelpersTest.mkMapOfPartitionRacks(3);
        this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, "topic6", 3, partitionRacks));
        Assertions.assertEquals(Collections.emptySet(), (Object)this.subscribedTopicMetadata.racksForPartition(topicId, 4));
        Assertions.assertEquals(partitionRacks.get(2), (Object)this.subscribedTopicMetadata.racksForPartition(topicId, 2));
        topicId = Uuid.randomUuid();
        this.topicMetadataMap.put(topicId, new TopicMetadata(topicId, "topic6", 3, Collections.emptyMap()));
        Assertions.assertEquals(Collections.emptySet(), (Object)this.subscribedTopicMetadata.racksForPartition(topicId, 1));
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)new SubscribedTopicMetadata(this.topicMetadataMap), (Object)this.subscribedTopicMetadata);
        HashMap<Uuid, TopicMetadata> topicMetadataMap2 = new HashMap<Uuid, TopicMetadata>();
        Uuid topicId = Uuid.randomUuid();
        topicMetadataMap2.put(topicId, new TopicMetadata(topicId, "newTopic", 5, Collections.emptyMap()));
        Assertions.assertNotEquals((Object)new SubscribedTopicMetadata(topicMetadataMap2), (Object)this.subscribedTopicMetadata);
    }
}

