/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.CurrentAssignmentBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CurrentAssignmentBuilderTest {
    @Test
    public void testTransitionFromNewTargetToRevoke() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> 10).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)10, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5)), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8)), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromNewTargetToAssigning() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> 10).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8)), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromNewTargetToStable() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> 10).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingAssignment());
    }

    private static Stream<Arguments> ownedTopicPartitionsArguments() {
        return Stream.of(null, Collections.emptyList()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"ownedTopicPartitionsArguments"})
    public void testTransitionFromRevokeToRevoke(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).withOwnedTopicPartitions(ownedTopicPartitions).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)10, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5)), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8)), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromRevokeToAssigning() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> 10).withOwnedTopicPartitions(CurrentAssignmentBuilderTest.requestFromAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8)), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromRevokeToStable() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).withOwnedTopicPartitions(CurrentAssignmentBuilderTest.requestFromAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromRevokeToStableWhenPartitionsPendingRevocationAreReassignedBeforeBeingRevoked() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(12, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)12, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)12, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromAssigningToAssigning() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(11).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> {
            if (topicId.equals((Object)topicId1)) {
                return -1;
            }
            return 10;
        }).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8)), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromAssigningToStable() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(11).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testTransitionFromStableToStable() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(11).setPreviousMemberEpoch(11).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(11, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)updatedMember.state());
        Assertions.assertEquals((int)11, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)11, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 6, 7, 8)), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.partitionsPendingAssignment());
    }

    @Test
    public void testNewTargetRestartReconciliation() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 6))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 4, 5), AssignmentTestUtil.mkTopicAssignment(topicId2, 7, 8))).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)member.state());
        Assignment targetAssignment = new Assignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 6, 7, 8), AssignmentTestUtil.mkTopicAssignment(topicId2, 9, 10, 11)));
        ConsumerGroupMember updatedMember = new CurrentAssignmentBuilder(member).withTargetAssignment(12, targetAssignment).withCurrentPartitionEpoch((topicId, partitionId) -> -1).build();
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)updatedMember.state());
        Assertions.assertEquals((int)10, (int)updatedMember.previousMemberEpoch());
        Assertions.assertEquals((int)10, (int)updatedMember.memberEpoch());
        Assertions.assertEquals((int)12, (int)updatedMember.targetMemberEpoch());
        Assertions.assertEquals(Collections.emptyMap(), (Object)updatedMember.assignedPartitions());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)updatedMember.partitionsPendingRevocation());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 6, 7, 8), AssignmentTestUtil.mkTopicAssignment(topicId2, 9, 10, 11)), (Object)updatedMember.partitionsPendingAssignment());
    }

    private static List<ConsumerGroupHeartbeatRequestData.TopicPartitions> requestFromAssignment(Map<Uuid, Set<Integer>> assignment) {
        ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions> topicPartitions = new ArrayList<ConsumerGroupHeartbeatRequestData.TopicPartitions>();
        assignment.forEach((topicId, partitions) -> {
            ConsumerGroupHeartbeatRequestData.TopicPartitions topic = new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(topicId).setPartitions(new ArrayList(partitions));
            topicPartitions.add(topic);
        });
        return topicPartitions;
    }
}

