/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConsumerGroupTest {
    private ConsumerGroup createConsumerGroup(String groupId) {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        return new ConsumerGroup(snapshotRegistry, groupId, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
    }

    @Test
    public void testGetOrCreateMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member-id", true);
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        member = consumerGroup.getOrMaybeCreateMember("member-id", false);
        Assertions.assertEquals((Object)"member-id", (Object)member.memberId());
        Assertions.assertThrows(UnknownMemberIdException.class, () -> consumerGroup.getOrMaybeCreateMember("does-not-exist", false));
    }

    @Test
    public void testUpdateMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        member = new ConsumerGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((Object)member, (Object)consumerGroup.getOrMaybeCreateMember("member", false));
    }

    @Test
    public void testNoStaticMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.getOrMaybeCreateMember("member", true);
        Assertions.assertNull((Object)consumerGroup.staticMember("instance-id"));
    }

    @Test
    public void testGetStaticMemberByInstanceId() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        member = new ConsumerGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setInstanceId("instance").build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((Object)member, (Object)consumerGroup.staticMember("instance"));
        Assertions.assertEquals((Object)member, (Object)consumerGroup.getOrMaybeCreateMember("member", false));
        Assertions.assertEquals((Object)member.memberId(), (Object)consumerGroup.staticMemberId("instance"));
    }

    @Test
    public void testRemoveMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.getOrMaybeCreateMember("member", true);
        Assertions.assertTrue((boolean)consumerGroup.hasMember("member"));
        consumerGroup.removeMember("member");
        Assertions.assertFalse((boolean)consumerGroup.hasMember("member"));
    }

    @Test
    public void testRemoveStaticMember() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = consumerGroup.getOrMaybeCreateMember("member", true);
        Assertions.assertTrue((boolean)consumerGroup.hasMember("member"));
        member = new ConsumerGroupMember.Builder(member).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setInstanceId("instance").build();
        consumerGroup.updateMember(member);
        consumerGroup.removeMember("member");
        Assertions.assertFalse((boolean)consumerGroup.hasMember("member"));
        Assertions.assertNull((Object)consumerGroup.staticMember("instance"));
        Assertions.assertNull((Object)consumerGroup.staticMemberId("instance"));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpoch() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(zarTopicId, 7, 8, 9))).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 2));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 3));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 4));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 5));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 6));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 7));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 8));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 9));
        member = new ConsumerGroupMember.Builder(member).setMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(zarTopicId, 4, 5, 6))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 7, 8, 9))).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 1));
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 2));
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(barTopicId, 3));
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 4));
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 5));
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 6));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 7));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 8));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 9));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpochWhenPartitionIsReassignedBeforeBeingRevoked() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(Collections.emptyMap()).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        member = new ConsumerGroupMember.Builder(member).setMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).setPartitionsPendingRevocation(Collections.emptyMap()).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((int)11, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
    }

    @Test
    public void testUpdatingMemberUpdatesPartitionEpochWhenPartitionIsNotReleased() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember m1 = new ConsumerGroupMember.Builder("m1").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(m1);
        ConsumerGroupMember m2 = new ConsumerGroupMember.Builder("m2").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.updateMember(m2));
    }

    @Test
    public void testRemovePartitionEpochs() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.removePartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 10));
        ConsumerGroupMember m1 = new ConsumerGroupMember.Builder("m1").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build();
        consumerGroup.updateMember(m1);
        Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.removePartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 11));
    }

    @Test
    public void testAddPartitionEpochs() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        consumerGroup.addPartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 10);
        Assertions.assertThrows(IllegalStateException.class, () -> consumerGroup.addPartitionEpochs(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1)), 11));
    }

    @Test
    public void testDeletingMemberRemovesPartitionEpoch() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 4, 5, 6))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(zarTopicId, 7, 8, 9))).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 1));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 2));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 3));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 4));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 5));
        Assertions.assertEquals((int)10, (int)consumerGroup.currentPartitionEpoch(barTopicId, 6));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 7));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 8));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 9));
        consumerGroup.removeMember(member.memberId());
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 1));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 2));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(barTopicId, 3));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 4));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 5));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(zarTopicId, 6));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 7));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 8));
        Assertions.assertEquals((int)-1, (int)consumerGroup.currentPartitionEpoch(fooTopicId, 9));
    }

    @Test
    public void testGroupState() {
        Uuid fooTopicId = Uuid.randomUuid();
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setMemberEpoch(1).setPreviousMemberEpoch(0).setTargetMemberEpoch(1).build();
        consumerGroup.updateMember(member1);
        consumerGroup.setGroupEpoch(1);
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member1.state());
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setMemberEpoch(1).setPreviousMemberEpoch(0).setTargetMemberEpoch(1).build();
        consumerGroup.updateMember(member2);
        consumerGroup.setGroupEpoch(2);
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member2.state());
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        consumerGroup.setTargetAssignmentEpoch(2);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member1 = new ConsumerGroupMember.Builder(member1).setMemberEpoch(2).setPreviousMemberEpoch(1).setTargetMemberEpoch(2).build();
        consumerGroup.updateMember(member1);
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member1.state());
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member2 = new ConsumerGroupMember.Builder(member2).setMemberEpoch(2).setPreviousMemberEpoch(1).setTargetMemberEpoch(2).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).build();
        consumerGroup.updateMember(member2);
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)member2.state());
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        member2 = new ConsumerGroupMember.Builder(member2).setMemberEpoch(2).setPreviousMemberEpoch(1).setTargetMemberEpoch(2).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).setPartitionsPendingAssignment(Collections.emptyMap()).build();
        consumerGroup.updateMember(member2);
        Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)member2.state());
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)consumerGroup.state());
        consumerGroup.removeMember("member1");
        consumerGroup.removeMember("member2");
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
    }

    @Test
    public void testGroupTypeFromString() {
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"classic"), (Object)Group.GroupType.CLASSIC);
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"Consumer"), (Object)Group.GroupType.CONSUMER);
        Assertions.assertEquals((Object)Group.GroupType.parse((String)"Invalid"), (Object)Group.GroupType.UNKNOWN);
    }

    @Test
    public void testPreferredServerAssignor() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setServerAssignorName("range").build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setServerAssignorName("range").build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setServerAssignorName("uniform").build();
        Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.preferredServerAssignor());
        Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.computePreferredServerAssignor(null, member1));
        consumerGroup.updateMember(member1);
        Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.computePreferredServerAssignor(member1, null));
        Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.computePreferredServerAssignor(null, member2));
        consumerGroup.updateMember(member2);
        Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        consumerGroup.updateMember(member3);
        Assertions.assertEquals(Optional.of("range"), (Object)consumerGroup.preferredServerAssignor());
        ConsumerGroupMember updatedMember1 = new ConsumerGroupMember.Builder("member1").setServerAssignorName(null).build();
        ConsumerGroupMember updatedMember2 = new ConsumerGroupMember.Builder("member2").setServerAssignorName(null).build();
        ConsumerGroupMember updatedMember3 = new ConsumerGroupMember.Builder("member3").setServerAssignorName(null).build();
        Optional assignor = consumerGroup.computePreferredServerAssignor(member1, updatedMember1);
        Assertions.assertTrue((assignor.equals(Optional.of("range")) || assignor.equals(Optional.of("uniform")) ? 1 : 0) != 0);
        consumerGroup.updateMember(updatedMember1);
        Assertions.assertEquals(Optional.of("uniform"), (Object)consumerGroup.computePreferredServerAssignor(member2, updatedMember2));
        consumerGroup.updateMember(updatedMember2);
        Assertions.assertEquals(Optional.of("uniform"), (Object)consumerGroup.preferredServerAssignor());
        Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.computePreferredServerAssignor(member3, updatedMember3));
        consumerGroup.updateMember(updatedMember3);
        Assertions.assertEquals(Optional.empty(), (Object)consumerGroup.preferredServerAssignor());
    }

    @Test
    public void testUpdateSubscriptionMetadata() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        Uuid zarTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addTopic(zarTopicId, "zar", 3).addRacks().build();
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ConsumerGroupMember member3 = new ConsumerGroupMember.Builder("member3").setSubscribedTopicNames(Collections.singletonList("zar")).build();
        ConsumerGroup consumerGroup = this.createConsumerGroup("group-foo");
        Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.computeSubscriptionMetadata(null, null, image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, member1, image.topics(), image.cluster()));
        consumerGroup.updateMember(member1);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, null, image.topics(), image.cluster()));
        Assertions.assertEquals(Collections.emptyMap(), (Object)consumerGroup.computeSubscriptionMetadata(member1, null, image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1))), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, member2, image.topics(), image.cluster()));
        consumerGroup.updateMember(member2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1))), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, null, image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1)))}), (Object)consumerGroup.computeSubscriptionMetadata(member2, null, image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)))}), (Object)consumerGroup.computeSubscriptionMetadata(member1, null, image.topics(), image.cluster()));
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1))), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2))), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, member3, image.topics(), image.cluster()));
        consumerGroup.updateMember(member3);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1))), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2))), Utils.mkEntry((Object)"zar", (Object)new TopicMetadata(zarTopicId, "zar", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, null, image.topics(), image.cluster()));
    }

    @Test
    public void testMetadataRefreshDeadline() {
        MockTime time = new MockTime();
        ConsumerGroup group = this.createConsumerGroup("group-foo");
        Assertions.assertEquals((int)0, (int)group.groupEpoch());
        Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)group.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)0, (int)group.metadataRefreshDeadline().epoch);
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch());
        Assertions.assertFalse((boolean)group.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)group.groupEpoch(), (int)group.metadataRefreshDeadline().epoch);
        time.sleep(1001L);
        Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch() + 1);
        Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)(group.groupEpoch() + 1), (int)group.metadataRefreshDeadline().epoch);
        group.setGroupEpoch(group.groupEpoch() + 1);
        group.setMetadataRefreshDeadline(time.milliseconds() + 1000L, group.groupEpoch());
        Assertions.assertFalse((boolean)group.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)(time.milliseconds() + 1000L), (long)group.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)group.groupEpoch(), (int)group.metadataRefreshDeadline().epoch);
        group.requestMetadataRefresh();
        Assertions.assertTrue((boolean)group.hasMetadataExpired(time.milliseconds()));
        Assertions.assertEquals((long)0L, (long)group.metadataRefreshDeadline().deadlineMs);
        Assertions.assertEquals((int)0, (int)group.metadataRefreshDeadline().epoch);
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testValidateOffsetCommit(boolean isTransactional) {
        ConsumerGroup group = this.createConsumerGroup("group-foo");
        group.validateOffsetCommit("", "", -1, isTransactional);
        Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("member-id", null, 0, isTransactional));
        group.getOrMaybeCreateMember("member-id", true);
        Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetCommit("", "", -1, isTransactional));
        Assertions.assertThrows(StaleMemberEpochException.class, () -> group.validateOffsetCommit("member-id", "", 10, isTransactional));
        group.validateOffsetCommit("member-id", "", 0, isTransactional);
    }

    @Test
    public void testAsListedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        GroupCoordinatorMetricsShard metricsShard = new GroupCoordinatorMetricsShard(snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0));
        ConsumerGroup group = new ConsumerGroup(snapshotRegistry, "group-foo", metricsShard);
        snapshotRegistry.getOrCreateSnapshot(0L);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.getOrCreateSnapshot(1L);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE.toString(), (Object)group.stateAsString(1L));
    }

    @Test
    public void testValidateOffsetFetch() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConsumerGroup group = new ConsumerGroup(snapshotRegistry, "group-foo", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        group.validateOffsetFetch(null, -1, Long.MAX_VALUE);
        Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetFetch("member-id", 0, Long.MAX_VALUE));
        snapshotRegistry.getOrCreateSnapshot(0L);
        group.getOrMaybeCreateMember("member-id", true);
        Assertions.assertThrows(UnknownMemberIdException.class, () -> group.validateOffsetFetch("member-id", 0, 0L));
        Assertions.assertThrows(StaleMemberEpochException.class, () -> group.validateOffsetFetch("member-id", 10, Long.MAX_VALUE));
        group.validateOffsetFetch("member-id", 0, Long.MAX_VALUE);
    }

    @Test
    public void testValidateDeleteGroup() {
        ConsumerGroup consumerGroup = this.createConsumerGroup("foo");
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        Assertions.assertDoesNotThrow(() -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setMemberEpoch(1).setPreviousMemberEpoch(0).setTargetMemberEpoch(1).build();
        consumerGroup.updateMember(member1);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        consumerGroup.setGroupEpoch(1);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
        consumerGroup.setTargetAssignmentEpoch(1);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)consumerGroup.state());
        Assertions.assertThrows(GroupNotEmptyException.class, () -> ((ConsumerGroup)consumerGroup).validateDeleteGroup());
    }

    @Test
    public void testOffsetExpirationCondition() {
        long currentTimestamp = 30000L;
        long commitTimestamp = 20000L;
        long offsetsRetentionMs = 10000L;
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(15000L, OptionalInt.empty(), "", commitTimestamp, OptionalLong.empty());
        ConsumerGroup group = new ConsumerGroup(new SnapshotRegistry(new LogContext()), "group-id", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        Optional offsetExpirationCondition = group.offsetExpirationCondition();
        Assertions.assertTrue((boolean)offsetExpirationCondition.isPresent());
        OffsetExpirationConditionImpl condition = (OffsetExpirationConditionImpl)offsetExpirationCondition.get();
        Assertions.assertEquals((long)commitTimestamp, (Long)((Long)condition.baseTimestamp().apply(offsetAndMetadata)));
        Assertions.assertTrue((boolean)condition.isOffsetExpired(offsetAndMetadata, currentTimestamp, offsetsRetentionMs));
    }

    @Test
    public void testIsSubscribedToTopic() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        MetadataImage image = new MetadataImageBuilder().addTopic(fooTopicId, "foo", 1).addTopic(barTopicId, "bar", 2).addRacks().build();
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder("member2").setSubscribedTopicNames(Collections.singletonList("bar")).build();
        ConsumerGroup consumerGroup = this.createConsumerGroup("group-foo");
        consumerGroup.updateMember(member1);
        consumerGroup.updateMember(member2);
        Assertions.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"foo", (Object)new TopicMetadata(fooTopicId, "foo", 1, RecordHelpersTest.mkMapOfPartitionRacks(1))), Utils.mkEntry((Object)"bar", (Object)new TopicMetadata(barTopicId, "bar", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)))}), (Object)consumerGroup.computeSubscriptionMetadata(null, null, image.topics(), image.cluster()));
        Assertions.assertTrue((boolean)consumerGroup.isSubscribedToTopic("foo"));
        Assertions.assertTrue((boolean)consumerGroup.isSubscribedToTopic("bar"));
        consumerGroup.removeMember("member1");
        Assertions.assertFalse((boolean)consumerGroup.isSubscribedToTopic("foo"));
        consumerGroup.removeMember("member2");
        Assertions.assertFalse((boolean)consumerGroup.isSubscribedToTopic("bar"));
    }

    @Test
    public void testAsDescribedGroup() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        ConsumerGroup group = new ConsumerGroup(snapshotRegistry, "group-id-1", (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        snapshotRegistry.getOrCreateSnapshot(0L);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY.toString(), (Object)group.stateAsString(0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).setServerAssignorName("assignorName").build());
        group.updateMember(new ConsumerGroupMember.Builder("member2").build());
        snapshotRegistry.getOrCreateSnapshot(1L);
        ConsumerGroupDescribeResponseData.DescribedGroup expected = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id-1").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupEpoch(0).setAssignmentEpoch(0).setAssignorName("assignorName").setMembers(Arrays.asList(new ConsumerGroupDescribeResponseData.Member().setMemberId("member1").setSubscribedTopicNames(Collections.singletonList("foo")).setSubscribedTopicRegex(""), new ConsumerGroupDescribeResponseData.Member().setMemberId("member2").setSubscribedTopicRegex("")));
        ConsumerGroupDescribeResponseData.DescribedGroup actual = group.asDescribedGroup(1L, "", new MetadataImageBuilder().build().topics());
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testStateTransitionMetrics() {
        GroupCoordinatorMetricsShard metrics = (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class);
        ConsumerGroup consumerGroup = new ConsumerGroup(new SnapshotRegistry(new LogContext()), "group-id", metrics);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)0))).onConsumerGroupStateTransition(null, ConsumerGroup.ConsumerGroupState.EMPTY);
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member").setMemberEpoch(1).setPreviousMemberEpoch(0).setTargetMemberEpoch(1).build();
        consumerGroup.updateMember(member);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)consumerGroup.state());
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.EMPTY, ConsumerGroup.ConsumerGroupState.RECONCILING);
        consumerGroup.setGroupEpoch(1);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)consumerGroup.state());
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.RECONCILING, ConsumerGroup.ConsumerGroupState.ASSIGNING);
        consumerGroup.setTargetAssignmentEpoch(1);
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)consumerGroup.state());
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.ASSIGNING, ConsumerGroup.ConsumerGroupState.STABLE);
        consumerGroup.removeMember("member");
        Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)consumerGroup.state());
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.STABLE, ConsumerGroup.ConsumerGroupState.EMPTY);
    }

    @Test
    public void testIsInStatesCaseInsensitive() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        GroupCoordinatorMetricsShard metricsShard = new GroupCoordinatorMetricsShard(snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0));
        ConsumerGroup group = new ConsumerGroup(snapshotRegistry, "group-foo", metricsShard);
        snapshotRegistry.getOrCreateSnapshot(0L);
        Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("empty"), 0L));
        Assertions.assertFalse((boolean)group.isInStates(Collections.singleton("Empty"), 0L));
        group.updateMember(new ConsumerGroupMember.Builder("member1").setSubscribedTopicNames(Collections.singletonList("foo")).build());
        snapshotRegistry.getOrCreateSnapshot(1L);
        Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("empty"), 0L));
        Assertions.assertTrue((boolean)group.isInStates(Collections.singleton("stable"), 1L));
        Assertions.assertFalse((boolean)group.isInStates(Collections.singleton("empty"), 1L));
    }
}

