/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;

public class ConsumerGroupBuilder {
    private final String groupId;
    private final int groupEpoch;
    private int assignmentEpoch;
    private final Map<String, ConsumerGroupMember> members = new HashMap<String, ConsumerGroupMember>();
    private final Map<String, Assignment> assignments = new HashMap<String, Assignment>();
    private Map<String, TopicMetadata> subscriptionMetadata;

    public ConsumerGroupBuilder(String groupId, int groupEpoch) {
        this.groupId = groupId;
        this.groupEpoch = groupEpoch;
        this.assignmentEpoch = 0;
    }

    public ConsumerGroupBuilder withMember(ConsumerGroupMember member) {
        this.members.put(member.memberId(), member);
        return this;
    }

    public ConsumerGroupBuilder withSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscriptionMetadata = subscriptionMetadata;
        return this;
    }

    public ConsumerGroupBuilder withAssignment(String memberId, Map<Uuid, Set<Integer>> assignment) {
        this.assignments.put(memberId, new Assignment(assignment));
        return this;
    }

    public ConsumerGroupBuilder withAssignmentEpoch(int assignmentEpoch) {
        this.assignmentEpoch = assignmentEpoch;
        return this;
    }

    public List<Record> build(TopicsImage topicsImage) {
        ArrayList<Record> records = new ArrayList<Record>();
        this.members.forEach((memberId, member) -> records.add(RecordHelpers.newMemberSubscriptionRecord((String)this.groupId, (ConsumerGroupMember)member)));
        if (this.subscriptionMetadata == null) {
            this.subscriptionMetadata = new HashMap<String, TopicMetadata>();
            this.members.forEach((memberId, member) -> member.subscribedTopicNames().forEach(topicName -> {
                TopicImage topicImage = topicsImage.getTopic(topicName);
                if (topicImage != null) {
                    this.subscriptionMetadata.put((String)topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size(), Collections.emptyMap()));
                }
            }));
        }
        if (!this.subscriptionMetadata.isEmpty()) {
            records.add(RecordHelpers.newGroupSubscriptionMetadataRecord((String)this.groupId, this.subscriptionMetadata));
        }
        records.add(RecordHelpers.newGroupEpochRecord((String)this.groupId, (int)this.groupEpoch));
        this.assignments.forEach((memberId, assignment) -> records.add(RecordHelpers.newTargetAssignmentRecord((String)this.groupId, (String)memberId, (Map)assignment.partitions())));
        records.add(RecordHelpers.newTargetAssignmentEpochRecord((String)this.groupId, (int)this.assignmentEpoch));
        this.members.forEach((memberId, member) -> records.add(RecordHelpers.newCurrentAssignmentRecord((String)this.groupId, (ConsumerGroupMember)member)));
        return records;
    }
}

