/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.coordinator.group.consumer.ClientAssignor;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientAssignorTest {
    @Test
    public void testNameAndMetadataCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new ClientAssignor("range", 2, 5, 10, null));
        Assertions.assertThrows(NullPointerException.class, () -> new ClientAssignor(null, 2, 5, 10, new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)))));
    }

    @Test
    public void testAttributes() {
        ClientAssignor clientAssignor = new ClientAssignor("range", 2, 5, 10, new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))));
        Assertions.assertEquals((Object)"range", (Object)clientAssignor.name());
        Assertions.assertEquals((byte)2, (byte)clientAssignor.reason());
        Assertions.assertEquals((short)5, (short)clientAssignor.minimumVersion());
        Assertions.assertEquals((short)10, (short)clientAssignor.maximumVersion());
        Assertions.assertEquals((Object)new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))), (Object)clientAssignor.metadata());
    }

    @Test
    public void testFromRecord() {
        ConsumerGroupMemberMetadataValue.Assignor record = new ConsumerGroupMemberMetadataValue.Assignor().setName("range").setReason((byte)2).setMinimumVersion((short)5).setMaximumVersion((short)10).setVersion((short)8).setMetadata("hello".getBytes(StandardCharsets.UTF_8));
        ClientAssignor clientAssignor = ClientAssignor.fromRecord((ConsumerGroupMemberMetadataValue.Assignor)record);
        Assertions.assertEquals((Object)"range", (Object)clientAssignor.name());
        Assertions.assertEquals((byte)2, (byte)clientAssignor.reason());
        Assertions.assertEquals((short)5, (short)clientAssignor.minimumVersion());
        Assertions.assertEquals((short)10, (short)clientAssignor.maximumVersion());
        Assertions.assertEquals((Object)new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))), (Object)clientAssignor.metadata());
    }

    @Test
    public void testEquals() {
        ClientAssignor clientAssignor = new ClientAssignor("range", 2, 5, 10, new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8))));
        Assertions.assertEquals((Object)new ClientAssignor("range", 2, 5, 10, new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)))), (Object)clientAssignor);
        Assertions.assertNotEquals((Object)new ClientAssignor("uniform", 2, 5, 10, new VersionedMetadata(8, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)))), (Object)clientAssignor);
    }
}

