/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AssignmentTest {
    @Test
    public void testPartitionsAndMetadataCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Assignment(1, null, new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)))));
        Assertions.assertThrows(NullPointerException.class, () -> new Assignment(1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 1, 2, 3)), null));
    }

    @Test
    public void testAttributes() {
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 1, 2, 3));
        VersionedMetadata metadata = new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        Assignment assignment = new Assignment(1, partitions, metadata);
        Assertions.assertEquals((byte)1, (byte)assignment.error());
        Assertions.assertEquals(partitions, (Object)assignment.partitions());
        Assertions.assertEquals((Object)metadata, (Object)assignment.metadata());
    }

    @Test
    public void testFromTargetAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition> partitions = new ArrayList<ConsumerGroupTargetAssignmentMemberValue.TopicPartition>();
        partitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId1).setPartitions(Arrays.asList(1, 2, 3)));
        partitions.add(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId2).setPartitions(Arrays.asList(4, 5, 6)));
        ConsumerGroupTargetAssignmentMemberValue record = new ConsumerGroupTargetAssignmentMemberValue().setError((byte)1).setTopicPartitions(partitions).setMetadataVersion((short)2).setMetadataBytes("foo".getBytes(StandardCharsets.UTF_8));
        Assignment assignment = Assignment.fromRecord((ConsumerGroupTargetAssignmentMemberValue)record);
        Assertions.assertEquals((short)1, (short)assignment.error());
        Assertions.assertEquals(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(topicId2, 4, 5, 6)), (Object)assignment.partitions());
        Assertions.assertEquals((Object)new VersionedMetadata(2, ByteBuffer.wrap("foo".getBytes(StandardCharsets.UTF_8))), (Object)assignment.metadata());
    }

    @Test
    public void testEquals() {
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(Uuid.randomUuid(), 1, 2, 3));
        VersionedMetadata metadata = new VersionedMetadata(1, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)));
        Assignment assignment = new Assignment(1, partitions, metadata);
        Assertions.assertEquals((Object)new Assignment(1, partitions, metadata), (Object)assignment);
        Assertions.assertNotEquals((Object)new Assignment(1, Collections.emptyMap(), metadata), (Object)assignment);
    }
}

