/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RangeAssignorTest {
    private final RangeAssignor assignor = new RangeAssignor();
    private final Uuid topic1Uuid = Uuid.randomUuid();
    private final String topic1Name = "topic1";
    private final Uuid topic2Uuid = Uuid.randomUuid();
    private final String topic2Name = "topic2";
    private final Uuid topic3Uuid = Uuid.randomUuid();
    private final String topic3Name = "topic3";
    private final String consumerA = "A";
    private final String consumerB = "B";
    private final String consumerC = "C";

    @Test
    public void testOneConsumerNoTopic() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3))));
        Map<String, AssignmentMemberSpec> members = Collections.singletonMap("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment groupAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testOneConsumerSubscribedToNonExistentTopic() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3))));
        Map<String, AssignmentMemberSpec> members = Collections.singletonMap("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoConsumersTwoTopicsSameSubscriptions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RangeAssignorTest.createPartitionRacks(2)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeConsumersThreeTopicsDifferentSubscriptions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RangeAssignorTest.createPartitionRacks(2)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumConsumersGreaterThanNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RangeAssignorTest.createPartitionRacks(2)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentNumConsumersGreaterThanNumPartitionsWhenOneConsumerAdded() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2, RangeAssignorTest.createPartitionRacks(2)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2, RangeAssignorTest.createPartitionRacks(2)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        Assertions.assertNull(computedAssignment.members().get("C"));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOnePartitionAddedForTwoConsumersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 4, RangeAssignorTest.createPartitionRacks(4)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 4, RangeAssignorTest.createPartitionRacks(4)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2, 3)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneConsumerAddedAfterInitialAssignmentWithTwoConsumersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RangeAssignorTest.createPartitionRacks(3)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneConsumerAddedAndOnePartitionAfterInitialAssignmentWithTwoConsumersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 4, RangeAssignorTest.createPartitionRacks(4)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RangeAssignorTest.createPartitionRacks(3)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 3)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneConsumerRemovedAfterInitialAssignmentWithTwoConsumersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RangeAssignorTest.createPartitionRacks(3)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenMultipleSubscriptionsRemovedAfterInitialAssignmentWithThreeConsumersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RangeAssignorTest.createPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RangeAssignorTest.createPartitionRacks(2)));
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), currentAssignmentForB));
        Map<Uuid, Set<Integer>> currentAssignmentForC = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), currentAssignmentForC));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        this.assertAssignment(expectedAssignment, computedAssignment);
    }

    private void assertAssignment(Map<String, Map<Uuid, Set<Integer>>> expectedAssignment, GroupAssignment computedGroupAssignment) {
        Assertions.assertEquals((int)expectedAssignment.size(), (int)computedGroupAssignment.members().size());
        for (String memberId : computedGroupAssignment.members().keySet()) {
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(memberId)).targetPartitions();
            Assertions.assertEquals(expectedAssignment.get(memberId), (Object)computedAssignmentForMember);
        }
    }

    private static Map<Integer, Set<String>> createPartitionRacks(int numPartitions) {
        HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>(numPartitions);
        Set emptySet = Collections.emptySet();
        for (int i = 0; i < numPartitions; ++i) {
            partitionRacks.put(i, emptySet);
        }
        return partitionRacks;
    }
}

