/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptimizedUniformAssignmentBuilderTest {
    private final UniformAssignor assignor = new UniformAssignor();
    private final Uuid topic1Uuid = Uuid.fromString((String)"T1-A4s3VTwiI5CTbEp6POw");
    private final Uuid topic2Uuid = Uuid.fromString((String)"T2-B4s3VTwiI5YHbPp6YUe");
    private final Uuid topic3Uuid = Uuid.fromString((String)"T3-CU8fVTLCz5YMkLoDQsa");
    private final String topic1Name = "topic1";
    private final String topic2Name = "topic2";
    private final String topic3Name = "topic3";
    private final String memberA = "A";
    private final String memberB = "B";
    private final String memberC = "C";

    @Test
    public void testOneMemberNoTopicSubscription() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3))));
        Map<String, AssignmentMemberSpec> members = Collections.singletonMap("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment groupAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testOneMemberSubscribedToNonexistentTopic() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3))));
        Map<String, AssignmentMemberSpec> members = Collections.singletonMap("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopicsNoMemberRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopicsNoPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, Collections.emptyMap()));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, Collections.emptyMap()));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack3"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsWithMemberAndPartitionRacks2() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsWithSomeMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, Collections.emptyMap()));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumMembersGreaterThanTotalNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 1)));
        expectedAssignment.put("C", Collections.emptyMap());
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testValidityAndBalanceForLargeSampleSet() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        for (int i = 1; i < 100; ++i) {
            Uuid topicId = Uuid.randomUuid();
            topicMetadata.put(topicId, new TopicMetadata(topicId, "topic-" + i, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        }
        ArrayList subscribedTopics = new ArrayList(topicMetadata.keySet());
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        for (int i = 1; i < 50; ++i) {
            members.put("member" + i, new AssignmentMemberSpec(Optional.empty(), Optional.empty(), subscribedTopics, Collections.emptyMap()));
        }
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentForTwoMembersTwoTopicsGivenUnbalancedPrevAssignment() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentOnRackChangesWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 0)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentOnAddingPartitionsWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 3, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 4, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 4)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenPartitionsAreAddedForTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 3, 5), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 4), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2, 3)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentOnAddingMemberWithRackAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberRemovedAfterInitialAssignmentWithThreeMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 4), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Collections.singletonList(this.topic1Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 3)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
        this.checkValidityAndBalance(members, computedAssignment);
    }

    private void checkValidityAndBalance(Map<String, AssignmentMemberSpec> members, GroupAssignment computedGroupAssignment) {
        ArrayList membersList = new ArrayList(computedGroupAssignment.members().keySet());
        int numMembers = membersList.size();
        ArrayList totalAssignmentSizesOfAllMembers = new ArrayList(membersList.size());
        membersList.forEach(member -> {
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(member)).targetPartitions();
            int sum = computedAssignmentForMember.values().stream().mapToInt(Set::size).sum();
            totalAssignmentSizesOfAllMembers.add(sum);
        });
        for (int i = 0; i < numMembers; ++i) {
            String memberId = (String)membersList.get(i);
            Map computedAssignmentForMember = ((MemberAssignment)computedGroupAssignment.members().get(memberId)).targetPartitions();
            computedAssignmentForMember.keySet().forEach(topicId -> Assertions.assertTrue((boolean)((AssignmentMemberSpec)members.get(memberId)).subscribedTopicIds().contains(topicId), (String)("Error: Partitions for topic " + topicId + " are assigned to member " + memberId + " but it is not part of the members subscription ")));
            for (int j = i + 1; j < numMembers; ++j) {
                String otherMemberId = (String)membersList.get(j);
                Map computedAssignmentForOtherMember = ((MemberAssignment)computedGroupAssignment.members().get(otherMemberId)).targetPartitions();
                computedAssignmentForMember.keySet().forEach(topicId -> {
                    HashSet intersection = new HashSet();
                    if (computedAssignmentForOtherMember.containsKey(topicId)) {
                        intersection = new HashSet((Collection)computedAssignmentForMember.get(topicId));
                        intersection.retainAll((Collection)computedAssignmentForOtherMember.get(topicId));
                    }
                    Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error : Member 1 " + memberId + " and Member 2 " + otherMemberId + "have common partitions assigned to them " + computedAssignmentForOtherMember.get(topicId)));
                });
                int size1 = (Integer)totalAssignmentSizesOfAllMembers.get(i);
                int size2 = (Integer)totalAssignmentSizesOfAllMembers.get(j);
                Assertions.assertTrue((Math.abs(size1 - size2) <= 1 ? 1 : 0) != 0, (String)("Size of one assignment is greater than the other assignment by more than one partition " + size1 + " " + size2 + "abs = " + Math.abs(size1 - size2)));
            }
        }
    }
}

