/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.assignor.AssignmentMemberSpec;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.consumer.SubscribedTopicMetadata;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeneralUniformAssignmentBuilderTest {
    private final UniformAssignor assignor = new UniformAssignor();
    private final Uuid topic1Uuid = Uuid.fromString((String)"T1-A4s3VTwiI5CTbEp6POw");
    private final Uuid topic2Uuid = Uuid.fromString((String)"T2-B4s3VTwiI5YHbPp6YUe");
    private final Uuid topic3Uuid = Uuid.fromString((String)"T3-CU8fVTLCz5YMkLoDQsa");
    private final Uuid topic4Uuid = Uuid.fromString((String)"T4-Tw9fVTLCz5HbPp6YQsa");
    private final String topic1Name = "topic1";
    private final String topic2Name = "topic2";
    private final String topic3Name = "topic3";
    private final String topic4Name = "topic4";
    private final String memberA = "A";
    private final String memberB = "B";
    private final String memberC = "C";

    @Test
    public void testTwoMembersNoTopicSubscription() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3))));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.emptyList(), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        GroupAssignment groupAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        Assertions.assertEquals(Collections.emptyMap(), (Object)groupAssignment.members());
    }

    @Test
    public void testTwoMembersSubscribedToNonexistentTopics() {
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(Collections.singletonMap(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3))));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        Assertions.assertThrows(PartitionAssignorException.class, () -> this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata));
    }

    @Test
    public void testFirstAssignmentTwoMembersTwoTopicsNoMemberRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 3, 5)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 4)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsNoPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, Collections.emptyMap()));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 8, Collections.emptyMap()));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, Collections.emptyMap()));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Collections.singletonList(this.topic2Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack3"), Arrays.asList(this.topic1Uuid, this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2, 4, 6), AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 3, 5, 7)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2, 3, 5), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Collections.singletonList(this.topic1Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack3"), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentThreeMembersThreeTopicsWithSomeMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 2, Collections.emptyMap()));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic2Uuid, this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Collections.singletonList(this.topic2Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testFirstAssignmentNumMembersGreaterThanTotalNumPartitions() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 1, RecordHelpersTest.mkMapOfPartitionRacks(1)));
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic3Uuid), Collections.emptyMap()));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0)));
        expectedAssignment.put("B", Collections.emptyMap());
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentForTwoMembersThreeTopicsGivenUnbalancedPrevAssignment() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 4, RecordHelpersTest.mkMapOfPartitionRacks(4)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 4, RecordHelpersTest.mkMapOfPartitionRacks(4)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForC = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 4, 5), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3)));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid), currentAssignmentForC));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 5), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentOnRackChangesWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic3Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentOnAddingPartitionsWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 4, RecordHelpersTest.mkMapOfPartitionRacks(4)));
        topicMetadata.put(this.topic4Uuid, new TopicMetadata(this.topic4Uuid, "topic4", 4, RecordHelpersTest.mkMapOfPartitionRacks(4)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Arrays.asList(this.topic1Uuid, this.topic4Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Arrays.asList(this.topic3Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2, 3)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2, 3)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenPartitionsAreAddedForTwoMembersNoMemberRack() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic4Uuid, new TopicMetadata(this.topic4Uuid, "topic4", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid, this.topic3Uuid, this.topic4Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4), AssignmentTestUtil.mkTopicAssignment(this.topic4Uuid, 0, 1, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberAddedAndPartitionsAddedTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 7, RecordHelpersTest.mkMapOfPartitionRacks(7)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 3, 4, 5)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 2, 5)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 3, 4, 6)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentOnAddingMemberWithRackAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4, 5)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Collections.singletonList(this.topic2Uuid), currentAssignmentForB));
        members.put("C", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack2"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), Collections.emptyMap()));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 3, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 3, 4)));
        expectedAssignment.put("C", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 2, 5), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 2)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneMemberRemovedAfterInitialAssignmentWithThreeMembersThreeTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 8, RecordHelpersTest.mkMapOfPartitionRacks(4)));
        topicMetadata.put(this.topic3Uuid, new TopicMetadata(this.topic3Uuid, "topic3", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic3Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 3, 4, 5, 6));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(this.topic3Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4, 5, 6, 7)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedAfterInitialAssignmentWithTwoMembersTwoTopics() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        HashMap<String, AssignmentMemberSpec> members = new HashMap<String, AssignmentMemberSpec>();
        Map<Uuid, Set<Integer>> currentAssignmentForA = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1, 3));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Collections.singletonList(this.topic1Uuid), currentAssignmentForA));
        Map<Uuid, Set<Integer>> currentAssignmentForB = AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 2, 4));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.empty(), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1, 2, 3, 4)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }

    @Test
    public void testReassignmentWhenOneSubscriptionRemovedWithMemberAndPartitionRacks() {
        HashMap<Uuid, TopicMetadata> topicMetadata = new HashMap<Uuid, TopicMetadata>();
        topicMetadata.put(this.topic1Uuid, new TopicMetadata(this.topic1Uuid, "topic1", 5, RecordHelpersTest.mkMapOfPartitionRacks(5)));
        topicMetadata.put(this.topic2Uuid, new TopicMetadata(this.topic2Uuid, "topic2", 2, RecordHelpersTest.mkMapOfPartitionRacks(2)));
        TreeMap<String, AssignmentMemberSpec> members = new TreeMap<String, AssignmentMemberSpec>();
        TreeMap<Uuid, Set<Integer>> currentAssignmentForA = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 2, 4), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0)));
        members.put("A", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack0"), Arrays.asList(this.topic1Uuid, this.topic2Uuid), currentAssignmentForA));
        TreeMap<Uuid, Set<Integer>> currentAssignmentForB = new TreeMap<Uuid, Set<Integer>>(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 1, 3), AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 1)));
        members.put("B", new AssignmentMemberSpec(Optional.empty(), Optional.of("rack1"), Collections.singletonList(this.topic2Uuid), currentAssignmentForB));
        AssignmentSpec assignmentSpec = new AssignmentSpec(members);
        SubscribedTopicMetadata subscribedTopicMetadata = new SubscribedTopicMetadata(topicMetadata);
        GroupAssignment computedAssignment = this.assignor.assign(assignmentSpec, (SubscribedTopicDescriber)subscribedTopicMetadata);
        HashMap<String, Map<Uuid, Set<Integer>>> expectedAssignment = new HashMap<String, Map<Uuid, Set<Integer>>>();
        expectedAssignment.put("A", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic1Uuid, 0, 1, 2, 3, 4)));
        expectedAssignment.put("B", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(this.topic2Uuid, 0, 1)));
        AssignmentTestUtil.assertAssignment(expectedAssignment, computedAssignment);
    }
}

