/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordTest {
    @Test
    public void testAttributes() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey(), 0);
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue(), 0);
        Record record = new Record(key, value);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
    }

    @Test
    public void testKeyCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new Record(null, null));
    }

    @Test
    public void testValueCanBeNull() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey(), 0);
        Record record = new Record(key, null);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertNull((Object)record.value());
    }

    @Test
    public void testEquals() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey(), 0);
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue(), 0);
        Record record1 = new Record(key, value);
        Record record2 = new Record(key, value);
        Assertions.assertEquals((Object)record1, (Object)record2);
    }
}

