/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordSerde;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.runtime.CoordinatorLoader;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordSerdeTest {
    @Test
    public void testSerializeKey() {
        RecordSerde serializer = new RecordSerde();
        Record record = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.key().version(), (Message)record.key().message()), (byte[])serializer.serializeKey(record));
    }

    @Test
    public void testSerializeValue() {
        RecordSerde serializer = new RecordSerde();
        Record record = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        Assertions.assertArrayEquals((byte[])MessageUtil.toVersionPrefixedBytes((short)record.value().version(), (Message)record.value().message()), (byte[])serializer.serializeValue(record));
    }

    @Test
    public void testSerializeNullValue() {
        RecordSerde serializer = new RecordSerde();
        Record record = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group"), 1), null);
        Assertions.assertNull((Object)serializer.serializeValue(record));
    }

    @Test
    public void testDeserialize() {
        RecordSerde serde = new RecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0);
        ByteBuffer valueBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)value.version(), (Message)value.message());
        Record record = serde.deserialize(keyBuffer, valueBuffer);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
    }

    @Test
    public void testDeserializeWithTombstoneForValue() {
        RecordSerde serde = new RecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        Record record = serde.deserialize(keyBuffer, null);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertNull((Object)record.value());
    }

    @Test
    public void testDeserializeWithInvalidRecordType() {
        RecordSerde serde = new RecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(64);
        keyBuffer.putShort((short)255);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        CoordinatorLoader.UnknownRecordTypeException ex = (CoordinatorLoader.UnknownRecordTypeException)Assertions.assertThrows(CoordinatorLoader.UnknownRecordTypeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((short)255, (short)ex.unknownType());
    }

    @Test
    public void testDeserializeWithKeyEmptyBuffer() {
        RecordSerde serde = new RecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(0);
        ByteBuffer valueBuffer = ByteBuffer.allocate(64);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from key's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithValueEmptyBuffer() {
        RecordSerde serde = new RecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(0);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertEquals((Object)"Could not read version from value's buffer.", (Object)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidKeyBytes() {
        RecordSerde serde = new RecordSerde();
        ByteBuffer keyBuffer = ByteBuffer.allocate(2);
        keyBuffer.putShort((short)3);
        keyBuffer.rewind();
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 3 from key's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeWithInvalidValueBytes() {
        RecordSerde serde = new RecordSerde();
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("foo"), 3);
        ByteBuffer keyBuffer = MessageUtil.toVersionPrefixedByteBuffer((short)key.version(), (Message)key.message());
        ByteBuffer valueBuffer = ByteBuffer.allocate(2);
        valueBuffer.putShort((short)0);
        valueBuffer.rewind();
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serde.deserialize(keyBuffer, valueBuffer));
        Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not read record with version 0 from value's buffer due to"), (String)ex.getMessage());
    }

    @Test
    public void testDeserializeAllRecordTypes() {
        this.roundTrip((short)0, new OffsetCommitKey(), new OffsetCommitValue());
        this.roundTrip((short)1, new OffsetCommitKey(), new OffsetCommitValue());
        this.roundTrip((short)2, new GroupMetadataKey(), new GroupMetadataValue());
        this.roundTrip((short)3, new ConsumerGroupMetadataKey(), new ConsumerGroupMetadataValue());
        this.roundTrip((short)4, new ConsumerGroupPartitionMetadataKey(), new ConsumerGroupPartitionMetadataValue());
        this.roundTrip((short)5, new ConsumerGroupMemberMetadataKey(), new ConsumerGroupMemberMetadataValue());
        this.roundTrip((short)6, new ConsumerGroupTargetAssignmentMetadataKey(), new ConsumerGroupTargetAssignmentMetadataValue());
        this.roundTrip((short)7, new ConsumerGroupTargetAssignmentMemberKey(), new ConsumerGroupTargetAssignmentMemberValue());
        this.roundTrip((short)8, new ConsumerGroupCurrentMemberAssignmentKey(), new ConsumerGroupCurrentMemberAssignmentValue());
    }

    private void roundTrip(short recordType, ApiMessage key, ApiMessage val) {
        RecordSerde serde = new RecordSerde();
        for (short version = val.lowestSupportedVersion(); version < val.highestSupportedVersion(); version = (short)(version + 1)) {
            ApiMessageAndVersion keyMessageAndVersion = new ApiMessageAndVersion(key, recordType);
            ApiMessageAndVersion valMessageAndVersion = new ApiMessageAndVersion(val, version);
            Record record = serde.deserialize(MessageUtil.toVersionPrefixedByteBuffer((short)recordType, (Message)key), MessageUtil.toVersionPrefixedByteBuffer((short)version, (Message)val));
            Assertions.assertEquals((Object)keyMessageAndVersion, (Object)record.key());
            Assertions.assertEquals((Object)valMessageAndVersion, (Object)record.value());
        }
    }
}

