/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.ClientAssignor;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.consumer.VersionedMetadata;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class RecordHelpersTest {
    @Test
    public void testNewMemberSubscriptionRecord() {
        ConsumerGroupMember member = new ConsumerGroupMember.Builder("member-id").setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(Arrays.asList("foo", "zar", "bar")).setSubscribedTopicRegex("regex").setServerAssignorName("range").setClientAssignors(Collections.singletonList(new ClientAssignor("assignor", 0, 1, 10, new VersionedMetadata(5, ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)))))).build();
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId("group-id").setMemberId("member-id"), 5), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataValue().setInstanceId("instance-id").setRackId("rack-id").setRebalanceTimeoutMs(5000).setClientId("client-id").setClientHost("client-host").setSubscribedTopicNames(Arrays.asList("bar", "foo", "zar")).setSubscribedTopicRegex("regex").setServerAssignor("range").setAssignors(Collections.singletonList(new ConsumerGroupMemberMetadataValue.Assignor().setName("assignor").setMinimumVersion((short)1).setMaximumVersion((short)10).setVersion((short)5).setMetadata("hello".getBytes(StandardCharsets.UTF_8)))), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newMemberSubscriptionRecord((String)"group-id", (ConsumerGroupMember)member));
    }

    @Test
    public void testNewMemberSubscriptionTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMemberMetadataKey().setGroupId("group-id").setMemberId("member-id"), 5), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newMemberSubscriptionTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    @Test
    public void testNewGroupSubscriptionMetadataRecord() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        LinkedHashMap<String, TopicMetadata> subscriptionMetadata = new LinkedHashMap<String, TopicMetadata>();
        subscriptionMetadata.put("foo", new TopicMetadata(fooTopicId, "foo", 10, RecordHelpersTest.mkMapOfPartitionRacks(10)));
        subscriptionMetadata.put("bar", new TopicMetadata(barTopicId, "bar", 20, RecordHelpersTest.mkMapOfPartitionRacks(20)));
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataValue().setTopics(Arrays.asList(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(fooTopicId).setTopicName("foo").setNumPartitions(10).setPartitionMetadata(RecordHelpersTest.mkListOfPartitionRacks(10)), new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(barTopicId).setTopicName("bar").setNumPartitions(20).setPartitionMetadata(RecordHelpersTest.mkListOfPartitionRacks(20)))), 0));
        Assertions.assertRecordEquals(expectedRecord, RecordHelpers.newGroupSubscriptionMetadataRecord((String)"group-id", subscriptionMetadata));
    }

    @Test
    public void testNewGroupSubscriptionMetadataTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newGroupSubscriptionMetadataTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testEmptyPartitionMetadataWhenRacksUnavailableGroupSubscriptionMetadataRecord() {
        Uuid fooTopicId = Uuid.randomUuid();
        Uuid barTopicId = Uuid.randomUuid();
        LinkedHashMap<String, TopicMetadata> subscriptionMetadata = new LinkedHashMap<String, TopicMetadata>();
        subscriptionMetadata.put("foo", new TopicMetadata(fooTopicId, "foo", 10, Collections.emptyMap()));
        subscriptionMetadata.put("bar", new TopicMetadata(barTopicId, "bar", 20, Collections.emptyMap()));
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataKey().setGroupId("group-id"), 4), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupPartitionMetadataValue().setTopics(Arrays.asList(new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(fooTopicId).setTopicName("foo").setNumPartitions(10).setPartitionMetadata(Collections.emptyList()), new ConsumerGroupPartitionMetadataValue.TopicMetadata().setTopicId(barTopicId).setTopicName("bar").setNumPartitions(20).setPartitionMetadata(Collections.emptyList()))), 0));
        Assertions.assertRecordEquals(expectedRecord, RecordHelpers.newGroupSubscriptionMetadataRecord((String)"group-id", subscriptionMetadata));
    }

    @Test
    public void testNewGroupEpochRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group-id"), 3), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataValue().setEpoch(10), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newGroupEpochRecord((String)"group-id", (int)10));
    }

    @Test
    public void testNewGroupEpochTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupMetadataKey().setGroupId("group-id"), 3), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newGroupEpochTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testNewTargetAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        Map<Uuid, Set<Integer>> partitions = AssignmentTestUtil.mkSortedAssignment(AssignmentTestUtil.mkTopicAssignment(topicId1, 11, 12, 13), AssignmentTestUtil.mkTopicAssignment(topicId2, 21, 22, 23));
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId("group-id").setMemberId("member-id"), 7), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberValue().setTopicPartitions(Arrays.asList(new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId1).setPartitions(Arrays.asList(11, 12, 13)), new ConsumerGroupTargetAssignmentMemberValue.TopicPartition().setTopicId(topicId2).setPartitions(Arrays.asList(21, 22, 23)))), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newTargetAssignmentRecord((String)"group-id", (String)"member-id", partitions));
    }

    @Test
    public void testNewTargetAssignmentTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMemberKey().setGroupId("group-id").setMemberId("member-id"), 7), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newTargetAssignmentTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    @Test
    public void testNewTargetAssignmentEpochRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId("group-id"), 6), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataValue().setAssignmentEpoch(10), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newTargetAssignmentEpochRecord((String)"group-id", (int)10));
    }

    @Test
    public void testNewTargetAssignmentEpochTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupTargetAssignmentMetadataKey().setGroupId("group-id"), 6), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newTargetAssignmentEpochTombstoneRecord((String)"group-id"));
    }

    @Test
    public void testNewCurrentAssignmentRecord() {
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        Map<Uuid, Set<Integer>> assigned = AssignmentTestUtil.mkSortedAssignment(AssignmentTestUtil.mkSortedTopicAssignment(topicId1, 11, 12, 13), AssignmentTestUtil.mkSortedTopicAssignment(topicId2, 21, 22, 23));
        Map<Uuid, Set<Integer>> revoking = AssignmentTestUtil.mkSortedAssignment(AssignmentTestUtil.mkSortedTopicAssignment(topicId1, 14, 15, 16), AssignmentTestUtil.mkSortedTopicAssignment(topicId2, 24, 25, 26));
        Map<Uuid, Set<Integer>> assigning = AssignmentTestUtil.mkSortedAssignment(AssignmentTestUtil.mkSortedTopicAssignment(topicId1, 17, 18, 19), AssignmentTestUtil.mkSortedTopicAssignment(topicId2, 27, 28, 29));
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId("group-id").setMemberId("member-id"), 8), new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentValue().setMemberEpoch(22).setPreviousMemberEpoch(21).setTargetMemberEpoch(23).setAssignedPartitions(Arrays.asList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(11, 12, 13)), new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(21, 22, 23)))).setPartitionsPendingRevocation(Arrays.asList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(14, 15, 16)), new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(24, 25, 26)))).setPartitionsPendingAssignment(Arrays.asList(new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId1).setPartitions(Arrays.asList(17, 18, 19)), new ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions().setTopicId(topicId2).setPartitions(Arrays.asList(27, 28, 29)))), 0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newCurrentAssignmentRecord((String)"group-id", (ConsumerGroupMember)new ConsumerGroupMember.Builder("member-id").setMemberEpoch(22).setPreviousMemberEpoch(21).setTargetMemberEpoch(23).setAssignedPartitions(assigned).setPartitionsPendingRevocation(revoking).setPartitionsPendingAssignment(assigning).build()));
    }

    @Test
    public void testNewCurrentAssignmentTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new ConsumerGroupCurrentMemberAssignmentKey().setGroupId("group-id").setMemberId("member-id"), 8), null);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newCurrentAssignmentTombstoneRecord((String)"group-id", (String)"member-id"));
    }

    private static Stream<Arguments> metadataToExpectedGroupMetadataValue() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{MetadataVersion.IBP_0_10_0_IV0, (short)0}), Arguments.arguments((Object[])new Object[]{MetadataVersion.IBP_1_1_IV0, (short)1}), Arguments.arguments((Object[])new Object[]{MetadataVersion.IBP_2_2_IV0, (short)2}), Arguments.arguments((Object[])new Object[]{MetadataVersion.IBP_3_5_IV0, (short)3}));
    }

    @ParameterizedTest
    @MethodSource(value={"metadataToExpectedGroupMetadataValue"})
    public void testNewGroupMetadataRecord(MetadataVersion metadataVersion, short expectedGroupMetadataValueVersion) {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(new byte[]{1, 2}));
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-2").setClientId("client-2").setClientHost("host-2").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-2").setSubscription(new byte[]{1, 2}).setAssignment(new byte[]{2, 3}));
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol("range").setProtocolType("consumer").setLeader("member-1").setGeneration(1).setCurrentStateTimestamp(time.milliseconds()).setMembers(expectedMembers), expectedGroupMetadataValueVersion));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        HashMap assignment = new HashMap();
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(member.subscription()));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, ClassicGroupMember.EMPTY_ASSIGNMENT));
            assignment.put(member.memberId(), member.assignment());
        });
        group.initNextGeneration();
        Record groupMetadataRecord = RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, assignment, (MetadataVersion)metadataVersion);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @Test
    public void testNewGroupMetadataTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), null);
        Record groupMetadataRecord = RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id");
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @Test
    public void testNewGroupMetadataRecordThrowsWhenNullSubscription() {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(new byte[]{1, 2}));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(null));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, member.assignment()));
        });
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap(), (MetadataVersion)MetadataVersion.IBP_3_5_IV2));
    }

    @Test
    public void testNewGroupMetadataRecordThrowsWhenEmptyAssignment() {
        MockTime time = new MockTime();
        ArrayList<GroupMetadataValue.MemberMetadata> expectedMembers = new ArrayList<GroupMetadataValue.MemberMetadata>();
        expectedMembers.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-1").setClientId("client-1").setClientHost("host-1").setRebalanceTimeout(1000).setSessionTimeout(1500).setGroupInstanceId("group-instance-1").setSubscription(new byte[]{0, 1}).setAssignment(null));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        expectedMembers.forEach(member -> {
            JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection();
            protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(member.subscription()));
            group.add(new ClassicGroupMember(member.memberId(), Optional.of(member.groupInstanceId()), member.clientId(), member.clientHost(), member.rebalanceTimeout(), member.sessionTimeout(), "consumer", protocols, member.assignment()));
        });
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap(), (MetadataVersion)MetadataVersion.IBP_3_5_IV2));
    }

    @ParameterizedTest
    @MethodSource(value={"metadataToExpectedGroupMetadataValue"})
    public void testEmptyGroupMetadataRecord(MetadataVersion metadataVersion, short expectedGroupMetadataValueVersion) {
        MockTime time = new MockTime();
        List<GroupMetadataValue.MemberMetadata> expectedMembers = Collections.emptyList();
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new GroupMetadataKey().setGroup("group-id"), 2), new ApiMessageAndVersion((ApiMessage)new GroupMetadataValue().setProtocol(null).setProtocolType("").setLeader(null).setGeneration(0).setCurrentStateTimestamp(time.milliseconds()).setMembers(expectedMembers), expectedGroupMetadataValueVersion));
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.PREPARING_REBALANCE, (Time)time, (GroupCoordinatorMetricsShard)Mockito.mock(GroupCoordinatorMetricsShard.class));
        group.initNextGeneration();
        Record groupMetadataRecord = RecordHelpers.newEmptyGroupMetadataRecord((ClassicGroup)group, (MetadataVersion)metadataVersion);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)groupMetadataRecord);
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testNewOffsetCommitRecord(MetadataVersion metadataVersion) {
        OffsetCommitKey key = new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1);
        OffsetCommitValue value = new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(-1L);
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)key, 1), new ApiMessageAndVersion((ApiMessage)value, metadataVersion.offsetCommitValueVersion(false)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.of(10), "metadata", 1234L, OptionalLong.empty()), (MetadataVersion)metadataVersion));
        value.setLeaderEpoch(-1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.empty(), "metadata", 1234L, OptionalLong.empty()), (MetadataVersion)metadataVersion));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testNewOffsetCommitRecordWithExpireTimestamp(MetadataVersion metadataVersion) {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1), 1), new ApiMessageAndVersion((ApiMessage)new OffsetCommitValue().setOffset(100L).setLeaderEpoch(10).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(5678L), 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)RecordHelpers.newOffsetCommitRecord((String)"group-id", (String)"foo", (int)1, (OffsetAndMetadata)new OffsetAndMetadata(100L, OptionalInt.of(10), "metadata", 1234L, OptionalLong.of(5678L)), (MetadataVersion)metadataVersion));
    }

    @Test
    public void testNewOffsetCommitTombstoneRecord() {
        Record expectedRecord = new Record(new ApiMessageAndVersion((ApiMessage)new OffsetCommitKey().setGroup("group-id").setTopic("foo").setPartition(1), 1), null);
        Record record = RecordHelpers.newOffsetCommitTombstoneRecord((String)"group-id", (String)"foo", (int)1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecord, (Object)record);
    }

    public static List<ConsumerGroupPartitionMetadataValue.PartitionMetadata> mkListOfPartitionRacks(int numPartitions) {
        ArrayList<ConsumerGroupPartitionMetadataValue.PartitionMetadata> partitionRacks = new ArrayList<ConsumerGroupPartitionMetadataValue.PartitionMetadata>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            ArrayList<String> racks = new ArrayList<String>(Arrays.asList("rack" + i % 4, "rack" + (i + 1) % 4));
            partitionRacks.add(new ConsumerGroupPartitionMetadataValue.PartitionMetadata().setPartition(i).setRacks(racks));
        }
        return partitionRacks;
    }

    public static Map<Integer, Set<String>> mkMapOfPartitionRacks(int numPartitions) {
        HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>(numPartitions);
        for (int i = 0; i < numPartitions; ++i) {
            partitionRacks.put(i, new HashSet<String>(Arrays.asList("rack" + i % 4, "rack" + (i + 1) % 4)));
        }
        return partitionRacks;
    }
}

