/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetAndMetadataTest {
    @Test
    public void testAttributes() {
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(100L, OptionalInt.of(10), "metadata", 1234L, OptionalLong.of(5678L));
        Assertions.assertEquals((long)100L, (long)offsetAndMetadata.committedOffset);
        Assertions.assertEquals((Object)OptionalInt.of(10), (Object)offsetAndMetadata.leaderEpoch);
        Assertions.assertEquals((Object)"metadata", (Object)offsetAndMetadata.metadata);
        Assertions.assertEquals((long)1234L, (long)offsetAndMetadata.commitTimestampMs);
        Assertions.assertEquals((Object)OptionalLong.of(5678L), (Object)offsetAndMetadata.expireTimestampMs);
    }

    @Test
    public void testFromRecord() {
        OffsetCommitValue record = new OffsetCommitValue().setOffset(100L).setLeaderEpoch(-1).setMetadata("metadata").setCommitTimestamp(1234L).setExpireTimestamp(-1L);
        Assertions.assertEquals((Object)new OffsetAndMetadata(10L, 100L, OptionalInt.empty(), "metadata", 1234L, OptionalLong.empty()), (Object)OffsetAndMetadata.fromRecord((long)10L, (OffsetCommitValue)record));
        record.setLeaderEpoch(12).setExpireTimestamp(5678L);
        Assertions.assertEquals((Object)new OffsetAndMetadata(11L, 100L, OptionalInt.of(12), "metadata", 1234L, OptionalLong.of(5678L)), (Object)OffsetAndMetadata.fromRecord((long)11L, (OffsetCommitValue)record));
    }

    @Test
    public void testFromRequest() {
        MockTime time = new MockTime();
        OffsetCommitRequestData.OffsetCommitRequestPartition partition = new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setCommittedMetadata(null).setCommitTimestamp(-1L);
        Assertions.assertEquals((Object)new OffsetAndMetadata(100L, OptionalInt.empty(), "", time.milliseconds(), OptionalLong.empty()), (Object)OffsetAndMetadata.fromRequest((OffsetCommitRequestData.OffsetCommitRequestPartition)partition, (long)time.milliseconds(), (OptionalLong)OptionalLong.empty()));
        partition.setCommittedLeaderEpoch(10).setCommittedMetadata("hello").setCommitTimestamp(1234L);
        Assertions.assertEquals((Object)new OffsetAndMetadata(100L, OptionalInt.of(10), "hello", 1234L, OptionalLong.empty()), (Object)OffsetAndMetadata.fromRequest((OffsetCommitRequestData.OffsetCommitRequestPartition)partition, (long)time.milliseconds(), (OptionalLong)OptionalLong.empty()));
        Assertions.assertEquals((Object)new OffsetAndMetadata(100L, OptionalInt.of(10), "hello", 1234L, OptionalLong.of(5678L)), (Object)OffsetAndMetadata.fromRequest((OffsetCommitRequestData.OffsetCommitRequestPartition)partition, (long)time.milliseconds(), (OptionalLong)OptionalLong.of(5678L)));
    }

    @Test
    public void testFromTransactionalRequest() {
        MockTime time = new MockTime();
        TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition partition = new TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setCommittedMetadata(null);
        Assertions.assertEquals((Object)new OffsetAndMetadata(100L, OptionalInt.empty(), "", time.milliseconds(), OptionalLong.empty()), (Object)OffsetAndMetadata.fromRequest((TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition)partition, (long)time.milliseconds()));
        partition.setCommittedLeaderEpoch(10).setCommittedMetadata("hello");
        Assertions.assertEquals((Object)new OffsetAndMetadata(100L, OptionalInt.of(10), "hello", time.milliseconds(), OptionalLong.empty()), (Object)OffsetAndMetadata.fromRequest((TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition)partition, (long)time.milliseconds()));
    }
}

