/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.FencedMemberEpochException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnreleasedInstanceIdException;
import org.apache.kafka.common.errors.UnsupportedAssignorException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.Assertions;
import org.apache.kafka.coordinator.group.AssignmentTestUtil;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.GroupMetadataManagerTestContext;
import org.apache.kafka.coordinator.group.MetadataImageBuilder;
import org.apache.kafka.coordinator.group.MockCoordinatorTimer;
import org.apache.kafka.coordinator.group.MockPartitionAssignor;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.RecordHelpersTest;
import org.apache.kafka.coordinator.group.assignor.AssignmentSpec;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.assignor.MemberAssignment;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupBuilder;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.consumer.TopicMetadata;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GroupMetadataManagerTest {
    @Test
    public void testConsumerHeartbeatRequestValidation() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        Exception ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("   ")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"GroupId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberEpoch(0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RebalanceTimeoutMs must be provided in first request.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberEpoch(0).setRebalanceTimeoutMs(5000)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"TopicPartitions must be empty when (re-)joining.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberEpoch(0).setRebalanceTimeoutMs(5000).setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SubscribedTopicNames must be set in first request.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberEpoch(1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"MemberId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setInstanceId("")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"InstanceId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setRackId("")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"RackId can't be empty.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedAssignorException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setServerAssignor("bar")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ServerAssignor bar is not supported. Supported assignors: range.", (Object)ex.getMessage());
        ex = (Exception)org.junit.jupiter.api.Assertions.assertThrows(InvalidRequestException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("foo").setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"InstanceId can't be null.", (Object)ex.getMessage());
    }

    @Test
    public void testMemberIdGeneration() {
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(MetadataImage.EMPTY).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId("group-foo").setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        String memberId = ((ConsumerGroupHeartbeatResponseData)result.response()).memberId();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)memberId);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"", (Object)memberId);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (Object)result.response());
    }

    @Test
    public void testUnknownGroupId() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(100).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testUnknownMemberIdJoinsConsumerGroup() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.emptyMap()));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(Uuid.randomUuid().toString()).setMemberEpoch(1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupMemberEpochValidation() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId).setMemberEpoch(100).setPreviousMemberEpoch(99).setTargetMemberEpoch(100).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build();
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)member));
        context.replay(RecordHelpers.newGroupEpochRecord((String)groupId, (int)100));
        context.replay(RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)100));
        context.replay(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(200).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(50).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(1, 2)))));
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
    }

    @Test
    public void testMemberJoinsEmptyConsumerGroup() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2, 3, 4, 5)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Arrays.asList(0, 1, 2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setMemberEpoch(1).setPreviousMemberEpoch(0).setTargetMemberEpoch(1).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)1), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)1), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testUpdatingSubscriptionTriggersNewTargetAssignment() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Collections.singletonList("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10).setSubscribedTopicNames(Arrays.asList("foo", "bar")));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2, 3, 4, 5)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Arrays.asList(0, 1, 2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testNewJoiningMemberTriggersNewTargetAssignment() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final String memberId3 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))));
                this.put(memberId3, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setPreviousMemberEpoch(0).setTargetMemberEpoch(11).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3));
        Assertions.assertRecordsEquals(expectedRecords.subList(0, 3), result.records().subList(0, 3));
        Assertions.assertUnorderedListEquals(expectedRecords.subList(3, 6), result.records().subList(3, 6));
        Assertions.assertRecordsEquals(expectedRecords.subList(6, 8), result.records().subList(6, 8));
    }

    @Test
    public void testLeavingMemberBumpsGroupEpoch() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-1), (ConsumerGroupHeartbeatResponseData)result.response());
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testGroupEpochBumpWhenNewStaticMemberJoins() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final String memberId3 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))));
                this.put(memberId3, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setInstanceId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember3 = new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setInstanceId(memberId3).setPreviousMemberEpoch(0).setTargetMemberEpoch(11).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedMember3), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId3, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember3));
        Assertions.assertRecordsEquals(expectedRecords.subList(0, 3), result.records().subList(0, 3));
        Assertions.assertUnorderedListEquals(expectedRecords.subList(3, 6), result.records().subList(3, 6));
        Assertions.assertRecordsEquals(expectedRecords.subList(6, 8), result.records().subList(6, 8));
    }

    @Test
    public void testStaticMemberGetsBackAssignmentUponRejoin() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        final String member2RejoinId = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10).withSubscriptionMetadata((Map<String, TopicMetadata>)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        })).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))));
                this.put(member2RejoinId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(-2).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-2), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember member2UpdatedEpoch = new ConsumerGroupMember.Builder(member2).setMemberEpoch(-2).build();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertRecordEquals((Record)result.records().get(0), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member2UpdatedEpoch));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> rejoinResult = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setMemberId(member2RejoinId).setGroupId(groupId).setInstanceId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(member2RejoinId).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(3, 4, 5)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(2))))), (ConsumerGroupHeartbeatResponseData)rejoinResult.response());
        ConsumerGroupMember expectedRejoinedMember = new ConsumerGroupMember.Builder(member2RejoinId).setMemberEpoch(10).setInstanceId(memberId2).setPreviousMemberEpoch(0).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        List<Record> expectedRecordsAfterRejoin = Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)expectedRejoinedMember), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)member2RejoinId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)10), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedRejoinedMember));
        Assertions.assertRecordsEquals(expectedRecordsAfterRejoin, rejoinResult.records());
        context.assertNoSessionTimeout(groupId, memberId2);
        context.assertNoRevocationTimeout(groupId, memberId2);
    }

    @Test
    public void testNoGroupEpochBumpWhenStaticMemberTemporarilyLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        ConsumerGroupMember member1 = new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build();
        ConsumerGroupMember member2 = new ConsumerGroupMember.Builder(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build();
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(member1).withMember(member2).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-2), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember member2UpdatedEpoch = new ConsumerGroupMember.Builder(member2).setMemberEpoch(-2).build();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.records().size());
        Assertions.assertRecordEquals((Record)result.records().get(0), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member2UpdatedEpoch));
    }

    @Test
    public void testLeavingStaticMemberBumpsGroupEpoch() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        final String barTopicName = "bar";
        Uuid zarTopicId = Uuid.randomUuid();
        String zarTopicName = "zar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addTopic(zarTopicId, zarTopicName, 1).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setInstanceId(memberId2).setMemberId(memberId2).setMemberEpoch(-1).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(-1), (ConsumerGroupHeartbeatResponseData)result.response());
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId2), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
                this.put(barTopicName, new TopicMetadata(barTopicId, barTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
    }

    @Test
    public void testShouldThrownUnreleasedInstanceIdExceptionWhenNewMemberJoinsWithInUseInstanceId() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnreleasedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrownUnknownMemberIdExceptionWhenUnknownStaticMemberJoins() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setInstanceId(memberId2).setMemberEpoch(10).setRebalanceTimeoutMs(5000).setServerAssignor("range").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrowFencedInstanceIdExceptionWhenStaticMemberWithDifferentMemberIdJoins() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-" + memberId1).setInstanceId(memberId1).setMemberEpoch(11).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupMemberEpochValidationForStaticMember() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        ConsumerGroupMember member = new ConsumerGroupMember.Builder(memberId).setInstanceId(memberId).setMemberEpoch(100).setPreviousMemberEpoch(99).setTargetMemberEpoch(100).setRebalanceTimeoutMs(5000).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build();
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)member));
        context.replay(RecordHelpers.newGroupEpochRecord((String)groupId, (int)100));
        context.replay(RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)100));
        context.replay(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)member));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(200).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(50).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        org.junit.jupiter.api.Assertions.assertThrows(FencedMemberEpochException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar"))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(99).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(1, 2)))));
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
    }

    @Test
    public void testShouldThrowUnknownMemberIdExceptionWhenUnknownStaticMemberLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setInstanceId("unknown-" + memberId1).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testShouldThrowFencedInstanceIdExceptionWhenStaticMemberWithDifferentMemberIdLeaves() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setInstanceId(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId("unknown-" + memberId1).setInstanceId(memberId1).setMemberEpoch(-2).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testReconciliationProcess() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final String memberId3 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        final Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))));
                this.put(memberId3, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))));
            }
        }));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordEquals(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setPreviousMemberEpoch(0).setTargetMemberEpoch(11).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build()), (Record)result.records().get(result.records().size() - 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(0))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(3)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10).setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1)), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(0)))));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(0))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(10).setHeartbeatIntervalMs(5000), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(1))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setPreviousMemberEpoch(11).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(10).setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(3)), new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(2)))));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(2, 3)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2, 3), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(11));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(4, 5)), new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(barTopicId).setPartitions(Collections.singletonList(1))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(11).setPreviousMemberEpoch(11).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 1))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.STABLE, (Object)context.consumerGroupMemberState(groupId, memberId3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
    }

    @Test
    public void testReconciliationRestartsWhenNewTargetAssignmentIsInstalled() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final String memberId3 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10)).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordEquals(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(11).setPreviousMemberEpoch(0).setTargetMemberEpoch(11).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))).build()), (Record)result.records().get(result.records().size() - 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId2));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)context.consumerGroupMemberState(groupId, memberId1));
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))));
                this.put(memberId3, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))));
            }
        }));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(12).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordEquals(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId3).setMemberEpoch(12).setPreviousMemberEpoch(0).setTargetMemberEpoch(12).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))).build()), (Record)result.records().get(result.records().size() - 1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId3));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(10).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(0))))), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(12).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.REVOKING, (Object)context.consumerGroupMemberState(groupId, memberId1));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(11));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(12).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        Assertions.assertRecordsEquals(Collections.singletonList(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(12).setPreviousMemberEpoch(11).setTargetMemberEpoch(12).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))).build())), result.records());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroupMember.MemberState.ASSIGNING, (Object)context.consumerGroupMemberState(groupId, memberId2));
    }

    @Test
    public void testNewMemberIsRejectedWithMaximumMembersIsReached() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        String memberId2 = Uuid.randomUuid().toString();
        String memberId3 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build()).withConsumerGroupMaxSize(2).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).build()).withMember(new ConsumerGroupMember.Builder(memberId2).setMemberEpoch(10).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).build()).withAssignment(memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1))).withAssignment(memberId2, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 2))).withAssignmentEpoch(10)).build();
        org.junit.jupiter.api.Assertions.assertThrows(GroupMaxSizeReachedException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testConsumerGroupStates() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10)).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.EMPTY, (Object)context.consumerGroupState(groupId));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setSubscribedTopicNames(Collections.singletonList(fooTopicName)).build()));
        context.replay(RecordHelpers.newGroupEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.ASSIGNING, (Object)context.consumerGroupState(groupId));
        context.replay(RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId1, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))));
        context.replay(RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        context.replay(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2))).setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.RECONCILING, (Object)context.consumerGroupState(groupId));
        context.replay(RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1, 2, 3))).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ConsumerGroup.ConsumerGroupState.STABLE, (Object)context.consumerGroupState(groupId));
    }

    @Test
    public void testPartitionAssignorExceptionOnRegularHeartbeat() {
        String groupId = "fooup";
        String memberId1 = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        PartitionAssignor assignor = (PartitionAssignor)Mockito.mock(PartitionAssignor.class);
        Mockito.when((Object)assignor.name()).thenReturn((Object)"range");
        Mockito.when((Object)assignor.assign((AssignmentSpec)ArgumentMatchers.any(), (SubscribedTopicDescriber)ArgumentMatchers.any())).thenThrow(new Throwable[]{new PartitionAssignorException("Assignment failed.")});
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownServerException.class, () -> context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignor("range").setTopicPartitions(Collections.emptyList())));
    }

    @Test
    public void testSubscriptionMetadataRefreshedAfterGroupIsLoaded() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withConsumerGroupMetadataRefreshIntervalMs(300000).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10).withSubscriptionMetadata((Map<String, TopicMetadata>)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        })).build();
        ConsumerGroup consumerGroup = context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2, 3, 4, 5))))), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + 300000L), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
    }

    @Test
    public void testSubscriptionMetadataRefreshedAgainAfterWriteFailure() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        final String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withConsumerGroupMetadataRefreshIntervalMs(300000).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).withConsumerGroup(new ConsumerGroupBuilder(groupId, 10).withMember(new ConsumerGroupMember.Builder(memberId).setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).build()).withAssignment(memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignmentEpoch(10).withSubscriptionMetadata((Map<String, TopicMetadata>)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 3, RecordHelpersTest.mkMapOfPartitionRacks(3)));
            }
        })).build();
        ConsumerGroup consumerGroup = context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + 300000L), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
        context.rollback();
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(10));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId).setMemberEpoch(11).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2, 3, 4, 5))))), (ConsumerGroupHeartbeatResponseData)result.response());
        ConsumerGroupMember expectedMember = new ConsumerGroupMember.Builder(memberId).setMemberEpoch(11).setPreviousMemberEpoch(10).setTargetMemberEpoch(11).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))).build();
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, (Map)new HashMap<String, TopicMetadata>(){
            {
                this.put(fooTopicName, new TopicMetadata(fooTopicId, fooTopicName, 6, RecordHelpersTest.mkMapOfPartitionRacks(6)));
            }
        }), RecordHelpers.newGroupEpochRecord((String)groupId, (int)11), RecordHelpers.newTargetAssignmentRecord((String)groupId, (String)memberId, AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))), RecordHelpers.newTargetAssignmentEpochRecord((String)groupId, (int)11), RecordHelpers.newCurrentAssignmentRecord((String)groupId, (ConsumerGroupMember)expectedMember));
        Assertions.assertRecordsEquals(expectedRecords, result.records());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consumerGroup.hasMetadataExpired(context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + 300000L), (long)consumerGroup.metadataRefreshDeadline().deadlineMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)11, (int)consumerGroup.metadataRefreshDeadline().epoch);
    }

    @Test
    public void testGroupIdsByTopics() {
        String groupId1 = "group1";
        String groupId2 = "group2";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m1").setSubscribedTopicNames(Arrays.asList("foo", "bar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(Arrays.asList("foo", "bar", "zar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m2").setSubscribedTopicNames(Arrays.asList("bar", "zar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(Arrays.asList("foo", "bar")).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId1, (String)"group1-m1"));
        context.replay(RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId1, (String)"group1-m1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1, groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(Collections.singletonList("foo")).build()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId2}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId2, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m2").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{groupId1}), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)groupId1, (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m2").setSubscribedTopicNames(Collections.emptyList()).build()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("foo"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("bar"));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptySet(), (Object)context.groupMetadataManager.groupsSubscribedToTopic("zar"));
    }

    @Test
    public void testOnNewMetadataImageWithEmptyDelta() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(new MockPartitionAssignor("range"))).build();
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        context.groupMetadataManager.onNewMetadataImage(image, delta);
        org.junit.jupiter.api.Assertions.assertEquals((Object)image, (Object)context.groupMetadataManager.image());
    }

    @Test
    public void testOnNewMetadataImage() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(new MockPartitionAssignor("range"))).build();
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)"group1", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group1-m1").setSubscribedTopicNames(Arrays.asList("a", "b")).build()));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)"group2", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group2-m1").setSubscribedTopicNames(Arrays.asList("b", "c")).build()));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)"group3", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group3-m1").setSubscribedTopicNames(Collections.singletonList("d")).build()));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)"group4", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group4-m1").setSubscribedTopicNames(Collections.singletonList("e")).build()));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)"group5", (ConsumerGroupMember)new ConsumerGroupMember.Builder("group5-m1").setSubscribedTopicNames(Collections.singletonList("f")).build()));
        Arrays.asList("group1", "group2", "group3", "group4", "group5").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false);
            group.setMetadataRefreshDeadline(context.time.milliseconds() + 5000L, 0);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        Uuid topicA = Uuid.randomUuid();
        Uuid topicB = Uuid.randomUuid();
        Uuid topicC = Uuid.randomUuid();
        Uuid topicD = Uuid.randomUuid();
        Uuid topicE = Uuid.randomUuid();
        MetadataDelta delta = new MetadataDelta(MetadataImage.EMPTY, __ -> null, new MetadataEncryptorFactory());
        delta.replay(new TopicRecord().setTopicId(topicA).setName("a"));
        delta.replay(new PartitionRecord().setTopicId(topicA).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicB).setName("b"));
        delta.replay(new PartitionRecord().setTopicId(topicB).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicC).setName("c"));
        delta.replay(new PartitionRecord().setTopicId(topicC).setPartitionId(0));
        delta.replay(new TopicRecord().setTopicId(topicD).setName("d"));
        delta.replay(new PartitionRecord().setTopicId(topicD).setPartitionId(0));
        MetadataImage image = delta.apply(MetadataProvenance.EMPTY);
        delta = new MetadataDelta(image, __ -> null, new MetadataEncryptorFactory());
        delta.replay(new PartitionRecord().setTopicId(topicB).setPartitionId(2));
        delta.replay(new RemoveTopicRecord().setTopicId(topicD));
        delta.replay(new TopicRecord().setTopicId(topicE).setName("e"));
        delta.replay(new PartitionRecord().setTopicId(topicE).setPartitionId(1));
        image = delta.apply(MetadataProvenance.EMPTY);
        context.groupMetadataManager.onNewMetadataImage(image, delta);
        Arrays.asList("group1", "group2", "group3", "group4").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        Collections.singletonList("group5").forEach(groupId -> {
            ConsumerGroup group = context.groupMetadataManager.getOrMaybeCreateConsumerGroup(groupId, false);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMetadataExpired(context.time.milliseconds()));
        });
        org.junit.jupiter.api.Assertions.assertEquals((Object)image, (Object)context.groupMetadataManager.image());
    }

    @Test
    public void testSessionTimeoutLifecycle() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(-1));
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRevocationTimeout(groupId, memberId);
    }

    @Test
    public void testSessionTimeoutExpiration() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(45001L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.consumerGroupSessionTimeoutKey((String)groupId, (String)memberId), new CoordinatorResult(Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap()), RecordHelpers.newGroupEpochRecord((String)groupId, (int)2))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRevocationTimeout(groupId, memberId);
    }

    @Test
    public void testSessionTimeoutExpirationStaticMember() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5))))));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setInstanceId(memberId).setMemberEpoch(-2).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        org.junit.jupiter.api.Assertions.assertEquals((int)-2, (int)((ConsumerGroupHeartbeatResponseData)result.response()).memberEpoch());
        context.assertSessionTimeout(groupId, memberId, 45000L);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(45001L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.consumerGroupSessionTimeoutKey((String)groupId, (String)memberId), new CoordinatorResult(Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId), RecordHelpers.newGroupSubscriptionMetadataRecord((String)groupId, Collections.emptyMap()), RecordHelpers.newGroupEpochRecord((String)groupId, (int)2))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId);
        context.assertNoRevocationTimeout(groupId, memberId);
    }

    @Test
    public void testRevocationTimeoutLifecycle() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final String memberId3 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(180000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))));
            }
        }));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(2).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setRebalanceTimeoutMs(12000).setSubscribedTopicNames(Collections.singletonList("foo")));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1))))), (ConsumerGroupHeartbeatResponseData)result.response());
        context.assertRevocationTimeout(groupId, memberId1, 12000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))));
                this.put(memberId3, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 1))));
            }
        }));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId3).setMemberEpoch(0).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId3).setMemberEpoch(3).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setRebalanceTimeoutMs(90000).setSubscribedTopicNames(Collections.singletonList("foo")));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(0))))), (ConsumerGroupHeartbeatResponseData)result.response());
        MockCoordinatorTimer.ScheduledTimeout<Void, Record> scheduledTimeout = context.assertRevocationTimeout(groupId, memberId1, 90000L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1).setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatRequestData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(0)))));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(3).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Collections.singletonList(0))))), (ConsumerGroupHeartbeatResponseData)result.response());
        context.assertNoRevocationTimeout(groupId, memberId1);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), (Object)scheduledTimeout.operation.generateRecords().records());
    }

    @Test
    public void testRevocationTimeoutExpiration() {
        String groupId = "fooup";
        final String memberId1 = Uuid.randomUuid().toString();
        final String memberId2 = Uuid.randomUuid().toString();
        final Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))));
            }
        }));
        CoordinatorResult<ConsumerGroupHeartbeatResponseData, Record> result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(0).setRebalanceTimeoutMs(10000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1, 2))))), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        assignor.prepareGroupAssignment(new GroupAssignment((Map)new HashMap<String, MemberAssignment>(){
            {
                this.put(memberId1, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1))));
                this.put(memberId2, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 2))));
            }
        }));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId2).setMemberEpoch(0).setRebalanceTimeoutMs(10000).setSubscribedTopicNames(Collections.singletonList("foo")).setTopicPartitions(Collections.emptyList()));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId2).setMemberEpoch(2).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()), (ConsumerGroupHeartbeatResponseData)result.response());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), context.sleep(((ConsumerGroupHeartbeatResponseData)result.response()).heartbeatIntervalMs()));
        result = context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId1).setMemberEpoch(1));
        Assertions.assertResponseEquals(new ConsumerGroupHeartbeatResponseData().setMemberId(memberId1).setMemberEpoch(1).setHeartbeatIntervalMs(5000).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment().setTopicPartitions(Collections.singletonList(new ConsumerGroupHeartbeatResponseData.TopicPartitions().setTopicId(fooTopicId).setPartitions(Arrays.asList(0, 1))))), (ConsumerGroupHeartbeatResponseData)result.response());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(10001L);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(new MockCoordinatorTimer.ExpiredTimeout(GroupMetadataManager.consumerGroupRevocationTimeoutKey((String)groupId, (String)memberId1), new CoordinatorResult(Arrays.asList(RecordHelpers.newCurrentAssignmentTombstoneRecord((String)groupId, (String)memberId1), RecordHelpers.newTargetAssignmentTombstoneRecord((String)groupId, (String)memberId1), RecordHelpers.newMemberSubscriptionTombstoneRecord((String)groupId, (String)memberId1), RecordHelpers.newGroupEpochRecord((String)groupId, (int)3))))), timeouts);
        context.assertNoSessionTimeout(groupId, memberId1);
        context.assertNoRevocationTimeout(groupId, memberId1);
    }

    @Test
    public void testOnLoaded() {
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(new MockPartitionAssignor("range"))).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).build()).withConsumerGroup(new ConsumerGroupBuilder("foo", 10).withMember(new ConsumerGroupMember.Builder("foo-1").setMemberEpoch(9).setPreviousMemberEpoch(9).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Collections.singletonList("foo")).setServerAssignorName("range").setAssignedPartitions(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).setPartitionsPendingRevocation(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build()).withMember(new ConsumerGroupMember.Builder("foo-2").setMemberEpoch(10).setPreviousMemberEpoch(10).setTargetMemberEpoch(10).setClientId("client").setClientHost("localhost/127.0.0.1").setSubscribedTopicNames(Collections.singletonList("foo")).setServerAssignorName("range").setPartitionsPendingAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).build()).withAssignment("foo-1", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2))).withAssignment("foo-2", AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 3, 4, 5))).withAssignmentEpoch(10)).build();
        context.groupMetadataManager.onLoaded();
        org.junit.jupiter.api.Assertions.assertNotNull(context.timer.timeout(GroupMetadataManager.consumerGroupSessionTimeoutKey((String)"foo", (String)"foo-1")));
        org.junit.jupiter.api.Assertions.assertNotNull(context.timer.timeout(GroupMetadataManager.consumerGroupSessionTimeoutKey((String)"foo", (String)"foo-2")));
        org.junit.jupiter.api.Assertions.assertNotNull(context.timer.timeout(GroupMetadataManager.consumerGroupRevocationTimeoutKey((String)"foo", (String)"foo-1")));
    }

    @Test
    public void testGenerateRecordsOnNewClassicGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newEmptyGroupMetadataRecord((ClassicGroup)group, (MetadataVersion)MetadataVersion.latestTesting())), joinResult.records);
    }

    @Test
    public void testGenerateRecordsOnNewClassicGroupFailureTransformsError() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.completeExceptionally((Throwable)new NotLeaderOrFollowerException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NOT_COORDINATOR.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplayGroupMetadataRecords(boolean useDefaultRebalanceTimeout) {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>();
        ArrayList expectedMembers = new ArrayList();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection expectedProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0);
        expectedProtocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("range").setMetadata(subscription));
        IntStream.range(0, 2).forEach(i -> {
            members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(useDefaultRebalanceTimeout ? -1 : 9000));
            expectedMembers.add(new ClassicGroupMember("member-" + i, Optional.of("group-instance-id-" + i), "client-" + i, "host-" + i, useDefaultRebalanceTimeout ? 4000 : 9000, 4000, "consumer", expectedProtocols, new byte[]{2}));
        });
        Record groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()), MetadataVersion.latestTesting());
        context.replay(groupMetadataRecord);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        ClassicGroup expectedGroup = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.STABLE, (Time)context.time, new GroupCoordinatorMetricsShard(context.snapshotRegistry, Collections.emptyMap(), new TopicPartition("__consumer_offsets", 0)), 1, Optional.of("consumer"), Optional.of("range"), Optional.of("member-0"), Optional.of(context.time.milliseconds()));
        expectedMembers.forEach(arg_0 -> ((ClassicGroup)expectedGroup).add(arg_0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.groupId(), (Object)group.groupId());
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedGroup.generationId(), (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.protocolType(), (Object)group.protocolType());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.protocolName(), (Object)group.protocolName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.leaderOrNull(), (Object)group.leaderOrNull());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.currentState(), (Object)group.currentState());
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedGroup.currentStateTimestampOrDefault(), (long)group.currentStateTimestampOrDefault());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedGroup.currentClassicGroupMembers(), (Object)group.currentClassicGroupMembers());
    }

    @Test
    public void testOnLoadedExceedGroupMaxSizeTriggersRebalance() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(1).build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>();
        IntStream.range(0, 2).forEach(i -> members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(9000)));
        Record groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()), MetadataVersion.latestTesting());
        context.replay(groupMetadataRecord);
        context.groupMetadataManager.onLoaded();
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
    }

    @Test
    public void testOnLoadedSchedulesClassicGroupMemberHeartbeats() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        byte[] subscription = ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"))).array();
        ArrayList<GroupMetadataValue.MemberMetadata> members = new ArrayList<GroupMetadataValue.MemberMetadata>();
        IntStream.range(0, 2).forEach(i -> members.add(new GroupMetadataValue.MemberMetadata().setMemberId("member-" + i).setGroupInstanceId("group-instance-id-" + i).setSubscription(subscription).setAssignment(new byte[]{2}).setClientId("client-" + i).setClientHost("host-" + i).setSessionTimeout(4000).setRebalanceTimeout(9000)));
        Record groupMetadataRecord = GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", new GroupMetadataValue().setMembers(members).setGeneration(1).setLeader("member-0").setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()), MetadataVersion.latestTesting());
        context.replay(groupMetadataRecord);
        context.groupMetadataManager.onLoaded();
        IntStream.range(0, 2).forEach(i -> {
            MockCoordinatorTimer.ScheduledTimeout<Void, Record> timeout = context.timer.timeout(GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)"member-1"));
            org.junit.jupiter.api.Assertions.assertNotNull(timeout);
            org.junit.jupiter.api.Assertions.assertEquals((long)(context.time.milliseconds() + 4000L), (long)timeout.deadlineMs);
        });
    }

    @Test
    public void testJoinGroupShouldReceiveErrorIfGroupOverMaxSize() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(10).build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withReason("exceed max group size").build();
        IntStream.range(0, 10).forEach(i -> {
            GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        });
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.GROUP_MAX_SIZE_REACHED.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testDynamicMembersJoinGroupWithMaxSizeAndRequiredKnownMember() {
        boolean requiredKnownMemberId = true;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(groupMaxSize).withClassicGroupInitialRebalanceDelayMs(50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, 0, Errors.MEMBER_ID_REQUIRED);
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)memberIds.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)group.numPendingJoinMembers());
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        List<GroupMetadataManagerTestContext.JoinResult> thirdRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(thirdRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
    }

    @Test
    public void testDynamicMembersJoinGroupWithMaxSizeAndNotRequiredKnownMember() {
        boolean requiredKnownMemberId = false;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(groupMaxSize).withClassicGroupInitialRebalanceDelayMs(50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, 10, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testStaticMembersJoinGroupWithMaxSize() {
        int groupMaxSize = 10;
        List groupInstanceIds = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> "instance-id-" + i).collect(Collectors.toList());
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(groupMaxSize).withClassicGroupInitialRebalanceDelayMs(50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = groupInstanceIds.stream().map(instanceId -> context.sendClassicGroupJoin(request.setGroupInstanceId(instanceId))).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        List<GroupMetadataManagerTestContext.JoinResult> secondRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(i -> context.sendClassicGroupJoin(request.setMemberId((String)memberIds.get(i)).setGroupInstanceId((String)groupInstanceIds.get(i)))).collect(Collectors.toList());
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(secondRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testDynamicMembersCanRejoinGroupWithMaxSizeWhileRebalancing() {
        boolean requiredKnownMemberId = true;
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(groupMaxSize).withClassicGroupInitialRebalanceDelayMs(50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        List<GroupMetadataManagerTestContext.JoinResult> firstRoundJoinResults = IntStream.range(0, groupMaxSize + 1).mapToObj(__ -> context.sendClassicGroupJoin(request, requiredKnownMemberId)).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        List<String> memberIds = GroupMetadataManagerTest.verifyClassicGroupJoinResponses(firstRoundJoinResults, 0, Errors.MEMBER_ID_REQUIRED);
        org.junit.jupiter.api.Assertions.assertEquals((int)(groupMaxSize + 1), (int)memberIds.size());
        memberIds.forEach(memberId -> {
            GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        List<GroupMetadataManagerTestContext.JoinResult> thirdRoundJoinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(request.setMemberId(memberId), requiredKnownMemberId)).collect(Collectors.toList());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(50L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(thirdRoundJoinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testLastJoiningMembersAreKickedOutWhenRejoiningGroupWithMaxSize() {
        int groupMaxSize = 10;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSize(groupMaxSize).withClassicGroupInitialRebalanceDelayMs(50).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        List<String> memberIds = IntStream.range(0, groupMaxSize + 2).mapToObj(i -> group.generateMemberId("client-id", Optional.empty())).collect(Collectors.toList());
        memberIds.forEach(memberId -> group.add(new ClassicGroupMember(memberId, Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", GroupMetadataManagerTestContext.toProtocols("range"))));
        context.groupMetadataManager.prepareRebalance(group, "test");
        List<GroupMetadataManagerTestContext.JoinResult> joinResults = memberIds.stream().map(memberId -> context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId((String)memberId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build())).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        GroupMetadataManagerTest.verifyClassicGroupJoinResponses(joinResults, groupMaxSize, Errors.GROUP_MAX_SIZE_REACHED);
        org.junit.jupiter.api.Assertions.assertEquals((int)groupMaxSize, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        memberIds.subList(groupMaxSize, groupMaxSize + 2).forEach(memberId -> org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMemberId(memberId)));
        memberIds.subList(0, groupMaxSize).forEach(memberId -> org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(memberId)));
    }

    @Test
    public void testJoinGroupSessionTimeoutTooSmall() throws Exception {
        int minSessionTimeout = 50;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMinSessionTimeoutMs(minSessionTimeout).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withSessionTimeoutMs(minSessionTimeout - 1).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INVALID_SESSION_TIMEOUT.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupSessionTimeoutTooLarge() throws Exception {
        int maxSessionTimeout = 50;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupMaxSessionTimeoutMs(maxSessionTimeout).build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withSessionTimeoutMs(maxSessionTimeout + 1).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INVALID_SESSION_TIMEOUT.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupUnknownMemberNewGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withGroupInstanceId("group-instance-id").build();
        joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testClassicGroupJoinInconsistentProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("connect").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupWithEmptyProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
        joinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("group-instance-id"), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupWithEmptyGroupProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0)).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testNewMemberJoinExpiration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000 + context.classicGroupNewMemberJoinTimeoutMs).withRebalanceTimeoutMs(2 * context.classicGroupNewMemberJoinTimeoutMs).build();
        JoinGroupResponseData firstResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        String firstMemberId = firstResponse.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstResponse.leader(), (Object)firstMemberId);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)group);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        GroupMetadataManagerTestContext.JoinResult secondJoinResult = context.sendClassicGroupJoin(request.setSessionTimeoutMs(5000).setRebalanceTimeoutMs(5000));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        ClassicGroupMember newMember = group.allMembers().stream().filter(ClassicGroupMember::isNew).findFirst().get();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)firstMemberId, (Object)newMember.memberId());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupNewMemberJoinTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondJoinResult.joinFuture.isDone());
        JoinGroupResponseData secondResponse = secondJoinResult.joinFuture.get();
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)secondResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        org.junit.jupiter.api.Assertions.assertEquals((Object)firstMemberId, (Object)((ClassicGroupMember)group.allMembers().iterator().next()).memberId());
    }

    @Test
    public void testJoinGroupInconsistentGroupProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)otherJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupSecondJoinInconsistentProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        String memberId = joinResult.joinFuture.get().memberId();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection emptyProtocols = new JoinGroupRequestData.JoinGroupRequestProtocolCollection(0);
        request = request.setMemberId(memberId).setProtocols(emptyProtocols);
        joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (short)joinResult.joinFuture.get().errorCode());
        joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("range")), true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberJoinAsFirstMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        context.joinClassicGroupAndCompleteJoin(request, false, true);
    }

    @Test
    public void testStaticMemberRejoinWithExplicitUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(5000).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, false, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId("unknown-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(5000).build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId("other-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerNewDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupProtocolTypeIsNotProvidedWhenAnErrorOccurs() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertNull((Object)joinResult.joinFuture.get().protocolType());
    }

    @Test
    public void testJoinGroupReturnsTheProtocolType() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"consumer", (Object)leaderJoinResult.joinFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"consumer", (Object)memberJoinResult.joinFuture.get().protocolType());
    }

    @Test
    public void testDelayInitialRebalanceByGroupInitialRebalanceDelayOnEmptyGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2 + 1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testResetRebalanceDelayWhenNewMemberJoinsGroupDuringInitialRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(context.classicGroupInitialRebalanceDelayMs * 3).build();
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs - 1));
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2L));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2 + 1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs / 2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testDelayRebalanceUptoRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(context.classicGroupInitialRebalanceDelayMs * 2).build();
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs + 1));
        GroupMetadataManagerTestContext.JoinResult thirdMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thirdMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)thirdMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs - 1));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)thirdMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thirdMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)thirdMemberJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupReplaceStaticMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult oldMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)newMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
    }

    @Test
    public void testHeartbeatExpirationShouldRemovePendingMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numPendingJoinMembers());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1000L));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testHeartbeatExpirationShouldRemoveMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withClassicGroupInitialRebalanceDelayMs(600000).build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        String memberId = group.leaderOrNull();
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(context.classicGroupNewMemberJoinTimeoutMs);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        timeouts.forEach(timeout -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)memberId), (Object)timeout.key);
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), (Object)timeout.result.records());
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.size());
    }

    @Test
    public void testExistingMemberJoinDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(memberId));
        group.transitionTo(ClassicGroupState.DEAD);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupExistingPendingMemberWithGroupInstanceIdThrowsException() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String memberId = joinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> context.sendClassicGroupJoin(request.setMemberId(memberId).setGroupInstanceId("group-instance-id")));
    }

    @Test
    public void testJoinGroupExistingMemberUpdatedMetadataTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(protocols).build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        ClassicGroupMember member = group.member(memberId);
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)member.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId).setProtocols(protocols));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)member.supportedProtocols());
    }

    @Test
    public void testJoinGroupAsExistingLeaderTriggersRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(memberId));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testJoinGroupAsExistingMemberWithUpdatedMetadataTriggersRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        String leaderId = leaderResponse.leader();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        group.transitionTo(ClassicGroupState.STABLE);
        String memberId = memberJoinResult.joinFuture.get().memberId();
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        memberJoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId).setProtocols(protocols));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
    }

    @Test
    public void testJoinGroupExistingMemberDoesNotTriggerRebalanceInStableState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        String leaderId = leaderResponse.leader();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setMemberId(leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        String memberId = memberJoinResult.joinFuture.get().memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        memberJoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)memberJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testJoinGroupExistingMemberInEmptyState() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String memberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)joinResult.joinFuture.get().generationId());
    }

    @Test
    public void testCompleteJoinRemoveNotYetRejoinedDynamicMembers() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).withRebalanceTimeoutMs(1000).build();
        JoinGroupResponseData leaderResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(request);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult memberJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(1000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)memberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)memberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(memberJoinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testCompleteJoinPhaseInEmptyStateSkipsRebalance() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(1000).withRebalanceTimeoutMs(1000).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        group.transitionTo(ClassicGroupState.DEAD);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.generationId());
    }

    @Test
    public void testCompleteJoinPhaseNoMembersRejoinedExtendsJoinPhase() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("first-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(30000).withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData firstMemberResponse = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberResponse.errorCode());
        String firstMemberId = firstMemberResponse.memberId();
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("second-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult firstMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(firstMemberId).setGroupInstanceId("first-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        String secondMemberId = secondMemberJoinResult.joinFuture.get().memberId();
        context.groupMetadataManager.prepareRebalance(group, "trigger rebalance");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numAwaitingJoinResponse());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)(context.timer.timeout((String)"join-group-id").deadlineMs - context.time.milliseconds()));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)(context.timer.timeout((String)"join-group-id").deadlineMs - context.time.milliseconds()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        firstMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(firstMemberId).setGroupInstanceId("first-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        secondMemberJoinResult = context.sendClassicGroupJoin(request.setMemberId(secondMemberId).setGroupInstanceId("second-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)firstMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)firstMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplaceStaticMemberInStableStateNoError(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        String oldMemberId = response.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.STABLE);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range", "roundrobin");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(protocols).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(4500), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String newMemberId = group.staticMemberId("group-instance-id");
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setLeader(oldMemberId).setMemberId(newMemberId).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(supportSkippingAssignment).setErrorCode(Errors.NONE.code());
        if (supportSkippingAssignment) {
            expectedResponse.setMembers(Collections.singletonList(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(newMemberId).setGroupInstanceId("group-instance-id").setMetadata(protocols.find("range").metadata()))).setLeader(newMemberId);
        }
        ClassicGroupMember updatedMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)newMemberId, (Object)updatedMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)updatedMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)7000, (int)updatedMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)4500, (int)updatedMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)updatedMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testReplaceStaticMemberInStableStateWithUpdatedProtocolTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range", "roundrobin")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("roundrobin")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testReplaceStaticMemberInStableStateErrors() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(protocols).withRebalanceTimeoutMs(4000).withSessionTimeoutMs(3000).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String oldMemberId = response.memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        protocols.add((ImplicitLinkedHashCollection.Element)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("roundrobin").setMetadata(ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("bar"))).array()));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(protocols).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(6000), false, false);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(Collections.emptyList()).setLeader(oldMemberId).setMemberId("").setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(false).setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        ClassicGroupMember revertedMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)oldMemberId, (Object)revertedMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)revertedMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)4000, (int)revertedMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)3000, (int)revertedMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)protocols, (Object)revertedMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testReplaceStaticMemberInStableStateSucceeds(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withProtocolType("consumer").withProtocols(GroupMetadataManagerTestContext.toProtocols("range")).build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String oldMemberId = response.memberId();
        group.transitionTo(ClassicGroupState.STABLE);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request.setProtocols(GroupMetadataManagerTestContext.toProtocols("range", "roundrobin")).setRebalanceTimeoutMs(7000).setSessionTimeoutMs(6000), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), joinResult.records);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setMembers(supportSkippingAssignment ? GroupMetadataManagerTest.toJoinResponseMembers(group) : Collections.emptyList()).setLeader(supportSkippingAssignment ? joinResult.joinFuture.get().memberId() : oldMemberId).setMemberId(joinResult.joinFuture.get().memberId()).setGenerationId(1).setProtocolType("consumer").setProtocolName("range").setSkipAssignment(supportSkippingAssignment).setErrorCode(Errors.NONE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)joinResult.joinFuture.get());
        ClassicGroupMember newMember = group.member(group.staticMemberId("group-instance-id"));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)oldMemberId, (Object)newMember.memberId());
        org.junit.jupiter.api.Assertions.assertEquals(Optional.of("group-instance-id"), (Object)newMember.groupInstanceId());
        org.junit.jupiter.api.Assertions.assertEquals((int)7000, (int)newMember.rebalanceTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((int)6000, (int)newMember.sessionTimeoutMs());
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManagerTestContext.toProtocols("range", "roundrobin"), (Object)newMember.supportedProtocols());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testReplaceStaticMemberInCompletingRebalanceStateTriggersRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData response = context.joinClassicGroupAndCompleteJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)response.errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testJoinGroupAppendErrorConversion() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.NOT_ENOUGH_REPLICAS));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.REQUEST_TIMED_OUT));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.NOT_LEADER_OR_FOLLOWER));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.KAFKA_STORAGE_ERROR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.MESSAGE_TOO_LARGE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.RECORD_LIST_TOO_LARGE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.UNKNOWN_SERVER_ERROR, (Object)GroupMetadataManager.appendGroupMetadataErrorToResponseError((Errors)Errors.INVALID_FETCH_SIZE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, (Object)Errors.LEADER_NOT_AVAILABLE);
    }

    @Test
    public void testNewMemberTimeoutCompletion() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(context.classicGroupNewMemberJoinTimeoutMs + 5000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupInitialRebalanceDelayMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)group.allMembers().stream().filter(ClassicGroupMember::isNew).count());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(joinResult.joinFuture.get().memberId()).withGenerationId(joinResult.joinFuture.get().generationId()).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(context.classicGroupNewMemberJoinTimeoutMs));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(5000L);
        List<Record> expectedRecords = Collections.singletonList(GroupMetadataManagerTestContext.newGroupMetadataRecord(group.groupId(), new GroupMetadataValue().setMembers(Collections.emptyList()).setGeneration(2).setLeader(null).setProtocolType("consumer").setProtocol(null).setCurrentStateTimestamp(context.time.milliseconds()), MetadataVersion.latestTesting()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        String memberId = joinResult.joinFuture.get().memberId();
        timeouts.forEach(timeout -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupHeartbeatKey((String)"group-id", (String)memberId), (Object)timeout.key);
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedRecords, (Object)timeout.result.records());
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
    }

    @Test
    public void testNewMemberFailureAfterJoinGroupCompletion() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withSessionTimeoutMs(5000).withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResponse.errorCode());
        String memberId = joinResponse.memberId();
        org.junit.jupiter.api.Assertions.assertEquals((Object)memberId, (Object)joinResponse.leader());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)joinResponse.generationId());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(1).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherJoinResult.joinFuture.get().errorCode());
        context.verifySessionExpiration(group, 5000);
    }

    @Test
    public void testStaticMemberFenceDuplicateRejoinedFollower() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerJoinResult.joinFuture.isDone());
        context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.FENCED_INSTANCE_ID.code()).setProtocolName(null).setProtocolType(null).setLeader("").setMemberId(rebalanceResult.followerId).setGenerationId(-1);
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.PREPARING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberFenceDuplicateSyncingFollowerAfterMemberIdChanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().withRebalanceTimeoutMs(10000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)leaderJoinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(oldFollowerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer");
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerId, (Object)oldFollowerJoinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.leaderId, (Object)oldFollowerJoinResult.joinFuture.get().leader());
        GroupMetadataManagerTestContext.SyncResult oldFollowerSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(oldFollowerJoinResult.joinFuture.get().generationId()).withMemberId(oldFollowerJoinResult.joinFuture.get().memberId()).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerSyncResult.syncFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult duplicateFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldFollowerSyncResult.syncFuture.get().errorCode());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(10000L);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)timeouts.size());
        timeouts.forEach(timeout -> org.junit.jupiter.api.Assertions.assertEquals(timeout.result, (Object)GroupMetadataManager.EMPTY_RESULT));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(duplicateFollowerJoinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)duplicateFollowerJoinResult.joinFuture.get().memberId(), (Object)duplicateFollowerJoinResult.joinFuture.get().leader());
    }

    @Test
    public void testStaticMemberFenceDuplicateRejoiningFollowerAfterMemberIdChanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult duplicateFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId("").setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedDuplicateFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(duplicateFollowerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedDuplicateFollowerResponse, duplicateFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)duplicateFollowerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedOldFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.FENCED_INSTANCE_ID.code()).setGenerationId(-1).setMemberId(rebalanceResult.followerId).setLeader("").setProtocolName(null).setProtocolType(null).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedOldFollowerResponse, oldFollowerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberRejoinWithKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withGroupInstanceId("group-instance-id").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(request, false, false);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResponse.errorCode());
        String memberId = joinResponse.memberId();
        GroupMetadataManagerTestContext.JoinResult rejoinResult = context.sendClassicGroupJoin(request.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)rejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)rejoinResult.joinFuture.get().errorCode());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(joinResponse.generationId()).withGroupInstanceId("group-instance-id").build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStaticMemberRejoinWithLeaderIdAndUnknownMemberId(boolean supportSkippingAssignment) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest, true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), joinResult.records);
        joinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        String leader = supportSkippingAssignment ? joinResult.joinFuture.get().memberId() : rebalanceResult.leaderId;
        List<Object> members = supportSkippingAssignment ? GroupMetadataManagerTest.toJoinResponseMembers(group) : Collections.emptyList();
        JoinGroupResponseData expectedJoinResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(joinResult.joinFuture.get().memberId()).setLeader(leader).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(supportSkippingAssignment).setMembers(members);
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedJoinResponse, joinResult.joinFuture.get(), group, ClassicGroupState.STABLE, supportSkippingAssignment ? Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}) : Collections.emptySet());
        GroupMetadataManagerTestContext.JoinResult oldLeaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(rebalanceResult.leaderId), true, supportSkippingAssignment);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldLeaderJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData oldLeaderSyncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(rebalanceResult.leaderId).build();
        GroupMetadataManagerTestContext.SyncResult oldLeaderSyncResult = context.sendClassicGroupSync(oldLeaderSyncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldLeaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)oldLeaderSyncResult.syncFuture.get().errorCode());
        SyncGroupRequestData newLeaderSyncRequest = oldLeaderSyncRequest.setGroupInstanceId(null);
        GroupMetadataManagerTestContext.SyncResult newLeaderSyncResult = context.sendClassicGroupSync(newLeaderSyncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLeaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newLeaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)newLeaderSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(request, true, true, 10000);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)group.hasMemberId(rebalanceResult.followerId));
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.leaderId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Collections.singleton("leader-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndUnexpectedDeadGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.DEAD);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.COORDINATOR_NOT_AVAILABLE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithLeaderIdAndUnexpectedEmptyGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithFollowerIdAndChangeOfProtocol() throws Exception {
        int rebalanceTimeoutMs = 10000;
        int sessionTimeoutMs = 15000;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("roundrobin");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.followerId).withProtocols(protocols).withRebalanceTimeoutMs(rebalanceTimeoutMs).withSessionTimeoutMs(sessionTimeoutMs).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(rebalanceResult.followerId));
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(rebalanceResult.followerId).setLeader(rebalanceResult.followerId).setProtocolName("roundrobin").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}));
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWithSelectedProtocolChanged() throws Exception {
        int rebalanceTimeoutMs = 10000;
        int sessionTimeoutMs = 15000;
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)"roundrobin", (Object)group.selectProtocol());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("roundrobin");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).withRebalanceTimeoutMs(rebalanceTimeoutMs).withSessionTimeoutMs(sessionTimeoutMs).build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"roundrobin", (Object)group.selectProtocol());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isLeader(joinResult.joinFuture.get().memberId()));
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)joinResult.joinFuture.get().memberId());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(joinResult.joinFuture.get().memberId()).setLeader(joinResult.joinFuture.get().memberId()).setProtocolName("roundrobin").setProtocolType("consumer").setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, joinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}));
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWhileSelectProtocolUnchangedPersistenceFailure() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols(group.selectProtocol());
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), followerJoinResult.records);
        followerJoinResult.appendFuture.completeExceptionally((Throwable)Errors.MESSAGE_TOO_LARGE.exception());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)followerJoinResult.joinFuture.get().memberId());
        followerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("leader-instance-id").setMemberId(rebalanceResult.leaderId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withGenerationId(rebalanceResult.generationId + 1).build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(syncRequest);
        leaderSyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), leaderSyncResult.records);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
        GroupMetadataManagerTestContext.SyncResult oldMemberSyncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldMemberSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)oldMemberSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinWithUnknownMemberIdAndChangeOfProtocolWhileSelectProtocolUnchanged() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols(group.selectProtocol());
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocols(protocols).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), followerJoinResult.records);
        followerJoinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        String newFollowerId = followerJoinResult.joinFuture.get().memberId();
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)newFollowerId);
        followerJoinResult = context.sendClassicGroupJoin(request.setMemberId(rebalanceResult.followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(rebalanceResult.followerId).withAssignment(Collections.emptyList()).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)syncResult.syncFuture.get().errorCode());
        syncResult = context.sendClassicGroupSync(syncRequest.setMemberId(newFollowerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerAssignment, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testStaticMemberRejoinWithKnownLeaderIdToTriggerRebalanceAndFollowerWithChangeofProtocol() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(leaderJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id"}));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
        JoinGroupRequestData.JoinGroupRequestProtocolCollection protocols = GroupMetadataManagerTestContext.toProtocols("range");
        followerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId).setProtocols(protocols), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(5000L);
        org.junit.jupiter.api.Assertions.assertTrue((timeouts.size() <= 2 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        String newFollowerId = followerJoinResult.joinFuture.get().memberId();
        expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 2).setMemberId(newFollowerId).setLeader(newFollowerId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.singleton("follower-instance-id"));
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), followerJoinResult.records);
        followerJoinResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(followerJoinResult.joinFuture.get().memberId()).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)rebalanceResult.followerId, (Object)followerJoinResult.joinFuture.get().memberId());
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withGenerationId(rebalanceResult.generationId).withMemberId(followerJoinResult.joinFuture.get().memberId()).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)rebalanceResult.followerAssignment, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithKnownMemberIdAndNoProtocolChange() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.followerId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasStaticMember("leader-instance-id"));
        JoinGroupResponseData expectedFollowerResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId).setMemberId(rebalanceResult.followerId).setLeader(rebalanceResult.leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedFollowerResponse, followerJoinResult.joinFuture.get(), group, ClassicGroupState.STABLE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberRejoinAsFollowerWithMismatchedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.followerId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)followerJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberRejoinAsLeaderWithMismatchedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberSyncAsLeaderWithInvalidMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        SyncGroupRequestData request = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("invalid-member-id").build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.FENCED_INSTANCE_ID.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testGetDifferentStaticMemberIdAfterEachRejoin() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String lastMemberId = rebalanceResult.leaderId;
        for (int i = 0; i < 5; ++i) {
            JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
            GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request, true, true);
            org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), leaderJoinResult.records);
            leaderJoinResult.appendFuture.complete(null);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
            org.junit.jupiter.api.Assertions.assertEquals((Object)group.staticMemberId("leader-instance-id"), (Object)leaderJoinResult.joinFuture.get().memberId());
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)lastMemberId, (Object)leaderJoinResult.joinFuture.get().memberId());
            lastMemberId = leaderJoinResult.joinFuture.get().memberId();
        }
    }

    @Test
    public void testStaticMemberJoinWithUnknownInstanceIdAndKnownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("unknown-instance-id").withMemberId(rebalanceResult.leaderId).withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberReJoinWithIllegalStateAsUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        group.transitionTo(ClassicGroupState.EMPTY);
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("follower-instance-id").withMemberId("").withProtocolSuperset().build();
        IllegalStateException exception = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> context.sendClassicGroupJoin(request, true, true));
        String message = exception.getMessage();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.contains(group.groupId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.contains("follower-instance-id"));
    }

    @Test
    public void testStaticMemberFollowerFailToRejoinBeforeRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", 10000, 15000);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String newMemberInstanceId = "new-member-instance-id";
        String leaderId = rebalanceResult.leaderId;
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId(newMemberInstanceId).withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("leader-instance-id").setMemberId(leaderId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(leaderId).setLeader(leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, leaderJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id", newMemberInstanceId}));
        JoinGroupResponseData expectedNewMemberResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newMemberJoinResult.joinFuture.get().memberId()).setLeader(leaderId).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedNewMemberResponse, newMemberJoinResult.joinFuture.get(), group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testStaticMemberLeaderFailToRejoinBeforeRebalanceTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", 10000, 15000);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String newMemberInstanceId = "new-member-instance-id";
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId(newMemberInstanceId).withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult newMemberJoinResult = context.sendClassicGroupJoin(request, true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)newMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult oldFollowerJoinResult = context.sendClassicGroupJoin(request.setGroupInstanceId("follower-instance-id").setMemberId(rebalanceResult.followerId), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)oldFollowerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)oldFollowerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newMemberJoinResult.joinFuture.isDone());
        JoinGroupResponseData oldFollowerJoinResponse = oldFollowerJoinResult.joinFuture.get();
        JoinGroupResponseData newMemberJoinResponse = newMemberJoinResult.joinFuture.get();
        JoinGroupResponseData newLeaderResponse = oldFollowerJoinResponse.leader().equals(oldFollowerJoinResponse.memberId()) ? oldFollowerJoinResponse : newMemberJoinResponse;
        JoinGroupResponseData newFollowerResponse = oldFollowerJoinResponse.leader().equals(oldFollowerJoinResponse.memberId()) ? newMemberJoinResponse : oldFollowerJoinResponse;
        JoinGroupResponseData expectedLeaderResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newLeaderResponse.memberId()).setLeader(newLeaderResponse.memberId()).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(GroupMetadataManagerTest.toJoinResponseMembers(group));
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedLeaderResponse, newLeaderResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Utils.mkSet((Object[])new String[]{"leader-instance-id", "follower-instance-id", newMemberInstanceId}));
        JoinGroupResponseData expectedNewMemberResponse = new JoinGroupResponseData().setErrorCode(Errors.NONE.code()).setGenerationId(rebalanceResult.generationId + 1).setMemberId(newFollowerResponse.memberId()).setLeader(newLeaderResponse.memberId()).setProtocolName("range").setProtocolType("consumer").setSkipAssignment(false).setMembers(Collections.emptyList());
        GroupMetadataManagerTest.checkJoinGroupResponse(expectedNewMemberResponse, newFollowerResponse, group, ClassicGroupState.COMPLETING_REBALANCE, Collections.emptySet());
    }

    @Test
    public void testSyncGroupReturnsAnErrorWhenProtocolTypeIsInconsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.of("protocolType"), Optional.empty(), Errors.INCONSISTENT_GROUP_PROTOCOL, Optional.empty(), Optional.empty());
    }

    @Test
    public void testSyncGroupReturnsAnErrorWhenProtocolNameIsInconsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.empty(), Optional.of("protocolName"), Errors.INCONSISTENT_GROUP_PROTOCOL, Optional.empty(), Optional.empty());
    }

    @Test
    public void testSyncGroupSucceedWhenProtocolTypeAndNameAreNotProvided() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.empty(), Optional.empty(), Errors.NONE, Optional.of("consumer"), Optional.of("range"));
    }

    @Test
    public void testSyncGroupSucceedWhenProtocolTypeAndNameAreConsistent() throws Exception {
        this.testSyncGroupProtocolTypeAndNameWith(Optional.of("consumer"), Optional.of("range"), Errors.NONE, Optional.of("consumer"), Optional.of("range"));
    }

    private void testSyncGroupProtocolTypeAndNameWith(Optional<String> protocolType, Optional<String> protocolName, Errors expectedError, Optional<String> expectedProtocolType, Optional<String> expectedProtocolName) throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withProtocolSuperset().build();
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)leaderJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest.setGroupInstanceId("follower-instance-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(10000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        String leaderId = leaderJoinResult.joinFuture.get().memberId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        int generationId = leaderJoinResult.joinFuture.get().generationId();
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderId));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderId).withProtocolType(protocolType.orElse(null)).withProtocolName(protocolName.orElse(null)).withGenerationId(generationId).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult leaderSyncResult = context.sendClassicGroupSync(syncRequest);
        leaderSyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)leaderSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolType.orElse(null), (Object)leaderSyncResult.syncFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolName.orElse(null), (Object)leaderSyncResult.syncFuture.get().protocolName());
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolType.orElse(null), (Object)followerSyncResult.syncFuture.get().protocolType());
        org.junit.jupiter.api.Assertions.assertEquals(expectedProtocolName.orElse(null), (Object)followerSyncResult.syncFuture.get().protocolName());
    }

    @Test
    public void testSyncGroupFromUnknownGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId("member-id").withGenerationId(1).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testSyncGroupFromUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        String memberId = joinResponse.memberId();
        int generationId = joinResponse.generationId();
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(memberId));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(generationId).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)((SyncGroupRequestData.SyncGroupRequestAssignment)assignment.get(0)).assignment(), (Object)syncResult.syncFuture.get().assignment());
        syncResult = context.sendClassicGroupSync(syncRequest.setMemberId("unknown-member-id"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ClassicGroupMember.EMPTY_ASSIGNMENT, (Object)syncResult.syncFuture.get().assignment());
    }

    @Test
    public void testSyncGroupFromIllegalGeneration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String memberId = joinResponse.memberId();
        int generationId = joinResponse.generationId();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(memberId).withGenerationId(generationId + 1).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.ILLEGAL_GENERATION.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testSyncGroupAsLeaderAppendFailureTransformsError() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        JoinGroupResponseData joinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(joinResponse.memberId()).withGenerationId(1).build());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)syncResult.syncFuture.isDone());
        syncResult.appendFuture.completeExceptionally((Throwable)new NotLeaderOrFollowerException());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NOT_COORDINATOR.code(), (short)syncResult.syncFuture.get().errorCode());
    }

    @Test
    public void testJoinGroupFromUnchangedFollowerDoesNotRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        followerJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)nextGenerationId, (int)followerJoinResult.joinFuture.get().generationId());
    }

    @Test
    public void testLeaderFailureInSyncGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(followerId).withGenerationId(nextGenerationId).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerSyncResult.syncFuture.isDone());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(10000L);
        org.junit.jupiter.api.Assertions.assertTrue((timeouts.size() <= 2 ? 1 : 0) != 0);
        timeouts.forEach(timeout -> org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(followerId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testSyncGroupFollowerAfterLeader() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        byte[] leaderAssignment = new byte[]{0};
        byte[] followerAssignment = new byte[]{1};
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderJoinResponse.memberId()).setAssignment(leaderAssignment));
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerId).setAssignment(followerAssignment));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withGenerationId(leaderJoinResponse.generationId()).withAssignment(assignment).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest.setGenerationId(nextGenerationId));
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderAssignment, (Object)syncResult.syncFuture.get().assignment());
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId).setGenerationId(nextGenerationId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)followerAssignment, (Object)followerSyncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testSyncGroupLeaderAfterFollower() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        GroupMetadataManagerTestContext.JoinResult followerJoinResult = context.sendClassicGroupJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerJoinResult.joinFuture.isDone());
        GroupMetadataManagerTestContext.JoinResult leaderJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(leaderJoinResponse.memberId()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)leaderJoinResult.joinFuture.get().generationId(), (int)followerJoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)leaderJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderJoinResponse.memberId(), (Object)followerJoinResult.joinFuture.get().leader());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        int nextGenerationId = leaderJoinResult.joinFuture.get().generationId();
        String followerId = followerJoinResult.joinFuture.get().memberId();
        byte[] leaderAssignment = new byte[]{0};
        byte[] followerAssignment = new byte[]{1};
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withGenerationId(leaderJoinResponse.generationId()).build();
        GroupMetadataManagerTestContext.SyncResult followerSyncResult = context.sendClassicGroupSync(syncRequest.setMemberId(followerId).setGenerationId(nextGenerationId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)followerSyncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)followerSyncResult.syncFuture.isDone());
        ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment> assignment = new ArrayList<SyncGroupRequestData.SyncGroupRequestAssignment>();
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(leaderJoinResponse.memberId()).setAssignment(leaderAssignment));
        assignment.add(new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(followerId).setAssignment(followerAssignment));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest.setMemberId(leaderJoinResponse.memberId()).setGenerationId(nextGenerationId).setAssignments(assignment));
        syncResult.appendFuture.complete(null);
        Map<String, byte[]> updatedAssignment = assignment.stream().collect(Collectors.toMap(SyncGroupRequestData.SyncGroupRequestAssignment::memberId, SyncGroupRequestData.SyncGroupRequestAssignment::assignment));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, updatedAssignment, (MetadataVersion)MetadataVersion.latestTesting())), syncResult.records);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)leaderAssignment, (Object)syncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)followerSyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)followerAssignment, (Object)followerSyncResult.syncFuture.get().assignment());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testJoinGroupFromUnchangedLeaderShouldRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.JoinResult leaderRejoinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderRejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaderRejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)leaderRejoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)(leaderJoinResponse.generationId() + 1), (int)leaderRejoinResult.joinFuture.get().generationId());
    }

    @Test
    public void testJoinGroupCompletionWhenPendingMemberJoins() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingMemberResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        JoinGroupRequestData request = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(pendingMemberResponse.memberId()).withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(request);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testJoinGroupCompletionWhenPendingMemberTimesOut() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        context.setupGroupWithPendingMember(group);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(3000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testGenerationIdIncrementsOnRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId(leaderJoinResponse.memberId()).withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)joinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
    }

    @Test
    public void testStaticMemberHeartbeatLeaderWithInvalidMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId(rebalanceResult.leaderId).withGenerationId(rebalanceResult.generationId).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(rebalanceResult.leaderId).setGenerationId(rebalanceResult.generationId);
        HeartbeatResponseData validHeartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)validHeartbeatResponse.errorCode());
        org.junit.jupiter.api.Assertions.assertThrows(FencedInstanceIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest.setGroupInstanceId("leader-instance-id").setMemberId("invalid-member-id")));
    }

    @Test
    public void testHeartbeatUnknownGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(-1);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
    }

    @Test
    public void testHeartbeatDeadGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(-1);
        org.junit.jupiter.api.Assertions.assertThrows(CoordinatorNotAvailableException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
    }

    @Test
    public void testHeartbeatEmptyGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.add(new ClassicGroupMember("member-id", Optional.empty(), "client-id", "client-host", 10000, 5000, "consumer", GroupMetadataManagerTestContext.toProtocols("range")));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId("member-id").setGenerationId(0);
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.UNKNOWN_MEMBER_ID.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testHeartbeatUnknownMemberExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId("unknown-member-id").setGenerationId(leaderJoinResponse.generationId())));
    }

    @Test
    public void testHeartbeatDuringPreparingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build();
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        String memberId = joinResult.joinFuture.get().memberId();
        context.sendClassicGroupJoin(joinRequest.setMemberId(memberId));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(memberId).setGenerationId(0));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testHeartbeatDuringCompletingRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)leaderJoinResponse.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HeartbeatResponseData(), (Object)heartbeatResponse);
    }

    @Test
    public void testHeartbeatIllegalGeneration() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId() + 1)));
    }

    @Test
    public void testValidHeartbeat() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId()));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testClassicGroupMemberSessionTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        context.verifySessionExpiration(group, 5000);
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId())));
    }

    @Test
    public void testClassicGroupMemberHeartbeatMaintainsSession() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testClassicGroupMemberSessionTimeoutDuringRebalance() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.JoinResult otherJoinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(5000L));
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupHeartbeat(heartbeatRequest));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
    }

    @Test
    public void testRebalanceCompletesBeforeMemberJoins() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String firstMemberId = leaderJoinResponse.memberId();
        int firstGenerationId = leaderJoinResponse.generationId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstGenerationId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        SyncGroupRequestData syncRequest = new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(firstMemberId).withGenerationId(firstGenerationId).build();
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(syncRequest);
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        GroupMetadataManagerTestContext.JoinResult secondMemberJoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId("").setGroupInstanceId(null).setSessionTimeoutMs(2500));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        HeartbeatRequestData firstMemberHeartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(firstMemberId).setGenerationId(firstGenerationId);
        for (int i = 0; i < 2; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
            HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest);
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
        }
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(8000L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)secondMemberJoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)secondMemberJoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        String otherMemberId = secondMemberJoinResult.joinFuture.get().memberId();
        syncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId(null).setMemberId(otherMemberId).setGenerationId(2));
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalGenerationException.class, () -> context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest));
        List<Errors> expectedErrors = Arrays.asList(Errors.NONE, Errors.NONE, Errors.REBALANCE_IN_PROGRESS);
        for (Errors expectedError : expectedErrors) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2000L));
            HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest.setMemberId(otherMemberId).setGenerationId(2));
            org.junit.jupiter.api.Assertions.assertEquals((short)expectedError.code(), (short)heartbeatResponse.errorCode());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult otherMemberRejoinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(otherMemberId).setGroupInstanceId(null).setSessionTimeoutMs(2500));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberRejoinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberRejoinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherMemberRejoinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)otherMemberRejoinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.SyncResult otherMemberResyncResult = context.sendClassicGroupSync(syncRequest.setGroupInstanceId(null).setMemberId(otherMemberId).setGenerationId(3));
        otherMemberResyncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)otherMemberResyncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)otherMemberResyncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        for (int i = 0; i < 20; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2000L));
            HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(firstMemberHeartbeatRequest.setMemberId(otherMemberId).setGenerationId(3));
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        }
    }

    @Test
    public void testSyncGroupEmptyAssignment() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId()));
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testSecondMemberPartiallyJoinAndTimeout() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("leader-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAndCompleteJoin(joinRequest, true, true);
        String firstMemberId = leaderJoinResponse.memberId();
        int firstGenerationId = leaderJoinResponse.generationId();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)firstGenerationId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withMemberId(firstMemberId).withGenerationId(firstGenerationId).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId("").setGroupInstanceId(null).setSessionTimeoutMs(5000), true, true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.numPendingJoinMembers());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(firstMemberId).setGenerationId(firstGenerationId);
        for (int i = 0; i < 2; ++i) {
            GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(2500L));
            HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)heartbeatResponse.errorCode());
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.hasMemberId(firstMemberId));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceived() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, Record> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), (Object)timeout.result.records());
        timeout.result.appendFuture().complete(null);
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceivedFromFollowers() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(joinResponses.get(0).memberId()).build());
        syncResult.appendFuture.complete(null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)syncResult.syncFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
        context.verifyHeartbeat(group.groupId(), joinResponses.get(0), Errors.NONE);
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, Record> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty());
        joinResponses.subList(0, 1).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.REBALANCE_IN_PROGRESS));
        joinResponses.subList(1, 3).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testRebalanceTimesOutWhenSyncRequestIsNotReceivedFromLeaders() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List<CompletableFuture> followerSyncFutures = joinResponses.subList(1, 3).stream().map(response -> {
            GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(response.memberId()).build());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)syncResult.syncFuture.isDone());
            return syncResult.syncFuture;
        }).collect(Collectors.toList());
        List<MockCoordinatorTimer.ExpiredTimeout<Void, Record>> timeouts = context.sleep(rebalanceTimeoutMs / 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)timeouts.size());
        MockCoordinatorTimer.ExpiredTimeout<Void, Record> timeout = timeouts.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)GroupMetadataManager.classicGroupSyncKey((String)"group-id"), (Object)timeout.key);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeout.result.records().isEmpty());
        followerSyncFutures.forEach(future -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)future.isDone());
            try {
                org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)((SyncGroupResponseData)future.get()).errorCode());
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
            }
        });
        joinResponses.subList(0, 1).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.UNKNOWN_MEMBER_ID));
        joinResponses.subList(1, 3).forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.REBALANCE_IN_PROGRESS));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testRebalanceDoesNotTimeOutWhenAllSyncAreReceived() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int rebalanceTimeoutMs = 5000;
        int sessionTimeoutMs = 5000;
        List<JoinGroupResponseData> joinResponses = context.joinWithNMembers("group-id", 3, rebalanceTimeoutMs, sessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        String leaderId = joinResponses.get(0).memberId();
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        List syncFutures = joinResponses.stream().map(response -> {
            GroupMetadataManagerTestContext.SyncResult syncResult = context.sendClassicGroupSync(new GroupMetadataManagerTestContext.SyncGroupRequestBuilder().withGroupId("group-id").withGenerationId(1).withMemberId(response.memberId()).build());
            if (response.memberId().equals(leaderId)) {
                org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), syncResult.records);
                syncResult.appendFuture.complete(null);
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.records.isEmpty());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)syncResult.syncFuture.isDone());
            return syncResult.syncFuture;
        }).collect(Collectors.toList());
        for (CompletableFuture syncFuture : syncFutures) {
            org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)((SyncGroupResponseData)syncFuture.get()).errorCode());
        }
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs / 2));
        joinResponses.forEach(response -> context.verifyHeartbeat(group.groupId(), (JoinGroupResponseData)response, Errors.NONE));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.STABLE));
    }

    @Test
    public void testHeartbeatDuringRebalanceCausesRebalanceInProgress() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupRequestData joinRequest = new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().withRebalanceTimeoutMs(10000).withSessionTimeoutMs(5000).build();
        JoinGroupResponseData leaderJoinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(joinRequest);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)leaderJoinResponse.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(joinRequest.setMemberId(""));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.records.isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)joinResult.joinFuture.isDone());
        HeartbeatRequestData heartbeatRequest = new HeartbeatRequestData().setGroupId("group-id").setMemberId(leaderJoinResponse.memberId()).setGenerationId(leaderJoinResponse.generationId());
        HeartbeatResponseData heartbeatResponse = context.sendClassicGroupHeartbeat(heartbeatRequest);
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.REBALANCE_IN_PROGRESS.code(), (short)heartbeatResponse.errorCode());
    }

    @Test
    public void testListGroups() {
        String consumerGroupId = "consumer-group-id";
        String classicGroupId = "classic-group-id";
        String memberId1 = Uuid.randomUuid().toString();
        String fooTopicName = "foo";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupId, 10)).build();
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord(classicGroupId, new GroupMetadataValue().setMembers(Collections.emptyList()).setGeneration(2).setLeader(null).setProtocolType("classic").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds()), MetadataVersion.latestTesting()));
        context.commit();
        ClassicGroup classicGroup = context.groupMetadataManager.getOrMaybeCreateClassicGroup(classicGroupId, false);
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)new ConsumerGroupMember.Builder(memberId1).setSubscribedTopicNames(Collections.singletonList(fooTopicName)).build()));
        context.replay(RecordHelpers.newGroupEpochRecord((String)consumerGroupId, (int)11));
        Map actualAllGroupMap = context.sendListGroups(Collections.emptyList(), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        Map<String, Object> expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.singletonList("empty"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        context.commit();
        actualAllGroupMap = context.sendListGroups(Collections.singletonList("assigning"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.singletonList("Empty"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), Collections.singletonList(Group.GroupType.CLASSIC.toString())).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType("classic").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), Collections.singletonList("Consumer")).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Arrays.asList("empty", "Assigning"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Stream.of(new ListGroupsResponseData.ListedGroup().setGroupId(classicGroup.groupId()).setProtocolType(Group.GroupType.CLASSIC.toString()).setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), new ListGroupsResponseData.ListedGroup().setGroupId(consumerGroupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString())).collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.emptyList(), Collections.singletonList("Invalid")).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Collections.emptyMap();
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
        actualAllGroupMap = context.sendListGroups(Collections.singletonList("Invalid"), Collections.emptyList()).stream().collect(Collectors.toMap(ListGroupsResponseData.ListedGroup::groupId, Function.identity()));
        expectAllGroupMap = Collections.emptyMap();
        org.junit.jupiter.api.Assertions.assertEquals(expectAllGroupMap, actualAllGroupMap);
    }

    @Test
    public void testConsumerGroupDescribeNoErrors() {
        List<String> consumerGroupIds = Arrays.asList("group-id-1", "group-id-2");
        int epoch = 10;
        String memberId = "member-id";
        String topicName = "topicName";
        ConsumerGroupMember.Builder memberBuilder = new ConsumerGroupMember.Builder(memberId).setSubscribedTopicNames(Collections.singletonList(topicName)).setServerAssignorName("assignorName");
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupIds.get(0), epoch)).withConsumerGroup(new ConsumerGroupBuilder(consumerGroupIds.get(1), epoch).withMember(memberBuilder.build())).build();
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = Arrays.asList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupEpoch(epoch).setGroupId(consumerGroupIds.get(0)).setGroupState(ConsumerGroup.ConsumerGroupState.EMPTY.toString()).setAssignorName("range"), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupEpoch(epoch).setGroupId(consumerGroupIds.get(1)).setMembers(Collections.singletonList(memberBuilder.build().asConsumerGroupDescribeMember(new Assignment(Collections.emptyMap()), new MetadataImageBuilder().build().topics()))).setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setAssignorName("assignorName"));
        List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = context.sendConsumerGroupDescribe(consumerGroupIds);
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testConsumerGroupDescribeWithErrors() {
        String groupId = "groupId";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).build();
        List<ConsumerGroupDescribeResponseData.DescribedGroup> actual = context.sendConsumerGroupDescribe(Collections.singletonList(groupId));
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(groupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code());
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = Collections.singletonList(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testConsumerGroupDescribeBeforeAndAfterCommittingOffset() {
        String consumerGroupId = "consumerGroupId";
        int epoch = 10;
        String memberId1 = "memberId1";
        String memberId2 = "memberId2";
        String topicName = "topicName";
        Uuid topicId = Uuid.randomUuid();
        MetadataImage metadataImage = new MetadataImageBuilder().addTopic(topicId, topicName, 3).build();
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(metadataImage).build();
        ConsumerGroupMember.Builder memberBuilder1 = new ConsumerGroupMember.Builder(memberId1).setSubscribedTopicNames(Collections.singletonList(topicName));
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder1.build()));
        context.replay(RecordHelpers.newGroupEpochRecord((String)consumerGroupId, (int)(epoch + 1)));
        HashMap assignmentMap = new HashMap();
        assignmentMap.put(topicId, Collections.emptySet());
        ConsumerGroupMember.Builder memberBuilder2 = new ConsumerGroupMember.Builder(memberId2);
        context.replay(RecordHelpers.newMemberSubscriptionRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder2.build()));
        context.replay(RecordHelpers.newTargetAssignmentRecord((String)consumerGroupId, (String)memberId2, assignmentMap));
        context.replay(RecordHelpers.newCurrentAssignmentRecord((String)consumerGroupId, (ConsumerGroupMember)memberBuilder2.build()));
        context.replay(RecordHelpers.newGroupEpochRecord((String)consumerGroupId, (int)(epoch + 2)));
        List actual = context.groupMetadataManager.consumerGroupDescribe(Collections.singletonList(consumerGroupId), context.lastCommittedOffset);
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(consumerGroupId).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code());
        List<ConsumerGroupDescribeResponseData.DescribedGroup> expected = Collections.singletonList(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
        context.commit();
        actual = context.groupMetadataManager.consumerGroupDescribe(Collections.singletonList(consumerGroupId), context.lastCommittedOffset);
        describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(consumerGroupId).setMembers(Arrays.asList(memberBuilder1.build().asConsumerGroupDescribeMember(new Assignment(Collections.emptyMap()), metadataImage.topics()), memberBuilder2.build().asConsumerGroupDescribeMember(new Assignment(assignmentMap), metadataImage.topics()))).setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setAssignorName("range").setGroupEpoch(epoch + 2);
        expected = Collections.singletonList(describedGroup);
        org.junit.jupiter.api.Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testDescribeGroupStable() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataValue.MemberMetadata memberMetadata = new GroupMetadataValue.MemberMetadata().setMemberId("member-id").setGroupInstanceId("group-instance-id").setClientHost("client-host").setClientId("client-id").setAssignment(new byte[]{0}).setSubscription(new byte[]{0, 1, 2});
        GroupMetadataValue groupMetadataValue = new GroupMetadataValue().setMembers(Collections.singletonList(memberMetadata)).setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds());
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", groupMetadataValue, MetadataVersion.latestTesting()));
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
        context.commit();
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setGroupState(ClassicGroupState.STABLE.toString()).setProtocolType(groupMetadataValue.protocolType()).setProtocolData(groupMetadataValue.protocol()).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberMetadata.memberId()).setGroupInstanceId(memberMetadata.groupInstanceId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setMemberMetadata(memberMetadata.subscription()).setMemberAssignment(memberMetadata.assignment()))));
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = context.describeGroups(Collections.singletonList("group-id"));
        org.junit.jupiter.api.Assertions.assertEquals(expectedDescribedGroups, describedGroups);
    }

    @Test
    public void testDescribeGroupRebalancing() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        GroupMetadataValue.MemberMetadata memberMetadata = new GroupMetadataValue.MemberMetadata().setMemberId("member-id").setGroupInstanceId("group-instance-id").setClientHost("client-host").setClientId("client-id").setAssignment(new byte[]{0}).setSubscription(new byte[]{0, 1, 2});
        GroupMetadataValue groupMetadataValue = new GroupMetadataValue().setMembers(Collections.singletonList(memberMetadata)).setProtocolType("consumer").setProtocol("range").setCurrentStateTimestamp(context.time.milliseconds());
        context.replay(GroupMetadataManagerTestContext.newGroupMetadataRecord("group-id", groupMetadataValue, MetadataVersion.latestTesting()));
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        context.groupMetadataManager.prepareRebalance(group, "trigger rebalance");
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
        context.commit();
        List<DescribeGroupsResponseData.DescribedGroup> expectedDescribedGroups = Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setGroupId("group-id").setGroupState(ClassicGroupState.PREPARING_REBALANCE.toString()).setProtocolType(groupMetadataValue.protocolType()).setProtocolData("").setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setMemberId(memberMetadata.memberId()).setGroupInstanceId(memberMetadata.groupInstanceId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setMemberAssignment(memberMetadata.assignment()))));
        List<DescribeGroupsResponseData.DescribedGroup> describedGroups = context.describeGroups(Collections.singletonList("group-id"));
        org.junit.jupiter.api.Assertions.assertEquals(expectedDescribedGroups, describedGroups);
    }

    @Test
    public void testDescribeGroupsGroupIdNotFoundException() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.verifyDescribeGroupsReturnsDeadGroup("group-id");
    }

    @Test
    public void testGroupStuckInRebalanceTimeoutDueToNonjoinedStaticMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        int longSessionTimeoutMs = 10000;
        int rebalanceTimeoutMs = 5000;
        GroupMetadataManagerTestContext.RebalanceResult rebalanceResult = context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id", rebalanceTimeoutMs, longSessionTimeoutMs);
        ClassicGroup group = context.groupMetadataManager.getOrMaybeCreateClassicGroup("group-id", false);
        GroupMetadataManagerTestContext.JoinResult joinResult = context.sendClassicGroupJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withProtocolSuperset().withSessionTimeoutMs(longSessionTimeoutMs).build());
        GroupMetadataManagerTestContext.assertNoOrEmptyResult(context.sleep(rebalanceTimeoutMs));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)joinResult.joinFuture.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((short)Errors.NONE.code(), (short)joinResult.joinFuture.get().errorCode());
        org.junit.jupiter.api.Assertions.assertEquals((Object)joinResult.joinFuture.get().leader(), (Object)joinResult.joinFuture.get().memberId());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)joinResult.joinFuture.get().members().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)joinResult.joinFuture.get().generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{rebalanceResult.leaderId, rebalanceResult.followerId, joinResult.joinFuture.get().memberId()}), (Object)group.allMemberIds());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{rebalanceResult.leaderId, rebalanceResult.followerId}), (Object)group.allStaticMemberIds());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{joinResult.joinFuture.get().memberId()}), (Object)group.allDynamicMemberIds());
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setMemberId(rebalanceResult.followerId).setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
        context.sleep(rebalanceTimeoutMs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.allDynamicMemberIds().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton(rebalanceResult.leaderId), (Object)group.allMemberIds());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.allDynamicMemberIds().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.PREPARING_REBALANCE));
    }

    @Test
    public void testPendingMembersLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingJoinResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingJoinResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingJoinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.COMPLETING_REBALANCE));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allMembers().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.allDynamicMemberIds().size());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)group.numPendingJoinMembers());
    }

    @Test
    public void testLeaveGroupInvalidGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("invalid-group-id")));
    }

    @Test
    public void testLeaveGroupUnknownGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("unknown-group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("member-id")))));
    }

    @Test
    public void testLeaveGroupUnknownMemberIdExistingGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testLeaveDeadGroup() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        group.transitionTo(ClassicGroupState.DEAD);
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId("member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testValidLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData joinResponse = context.joinClassicGroupAsDynamicMemberAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build());
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setMemberId(joinResponse.memberId()))));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, (Map)group.groupAssignment(), (MetadataVersion)MetadataVersion.latestTesting())), (Object)leaveResult.records());
        leaveResult.appendFuture().complete(null);
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(joinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(ClassicGroupState.EMPTY));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)group.generationId());
    }

    @Test
    public void testLeaveGroupWithFencedInstanceId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("group-instance-id").setMemberId("other-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("group-instance-id").setMemberId("other-member-id").setErrorCode(Errors.FENCED_INSTANCE_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testLeaveGroupStaticMemberWithUnknownMemberId() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        context.joinClassicGroupAndCompleteJoin(new GroupMetadataManagerTestContext.JoinGroupRequestBuilder().withGroupId("group-id").withGroupInstanceId("group-instance-id").withMemberId("").withDefaultProtocolTypeAndProtocols().build(), true, true);
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Collections.singletonList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("group-instance-id").setMemberId(""))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Collections.singletonList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("group-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersValidBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("leader-instance-id"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersLeaveUnknownGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        org.junit.jupiter.api.Assertions.assertThrows(UnknownMemberIdException.class, () -> context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("invalid-group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id")))));
    }

    @Test
    public void testStaticMembersFencedInstanceBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("leader-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id").setMemberId("invalid-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("leader-instance-id"), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id").setMemberId("invalid-member-id").setErrorCode(Errors.FENCED_INSTANCE_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testStaticMembersUnknownInstanceBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.staticMembersJoinAndRebalance("group-id", "leader-instance-id", "follower-instance-id");
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("unknown-instance-id"), new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("follower-instance-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("unknown-instance-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("follower-instance-id")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)leaveResult.records().isEmpty());
    }

    @Test
    public void testPendingMemberBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        JoinGroupResponseData pendingJoinResponse = context.setupGroupWithPendingMember((ClassicGroup)group).pendingMemberResponse;
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setGroupInstanceId("unknown-instance-id"), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingJoinResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId("unknown-instance-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingJoinResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testJoinedMemberPendingMemberBatchLeaveGroup() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.PendingMemberGroupResult pendingMemberGroupResult = context.setupGroupWithPendingMember(group);
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testJoinedMemberPendingMemberBatchLeaveGroupWithUnknownMember() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        GroupMetadataManagerTestContext.PendingMemberGroupResult pendingMemberGroupResult = context.setupGroupWithPendingMember(group);
        CoordinatorResult<LeaveGroupResponseData, Record> leaveResult = context.sendClassicGroupLeave(new LeaveGroupRequestData().setGroupId("group-id").setMembers(Arrays.asList(new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupRequestData.MemberIdentity().setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()), new LeaveGroupRequestData.MemberIdentity().setMemberId("unknown-member-id"))));
        LeaveGroupResponseData expectedResponse = new LeaveGroupResponseData().setMembers(Arrays.asList(new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.leaderId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.followerId), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId(pendingMemberGroupResult.pendingMemberResponse.memberId()), new LeaveGroupResponseData.MemberResponse().setGroupInstanceId(null).setMemberId("unknown-member-id").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)leaveResult.response());
    }

    @Test
    public void testClassicGroupDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.createClassicGroup("group-id");
        List<Record> expectedRecords = Collections.singletonList(RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.deleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
    }

    @Test
    public void testClassicGroupMaybeDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        List<Record> expectedRecords = Collections.singletonList(RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
        records = new ArrayList();
        group.transitionTo(ClassicGroupState.PREPARING_REBALANCE);
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
        records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup("invalid-group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
    }

    @Test
    public void testConsumerGroupDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.groupMetadataManager.getOrMaybeCreateConsumerGroup("group-id", true);
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newTargetAssignmentEpochTombstoneRecord((String)"group-id"), RecordHelpers.newGroupSubscriptionMetadataTombstoneRecord((String)"group-id"), RecordHelpers.newGroupEpochTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.deleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
    }

    @Test
    public void testConsumerGroupMaybeDelete() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ConsumerGroup group = context.groupMetadataManager.getOrMaybeCreateConsumerGroup("group-id", true);
        List<Record> expectedRecords = Arrays.asList(RecordHelpers.newTargetAssignmentEpochTombstoneRecord((String)"group-id"), RecordHelpers.newGroupSubscriptionMetadataTombstoneRecord((String)"group-id"), RecordHelpers.newGroupEpochTombstoneRecord((String)"group-id"));
        ArrayList records = new ArrayList();
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(expectedRecords, records);
        records = new ArrayList();
        group.updateMember(new ConsumerGroupMember.Builder("member").setMemberEpoch(10).setTargetMemberEpoch(10).setPreviousMemberEpoch(10).build());
        context.groupMetadataManager.maybeDeleteGroup("group-id", records);
        org.junit.jupiter.api.Assertions.assertEquals(Collections.emptyList(), records);
    }

    @Test
    public void testClassicGroupCompletedRebalanceSensor() throws Exception {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.joinClassicGroupAsDynamicMemberAndCompleteRebalance("group-id");
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics)).record("CompletedRebalances");
    }

    @Test
    public void testConsumerGroupRebalanceSensor() {
        String groupId = "fooup";
        String memberId = Uuid.randomUuid().toString();
        Uuid fooTopicId = Uuid.randomUuid();
        String fooTopicName = "foo";
        Uuid barTopicId = Uuid.randomUuid();
        String barTopicName = "bar";
        MockPartitionAssignor assignor = new MockPartitionAssignor("range");
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().withAssignors(Collections.singletonList(assignor)).withMetadataImage(new MetadataImageBuilder().addTopic(fooTopicId, fooTopicName, 6).addTopic(barTopicId, barTopicName, 3).addRacks().build()).build();
        assignor.prepareGroupAssignment(new GroupAssignment(Collections.singletonMap(memberId, new MemberAssignment(AssignmentTestUtil.mkAssignment(AssignmentTestUtil.mkTopicAssignment(fooTopicId, 0, 1, 2, 3, 4, 5), AssignmentTestUtil.mkTopicAssignment(barTopicId, 0, 1, 2))))));
        context.consumerGroupHeartbeat(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(0).setServerAssignor("range").setRebalanceTimeoutMs(5000).setSubscribedTopicNames(Arrays.asList("foo", "bar")).setTopicPartitions(Collections.emptyList()));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics)).record("ConsumerGroupRebalances");
    }

    @Test
    public void testOnClassicGroupStateTransition() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = context.createClassicGroup("group-id");
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(null, ClassicGroupState.EMPTY);
        context.replay(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap(), (MetadataVersion)MetadataVersion.LATEST_PRODUCTION));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(null, ClassicGroupState.EMPTY);
        context.createClassicGroup("group-id");
        context.replay(RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(ClassicGroupState.EMPTY, null);
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.group("group-id"));
        context.replay(RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id"));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(ClassicGroupState.EMPTY, null);
    }

    @Test
    public void testOnClassicGroupStateTransitionOnLoading() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        ClassicGroup group = new ClassicGroup(new LogContext(), "group-id", ClassicGroupState.EMPTY, (Time)context.time, context.metrics);
        IntStream.range(0, 5).forEach(__ -> context.replay(RecordHelpers.newGroupMetadataRecord((ClassicGroup)group, Collections.emptyMap(), (MetadataVersion)MetadataVersion.LATEST_PRODUCTION)));
        IntStream.range(0, 4).forEach(__ -> context.replay(RecordHelpers.newGroupMetadataTombstoneRecord((String)"group-id")));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(null, ClassicGroupState.EMPTY);
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onClassicGroupStateTransition(ClassicGroupState.EMPTY, null);
    }

    @Test
    public void testOnConsumerGroupStateTransition() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        context.replay(RecordHelpers.newGroupEpochRecord((String)"group-id", (int)1));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(null, ConsumerGroup.ConsumerGroupState.EMPTY);
        context.replay(RecordHelpers.newGroupEpochRecord((String)"group-id", (int)1));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(null, ConsumerGroup.ConsumerGroupState.EMPTY);
        ArrayList tombstones = new ArrayList();
        Group group = context.groupMetadataManager.group("group-id");
        group.createGroupTombstoneRecords(tombstones);
        tombstones.forEach(context::replay);
        org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.groupMetadataManager.group("group-id"));
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.EMPTY, null);
        tombstones.forEach(tombstone -> {
            GroupIdNotFoundException cfr_ignored_0 = (GroupIdNotFoundException)org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.replay((Record)tombstone));
        });
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.EMPTY, null);
    }

    @Test
    public void testOnConsumerGroupStateTransitionOnLoading() {
        GroupMetadataManagerTestContext context = new GroupMetadataManagerTestContext.Builder().build();
        IntStream.range(0, 5).forEach(__ -> context.replay(RecordHelpers.newGroupEpochRecord((String)"group-id", (int)0)));
        context.replay(RecordHelpers.newTargetAssignmentEpochTombstoneRecord((String)"group-id"));
        context.replay(RecordHelpers.newGroupEpochTombstoneRecord((String)"group-id"));
        IntStream.range(0, 3).forEach(__ -> {
            org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.replay(RecordHelpers.newTargetAssignmentEpochTombstoneRecord((String)"group-id")));
            org.junit.jupiter.api.Assertions.assertThrows(GroupIdNotFoundException.class, () -> context.replay(RecordHelpers.newGroupEpochTombstoneRecord((String)"group-id")));
        });
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(null, ConsumerGroup.ConsumerGroupState.EMPTY);
        ((GroupCoordinatorMetricsShard)Mockito.verify((Object)context.metrics, (VerificationMode)Mockito.times((int)1))).onConsumerGroupStateTransition(ConsumerGroup.ConsumerGroupState.EMPTY, null);
    }

    private static void checkJoinGroupResponse(JoinGroupResponseData expectedResponse, JoinGroupResponseData actualResponse, ClassicGroup group, ClassicGroupState expectedState, Set<String> expectedGroupInstanceIds) {
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedResponse, (Object)actualResponse);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)group.isInState(expectedState));
        Set groupInstanceIds = actualResponse.members().stream().map(JoinGroupResponseData.JoinGroupResponseMember::groupInstanceId).collect(Collectors.toSet());
        org.junit.jupiter.api.Assertions.assertEquals(expectedGroupInstanceIds, groupInstanceIds);
    }

    private static List<JoinGroupResponseData.JoinGroupResponseMember> toJoinResponseMembers(ClassicGroup group) {
        ArrayList<JoinGroupResponseData.JoinGroupResponseMember> members = new ArrayList<JoinGroupResponseData.JoinGroupResponseMember>();
        String protocolName = (String)group.protocolName().get();
        group.allMembers().forEach(member -> members.add(new JoinGroupResponseData.JoinGroupResponseMember().setMemberId(member.memberId()).setGroupInstanceId(member.groupInstanceId().orElse("")).setMetadata(member.metadata(protocolName))));
        return members;
    }

    private static List<String> verifyClassicGroupJoinResponses(List<GroupMetadataManagerTestContext.JoinResult> joinResults, int expectedSuccessCount, Errors expectedFailure) {
        int successCount = 0;
        ArrayList<String> memberIds = new ArrayList<String>();
        for (GroupMetadataManagerTestContext.JoinResult joinResult : joinResults) {
            if (!joinResult.joinFuture.isDone()) {
                org.junit.jupiter.api.Assertions.fail((String)"All responseFutures should be completed.");
            }
            try {
                JoinGroupResponseData joinResponse = joinResult.joinFuture.get();
                if (joinResponse.errorCode() == Errors.NONE.code()) {
                    ++successCount;
                } else {
                    org.junit.jupiter.api.Assertions.assertEquals((short)expectedFailure.code(), (short)joinResponse.errorCode());
                }
                memberIds.add(joinResponse.memberId());
            }
            catch (Exception e) {
                org.junit.jupiter.api.Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedSuccessCount, (int)successCount);
        return memberIds;
    }
}

