/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Collections;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GroupCoordinatorConfigTest {
    @Test
    public void testConfigs() {
        RangeAssignor assignor = new RangeAssignor();
        GroupCoordinatorConfig config = new GroupCoordinatorConfig(10, 30, 10, 55, Collections.singletonList(assignor), 2222, 3333, 60, 3000, 300000, 120, 600000, 86400000L, 0.5, 90000000L, 600000L, 86400000L, 5000);
        Assertions.assertEquals((int)10, (int)config.numThreads);
        Assertions.assertEquals((int)30, (int)config.consumerGroupSessionTimeoutMs);
        Assertions.assertEquals((int)10, (int)config.consumerGroupHeartbeatIntervalMs);
        Assertions.assertEquals((int)55, (int)config.consumerGroupMaxSize);
        Assertions.assertEquals(Collections.singletonList(assignor), (Object)config.consumerGroupAssignors);
        Assertions.assertEquals((int)2222, (int)config.offsetsTopicSegmentBytes);
        Assertions.assertEquals((int)3333, (int)config.offsetMetadataMaxSize);
        Assertions.assertEquals((int)60, (int)config.classicGroupMaxSize);
        Assertions.assertEquals((int)3000, (int)config.classicGroupInitialRebalanceDelayMs);
        Assertions.assertEquals((int)300000, (int)config.classicGroupNewMemberJoinTimeoutMs);
        Assertions.assertEquals((int)120, (int)config.classicGroupMinSessionTimeoutMs);
        Assertions.assertEquals((int)600000, (int)config.classicGroupMaxSessionTimeoutMs);
        Assertions.assertEquals((long)86400000L, (long)config.offsetsLogCleanerDeleteRetentionMs);
        Assertions.assertEquals((double)0.5, (double)config.offsetsLogCleanerMinCleanableDirtyRatio);
        Assertions.assertEquals((long)90000000L, (long)config.offsetsLogCleanerMaxCompactionLagMs);
        Assertions.assertEquals((long)600000L, (long)config.offsetsRetentionCheckIntervalMs);
        Assertions.assertEquals((long)86400000L, (long)config.offsetsRetentionMs);
        Assertions.assertEquals((int)5000, (int)config.offsetCommitTimeoutMs);
    }

    public static GroupCoordinatorConfig createGroupCoordinatorConfig(int offsetMetadataMaxSize, long offsetsRetentionCheckIntervalMs, long offsetsRetentionMs) {
        return new GroupCoordinatorConfig(1, 45, 5, Integer.MAX_VALUE, Collections.singletonList(new RangeAssignor()), 1000, offsetMetadataMaxSize, Integer.MAX_VALUE, 3000, 300000, 120, 50000, 86400000L, 0.5, 90000000L, offsetsRetentionCheckIntervalMs, offsetsRetentionMs, 5000);
    }
}

