/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.assignor.GroupAssignment;
import org.junit.jupiter.api.Assertions;

public class AssignmentTestUtil {
    public static Map.Entry<Uuid, Set<Integer>> mkTopicAssignment(Uuid topicId, Integer ... partitions) {
        return new AbstractMap.SimpleEntry<Uuid, Set<Integer>>(topicId, new HashSet<Integer>(Arrays.asList(partitions)));
    }

    public static Map.Entry<Uuid, Set<Integer>> mkSortedTopicAssignment(Uuid topicId, Integer ... partitions) {
        return new AbstractMap.SimpleEntry<Uuid, Set<Integer>>(topicId, new TreeSet<Integer>(Arrays.asList(partitions)));
    }

    @SafeVarargs
    public static Map<Uuid, Set<Integer>> mkAssignment(Map.Entry<Uuid, Set<Integer>> ... entries) {
        HashMap<Uuid, Set<Integer>> assignment = new HashMap<Uuid, Set<Integer>>();
        for (Map.Entry<Uuid, Set<Integer>> entry : entries) {
            assignment.put(entry.getKey(), entry.getValue());
        }
        return assignment;
    }

    @SafeVarargs
    public static Map<Uuid, Set<Integer>> mkSortedAssignment(Map.Entry<Uuid, Set<Integer>> ... entries) {
        LinkedHashMap<Uuid, Set<Integer>> assignment = new LinkedHashMap<Uuid, Set<Integer>>();
        for (Map.Entry<Uuid, Set<Integer>> entry : entries) {
            assignment.put(entry.getKey(), entry.getValue());
        }
        return assignment;
    }

    public static void assertAssignment(Map<String, Map<Uuid, Set<Integer>>> expectedAssignment, GroupAssignment computedGroupAssignment) {
        Assertions.assertEquals((int)expectedAssignment.size(), (int)computedGroupAssignment.members().size());
        computedGroupAssignment.members().forEach((memberId, memberAssignment) -> {
            Map computedAssignmentForMember = memberAssignment.targetPartitions();
            Assertions.assertEquals(expectedAssignment.get(memberId), (Object)computedAssignmentForMember);
        });
    }
}

