/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.opentest4j.AssertionFailedError;

public class Assertions {
    public static <T> void assertUnorderedListEquals(List<T> expected, List<T> actual) {
        org.junit.jupiter.api.Assertions.assertEquals(new HashSet<T>(expected), new HashSet<T>(actual));
    }

    public static void assertResponseEquals(ConsumerGroupHeartbeatResponseData expected, ConsumerGroupHeartbeatResponseData actual) {
        if (!Assertions.responseEquals(expected, actual)) {
            AssertionFailureBuilder.assertionFailure().expected((Object)expected).actual((Object)actual).buildAndThrow();
        }
    }

    private static boolean responseEquals(ConsumerGroupHeartbeatResponseData expected, ConsumerGroupHeartbeatResponseData actual) {
        if (expected.throttleTimeMs() != actual.throttleTimeMs()) {
            return false;
        }
        if (expected.errorCode() != actual.errorCode()) {
            return false;
        }
        if (!Objects.equals(expected.errorMessage(), actual.errorMessage())) {
            return false;
        }
        if (!Objects.equals(expected.memberId(), actual.memberId())) {
            return false;
        }
        if (expected.memberEpoch() != actual.memberEpoch()) {
            return false;
        }
        if (expected.heartbeatIntervalMs() != actual.heartbeatIntervalMs()) {
            return false;
        }
        return Assertions.responseAssignmentEquals(expected.assignment(), actual.assignment());
    }

    private static boolean responseAssignmentEquals(ConsumerGroupHeartbeatResponseData.Assignment expected, ConsumerGroupHeartbeatResponseData.Assignment actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null) {
            return false;
        }
        if (actual == null) {
            return false;
        }
        return Objects.equals(Assertions.fromAssignment(expected.topicPartitions()), Assertions.fromAssignment(actual.topicPartitions()));
    }

    private static Map<Uuid, Set<Integer>> fromAssignment(List<ConsumerGroupHeartbeatResponseData.TopicPartitions> assignment) {
        if (assignment == null) {
            return null;
        }
        HashMap<Uuid, Set<Integer>> assignmentMap = new HashMap<Uuid, Set<Integer>>();
        assignment.forEach(topicPartitions -> {
            Set cfr_ignored_0 = assignmentMap.put(topicPartitions.topicId(), new HashSet(topicPartitions.partitions()));
        });
        return assignmentMap;
    }

    public static void assertRecordsEquals(List<Record> expectedRecords, List<Record> actualRecords) {
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedRecords.size(), (int)actualRecords.size());
            for (int i = 0; i < expectedRecords.size(); ++i) {
                Record expectedRecord = expectedRecords.get(i);
                Record actualRecord = actualRecords.get(i);
                Assertions.assertRecordEquals(expectedRecord, actualRecord);
            }
        }
        catch (AssertionFailedError e) {
            AssertionFailureBuilder.assertionFailure().expected(expectedRecords).actual(actualRecords).buildAndThrow();
        }
    }

    public static void assertRecordEquals(Record expected, Record actual) {
        try {
            Assertions.assertApiMessageAndVersionEquals(expected.key(), actual.key());
            Assertions.assertApiMessageAndVersionEquals(expected.value(), actual.value());
        }
        catch (AssertionFailedError e) {
            AssertionFailureBuilder.assertionFailure().expected((Object)expected).actual((Object)actual).buildAndThrow();
        }
    }

    private static void assertApiMessageAndVersionEquals(ApiMessageAndVersion expected, ApiMessageAndVersion actual) {
        if (expected == actual) {
            return;
        }
        org.junit.jupiter.api.Assertions.assertEquals((short)expected.version(), (short)actual.version());
        if (actual.message() instanceof ConsumerGroupCurrentMemberAssignmentValue) {
            ConsumerGroupCurrentMemberAssignmentValue expectedValue = (ConsumerGroupCurrentMemberAssignmentValue)expected.message();
            ConsumerGroupCurrentMemberAssignmentValue actualValue = (ConsumerGroupCurrentMemberAssignmentValue)actual.message();
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue.memberEpoch(), (int)actualValue.memberEpoch());
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue.previousMemberEpoch(), (int)actualValue.previousMemberEpoch());
            org.junit.jupiter.api.Assertions.assertEquals((int)expectedValue.targetMemberEpoch(), (int)actualValue.targetMemberEpoch());
            org.junit.jupiter.api.Assertions.assertEquals((byte)expectedValue.error(), (byte)actualValue.error());
            org.junit.jupiter.api.Assertions.assertEquals((short)expectedValue.metadataVersion(), (short)actualValue.metadataVersion());
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue.metadataBytes(), (Object)actualValue.metadataBytes());
            org.junit.jupiter.api.Assertions.assertEquals(Assertions.fromTopicPartitions(expectedValue.assignedPartitions()), Assertions.fromTopicPartitions(actualValue.assignedPartitions()));
            org.junit.jupiter.api.Assertions.assertEquals(Assertions.fromTopicPartitions(expectedValue.partitionsPendingRevocation()), Assertions.fromTopicPartitions(actualValue.partitionsPendingRevocation()));
            org.junit.jupiter.api.Assertions.assertEquals(Assertions.fromTopicPartitions(expectedValue.partitionsPendingAssignment()), Assertions.fromTopicPartitions(actualValue.partitionsPendingAssignment()));
        } else if (actual.message() instanceof ConsumerGroupPartitionMetadataValue) {
            ConsumerGroupPartitionMetadataValue expectedValue = (ConsumerGroupPartitionMetadataValue)expected.message();
            ConsumerGroupPartitionMetadataValue actualValue = (ConsumerGroupPartitionMetadataValue)actual.message();
            List<ConsumerGroupPartitionMetadataValue.TopicMetadata> expectedTopicMetadataList = expectedValue.topics();
            List<ConsumerGroupPartitionMetadataValue.TopicMetadata> actualTopicMetadataList = actualValue.topics();
            if (expectedTopicMetadataList.size() != actualTopicMetadataList.size()) {
                org.junit.jupiter.api.Assertions.fail((String)"Topic metadata lists have different sizes");
            }
            for (int i = 0; i < expectedTopicMetadataList.size(); ++i) {
                ConsumerGroupPartitionMetadataValue.TopicMetadata expectedTopicMetadata = expectedTopicMetadataList.get(i);
                ConsumerGroupPartitionMetadataValue.TopicMetadata actualTopicMetadata = actualTopicMetadataList.get(i);
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTopicMetadata.topicId(), (Object)actualTopicMetadata.topicId());
                org.junit.jupiter.api.Assertions.assertEquals((Object)expectedTopicMetadata.topicName(), (Object)actualTopicMetadata.topicName());
                org.junit.jupiter.api.Assertions.assertEquals((int)expectedTopicMetadata.numPartitions(), (int)actualTopicMetadata.numPartitions());
                List<ConsumerGroupPartitionMetadataValue.PartitionMetadata> expectedPartitionMetadataList = expectedTopicMetadata.partitionMetadata();
                List<ConsumerGroupPartitionMetadataValue.PartitionMetadata> actualPartitionMetadataList = actualTopicMetadata.partitionMetadata();
                if (expectedPartitionMetadataList.size() != actualPartitionMetadataList.size()) {
                    org.junit.jupiter.api.Assertions.fail((String)"Partition metadata lists have different sizes");
                    continue;
                }
                if (expectedPartitionMetadataList.isEmpty() || actualPartitionMetadataList.isEmpty()) continue;
                for (int j = 0; j < expectedTopicMetadataList.size(); ++j) {
                    ConsumerGroupPartitionMetadataValue.PartitionMetadata expectedPartitionMetadata = expectedPartitionMetadataList.get(j);
                    ConsumerGroupPartitionMetadataValue.PartitionMetadata actualPartitionMetadata = actualPartitionMetadataList.get(j);
                    org.junit.jupiter.api.Assertions.assertEquals((int)expectedPartitionMetadata.partition(), (int)actualPartitionMetadata.partition());
                    Assertions.assertUnorderedListEquals(expectedPartitionMetadata.racks(), actualPartitionMetadata.racks());
                }
            }
        } else {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected.message(), (Object)actual.message());
        }
    }

    private static Map<Uuid, Set<Integer>> fromTopicPartitions(List<ConsumerGroupCurrentMemberAssignmentValue.TopicPartitions> assignment) {
        HashMap<Uuid, Set<Integer>> assignmentMap = new HashMap<Uuid, Set<Integer>>();
        assignment.forEach(topicPartitions -> {
            Set cfr_ignored_0 = assignmentMap.put(topicPartitions.topicId(), new HashSet<Integer>(topicPartitions.partitions()));
        });
        return assignmentMap;
    }
}

