/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import kafka.examples.DemoCallBack;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class Producer
extends Thread {
    private final KafkaProducer<Integer, String> producer;
    private final String topic;
    private final Boolean isAsync;
    private int numRecords;
    private final CountDownLatch latch;

    public Producer(String topic, Boolean isAsync, String transactionalId, boolean enableIdempotency, int numRecords, int transactionTimeoutMs, CountDownLatch latch) {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("client.id", "DemoProducer");
        props.put("key.serializer", IntegerSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        if (transactionTimeoutMs > 0) {
            props.put("transaction.timeout.ms", (Object)transactionTimeoutMs);
        }
        if (transactionalId != null) {
            props.put("transactional.id", transactionalId);
        }
        props.put("enable.idempotence", (Object)enableIdempotency);
        this.producer = new KafkaProducer(props);
        this.topic = topic;
        this.isAsync = isAsync;
        this.numRecords = numRecords;
        this.latch = latch;
    }

    KafkaProducer<Integer, String> get() {
        return this.producer;
    }

    @Override
    public void run() {
        int messageKey = 0;
        for (int recordsSent = 0; recordsSent < this.numRecords; ++recordsSent) {
            String messageStr = "Message_" + messageKey;
            long startTime = System.currentTimeMillis();
            if (this.isAsync.booleanValue()) {
                this.producer.send(new ProducerRecord(this.topic, (Object)messageKey, (Object)messageStr), (Callback)new DemoCallBack(startTime, messageKey, messageStr));
            } else {
                try {
                    this.producer.send(new ProducerRecord(this.topic, (Object)messageKey, (Object)messageStr)).get();
                    System.out.println("Sent message: (" + messageKey + ", " + messageStr + ")");
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            messageKey += 2;
        }
        System.out.println("Producer sent " + this.numRecords + " records successfully");
        this.latch.countDown();
    }
}

