/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class Consumer
extends ShutdownableThread {
    private final KafkaConsumer<Integer, String> consumer;
    private final String topic;
    private final String groupId;
    private final int numMessageToConsume;
    private int messageRemaining;
    private final CountDownLatch latch;

    public Consumer(String topic, String groupId, Optional<String> instanceId, boolean readCommitted, int numMessageToConsume, CountDownLatch latch) {
        super("KafkaConsumerExample", false);
        this.groupId = groupId;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", groupId);
        instanceId.ifPresent(id -> props.put("group.instance.id", id));
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.IntegerDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        if (readCommitted) {
            props.put("isolation.level", "read_committed");
        }
        props.put("auto.offset.reset", "earliest");
        this.consumer = new KafkaConsumer(props);
        this.topic = topic;
        this.numMessageToConsume = numMessageToConsume;
        this.messageRemaining = numMessageToConsume;
        this.latch = latch;
    }

    KafkaConsumer<Integer, String> get() {
        return this.consumer;
    }

    public void doWork() {
        this.consumer.subscribe(Collections.singletonList(this.topic));
        ConsumerRecords records = this.consumer.poll(Duration.ofSeconds(1L));
        for (ConsumerRecord record : records) {
            System.out.println(this.groupId + " received message : from partition " + record.partition() + ", (" + record.key() + ", " + (String)record.value() + ") at offset " + record.offset());
        }
        this.messageRemaining -= records.count();
        if (this.messageRemaining <= 0) {
            System.out.println(this.groupId + " finished reading " + this.numMessageToConsume + " messages");
            this.latch.countDown();
        }
    }

    public String name() {
        return null;
    }

    public boolean isInterruptible() {
        return false;
    }
}

