/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.examples.DemoCallBack;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class Producer
extends Thread {
    private final KafkaProducer<Integer, String> producer;
    private final String topic;
    private final Boolean isAsync;

    public Producer(String topic, Boolean isAsync) {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("client.id", "DemoProducer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.IntegerSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new KafkaProducer(props);
        this.topic = topic;
        this.isAsync = isAsync;
    }

    @Override
    public void run() {
        int messageNo = 1;
        while (true) {
            String messageStr = "Message_" + messageNo;
            long startTime = System.currentTimeMillis();
            if (this.isAsync.booleanValue()) {
                this.producer.send(new ProducerRecord(this.topic, (Object)messageNo, (Object)messageStr), (Callback)new DemoCallBack(startTime, messageNo, messageStr));
            } else {
                try {
                    this.producer.send(new ProducerRecord(this.topic, (Object)messageNo, (Object)messageStr)).get();
                    System.out.println("Sent message: (" + messageNo + ", " + messageStr + ")");
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            ++messageNo;
        }
    }
}

