/*
 * Decompiled with CFR 0.152.
 */
package kafka.examples;

import java.util.Collections;
import java.util.Properties;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class Consumer
extends ShutdownableThread {
    private final KafkaConsumer<Integer, String> consumer;
    private final String topic;

    public Consumer(String topic) {
        super("KafkaConsumerExample", false);
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:9092");
        props.put("group.id", "DemoConsumer");
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.IntegerDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.consumer = new KafkaConsumer(props);
        this.topic = topic;
    }

    public void doWork() {
        this.consumer.subscribe(Collections.singletonList(this.topic));
        ConsumerRecords records = this.consumer.poll(1000L);
        for (ConsumerRecord record : records) {
            System.out.println("Received message: (" + record.key() + ", " + (String)record.value() + ") at offset " + record.offset());
        }
    }

    public String name() {
        return null;
    }

    public boolean isInterruptible() {
        return false;
    }
}

