/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRuntimeTest;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShard;
import org.apache.kafka.coordinator.common.runtime.MockCoordinatorTimer;
import org.apache.kafka.coordinator.common.runtime.SnapshottableCoordinator;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SnapshottableCoordinatorTest {
    @Test
    public void testUpdateLastWrittenOffset() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(0L));
        coordinator.updateLastWrittenOffset(Long.valueOf(100L));
        Assertions.assertEquals((long)100L, (long)coordinator.lastWrittenOffset());
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(100L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(0L));
    }

    @Test
    public void testUpdateLastWrittenOffsetFailed() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        Assertions.assertEquals((long)0L, (long)coordinator.lastWrittenOffset());
        Assertions.assertThrows(IllegalStateException.class, () -> coordinator.updateLastWrittenOffset(Long.valueOf(0L)));
        Assertions.assertEquals((long)0L, (long)coordinator.lastWrittenOffset());
    }

    @Test
    public void testRevertWrittenOffset() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        coordinator.updateLastWrittenOffset(Long.valueOf(100L));
        coordinator.updateLastWrittenOffset(Long.valueOf(200L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(0L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(100L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(200L));
        coordinator.revertLastWrittenOffset(100L);
        Assertions.assertEquals((long)100L, (long)coordinator.lastWrittenOffset());
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(100L));
        Assertions.assertFalse((boolean)coordinator.snapshotRegistry().hasSnapshot(200L));
    }

    @Test
    public void testRevertLastWrittenOffsetFailed() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        Assertions.assertEquals((long)0L, (long)coordinator.lastWrittenOffset());
        Assertions.assertThrows(IllegalStateException.class, () -> coordinator.revertLastWrittenOffset(1L));
        Assertions.assertEquals((long)0L, (long)coordinator.lastWrittenOffset());
    }

    @Test
    public void testUpdateLastCommittedOffset() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        coordinator.updateLastWrittenOffset(Long.valueOf(100L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(0L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(100L));
        coordinator.updateLastCommittedOffset(Long.valueOf(100L));
        Assertions.assertEquals((long)100L, (long)coordinator.lastCommittedOffset());
        Assertions.assertFalse((boolean)coordinator.snapshotRegistry().hasSnapshot(0L));
        Assertions.assertTrue((boolean)coordinator.snapshotRegistry().hasSnapshot(100L));
    }

    @Test
    public void testUpdateLastCommittedOffsetFailed() {
        LogContext logContext = new LogContext();
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(logContext);
        SnapshottableCoordinator coordinator = new SnapshottableCoordinator(logContext, snapshotRegistry, (CoordinatorShard)new CoordinatorRuntimeTest.MockCoordinatorShard(snapshotRegistry, new MockCoordinatorTimer<Void, String>((Time)new MockTime())), new TopicPartition("test-topic", 0));
        coordinator.updateLastWrittenOffset(Long.valueOf(100L));
        coordinator.updateLastCommittedOffset(Long.valueOf(100L));
        Assertions.assertEquals((long)100L, (long)coordinator.lastCommittedOffset());
        Assertions.assertThrows(IllegalStateException.class, () -> coordinator.updateLastCommittedOffset(Long.valueOf(99L)));
        Assertions.assertEquals((long)100L, (long)coordinator.lastCommittedOffset());
        Assertions.assertThrows(IllegalStateException.class, () -> coordinator.updateLastCommittedOffset(Long.valueOf(101L)));
    }
}

