/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.CoordinatorTimer;

public class MockCoordinatorTimer<T, U>
implements CoordinatorTimer<T, U> {
    private final Time time;
    private final Map<String, ScheduledTimeout<T, U>> timeoutMap = new HashMap<String, ScheduledTimeout<T, U>>();
    private final PriorityQueue<ScheduledTimeout<T, U>> timeoutQueue = new PriorityQueue<ScheduledTimeout>(Comparator.comparingLong(entry -> entry.deadlineMs));

    public MockCoordinatorTimer(Time time) {
        this.time = time;
    }

    public void schedule(String key, long delay, TimeUnit unit, boolean retry, long retryBackoff, CoordinatorTimer.TimeoutOperation<T, U> operation) {
        this.cancel(key);
        long deadlineMs = this.time.milliseconds() + unit.toMillis(delay);
        ScheduledTimeout<T, U> timeout = new ScheduledTimeout<T, U>(key, deadlineMs, operation);
        this.timeoutQueue.add(timeout);
        this.timeoutMap.put(key, timeout);
    }

    public void schedule(String key, long delay, TimeUnit unit, boolean retry, CoordinatorTimer.TimeoutOperation<T, U> operation) {
        this.schedule(key, delay, unit, retry, 500L, operation);
    }

    public void scheduleIfAbsent(String key, long delay, TimeUnit unit, boolean retry, CoordinatorTimer.TimeoutOperation<T, U> operation) {
        if (!this.timeoutMap.containsKey(key)) {
            this.schedule(key, delay, unit, retry, 500L, operation);
        }
    }

    public void cancel(String key) {
        ScheduledTimeout<T, U> timeout = this.timeoutMap.remove(key);
        if (timeout != null) {
            this.timeoutQueue.remove(timeout);
        }
    }

    public boolean contains(String key) {
        return this.timeoutMap.containsKey(key);
    }

    public ScheduledTimeout<T, U> timeout(String key) {
        return this.timeoutMap.get(key);
    }

    public int size() {
        return this.timeoutMap.size();
    }

    public List<ExpiredTimeout<T, U>> poll() {
        ArrayList<ExpiredTimeout<T, U>> results = new ArrayList<ExpiredTimeout<T, U>>();
        ScheduledTimeout<T, U> timeout = this.timeoutQueue.peek();
        while (timeout != null && timeout.deadlineMs <= this.time.milliseconds()) {
            this.timeoutQueue.poll();
            this.timeoutMap.remove(timeout.key, timeout);
            results.add(new ExpiredTimeout(timeout.key, timeout.operation.generateRecords()));
            timeout = this.timeoutQueue.peek();
        }
        return results;
    }

    public static class ScheduledTimeout<T, U> {
        public final String key;
        public final long deadlineMs;
        public final CoordinatorTimer.TimeoutOperation<T, U> operation;

        public ScheduledTimeout(String key, long deadlineMs, CoordinatorTimer.TimeoutOperation<T, U> operation) {
            this.key = key;
            this.deadlineMs = deadlineMs;
            this.operation = operation;
        }
    }

    public static class ExpiredTimeout<T, U> {
        public final String key;
        public final CoordinatorResult<T, U> result;

        public ExpiredTimeout(String key, CoordinatorResult<T, U> result) {
            this.key = key;
            this.result = result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpiredTimeout that = (ExpiredTimeout)o;
            if (!Objects.equals(this.key, that.key)) {
                return false;
            }
            return Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            int result1 = this.key != null ? this.key.hashCode() : 0;
            result1 = 31 * result1 + (this.result != null ? this.result.hashCode() : 0);
            return result1;
        }
    }
}

